/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceSettings;
import com.google.cloud.recommendationengine.v1beta1.CreateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.DeleteCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.GetCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.ImportErrorsConfig;
import com.google.cloud.recommendationengine.v1beta1.ImportMetadata;
import com.google.cloud.recommendationengine.v1beta1.InputConfig;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListCatalogItemsResponse;
import com.google.cloud.recommendationengine.v1beta1.UpdateCatalogItemRequest;
import com.google.cloud.recommendationengine.v1beta1.stub.CatalogServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.CatalogServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CatalogServiceClient
implements BackgroundResource {
    private final CatalogServiceSettings settings;
    private final CatalogServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate CATALOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}");
    private static final PathTemplate CATALOG_ITEM_PATH_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/catalogItems/{catalog_item_path=**}");

    @Deprecated
    public static final String formatCatalogName(String project, String location, String catalog) {
        return CATALOG_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "catalog", catalog});
    }

    @Deprecated
    public static final String formatCatalogItemPathName(String project, String location, String catalog, String catalogItemPath) {
        return CATALOG_ITEM_PATH_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "catalog", catalog, "catalog_item_path", catalogItemPath});
    }

    @Deprecated
    public static final String parseProjectFromCatalogName(String catalogName) {
        return CATALOG_PATH_TEMPLATE.parse(catalogName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromCatalogName(String catalogName) {
        return CATALOG_PATH_TEMPLATE.parse(catalogName).get((Object)"location");
    }

    @Deprecated
    public static final String parseCatalogFromCatalogName(String catalogName) {
        return CATALOG_PATH_TEMPLATE.parse(catalogName).get((Object)"catalog");
    }

    @Deprecated
    public static final String parseProjectFromCatalogItemPathName(String catalogItemPathName) {
        return CATALOG_ITEM_PATH_PATH_TEMPLATE.parse(catalogItemPathName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromCatalogItemPathName(String catalogItemPathName) {
        return CATALOG_ITEM_PATH_PATH_TEMPLATE.parse(catalogItemPathName).get((Object)"location");
    }

    @Deprecated
    public static final String parseCatalogFromCatalogItemPathName(String catalogItemPathName) {
        return CATALOG_ITEM_PATH_PATH_TEMPLATE.parse(catalogItemPathName).get((Object)"catalog");
    }

    @Deprecated
    public static final String parseCatalogItemPathFromCatalogItemPathName(String catalogItemPathName) {
        return CATALOG_ITEM_PATH_PATH_TEMPLATE.parse(catalogItemPathName).get((Object)"catalog_item_path");
    }

    public static final CatalogServiceClient create() throws IOException {
        return CatalogServiceClient.create(CatalogServiceSettings.newBuilder().build());
    }

    public static final CatalogServiceClient create(CatalogServiceSettings settings) throws IOException {
        return new CatalogServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CatalogServiceClient create(CatalogServiceStub stub) {
        return new CatalogServiceClient(stub);
    }

    protected CatalogServiceClient(CatalogServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CatalogServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CatalogServiceClient(CatalogServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CatalogServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CatalogServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final CatalogItem createCatalogItem(String parent, CatalogItem catalogItem) {
        CATALOG_PATH_TEMPLATE.validate(parent, "createCatalogItem");
        CreateCatalogItemRequest request = CreateCatalogItemRequest.newBuilder().setParent(parent).setCatalogItem(catalogItem).build();
        return this.createCatalogItem(request);
    }

    public final CatalogItem createCatalogItem(CreateCatalogItemRequest request) {
        return (CatalogItem)this.createCatalogItemCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCatalogItemRequest, CatalogItem> createCatalogItemCallable() {
        return this.stub.createCatalogItemCallable();
    }

    public final CatalogItem getCatalogItem(String name) {
        CATALOG_ITEM_PATH_PATH_TEMPLATE.validate(name, "getCatalogItem");
        GetCatalogItemRequest request = GetCatalogItemRequest.newBuilder().setName(name).build();
        return this.getCatalogItem(request);
    }

    public final CatalogItem getCatalogItem(GetCatalogItemRequest request) {
        return (CatalogItem)this.getCatalogItemCallable().call((Object)request);
    }

    public final UnaryCallable<GetCatalogItemRequest, CatalogItem> getCatalogItemCallable() {
        return this.stub.getCatalogItemCallable();
    }

    public final ListCatalogItemsPagedResponse listCatalogItems(String parent, String filter) {
        CATALOG_PATH_TEMPLATE.validate(parent, "listCatalogItems");
        ListCatalogItemsRequest request = ListCatalogItemsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listCatalogItems(request);
    }

    public final ListCatalogItemsPagedResponse listCatalogItems(ListCatalogItemsRequest request) {
        return (ListCatalogItemsPagedResponse)((Object)this.listCatalogItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCatalogItemsRequest, ListCatalogItemsPagedResponse> listCatalogItemsPagedCallable() {
        return this.stub.listCatalogItemsPagedCallable();
    }

    public final UnaryCallable<ListCatalogItemsRequest, ListCatalogItemsResponse> listCatalogItemsCallable() {
        return this.stub.listCatalogItemsCallable();
    }

    public final CatalogItem updateCatalogItem(String name, CatalogItem catalogItem) {
        CATALOG_ITEM_PATH_PATH_TEMPLATE.validate(name, "updateCatalogItem");
        UpdateCatalogItemRequest request = UpdateCatalogItemRequest.newBuilder().setName(name).setCatalogItem(catalogItem).build();
        return this.updateCatalogItem(request);
    }

    public final CatalogItem updateCatalogItem(UpdateCatalogItemRequest request) {
        return (CatalogItem)this.updateCatalogItemCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCatalogItemRequest, CatalogItem> updateCatalogItemCallable() {
        return this.stub.updateCatalogItemCallable();
    }

    public final void deleteCatalogItem(String name) {
        CATALOG_ITEM_PATH_PATH_TEMPLATE.validate(name, "deleteCatalogItem");
        DeleteCatalogItemRequest request = DeleteCatalogItemRequest.newBuilder().setName(name).build();
        this.deleteCatalogItem(request);
    }

    public final void deleteCatalogItem(DeleteCatalogItemRequest request) {
        this.deleteCatalogItemCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCatalogItemRequest, Empty> deleteCatalogItemCallable() {
        return this.stub.deleteCatalogItemCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsAsync(String parent, String requestId, InputConfig inputConfig, ImportErrorsConfig errorsConfig) {
        CATALOG_PATH_TEMPLATE.validate(parent, "importCatalogItems");
        ImportCatalogItemsRequest request = ImportCatalogItemsRequest.newBuilder().setParent(parent).setRequestId(requestId).setInputConfig(inputConfig).setErrorsConfig(errorsConfig).build();
        return this.importCatalogItemsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsAsync(ImportCatalogItemsRequest request) {
        return this.importCatalogItemsOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ImportCatalogItemsRequest, ImportCatalogItemsResponse, ImportMetadata> importCatalogItemsOperationCallable() {
        return this.stub.importCatalogItemsOperationCallable();
    }

    public final UnaryCallable<ImportCatalogItemsRequest, Operation> importCatalogItemsCallable() {
        return this.stub.importCatalogItemsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCatalogItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem, ListCatalogItemsPage, ListCatalogItemsFixedSizeCollection> {
        private ListCatalogItemsFixedSizeCollection(List<ListCatalogItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCatalogItemsFixedSizeCollection createEmptyCollection() {
            return new ListCatalogItemsFixedSizeCollection(null, 0);
        }

        protected ListCatalogItemsFixedSizeCollection createCollection(List<ListCatalogItemsPage> pages, int collectionSize) {
            return new ListCatalogItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCatalogItemsPage
    extends AbstractPage<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem, ListCatalogItemsPage> {
        private ListCatalogItemsPage(PageContext<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem> context, ListCatalogItemsResponse response) {
            super(context, (Object)response);
        }

        private static ListCatalogItemsPage createEmptyPage() {
            return new ListCatalogItemsPage(null, null);
        }

        protected ListCatalogItemsPage createPage(PageContext<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem> context, ListCatalogItemsResponse response) {
            return new ListCatalogItemsPage(context, response);
        }

        public ApiFuture<ListCatalogItemsPage> createPageAsync(PageContext<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem> context, ApiFuture<ListCatalogItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCatalogItemsPagedResponse
    extends AbstractPagedListResponse<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem, ListCatalogItemsPage, ListCatalogItemsFixedSizeCollection> {
        public static ApiFuture<ListCatalogItemsPagedResponse> createAsync(PageContext<ListCatalogItemsRequest, ListCatalogItemsResponse, CatalogItem> context, ApiFuture<ListCatalogItemsResponse> futureResponse) {
            ApiFuture<ListCatalogItemsPage> futurePage = ListCatalogItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCatalogItemsPage, ListCatalogItemsPagedResponse>(){

                public ListCatalogItemsPagedResponse apply(ListCatalogItemsPage input) {
                    return new ListCatalogItemsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCatalogItemsPagedResponse(ListCatalogItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCatalogItemsFixedSizeCollection.createEmptyCollection());
        }
    }
}

