package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SinglePartitionPublisherBuilder extends SinglePartitionPublisherBuilder {

  private final TopicPath topic;

  private final Partition partition;

  private final StreamFactories.PublishStreamFactory streamFactory;

  private final BatchingSettings batchingSettings;

  private final PublisherBuilder.Builder underlyingBuilder;

  private AutoValue_SinglePartitionPublisherBuilder(
      TopicPath topic,
      Partition partition,
      StreamFactories.PublishStreamFactory streamFactory,
      BatchingSettings batchingSettings,
      PublisherBuilder.Builder underlyingBuilder) {
    this.topic = topic;
    this.partition = partition;
    this.streamFactory = streamFactory;
    this.batchingSettings = batchingSettings;
    this.underlyingBuilder = underlyingBuilder;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  StreamFactories.PublishStreamFactory streamFactory() {
    return streamFactory;
  }

  @Override
  BatchingSettings batchingSettings() {
    return batchingSettings;
  }

  @Override
  PublisherBuilder.Builder underlyingBuilder() {
    return underlyingBuilder;
  }

  @Override
  public String toString() {
    return "SinglePartitionPublisherBuilder{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "streamFactory=" + streamFactory + ", "
        + "batchingSettings=" + batchingSettings + ", "
        + "underlyingBuilder=" + underlyingBuilder
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SinglePartitionPublisherBuilder) {
      SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.partition.equals(that.partition())
          && this.streamFactory.equals(that.streamFactory())
          && this.batchingSettings.equals(that.batchingSettings())
          && this.underlyingBuilder.equals(that.underlyingBuilder());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= streamFactory.hashCode();
    h$ *= 1000003;
    h$ ^= batchingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= underlyingBuilder.hashCode();
    return h$;
  }

  static final class Builder extends SinglePartitionPublisherBuilder.Builder {
    private TopicPath topic;
    private Partition partition;
    private StreamFactories.PublishStreamFactory streamFactory;
    private BatchingSettings batchingSettings;
    private PublisherBuilder.Builder underlyingBuilder;
    Builder() {
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setStreamFactory(StreamFactories.PublishStreamFactory streamFactory) {
      if (streamFactory == null) {
        throw new NullPointerException("Null streamFactory");
      }
      this.streamFactory = streamFactory;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setBatchingSettings(BatchingSettings batchingSettings) {
      if (batchingSettings == null) {
        throw new NullPointerException("Null batchingSettings");
      }
      this.batchingSettings = batchingSettings;
      return this;
    }
    @Override
    SinglePartitionPublisherBuilder.Builder setUnderlyingBuilder(PublisherBuilder.Builder underlyingBuilder) {
      if (underlyingBuilder == null) {
        throw new NullPointerException("Null underlyingBuilder");
      }
      this.underlyingBuilder = underlyingBuilder;
      return this;
    }
    @Override
    SinglePartitionPublisherBuilder autoBuild() {
      if (this.topic == null
          || this.partition == null
          || this.streamFactory == null
          || this.batchingSettings == null
          || this.underlyingBuilder == null) {
        StringBuilder missing = new StringBuilder();
        if (this.topic == null) {
          missing.append(" topic");
        }
        if (this.partition == null) {
          missing.append(" partition");
        }
        if (this.streamFactory == null) {
          missing.append(" streamFactory");
        }
        if (this.batchingSettings == null) {
          missing.append(" batchingSettings");
        }
        if (this.underlyingBuilder == null) {
          missing.append(" underlyingBuilder");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SinglePartitionPublisherBuilder(
          this.topic,
          this.partition,
          this.streamFactory,
          this.batchingSettings,
          this.underlyingBuilder);
    }
  }

}
