/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.Lazy;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class SystemExecutors {
    private static final Lazy<ScheduledExecutorService> ALARM_EXECUTOR = new Lazy<ScheduledExecutorService>(() -> SystemExecutors.newDaemonExecutor("pubsub-lite-alarms"));
    private static final Lazy<ScheduledExecutorService> FUTURES_EXECUTOR = new Lazy<ScheduledExecutorService>(() -> SystemExecutors.newDaemonExecutor("pubsub-lite-futures"));

    private SystemExecutors() {
    }

    public static ScheduledExecutorService newDaemonExecutor(String prefix) {
        return Executors.newScheduledThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(prefix + "-%d").build());
    }

    public static ScheduledExecutorService getAlarmExecutor() {
        return ALARM_EXECUTOR.get();
    }

    public static ScheduledExecutorService getFuturesExecutor() {
        return FUTURES_EXECUTOR.get();
    }
}

