/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.cloudpubsub.AutoValue_PublisherSettings;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.cloudpubsub.MessageTransforms;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.cloudpubsub.internal.WrappingPublisher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.UuidBuilder;
import com.google.cloud.pubsublite.v1.AdminServiceClient;
import com.google.cloud.pubsublite.v1.AdminServiceSettings;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import com.google.cloud.pubsublite.v1.PublisherServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Optional;
import org.threeten.bp.Duration;

@AutoValue
public abstract class PublisherSettings {
    public static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(0x380000L)).setDelayThreshold(Duration.ofMillis((long)50L)).build();

    abstract TopicPath topicPath();

    abstract Optional<KeyExtractor> keyExtractor();

    abstract Optional<MessageTransformer<PubsubMessage, Message>> messageTransformer();

    abstract BatchingSettings batchingSettings();

    abstract boolean enableIdempotence();

    abstract CredentialsProvider credentialsProvider();

    abstract PubsubContext.Framework framework();

    abstract Optional<PublisherServiceClient> serviceClient();

    abstract Optional<AdminClient> adminClient();

    abstract SinglePartitionPublisherBuilder.Builder underlyingBuilder();

    public static Builder newBuilder() {
        return new AutoValue_PublisherSettings.Builder().setFramework(PubsubContext.Framework.of("CLOUD_PUBSUB_SHIM")).setCredentialsProvider((CredentialsProvider)PublisherServiceSettings.defaultCredentialsProviderBuilder().build()).setBatchingSettings(DEFAULT_BATCHING_SETTINGS).setEnableIdempotence(true).setUnderlyingBuilder(SinglePartitionPublisherBuilder.newBuilder());
    }

    private PublisherServiceClient newServiceClient() throws ApiException {
        if (this.serviceClient().isPresent()) {
            return this.serviceClient().get();
        }
        try {
            return PublisherServiceClient.create((PublisherServiceSettings)((Object)ServiceClients.addDefaultSettings(this.topicPath().location().extractRegion(), PublisherServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private PartitionPublisherFactory getPartitionPublisherFactory() {
        final PublisherServiceClient client = this.newServiceClient();
        final ByteString publisherClientId = UuidBuilder.toByteString(UuidBuilder.generate());
        return new PartitionPublisherFactory(){

            @Override
            public com.google.cloud.pubsublite.internal.Publisher<MessageMetadata> newPublisher(Partition partition) throws ApiException {
                SinglePartitionPublisherBuilder.Builder singlePartitionBuilder = PublisherSettings.this.underlyingBuilder().setBatchingSettings(PublisherSettings.this.batchingSettings()).setTopic(PublisherSettings.this.topicPath()).setPartition(partition).setStreamFactory(responseStream -> {
                    ApiCallContext context = ServiceClients.getCallContext(PubsubContext.of(PublisherSettings.this.framework()), RoutingMetadata.of(PublisherSettings.this.topicPath(), partition));
                    return client.publishCallable().splitCall(responseStream, context);
                });
                if (PublisherSettings.this.enableIdempotence()) {
                    singlePartitionBuilder.setClientId(publisherClientId);
                }
                return singlePartitionBuilder.build();
            }

            @Override
            public void close() {
                client.close();
            }
        };
    }

    private AdminClient getAdminClient() throws ApiException {
        if (this.adminClient().isPresent()) {
            return this.adminClient().get();
        }
        try {
            return AdminClient.create(AdminClientSettings.newBuilder().setServiceClient(AdminServiceClient.create((AdminServiceSettings)((Object)ServiceClients.addDefaultSettings(this.topicPath().location().extractRegion(), AdminServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider()))))).setRegion(this.topicPath().location().extractRegion()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    Publisher instantiate() throws ApiException {
        if (this.batchingSettings().getFlowControlSettings().getMaxOutstandingElementCount() != null || this.batchingSettings().getFlowControlSettings().getMaxOutstandingRequestBytes() != null) {
            throw new CheckedApiException((String)"Pub/Sub Lite does not support flow control settings for publishing.", (StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT).underlying;
        }
        KeyExtractor keyExtractor = this.keyExtractor().orElse(KeyExtractor.DEFAULT);
        MessageTransformer messageTransformer = this.messageTransformer().orElseGet(() -> MessageTransforms.fromCpsPublishTransformer(keyExtractor));
        PartitionCountWatchingPublisherSettings.Builder publisherSettings = PartitionCountWatchingPublisherSettings.newBuilder().setTopic(this.topicPath()).setPublisherFactory(this.getPartitionPublisherFactory()).setAdminClient(this.getAdminClient());
        return new WrappingPublisher(publisherSettings.build().instantiate(), messageTransformer);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopicPath(TopicPath var1);

        public abstract Builder setKeyExtractor(KeyExtractor var1);

        public abstract Builder setMessageTransformer(MessageTransformer<PubsubMessage, Message> var1);

        public abstract Builder setBatchingSettings(BatchingSettings var1);

        public abstract Builder setEnableIdempotence(boolean var1);

        public abstract Builder setCredentialsProvider(CredentialsProvider var1);

        public abstract Builder setFramework(PubsubContext.Framework var1);

        public abstract Builder setServiceClient(PublisherServiceClient var1);

        public abstract Builder setAdminClient(AdminClient var1);

        @VisibleForTesting
        abstract Builder setUnderlyingBuilder(SinglePartitionPublisherBuilder.Builder var1);

        public abstract PublisherSettings build();
    }
}

