package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.protobuf.ByteString;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PublisherBuilder extends PublisherBuilder {

  private final TopicPath topic;

  private final Partition partition;

  private final BatchingSettings batching;

  private final StreamFactories.PublishStreamFactory streamFactory;

  private final Optional<ByteString> clientId;

  private AutoValue_PublisherBuilder(
      TopicPath topic,
      Partition partition,
      BatchingSettings batching,
      StreamFactories.PublishStreamFactory streamFactory,
      Optional<ByteString> clientId) {
    this.topic = topic;
    this.partition = partition;
    this.batching = batching;
    this.streamFactory = streamFactory;
    this.clientId = clientId;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  BatchingSettings batching() {
    return batching;
  }

  @Override
  StreamFactories.PublishStreamFactory streamFactory() {
    return streamFactory;
  }

  @Override
  Optional<ByteString> clientId() {
    return clientId;
  }

  @Override
  public String toString() {
    return "PublisherBuilder{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "batching=" + batching + ", "
        + "streamFactory=" + streamFactory + ", "
        + "clientId=" + clientId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PublisherBuilder) {
      PublisherBuilder that = (PublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.partition.equals(that.partition())
          && this.batching.equals(that.batching())
          && this.streamFactory.equals(that.streamFactory())
          && this.clientId.equals(that.clientId());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= batching.hashCode();
    h$ *= 1000003;
    h$ ^= streamFactory.hashCode();
    h$ *= 1000003;
    h$ ^= clientId.hashCode();
    return h$;
  }

  static final class Builder extends PublisherBuilder.Builder {
    private TopicPath topic;
    private Partition partition;
    private BatchingSettings batching;
    private StreamFactories.PublishStreamFactory streamFactory;
    private Optional<ByteString> clientId = Optional.empty();
    Builder() {
    }
    @Override
    public PublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setBatching(BatchingSettings batching) {
      if (batching == null) {
        throw new NullPointerException("Null batching");
      }
      this.batching = batching;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setStreamFactory(StreamFactories.PublishStreamFactory streamFactory) {
      if (streamFactory == null) {
        throw new NullPointerException("Null streamFactory");
      }
      this.streamFactory = streamFactory;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setClientId(ByteString clientId) {
      this.clientId = Optional.of(clientId);
      return this;
    }
    @Override
    PublisherBuilder autoBuild() {
      if (this.topic == null
          || this.partition == null
          || this.batching == null
          || this.streamFactory == null) {
        StringBuilder missing = new StringBuilder();
        if (this.topic == null) {
          missing.append(" topic");
        }
        if (this.partition == null) {
          missing.append(" partition");
        }
        if (this.batching == null) {
          missing.append(" batching");
        }
        if (this.streamFactory == null) {
          missing.append(" streamFactory");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PublisherBuilder(
          this.topic,
          this.partition,
          this.batching,
          this.streamFactory,
          this.clientId);
    }
  }

}
