/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.AbstractApiService;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.common.flogger.GoogleLogger;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class PartitionCountWatcherImpl
extends AbstractApiService
implements PartitionCountWatcher {
    private static final GoogleLogger log = GoogleLogger.forEnclosingClass();
    private final Duration period;
    private final TopicPath topicPath;
    private final AdminClient adminClient;
    private final ScheduledExecutorService executorService;
    private final Consumer<Long> partitionCountReceiver;
    private ScheduledFuture<?> partitionCountPoll;
    private Optional<Long> currentPartitionCount = Optional.empty();

    private PartitionCountWatcherImpl(TopicPath topicPath, AdminClient adminClient, Consumer<Long> receiver, Duration period) {
        this.period = period;
        this.topicPath = topicPath;
        this.adminClient = adminClient;
        this.partitionCountReceiver = receiver;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    private void pollTopicConfig() {
        Long partitionCount;
        try {
            partitionCount = (Long)this.adminClient.getTopicPartitionCount(this.topicPath).get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (!this.currentPartitionCount.isPresent()) {
                this.notifyFailed(ExtractStatus.toCanonical(e.getCause()));
                this.stop();
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)log.atWarning()).withCause((Throwable)e)).log("Failed to refresh partition count");
            return;
        }
        if (this.currentPartitionCount.isPresent() && this.currentPartitionCount.get().equals(partitionCount)) {
            return;
        }
        this.partitionCountReceiver.accept(partitionCount);
        if (!this.currentPartitionCount.isPresent()) {
            this.notifyStarted();
        }
        this.currentPartitionCount = Optional.of(partitionCount);
    }

    private void stop() {
        this.partitionCountPoll.cancel(true);
        this.adminClient.close();
    }

    protected void doStart() {
        this.partitionCountPoll = this.executorService.scheduleAtFixedRate(this::pollTopicConfig, 0L, this.period.toMillis(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        try {
            this.stop();
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyFailed(e);
        }
    }

    public static class Factory
    implements PartitionCountWatcher.Factory {
        private final TopicPath topicPath;
        private final AdminClient adminClient;
        private final Duration period;

        public Factory(TopicPath topicPath, AdminClient adminClient, Duration period) {
            this.topicPath = topicPath;
            this.adminClient = adminClient;
            this.period = period;
        }

        @Override
        public PartitionCountWatcher newWatcher(Consumer<Long> receiver) {
            return new PartitionCountWatcherImpl(this.topicPath, this.adminClient, receiver, this.period);
        }
    }
}

