/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatcher;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PartitionPublisherFactory;
import java.time.Duration;
import java.util.Optional;

final class AutoValue_PartitionCountWatchingPublisherSettings
extends PartitionCountWatchingPublisherSettings {
    private final TopicPath topic;
    private final PartitionPublisherFactory publisherFactory;
    private final PartitionCountWatcher.Factory configWatcherFactory;
    private final RoutingPolicy.Factory routingPolicyFactory;
    private final Duration configPollPeriod;

    private AutoValue_PartitionCountWatchingPublisherSettings(TopicPath topic, PartitionPublisherFactory publisherFactory, PartitionCountWatcher.Factory configWatcherFactory, RoutingPolicy.Factory routingPolicyFactory, Duration configPollPeriod) {
        this.topic = topic;
        this.publisherFactory = publisherFactory;
        this.configWatcherFactory = configWatcherFactory;
        this.routingPolicyFactory = routingPolicyFactory;
        this.configPollPeriod = configPollPeriod;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    PartitionPublisherFactory publisherFactory() {
        return this.publisherFactory;
    }

    @Override
    PartitionCountWatcher.Factory configWatcherFactory() {
        return this.configWatcherFactory;
    }

    @Override
    RoutingPolicy.Factory routingPolicyFactory() {
        return this.routingPolicyFactory;
    }

    @Override
    Duration configPollPeriod() {
        return this.configPollPeriod;
    }

    public String toString() {
        return "PartitionCountWatchingPublisherSettings{topic=" + this.topic + ", publisherFactory=" + this.publisherFactory + ", configWatcherFactory=" + this.configWatcherFactory + ", routingPolicyFactory=" + this.routingPolicyFactory + ", configPollPeriod=" + this.configPollPeriod + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PartitionCountWatchingPublisherSettings) {
            PartitionCountWatchingPublisherSettings that = (PartitionCountWatchingPublisherSettings)o;
            return this.topic.equals(that.topic()) && this.publisherFactory.equals(that.publisherFactory()) && this.configWatcherFactory.equals(that.configWatcherFactory()) && this.routingPolicyFactory.equals(that.routingPolicyFactory()) && this.configPollPeriod.equals(that.configPollPeriod());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.publisherFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.configWatcherFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.routingPolicyFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.configPollPeriod.hashCode();
    }

    static final class Builder
    extends PartitionCountWatchingPublisherSettings.Builder {
        private TopicPath topic;
        private PartitionPublisherFactory publisherFactory;
        private PartitionCountWatcher.Factory configWatcherFactory;
        private RoutingPolicy.Factory routingPolicyFactory;
        private Duration configPollPeriod;

        Builder() {
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        TopicPath topic() {
            if (this.topic == null) {
                throw new IllegalStateException("Property \"topic\" has not been set");
            }
            return this.topic;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setPublisherFactory(PartitionPublisherFactory publisherFactory) {
            if (publisherFactory == null) {
                throw new NullPointerException("Null publisherFactory");
            }
            this.publisherFactory = publisherFactory;
            return this;
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setConfigWatcherFactory(PartitionCountWatcher.Factory configWatcherFactory) {
            if (configWatcherFactory == null) {
                throw new NullPointerException("Null configWatcherFactory");
            }
            this.configWatcherFactory = configWatcherFactory;
            return this;
        }

        @Override
        Optional<PartitionCountWatcher.Factory> configWatcherFactory() {
            if (this.configWatcherFactory == null) {
                return Optional.empty();
            }
            return Optional.of(this.configWatcherFactory);
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setRoutingPolicyFactory(RoutingPolicy.Factory routingPolicyFactory) {
            if (routingPolicyFactory == null) {
                throw new NullPointerException("Null routingPolicyFactory");
            }
            this.routingPolicyFactory = routingPolicyFactory;
            return this;
        }

        @Override
        Optional<RoutingPolicy.Factory> routingPolicyFactory() {
            if (this.routingPolicyFactory == null) {
                return Optional.empty();
            }
            return Optional.of(this.routingPolicyFactory);
        }

        @Override
        public PartitionCountWatchingPublisherSettings.Builder setConfigPollPeriod(Duration configPollPeriod) {
            if (configPollPeriod == null) {
                throw new NullPointerException("Null configPollPeriod");
            }
            this.configPollPeriod = configPollPeriod;
            return this;
        }

        @Override
        Duration configPollPeriod() {
            if (this.configPollPeriod == null) {
                throw new IllegalStateException("Property \"configPollPeriod\" has not been set");
            }
            return this.configPollPeriod;
        }

        @Override
        PartitionCountWatchingPublisherSettings autoBuild() {
            String missing = "";
            if (this.topic == null) {
                missing = missing + " topic";
            }
            if (this.publisherFactory == null) {
                missing = missing + " publisherFactory";
            }
            if (this.configWatcherFactory == null) {
                missing = missing + " configWatcherFactory";
            }
            if (this.routingPolicyFactory == null) {
                missing = missing + " routingPolicyFactory";
            }
            if (this.configPollPeriod == null) {
                missing = missing + " configPollPeriod";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PartitionCountWatchingPublisherSettings(this.topic, this.publisherFactory, this.configWatcherFactory, this.routingPolicyFactory, this.configPollPeriod);
        }
    }
}

