/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.CommitterBuilder;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import java.util.Optional;

final class AutoValue_CommitterBuilder
extends CommitterBuilder {
    private final SubscriptionPath subscriptionPath;
    private final Partition partition;
    private final Optional<CursorServiceClient> serviceClient;

    private AutoValue_CommitterBuilder(SubscriptionPath subscriptionPath, Partition partition, Optional<CursorServiceClient> serviceClient) {
        this.subscriptionPath = subscriptionPath;
        this.partition = partition;
        this.serviceClient = serviceClient;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    Optional<CursorServiceClient> serviceClient() {
        return this.serviceClient;
    }

    public String toString() {
        return "CommitterBuilder{subscriptionPath=" + this.subscriptionPath + ", partition=" + this.partition + ", serviceClient=" + this.serviceClient + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CommitterBuilder) {
            CommitterBuilder that = (CommitterBuilder)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.partition.equals(that.partition()) && this.serviceClient.equals(that.serviceClient());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        return h$ ^= this.serviceClient.hashCode();
    }

    static final class Builder
    extends CommitterBuilder.Builder {
        private SubscriptionPath subscriptionPath;
        private Partition partition;
        private Optional<CursorServiceClient> serviceClient = Optional.empty();

        Builder() {
        }

        @Override
        public CommitterBuilder.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public CommitterBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public CommitterBuilder.Builder setServiceClient(CursorServiceClient serviceClient) {
            this.serviceClient = Optional.of(serviceClient);
            return this;
        }

        @Override
        CommitterBuilder autoBuild() {
            String missing = "";
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CommitterBuilder(this.subscriptionPath, this.partition, this.serviceClient);
        }
    }
}

