/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.AutoValue_SinglePartitionPublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisher;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import io.grpc.StatusException;
import java.util.Optional;

@AutoValue
public abstract class SinglePartitionPublisherBuilder {
    abstract TopicPath topic();

    abstract Partition partition();

    abstract Optional<PublisherServiceGrpc.PublisherServiceStub> stub();

    abstract Optional<BatchingSettings> batchingSettings();

    abstract PubsubContext context();

    public static Builder newBuilder() {
        return new AutoValue_SinglePartitionPublisherBuilder.Builder().setContext(PubsubContext.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTopic(TopicPath var1);

        public abstract Builder setPartition(Partition var1);

        public abstract Builder setStub(Optional<PublisherServiceGrpc.PublisherServiceStub> var1);

        public abstract Builder setBatchingSettings(Optional<BatchingSettings> var1);

        public abstract Builder setContext(PubsubContext var1);

        abstract SinglePartitionPublisherBuilder autoBuild();

        public SinglePartitionPublisher build() throws StatusException {
            SinglePartitionPublisherBuilder builder = this.autoBuild();
            PublisherBuilder.Builder publisherBuilder = PublisherBuilder.builder().setTopic(builder.topic()).setPartition(builder.partition()).setContext(builder.context());
            builder.stub().ifPresent(publisherBuilder::setStub);
            builder.batchingSettings().ifPresent(publisherBuilder::setBatching);
            return new SinglePartitionPublisher(publisherBuilder.build(), builder.partition());
        }
    }
}

