/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.wire.PublisherBuilder;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.proto.PublisherServiceGrpc;
import java.util.Optional;

final class AutoValue_PublisherBuilder
extends PublisherBuilder {
    private final TopicPath topic;
    private final Partition partition;
    private final BatchingSettings batching;
    private final Optional<PublisherServiceGrpc.PublisherServiceStub> stub;
    private final PubsubContext context;

    private AutoValue_PublisherBuilder(TopicPath topic, Partition partition, BatchingSettings batching, Optional<PublisherServiceGrpc.PublisherServiceStub> stub, PubsubContext context) {
        this.topic = topic;
        this.partition = partition;
        this.batching = batching;
        this.stub = stub;
        this.context = context;
    }

    @Override
    TopicPath topic() {
        return this.topic;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    BatchingSettings batching() {
        return this.batching;
    }

    @Override
    Optional<PublisherServiceGrpc.PublisherServiceStub> stub() {
        return this.stub;
    }

    @Override
    PubsubContext context() {
        return this.context;
    }

    public String toString() {
        return "PublisherBuilder{topic=" + this.topic + ", partition=" + this.partition + ", batching=" + this.batching + ", stub=" + this.stub + ", context=" + this.context + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PublisherBuilder) {
            PublisherBuilder that = (PublisherBuilder)o;
            return this.topic.equals(that.topic()) && this.partition.equals(that.partition()) && this.batching.equals(that.batching()) && this.stub.equals(that.stub()) && this.context.equals(that.context());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        h$ ^= this.batching.hashCode();
        h$ *= 1000003;
        h$ ^= this.stub.hashCode();
        h$ *= 1000003;
        return h$ ^= this.context.hashCode();
    }

    static final class Builder
    extends PublisherBuilder.Builder {
        private TopicPath topic;
        private Partition partition;
        private BatchingSettings batching;
        private Optional<PublisherServiceGrpc.PublisherServiceStub> stub = Optional.empty();
        private PubsubContext context;

        Builder() {
        }

        @Override
        public PublisherBuilder.Builder setTopic(TopicPath topic) {
            if (topic == null) {
                throw new NullPointerException("Null topic");
            }
            this.topic = topic;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setBatching(BatchingSettings batching) {
            if (batching == null) {
                throw new NullPointerException("Null batching");
            }
            this.batching = batching;
            return this;
        }

        @Override
        public PublisherBuilder.Builder setStub(PublisherServiceGrpc.PublisherServiceStub stub) {
            this.stub = Optional.of(stub);
            return this;
        }

        @Override
        public PublisherBuilder.Builder setContext(PubsubContext context) {
            if (context == null) {
                throw new NullPointerException("Null context");
            }
            this.context = context;
            return this;
        }

        @Override
        PublisherBuilder autoBuild() {
            String missing = "";
            if (this.topic == null) {
                missing = missing + " topic";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.batching == null) {
                missing = missing + " batching";
            }
            if (this.context == null) {
                missing = missing + " context";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PublisherBuilder(this.topic, this.partition, this.batching, this.stub, this.context);
        }
    }
}

