/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.PublishMetadata;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import io.grpc.StatusException;
import java.util.concurrent.Executor;

public class WrappingPublisher
extends ProxyService
implements Publisher {
    private final com.google.cloud.pubsublite.internal.Publisher<PublishMetadata> wirePublisher;
    private final MessageTransformer<PubsubMessage, Message> transformer;

    public WrappingPublisher(com.google.cloud.pubsublite.internal.Publisher<PublishMetadata> wirePublisher, MessageTransformer<PubsubMessage, Message> transformer) throws StatusException {
        this.wirePublisher = wirePublisher;
        this.transformer = transformer;
        this.addServices(wirePublisher);
    }

    @Override
    protected void start() {
    }

    @Override
    protected void stop() {
    }

    @Override
    protected void handlePermanentError(StatusException error) {
    }

    public ApiFuture<String> publish(PubsubMessage message) {
        Message wireMessage;
        try {
            wireMessage = this.transformer.transform(message);
        }
        catch (StatusException e) {
            this.onPermanentError(e);
            return ApiFutures.immediateFailedFuture((Throwable)e);
        }
        return ApiFutures.transform(this.wirePublisher.publish(wireMessage), PublishMetadata::encode, (Executor)MoreExecutors.directExecutor());
    }
}

