/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub;

import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.cloudpubsub.KeyExtractor;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.PubsubMessage;
import io.grpc.Status;
import io.grpc.StatusException;
import java.util.Base64;
import java.util.Collection;

public class MessageTransforms {
    public static final String PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO = "x-goog-pubsublite-event-time-timestamp-proto";

    private MessageTransforms() {
    }

    public static String encodeAttributeEventTime(Timestamp timestamp) {
        return Base64.getEncoder().encodeToString(timestamp.toByteArray());
    }

    public static Timestamp decodeAttributeEventTime(String encoded) throws StatusException {
        try {
            return Timestamp.parseFrom((byte[])Base64.getDecoder().decode(encoded));
        }
        catch (Exception e) {
            throw Status.INVALID_ARGUMENT.withCause((Throwable)e).asException();
        }
    }

    private static String parseAttributes(Collection<ByteString> values) throws StatusException {
        Preconditions.checkArgument(values.size() == 1, "Received an unparseable message with multiple values for an attribute.");
        ByteString attribute = values.iterator().next();
        Preconditions.checkArgument(attribute.isValidUtf8(), "Received an unparseable message with a non-utf8 attribute.");
        return attribute.toStringUtf8();
    }

    public static MessageTransformer<SequencedMessage, PubsubMessage> toCpsSubscribeTransformer() {
        return message -> {
            PubsubMessage.Builder outBuilder = MessageTransforms.toCpsPublishTransformer().transform(message.message()).toBuilder();
            outBuilder.setMessageId(Long.toString(message.offset().value()));
            outBuilder.setPublishTime(message.publishTime());
            return outBuilder.build();
        };
    }

    public static MessageTransformer<Message, PubsubMessage> toCpsPublishTransformer() {
        return message -> {
            Preconditions.checkArgument(message.key().isValidUtf8(), "Message key is not valid utf-8. Unable to parse message.");
            Preconditions.checkArgument(!message.attributes().containsKey((Object)PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO), "Special timestamp attribute exists in wire message. Unable to parse message.");
            PubsubMessage.Builder outBuilder = PubsubMessage.newBuilder();
            outBuilder.setOrderingKey(message.key().toStringUtf8());
            outBuilder.setData(message.data());
            for (String key : message.attributes().keys()) {
                outBuilder.putAttributes(key, MessageTransforms.parseAttributes((Collection<ByteString>)message.attributes().get((Object)key)));
            }
            message.eventTime().ifPresent(eventTime -> outBuilder.putAttributes(PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO, MessageTransforms.encodeAttributeEventTime(eventTime)));
            return outBuilder.build();
        };
    }

    public static MessageTransformer<PubsubMessage, Message> fromCpsPublishTransformer(KeyExtractor keyExtractor) {
        return message -> {
            Message.Builder outBuilder = Message.builder();
            if (message.containsAttributes(PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO)) {
                outBuilder = outBuilder.setEventTime(MessageTransforms.decodeAttributeEventTime(message.getAttributesOrThrow(PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO)));
            }
            outBuilder = outBuilder.setData(message.getData());
            outBuilder = outBuilder.setKey(keyExtractor.extractKey((PubsubMessage)message));
            ImmutableListMultimap.Builder attributesBuilder = ImmutableListMultimap.builder();
            message.getAttributesMap().forEach((key, value) -> {
                if (!PUBSUB_LITE_EVENT_TIME_TIMESTAMP_PROTO.equals(key)) {
                    attributesBuilder.put(key, (Object)ByteString.copyFromUtf8((String)value));
                }
            });
            outBuilder = outBuilder.setAttributes((ImmutableListMultimap<String, ByteString>)attributesBuilder.build());
            return outBuilder.build();
        };
    }
}

