/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_PublishMetadata;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.Preconditions;
import io.grpc.Status;
import io.grpc.StatusException;

@AutoValue
public abstract class PublishMetadata {
    public abstract Partition partition();

    public abstract Offset offset();

    public static PublishMetadata of(Partition partition, Offset offset) {
        return new AutoValue_PublishMetadata(partition, offset);
    }

    public static PublishMetadata decode(String encoded) throws StatusException {
        String[] split = encoded.split(":");
        Preconditions.checkArgument(split.length == 2, "Invalid encoded PublishMetadata.");
        try {
            Partition partition = Partition.of(Long.parseLong(split[0]));
            Offset offset = Offset.of(Long.parseLong(split[1]));
            return PublishMetadata.of(partition, offset);
        }
        catch (NumberFormatException e) {
            throw Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription("Invalid encoded PublishMetadata.").asException();
        }
    }

    public String encode() {
        return String.format("%s:%s", this.partition().value(), this.offset().value());
    }
}

