/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.api.core.ApiFuture;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.SubscriptionPaths;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.TopicPaths;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.proto.Subscription;
import io.grpc.StatusException;
import java.util.concurrent.ExecutionException;

public final class PartitionLookupUtils {
    private PartitionLookupUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int numPartitions(TopicPath topic) throws StatusException {
        try (AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(TopicPaths.getZone(topic).region()).build());){
            int n = PartitionLookupUtils.numPartitions(topic, client);
            return n;
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    public static int numPartitions(TopicPath topic, AdminClient client) throws StatusException {
        ApiFuture<Long> partitionCountFuture = client.getTopicPartitionCount(topic);
        try {
            long numPartitions = (Long)partitionCountFuture.get();
            Preconditions.checkState(numPartitions > 0L, "Config has 0 or less partitions configured. This config is invalid.");
            Preconditions.checkState(numPartitions < Integer.MAX_VALUE, "Config has more than Integer.MAX_VALUE partitions configured. This config cannot be used with this client library.");
            return (int)numPartitions;
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical(e.getCause());
        }
        catch (InterruptedException t) {
            throw ExtractStatus.toCanonical(t);
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int numPartitions(SubscriptionPath subscription) throws StatusException {
        try (AdminClient client = AdminClient.create(AdminClientSettings.newBuilder().setRegion(SubscriptionPaths.getZone(subscription).region()).build());){
            int n = PartitionLookupUtils.numPartitions(subscription, client);
            return n;
        }
        catch (Exception e) {
            throw ExtractStatus.toCanonical(e);
        }
    }

    public static int numPartitions(SubscriptionPath subscription, AdminClient client) throws StatusException {
        ApiFuture<Subscription> subscriptionFuture = client.getSubscription(subscription);
        try {
            return PartitionLookupUtils.numPartitions(TopicPath.of(((Subscription)subscriptionFuture.get()).getTopic()), client);
        }
        catch (ExecutionException e) {
            throw ExtractStatus.toCanonical(e.getCause());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical(t);
        }
    }
}

