/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiClock;
import com.google.api.core.ApiService;
import com.google.api.core.BetaApi;
import com.google.api.core.CurrentMillisClock;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.Distribution;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.MessageReceiverWithAckResponse;
import com.google.cloud.pubsub.v1.OpenTelemetryPubsubTracer;
import com.google.cloud.pubsub.v1.StreamingSubscriberConnection;
import com.google.cloud.pubsub.v1.SubscriberInterface;
import com.google.cloud.pubsub.v1.SubscriberShutdownSettings;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Subscriber
extends AbstractApiService
implements SubscriberInterface {
    private static final int THREADS_PER_CHANNEL = 5;
    private static final int MAX_INBOUND_MESSAGE_SIZE = 0x1400000;
    private static final int MAX_INBOUND_METADATA_SIZE = 0x400000;
    @InternalApi
    static final java.time.Duration DEFAULT_MAX_ACK_EXTENSION_PERIOD = java.time.Duration.ofMinutes(60L);
    @InternalApi
    static final java.time.Duration DEFAULT_MIN_ACK_DEADLINE_EXTENSION_EXACTLY_ONCE_DELIVERY = java.time.Duration.ofMinutes(1L);
    @InternalApi
    static final java.time.Duration DEFAULT_MIN_ACK_DEADLINE_EXTENSION = java.time.Duration.ofMinutes(0L);
    @InternalApi
    static final java.time.Duration DEFAULT_MAX_ACK_DEADLINE_EXTENSION = java.time.Duration.ofSeconds(0L);
    @InternalApi
    static final java.time.Duration MIN_STREAM_ACK_DEADLINE = java.time.Duration.ofSeconds(10L);
    @InternalApi
    static final java.time.Duration MAX_STREAM_ACK_DEADLINE = java.time.Duration.ofSeconds(600L);
    @InternalApi
    static final java.time.Duration STREAM_ACK_DEADLINE_DEFAULT = java.time.Duration.ofSeconds(60L);
    @InternalApi
    static final java.time.Duration STREAM_ACK_DEADLINE_EXACTLY_ONCE_DELIVERY_DEFAULT = java.time.Duration.ofSeconds(60L);
    @InternalApi
    static final java.time.Duration ACK_EXPIRATION_PADDING_DEFAULT = java.time.Duration.ofSeconds(5L);
    private static final Logger logger = Logger.getLogger(Subscriber.class.getName());
    private static final String OPEN_TELEMETRY_TRACER_NAME = "com.google.cloud.pubsub.v1";
    private final String subscriptionName;
    private final FlowControlSettings flowControlSettings;
    private final boolean useLegacyFlowControl;
    private final java.time.Duration maxAckExtensionPeriod;
    private final java.time.Duration maxDurationPerAckExtension;
    private final boolean maxDurationPerAckExtensionDefaultUsed;
    private final java.time.Duration minDurationPerAckExtension;
    private final boolean minDurationPerAckExtensionDefaultUsed;
    private final long protocolVersion = 1L;
    private final ExecutorProvider executorProvider;
    @Nullable
    private final ScheduledExecutorService alarmsExecutor;
    private final Distribution ackLatencyDistribution = new Distribution(Math.toIntExact(MAX_STREAM_ACK_DEADLINE.getSeconds()) + 1);
    private SubscriberStub subscriberStub;
    private final SubscriberStubSettings subStubSettings;
    private final FlowController flowController;
    private final int numPullers;
    private final MessageReceiver receiver;
    private final MessageReceiverWithAckResponse receiverWithAckResponse;
    private final List<StreamingSubscriberConnection> streamingSubscriberConnections;
    private final ApiClock clock;
    private final List<BackgroundResource> backgroundResources = new ArrayList<BackgroundResource>();
    private final boolean enableOpenTelemetryTracing;
    private final OpenTelemetry openTelemetry;
    private OpenTelemetryPubsubTracer tracer = new OpenTelemetryPubsubTracer(null, false);
    private final SubscriberShutdownSettings subscriberShutdownSettings;

    private Subscriber(Builder builder) {
        Tracer openTelemetryTracer;
        TransportChannelProvider channelProvider;
        this.receiver = builder.receiver;
        this.receiverWithAckResponse = builder.receiverWithAckResponse;
        this.flowControlSettings = builder.flowControlSettings;
        this.useLegacyFlowControl = builder.useLegacyFlowControl;
        this.subscriptionName = builder.subscription;
        this.maxAckExtensionPeriod = builder.maxAckExtensionPeriod;
        this.maxDurationPerAckExtension = builder.maxDurationPerAckExtension;
        this.maxDurationPerAckExtensionDefaultUsed = builder.maxDurationPerAckExtensionDefaultUsed;
        this.minDurationPerAckExtension = builder.minDurationPerAckExtension;
        this.minDurationPerAckExtensionDefaultUsed = builder.minDurationPerAckExtensionDefaultUsed;
        this.clock = builder.clock.isPresent() ? (ApiClock)builder.clock.get() : CurrentMillisClock.getDefaultClock();
        this.flowController = new FlowController(builder.flowControlSettings.toBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build());
        this.numPullers = builder.parallelPullCount;
        this.executorProvider = builder.executorProvider;
        ExecutorProvider systemExecutorProvider = builder.systemExecutorProvider;
        this.alarmsExecutor = systemExecutorProvider.getExecutor();
        if (systemExecutorProvider.shouldAutoClose()) {
            this.backgroundResources.add((BackgroundResource)new ExecutorAsBackgroundResource((ExecutorService)this.alarmsExecutor));
        }
        if ((channelProvider = builder.channelProvider).acceptsPoolSize()) {
            channelProvider = channelProvider.withPoolSize(this.numPullers);
        }
        try {
            this.subStubSettings = ((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)((SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setExecutorProvider(systemExecutorProvider)).setCredentialsProvider(builder.credentialsProvider)).setTransportChannelProvider(channelProvider)).setHeaderProvider(builder.headerProvider)).setEndpoint(builder.endpoint)).setUniverseDomain(builder.universeDomain)).build();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.enableOpenTelemetryTracing = builder.enableOpenTelemetryTracing;
        this.openTelemetry = builder.openTelemetry;
        this.subscriberShutdownSettings = builder.subscriberShutdownSettings;
        if (this.openTelemetry != null && this.enableOpenTelemetryTracing && (openTelemetryTracer = builder.openTelemetry.getTracer(OPEN_TELEMETRY_TRACER_NAME)) != null) {
            this.tracer = new OpenTelemetryPubsubTracer(openTelemetryTracer, this.enableOpenTelemetryTracing);
        }
        this.streamingSubscriberConnections = new ArrayList<StreamingSubscriberConnection>(this.numPullers);
        this.ackLatencyDistribution.record(Math.toIntExact(MIN_STREAM_ACK_DEADLINE.getSeconds()));
    }

    public static Builder newBuilder(ProjectSubscriptionName subscription, MessageReceiver receiver) {
        return Subscriber.newBuilder(subscription.toString(), receiver);
    }

    public static Builder newBuilder(ProjectSubscriptionName subscription, MessageReceiverWithAckResponse receiver) {
        return Subscriber.newBuilder(subscription.toString(), receiver);
    }

    public static Builder newBuilder(String subscription, MessageReceiver receiver) {
        return new Builder(subscription, receiver);
    }

    public static Builder newBuilder(String subscription, MessageReceiverWithAckResponse receiver) {
        return new Builder(subscription, receiver);
    }

    public static Integer getDeliveryAttempt(PubsubMessage message) {
        if (!message.containsAttributes("googclient_deliveryattempt")) {
            return null;
        }
        return Integer.parseInt(message.getAttributesOrThrow("googclient_deliveryattempt"));
    }

    public String getSubscriptionNameString() {
        return this.subscriptionName;
    }

    public FlowControlSettings getFlowControlSettings() {
        return this.flowControlSettings;
    }

    public ApiService startAsync() {
        return super.startAsync();
    }

    protected void doStart() {
        logger.log(Level.FINE, "Starting subscriber group.");
        try {
            this.subscriberStub = GrpcSubscriberStub.create(this.subStubSettings);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.startStreamingConnections();
                    Subscriber.this.notifyStarted();
                }
                catch (Throwable t) {
                    Subscriber.this.notifyFailed(t);
                }
            }
        }).start();
    }

    protected void doStop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.runShutdown();
                    Subscriber.this.notifyStopped();
                }
                catch (Exception e) {
                    Subscriber.this.notifyFailed(e);
                }
            }
        }).start();
    }

    private void runShutdown() {
        java.time.Duration timeout = this.subscriberShutdownSettings.getTimeout();
        long deadlineMillis = -1L;
        if (!timeout.isNegative()) {
            deadlineMillis = this.clock.millisTime() + timeout.toMillis();
        }
        this.stopAllStreamingConnections(deadlineMillis);
        this.shutdownBackgroundResources();
        this.subscriberStub.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStreamingConnections() {
        List<StreamingSubscriberConnection> list = this.streamingSubscriberConnections;
        synchronized (list) {
            for (int i = 0; i < this.numPullers; ++i) {
                ScheduledExecutorService executor = this.executorProvider.getExecutor();
                if (this.executorProvider.shouldAutoClose()) {
                    this.backgroundResources.add((BackgroundResource)new ExecutorAsBackgroundResource((ExecutorService)executor));
                }
                StreamingSubscriberConnection.Builder streamingSubscriberConnectionBuilder = this.receiverWithAckResponse != null ? StreamingSubscriberConnection.newBuilder(this.receiverWithAckResponse) : StreamingSubscriberConnection.newBuilder(this.receiver);
                StreamingSubscriberConnection streamingSubscriberConnection = streamingSubscriberConnectionBuilder.setSubscription(this.subscriptionName).setAckExpirationPadding(ACK_EXPIRATION_PADDING_DEFAULT).setMaxAckExtensionPeriod(this.maxAckExtensionPeriod).setMinDurationPerAckExtension(this.minDurationPerAckExtension).setMinDurationPerAckExtensionDefaultUsed(this.minDurationPerAckExtensionDefaultUsed).setMaxDurationPerAckExtension(this.maxDurationPerAckExtension).setMaxDurationPerAckExtensionDefaultUsed(this.maxDurationPerAckExtensionDefaultUsed).setAckLatencyDistribution(this.ackLatencyDistribution).setSubscriberStub(this.subscriberStub).setChannelAffinity(i).setFlowControlSettings(this.flowControlSettings).setFlowController(this.flowController).setUseLegacyFlowControl(this.useLegacyFlowControl).setExecutor(executor).setSystemExecutor(this.alarmsExecutor).setClock(this.clock).setEnableOpenTelemetryTracing(this.enableOpenTelemetryTracing).setTracer(this.tracer).setSubscriberShutdownSettings(this.subscriberShutdownSettings).setProtocolVersion(1L).build();
                this.streamingSubscriberConnections.add(streamingSubscriberConnection);
            }
            this.startConnections(this.streamingSubscriberConnections, new ApiService.Listener(){

                public void failed(ApiService.State from, Throwable failure) {
                    block2: {
                        Subscriber.this.runShutdown();
                        try {
                            Subscriber.this.notifyFailed(failure);
                        }
                        catch (IllegalStateException e) {
                            if (!Subscriber.this.isRunning()) break block2;
                            throw e;
                        }
                    }
                }
            });
        }
    }

    private void stopAllStreamingConnections(long deadlineMillis) {
        this.stopConnections(this.streamingSubscriberConnections, deadlineMillis);
    }

    private void shutdownBackgroundResources() {
        for (BackgroundResource resource : this.backgroundResources) {
            resource.shutdown();
        }
    }

    private void startConnections(List<? extends ApiService> connections, ApiService.Listener connectionsListener) {
        for (ApiService apiService : connections) {
            apiService.addListener(connectionsListener, (Executor)this.alarmsExecutor);
            apiService.startAsync();
        }
        for (ApiService apiService : connections) {
            apiService.awaitRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopConnections(List<? extends ApiService> connections, long deadlineMillis) {
        ArrayList<? extends ApiService> liveConnections;
        Iterator<? extends ApiService> iterator = connections;
        synchronized (iterator) {
            liveConnections = new ArrayList<ApiService>(connections);
            connections.clear();
        }
        for (ApiService apiService : liveConnections) {
            apiService.stopAsync();
        }
        for (ApiService apiService : liveConnections) {
            try {
                if (deadlineMillis < 0L) {
                    apiService.awaitTerminated();
                    continue;
                }
                long remaining = deadlineMillis - this.clock.millisTime();
                if (remaining < 0L) {
                    remaining = 0L;
                }
                apiService.awaitTerminated(remaining, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Exception while waiting for a connection to terminate", e);
                break;
            }
        }
    }

    public static final class Builder {
        static final FlowControlSettings DEFAULT_FLOW_CONTROL_SETTINGS = FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(1000L)).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).build();
        private static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5).build();
        private static final AtomicInteger SYSTEM_EXECUTOR_COUNTER = new AtomicInteger();
        private String subscription;
        private MessageReceiver receiver;
        private MessageReceiverWithAckResponse receiverWithAckResponse;
        private java.time.Duration maxAckExtensionPeriod = DEFAULT_MAX_ACK_EXTENSION_PERIOD;
        private java.time.Duration minDurationPerAckExtension = DEFAULT_MIN_ACK_DEADLINE_EXTENSION;
        private boolean minDurationPerAckExtensionDefaultUsed = true;
        private java.time.Duration maxDurationPerAckExtension = DEFAULT_MAX_ACK_DEADLINE_EXTENSION;
        private boolean maxDurationPerAckExtensionDefaultUsed = true;
        private boolean useLegacyFlowControl = false;
        private FlowControlSettings flowControlSettings = DEFAULT_FLOW_CONTROL_SETTINGS;
        private ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        private ExecutorProvider systemExecutorProvider = null;
        private TransportChannelProvider channelProvider = SubscriptionAdminSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).setMaxInboundMetadataSize(Integer.valueOf(0x400000)).setKeepAliveTimeDuration(java.time.Duration.ofMinutes(5L)).build();
        private HeaderProvider headerProvider = new NoHeaderProvider();
        private CredentialsProvider credentialsProvider = SubscriptionAdminSettings.defaultCredentialsProviderBuilder().build();
        private Optional<ApiClock> clock = Optional.absent();
        private int parallelPullCount = 1;
        private String endpoint = null;
        private String universeDomain = null;
        private boolean enableOpenTelemetryTracing = false;
        private OpenTelemetry openTelemetry = null;
        private SubscriberShutdownSettings subscriberShutdownSettings = SubscriberShutdownSettings.newBuilder().build();

        Builder(String subscription, MessageReceiver receiver) {
            this.subscription = subscription;
            this.receiver = receiver;
        }

        Builder(String subscription, MessageReceiverWithAckResponse receiverWithAckResponse) {
            this.subscription = subscription;
            this.receiverWithAckResponse = receiverWithAckResponse;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings);
            return this;
        }

        public Builder setUseLegacyFlowControl(boolean value) {
            this.useLegacyFlowControl = value;
            return this;
        }

        @ObsoleteApi(value="Use setMaxAckExtensionPeriodDuration(java.time.Duration) instead")
        public Builder setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
            return this.setMaxAckExtensionPeriodDuration(TimeConversionUtils.toJavaTimeDuration((Duration)maxAckExtensionPeriod));
        }

        public Builder setMaxAckExtensionPeriodDuration(java.time.Duration maxAckExtensionPeriod) {
            Preconditions.checkArgument((maxAckExtensionPeriod.toMillis() >= 0L ? 1 : 0) != 0);
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
            return this;
        }

        @ObsoleteApi(value="Use setMaxDurationPerAckExtensionDuration(java.time.Duration) instead")
        public Builder setMaxDurationPerAckExtension(Duration maxDurationPerAckExtension) {
            return this.setMaxDurationPerAckExtensionDuration(TimeConversionUtils.toJavaTimeDuration((Duration)maxDurationPerAckExtension));
        }

        public Builder setMaxDurationPerAckExtensionDuration(java.time.Duration maxDurationPerAckExtension) {
            Preconditions.checkArgument((maxDurationPerAckExtension.toMillis() >= 0L && (this.minDurationPerAckExtensionDefaultUsed || this.minDurationPerAckExtension.toMillis() < maxDurationPerAckExtension.toMillis()) ? 1 : 0) != 0);
            this.maxDurationPerAckExtension = maxDurationPerAckExtension;
            this.maxDurationPerAckExtensionDefaultUsed = false;
            return this;
        }

        @ObsoleteApi(value="Use setMinDurationPerAckExtensionDuration(java.time.Duration) instead")
        public Builder setMinDurationPerAckExtension(Duration minDurationPerAckExtension) {
            return this.setMinDurationPerAckExtensionDuration(TimeConversionUtils.toJavaTimeDuration((Duration)minDurationPerAckExtension));
        }

        public Builder setMinDurationPerAckExtensionDuration(java.time.Duration minDurationPerAckExtension) {
            Preconditions.checkArgument((minDurationPerAckExtension.toMillis() >= 0L && (this.maxDurationPerAckExtensionDefaultUsed || minDurationPerAckExtension.toMillis() < this.maxDurationPerAckExtension.toMillis()) ? 1 : 0) != 0);
            this.minDurationPerAckExtension = minDurationPerAckExtension;
            this.minDurationPerAckExtensionDefaultUsed = false;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setSystemExecutorProvider(ExecutorProvider executorProvider) {
            this.systemExecutorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Builder setParallelPullCount(int parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
            return this;
        }

        Builder setClock(ApiClock clock) {
            this.clock = Optional.of((Object)clock);
            return this;
        }

        public Builder setEnableOpenTelemetryTracing(boolean enableOpenTelemetryTracing) {
            this.enableOpenTelemetryTracing = enableOpenTelemetryTracing;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        @BetaApi(value="The surface for SubscriberShutdownSettings is not stable yet and may be changed in the future.")
        public Builder setSubscriberShutdownSettings(SubscriberShutdownSettings subscriberShutdownSettings) {
            this.subscriberShutdownSettings = (SubscriberShutdownSettings)Preconditions.checkNotNull((Object)subscriberShutdownSettings);
            return this;
        }

        public static FlowControlSettings getDefaultFlowControlSettings() {
            return DEFAULT_FLOW_CONTROL_SETTINGS;
        }

        public Subscriber build() {
            if (this.systemExecutorProvider == null) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Subscriber-SE-" + SYSTEM_EXECUTOR_COUNTER.incrementAndGet() + "-%d").build();
                int threadCount = Math.max(6, 2 * this.parallelPullCount);
                final ScheduledExecutorService executor = Executors.newScheduledThreadPool(threadCount, threadFactory);
                this.systemExecutorProvider = new ExecutorProvider(){

                    public boolean shouldAutoClose() {
                        return true;
                    }

                    public ScheduledExecutorService getExecutor() {
                        return executor;
                    }
                };
            }
            return new Subscriber(this);
        }
    }
}

