/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.PubsubMessageWrapper;
import com.google.pubsub.v1.PubsubMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtil {
    private static final Logger slowAckLogger = Logger.getLogger("slow-ack");
    private static final Logger callbackDeliveryLogger = Logger.getLogger("callback-delivery");
    private static final Logger expiryLogger = Logger.getLogger("expiry");
    private static final Logger callbackExceptionsLogger = Logger.getLogger("callback-exceptions");
    private static final Logger ackBatchLogger = Logger.getLogger("ack-batch");
    private static final Logger subscriberFlowControlLogger = Logger.getLogger("subscriber-flow-control");
    private static final Logger ackNackLogger = Logger.getLogger("ack-nack");
    private static final Logger publishBatchLogger = Logger.getLogger("publish-batch");
    private static final Logger subscriberStreamsLogger = Logger.getLogger("subscriber-streams");

    private String getSubscriptionLogPrefix(PubsubMessageWrapper messageWrapper, String ackId, boolean exactlyOnceDeliveryEnabled) {
        if (messageWrapper == null || messageWrapper.getPubsubMessage() == null) {
            return " Ack ID: " + ackId + ", Exactly Once Delivery: " + exactlyOnceDeliveryEnabled + " (Message details not available)";
        }
        PubsubMessage message = messageWrapper.getPubsubMessage();
        String messageId = message.getMessageId();
        String orderingKey = message.getOrderingKey();
        StringBuilder sb = new StringBuilder();
        sb.append("Message ID: ").append(messageId);
        sb.append(", Ack ID: ").append(ackId);
        if (orderingKey != null && !orderingKey.isEmpty()) {
            sb.append(", Ordering Key: ").append(orderingKey);
        }
        sb.append(", Exactly Once Delivery: ").append(exactlyOnceDeliveryEnabled);
        return sb.toString();
    }

    private String getPublisherLogPrefix(PubsubMessageWrapper messageWrapper) {
        if (messageWrapper == null || messageWrapper.getPubsubMessage() == null) {
            return " (Message details not available)";
        }
        PubsubMessage message = messageWrapper.getPubsubMessage();
        String messageId = message.getMessageId();
        String orderingKey = message.getOrderingKey();
        StringBuilder sb = new StringBuilder();
        sb.append("Message ID: ").append(messageId);
        if (orderingKey != null && !orderingKey.isEmpty()) {
            sb.append(", Ordering Key: ").append(orderingKey);
        }
        return sb.toString();
    }

    public void logSubscriber(SubSystem subSystem, Level level, String msg, PubsubMessageWrapper messageWrapper, String ackId, boolean exactlyOnceDeliveryEnabled) {
        Logger logger = subSystem.getLogger();
        if (logger.isLoggable(level)) {
            String prefix = this.getSubscriptionLogPrefix(messageWrapper, ackId, exactlyOnceDeliveryEnabled);
            logger.log(level, prefix + " - " + msg);
        }
    }

    public void logSubscriberWithThrowable(SubSystem subSystem, Level level, String msg, PubsubMessageWrapper messageWrapper, String ackId, boolean exactlyOnceDeliveryEnabled, Throwable throwable) {
        Logger logger = subSystem.getLogger();
        if (logger.isLoggable(level)) {
            String prefix = this.getSubscriptionLogPrefix(messageWrapper, ackId, exactlyOnceDeliveryEnabled);
            logger.log(level, prefix + " - " + msg, throwable);
        }
    }

    public void logPublisher(SubSystem subSystem, Level level, String msg, PubsubMessageWrapper messageWrapper) {
        Logger logger = subSystem.getLogger();
        if (logger.isLoggable(level)) {
            String prefix = this.getPublisherLogPrefix(messageWrapper);
            logger.log(level, prefix + " - " + msg);
        }
    }

    public void logEvent(SubSystem subSystem, Level level, String msg, Object ... params) {
        Logger logger = subSystem.getLogger();
        if (logger.isLoggable(level)) {
            logger.log(level, msg, params);
        }
    }

    static /* synthetic */ Logger access$000() {
        return slowAckLogger;
    }

    static /* synthetic */ Logger access$100() {
        return callbackDeliveryLogger;
    }

    static /* synthetic */ Logger access$200() {
        return expiryLogger;
    }

    static /* synthetic */ Logger access$300() {
        return callbackExceptionsLogger;
    }

    static /* synthetic */ Logger access$400() {
        return ackBatchLogger;
    }

    static /* synthetic */ Logger access$500() {
        return subscriberFlowControlLogger;
    }

    static /* synthetic */ Logger access$600() {
        return ackNackLogger;
    }

    static /* synthetic */ Logger access$700() {
        return publishBatchLogger;
    }

    static /* synthetic */ Logger access$800() {
        return subscriberStreamsLogger;
    }

    public static enum SubSystem {
        SLOW_ACK(LoggingUtil.access$000()),
        CALLBACK_DELIVERY(LoggingUtil.access$100()),
        EXPIRY(LoggingUtil.access$200()),
        CALLBACK_EXCEPTIONS(LoggingUtil.access$300()),
        ACK_BATCH(LoggingUtil.access$400()),
        SUBSCRIBER_FLOW_CONTROL(LoggingUtil.access$500()),
        ACK_NACK(LoggingUtil.access$600()),
        PUBLISH_BATCH(LoggingUtil.access$700()),
        SUBSCRIBER_STREAMS(LoggingUtil.access$800());

        private final Logger logger;

        private SubSystem(Logger logger) {
            this.logger = logger;
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

