/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.stub.HttpJsonSchemaServiceCallableFactory;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.pubsub.v1.CreateSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaRequest;
import com.google.pubsub.v1.ValidateSchemaResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSchemaServiceStub
extends SchemaServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSchemaRequest, Schema> createSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/CreateSchema").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/schemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "schemaId", (Object)request.getSchemaId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("schema", (Message)request.getSchema(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Schema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSchemaRequest, Schema> getSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/GetSchema").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/schemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Schema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSchemasRequest, ListSchemasResponse> listSchemasMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/ListSchemas").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/schemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSchemasResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSchemaRequest, Empty> deleteSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/DeleteSchema").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/schemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/ValidateSchema").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/schemas:validate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ValidateSchemaResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ValidateMessageRequest, ValidateMessageResponse> validateMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.pubsub.v1.SchemaService/ValidateMessage").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/schemas:validateMessage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ValidateMessageResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/subscriptions/*}:setIamPolicy", "/v1/{resource=projects/*/snapshots/*}:setIamPolicy", "/v1/{resource=projects/*/schemas/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/topics/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/subscriptions/*}:getIamPolicy", "/v1/{resource=projects/*/snapshots/*}:getIamPolicy", "/v1/{resource=projects/*/schemas/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/subscriptions/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/topics/*}:testIamPermissions", "/v1/{resource=projects/*/snapshots/*}:testIamPermissions", "/v1/{resource=projects/*/schemas/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSchemaRequest, Schema> createSchemaCallable;
    private final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable;
    private final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable;
    private final UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable;
    private final UnaryCallable<DeleteSchemaRequest, Empty> deleteSchemaCallable;
    private final UnaryCallable<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaCallable;
    private final UnaryCallable<ValidateMessageRequest, ValidateMessageResponse> validateMessageCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSchemaServiceStub create(SchemaServiceStubSettings settings) throws IOException {
        return new HttpJsonSchemaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSchemaServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSchemaServiceStub(SchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSchemaServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSchemaServiceStub(SchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSchemaServiceCallableFactory());
    }

    protected HttpJsonSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSchemaMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSchemaMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listSchemasTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSchemasMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSchemaMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings validateSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateSchemaMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings validateMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateMessageMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createSchemaCallable = callableFactory.createUnaryCallable(createSchemaTransportSettings, settings.createSchemaSettings(), clientContext);
        this.getSchemaCallable = callableFactory.createUnaryCallable(getSchemaTransportSettings, settings.getSchemaSettings(), clientContext);
        this.listSchemasCallable = callableFactory.createUnaryCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.listSchemasPagedCallable = callableFactory.createPagedCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.deleteSchemaCallable = callableFactory.createUnaryCallable(deleteSchemaTransportSettings, settings.deleteSchemaSettings(), clientContext);
        this.validateSchemaCallable = callableFactory.createUnaryCallable(validateSchemaTransportSettings, settings.validateSchemaSettings(), clientContext);
        this.validateMessageCallable = callableFactory.createUnaryCallable(validateMessageTransportSettings, settings.validateMessageSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSchemaMethodDescriptor);
        methodDescriptors.add(getSchemaMethodDescriptor);
        methodDescriptors.add(listSchemasMethodDescriptor);
        methodDescriptors.add(deleteSchemaMethodDescriptor);
        methodDescriptors.add(validateSchemaMethodDescriptor);
        methodDescriptors.add(validateMessageMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSchemaRequest, Schema> createSchemaCallable() {
        return this.createSchemaCallable;
    }

    @Override
    public UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.getSchemaCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.listSchemasCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.listSchemasPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSchemaRequest, Empty> deleteSchemaCallable() {
        return this.deleteSchemaCallable;
    }

    @Override
    public UnaryCallable<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaCallable() {
        return this.validateSchemaCallable;
    }

    @Override
    public UnaryCallable<ValidateMessageRequest, ValidateMessageResponse> validateMessageCallable() {
        return this.validateMessageCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

