/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.SettableApiFuture;
import com.google.cloud.pubsub.v1.AckResponse;
import java.util.Optional;

public class AckRequestData {
    private final String ackId;
    private final Optional<SettableApiFuture<AckResponse>> messageFuture;

    protected AckRequestData(Builder builder) {
        this.ackId = builder.ackId;
        this.messageFuture = builder.messageFuture;
    }

    public String getAckId() {
        return this.ackId;
    }

    public SettableApiFuture<AckResponse> getMessageFutureIfExists() {
        return this.messageFuture.orElse(null);
    }

    public AckRequestData setResponse(AckResponse ackResponse, boolean setResponseOnSuccess) {
        if (this.messageFuture.isPresent() && !this.messageFuture.get().isDone()) {
            switch (ackResponse) {
                case SUCCESSFUL: {
                    if (!setResponseOnSuccess) break;
                    this.messageFuture.get().set((Object)ackResponse);
                    break;
                }
                case INVALID: 
                case OTHER: 
                case PERMISSION_DENIED: 
                case FAILED_PRECONDITION: {
                    this.messageFuture.get().set((Object)ackResponse);
                }
            }
        }
        return this;
    }

    public boolean hasMessageFuture() {
        return this.messageFuture.isPresent();
    }

    public static Builder newBuilder(String ackId) {
        return new Builder(ackId);
    }

    protected static final class Builder {
        private final String ackId;
        private Optional<SettableApiFuture<AckResponse>> messageFuture = Optional.empty();

        protected Builder(String ackId) {
            this.ackId = ackId;
        }

        public Builder setMessageFuture(SettableApiFuture<AckResponse> messageFuture) {
            this.messageFuture = Optional.of(messageFuture);
            return this;
        }

        public AckRequestData build() {
            return new AckRequestData(this);
        }
    }
}

