/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.Policy;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.TopicId;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;

public class Subscription
extends SubscriptionInfo {
    private static final long serialVersionUID = -4153366055659552230L;
    private final PubSubOptions options;
    private transient PubSub pubsub;

    Subscription(PubSub pubsub, SubscriptionInfo.BuilderImpl builder) {
        super(builder);
        this.pubsub = (PubSub)Preconditions.checkNotNull((Object)pubsub);
        this.options = (PubSubOptions)pubsub.getOptions();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Subscription.class)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Deprecated
    public PubSub pubSub() {
        return this.getPubsub();
    }

    public PubSub getPubsub() {
        return this.pubsub;
    }

    public boolean delete() {
        return this.pubsub.deleteSubscription(this.getName());
    }

    public Future<Boolean> deleteAsync() {
        return this.pubsub.deleteSubscriptionAsync(this.getName());
    }

    public Subscription reload() {
        return this.pubsub.getSubscription(this.getName());
    }

    public Future<Subscription> reloadAsync() {
        return this.pubsub.getSubscriptionAsync(this.getName());
    }

    public void replacePushConfig(PushConfig pushConfig) {
        this.pubsub.replacePushConfig(this.getName(), pushConfig);
    }

    public Future<Void> replacePushConfigAsync(PushConfig pushConfig) {
        return this.pubsub.replacePushConfigAsync(this.getName(), pushConfig);
    }

    public Iterator<ReceivedMessage> pull(int maxMessages) {
        return this.pubsub.pull(this.getName(), maxMessages);
    }

    public Future<Iterator<ReceivedMessage>> pullAsync(int maxMessages) {
        return this.pubsub.pullAsync(this.getName(), maxMessages);
    }

    public PubSub.MessageConsumer pullAsync(PubSub.MessageProcessor callback, PubSub.PullOption ... options) {
        return this.pubsub.pullAsync(this.getName(), callback, options);
    }

    public Policy getPolicy() {
        return this.pubsub.getSubscriptionPolicy(this.getName());
    }

    public Future<Policy> getPolicyAsync() {
        return this.pubsub.getSubscriptionPolicyAsync(this.getName());
    }

    public Policy replacePolicy(Policy newPolicy) {
        return this.pubsub.replaceSubscriptionPolicy(this.getName(), newPolicy);
    }

    public Future<Policy> replacePolicyAsync(Policy newPolicy) {
        return this.pubsub.replaceSubscriptionPolicyAsync(this.getName(), newPolicy);
    }

    public List<Boolean> testPermissions(List<String> permissions) {
        return this.pubsub.testSubscriptionPermissions(this.getName(), permissions);
    }

    public Future<List<Boolean>> testPermissionsAsync(List<String> permissions) {
        return this.pubsub.testSubscriptionPermissionsAsync(this.getName(), permissions);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.pubsub = (PubSub)this.options.getService();
    }

    static Subscription fromPb(PubSub storage, com.google.pubsub.v1.Subscription subscriptionPb) {
        SubscriptionInfo subscriptionInfo = SubscriptionInfo.fromPb(subscriptionPb);
        return new Subscription(storage, new SubscriptionInfo.BuilderImpl(subscriptionInfo));
    }

    static Function<com.google.pubsub.v1.Subscription, Subscription> fromPbFunction(final PubSub pubsub) {
        return new Function<com.google.pubsub.v1.Subscription, Subscription>(){

            public Subscription apply(com.google.pubsub.v1.Subscription subscriptionPb) {
                return subscriptionPb != null ? Subscription.fromPb(pubsub, subscriptionPb) : null;
            }
        };
    }

    public static final class Builder
    extends SubscriptionInfo.Builder {
        private final PubSub pubsub;
        private final SubscriptionInfo.BuilderImpl delegate;

        private Builder(Subscription subscription) {
            this.pubsub = subscription.pubsub;
            this.delegate = new SubscriptionInfo.BuilderImpl(subscription);
        }

        @Override
        @Deprecated
        public Builder topic(TopicId topic) {
            return this.setTopic(topic);
        }

        @Override
        public Builder setTopic(TopicId topic) {
            this.delegate.setTopic(topic);
            return this;
        }

        @Override
        @Deprecated
        public Builder topic(String project, String topic) {
            return this.setTopic(project, topic);
        }

        @Override
        public Builder setTopic(String project, String topic) {
            this.delegate.setTopic(project, topic);
            return this;
        }

        @Override
        @Deprecated
        public Builder topic(String topic) {
            return this.setTopic(topic);
        }

        @Override
        public Builder setTopic(String topic) {
            this.delegate.setTopic(topic);
            return this;
        }

        @Override
        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        @Override
        public Builder setName(String name) {
            this.delegate.setName(name);
            return this;
        }

        @Override
        @Deprecated
        public Builder pushConfig(PushConfig pushConfig) {
            return this.setPushConfig(pushConfig);
        }

        @Override
        public Builder setPushConfig(PushConfig pushConfig) {
            this.delegate.setPushConfig(pushConfig);
            return this;
        }

        @Override
        @Deprecated
        public Builder ackDeadLineSeconds(int ackDeadLineSeconds) {
            return this.setAckDeadLineSeconds(ackDeadLineSeconds);
        }

        @Override
        public Builder setAckDeadLineSeconds(int ackDeadLineSeconds) {
            this.delegate.setAckDeadLineSeconds(ackDeadLineSeconds);
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this.pubsub, this.delegate);
        }
    }
}

