/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PushConfig
implements Serializable {
    private static final long serialVersionUID = 4408885787064092231L;
    private final String endpoint;
    private final ImmutableMap<String, String> attributes;

    private PushConfig(Builder builder) {
        this.endpoint = builder.endpoint;
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PushConfig)) {
            return false;
        }
        PushConfig other = (PushConfig)obj;
        return Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.attributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", this.attributes).add("endpoint", (Object)this.endpoint).toString();
    }

    public Builder toBuilder() {
        return PushConfig.builder(this.endpoint, this.attributes);
    }

    public static PushConfig of(String endpoint) {
        return PushConfig.builder(endpoint).build();
    }

    public static PushConfig of(String endpoint, Map<String, String> attributes) {
        return PushConfig.builder(endpoint, attributes).build();
    }

    public static Builder builder(String endpoint) {
        return new Builder().endpoint(endpoint);
    }

    public static Builder builder(String endpoint, Map<String, String> attributes) {
        return PushConfig.builder(endpoint).attributes(attributes);
    }

    com.google.pubsub.v1.PushConfig toPb() {
        return com.google.pubsub.v1.PushConfig.newBuilder().setPushEndpoint(this.endpoint).putAllAttributes(this.attributes).build();
    }

    static PushConfig fromPb(com.google.pubsub.v1.PushConfig pushConfigPb) {
        return PushConfig.builder(pushConfigPb.getPushEndpoint(), pushConfigPb.getAttributes()).build();
    }

    public static final class Builder {
        private String endpoint;
        private Map<String, String> attributes = new HashMap<String, String>();

        private Builder() {
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint);
            return this;
        }

        public Builder addAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = new HashMap<String, String>(attributes);
            return this;
        }

        public Builder removeAttribute(String name) {
            this.attributes.remove(name);
            return this;
        }

        public Builder clearAttributes() {
            this.attributes.clear();
            return this;
        }

        public PushConfig build() {
            return new PushConfig(this);
        }
    }
}

