/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubException;
import com.google.cloud.pubsub.PubSubFactory;
import com.google.cloud.pubsub.PubSubImpl;
import com.google.cloud.pubsub.spi.DefaultPubSubRpc;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.PubSubRpcFactory;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class PubSubOptions
extends GrpcServiceOptions<PubSub, PubSubRpc, PubSubOptions> {
    private static final long serialVersionUID = 5640180400046623305L;
    private static final String PUBSUB_SCOPE = "https://www.googleapis.com/auth/pubsub";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/pubsub");
    private static final String DEFAULT_HOST = PublisherSettings.getDefaultServiceAddress() + ':' + PublisherSettings.getDefaultServicePort();

    public static PubSubOptions defaultInstance() {
        return PubSubOptions.builder().build();
    }

    protected String defaultHost() {
        return DEFAULT_HOST;
    }

    protected PubSubOptions(Builder builder) {
        super(PubSubFactory.class, PubSubRpcFactory.class, (GrpcServiceOptions.Builder)builder);
    }

    protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory() {
        return super.executorFactory();
    }

    protected PubSubFactory defaultServiceFactory() {
        return DefaultPubSubFactory.INSTANCE;
    }

    protected PubSubRpcFactory defaultRpcFactory() {
        return DefaultPubSubRpcFactory.INSTANCE;
    }

    protected Set<String> scopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof PubSubOptions && this.baseEquals((PubSubOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GrpcServiceOptions.Builder<PubSub, PubSubRpc, PubSubOptions, Builder> {
        private Builder() {
        }

        private Builder(PubSubOptions options) {
            super((GrpcServiceOptions)options);
        }

        public PubSubOptions build() {
            return new PubSubOptions(this);
        }
    }

    public static class DefaultPubSubRpcFactory
    implements PubSubRpcFactory {
        private static final PubSubRpcFactory INSTANCE = new DefaultPubSubRpcFactory();

        public PubSubRpc create(PubSubOptions options) {
            try {
                return new DefaultPubSubRpc(options);
            }
            catch (IOException e) {
                throw new PubSubException(e, true);
            }
        }
    }

    public static class DefaultPubSubFactory
    implements PubSubFactory {
        private static final PubSubFactory INSTANCE = new DefaultPubSubFactory();

        public PubSub create(PubSubOptions options) {
            return new PubSubImpl(options);
        }
    }
}

