/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.AckDeadlineRenewer;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.v1.SubscriberApi;
import com.google.common.base.MoreObjects;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import io.grpc.internal.SharedResourceHolder;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

final class MessageConsumerImpl
implements PubSub.MessageConsumer {
    private static final int MAX_QUEUED_CALLBACKS = 100;
    private static final SharedResourceHolder.Resource<ExecutorService> CONSUMER_EXECUTOR = new SharedResourceHolder.Resource<ExecutorService>(){

        public ExecutorService create() {
            return Executors.newSingleThreadExecutor();
        }

        public void close(ExecutorService instance) {
            instance.shutdown();
        }
    };
    private final PubSubOptions pubsubOptions;
    private final PubSubRpc pubsubRpc;
    private final PubSub pubsub;
    private final AckDeadlineRenewer deadlineRenewer;
    private final String subscription;
    private final PubSub.MessageProcessor messageProcessor;
    private final ExecutorService consumerExecutor;
    private final GrpcServiceOptions.ExecutorFactory<ExecutorService> executorFactory;
    private final ExecutorService executor;
    private final AtomicInteger queuedCallbacks;
    private final int maxQueuedCallbacks;
    private final Object futureLock = new Object();
    private final Runnable consumerRunnable;
    private final NextPullPolicy pullPolicy;
    private boolean closed;
    private Future<?> scheduledFuture;
    private PubSubRpc.PullFuture pullerFuture;

    private MessageConsumerImpl(Builder builder) {
        this.pubsubOptions = builder.pubsubOptions;
        this.subscription = builder.subscription;
        this.messageProcessor = builder.messageProcessor;
        this.pubsubRpc = (PubSubRpc)this.pubsubOptions.rpc();
        this.pubsub = (PubSub)this.pubsubOptions.service();
        this.deadlineRenewer = builder.deadlineRenewer;
        this.queuedCallbacks = new AtomicInteger();
        this.consumerExecutor = (ExecutorService)SharedResourceHolder.get(CONSUMER_EXECUTOR);
        this.executorFactory = builder.executorFactory != null ? builder.executorFactory : new DefaultExecutorFactory();
        this.executor = this.executorFactory.get();
        this.maxQueuedCallbacks = (Integer)MoreObjects.firstNonNull((Object)builder.maxQueuedCallbacks, (Object)100);
        this.consumerRunnable = new ConsumerRunnable();
        int nextPullThreshold = builder.nextPullThreshold != null ? builder.nextPullThreshold : this.maxQueuedCallbacks / 2;
        this.pullPolicy = new DefaultNextPullPolicy(this.maxQueuedCallbacks, nextPullThreshold);
        this.nextPull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullIfNeeded() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.closed || this.scheduledFuture != null || !this.pullPolicy.shouldPull(this.queuedCallbacks.get())) {
                return;
            }
            this.scheduledFuture = this.consumerExecutor.submit(this.consumerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextPull() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.closed || this.queuedCallbacks.get() == this.maxQueuedCallbacks) {
                this.scheduledFuture = null;
                return;
            }
            this.scheduledFuture = this.consumerExecutor.submit(this.consumerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.futureLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            if (this.pullerFuture != null) {
                this.pullerFuture.cancel(true);
            }
        }
        SharedResourceHolder.release(CONSUMER_EXECUTOR, (Object)this.consumerExecutor);
        this.executorFactory.release(this.executor);
    }

    static Builder builder(PubSubOptions pubsubOptions, String subscription, AckDeadlineRenewer deadlineRenewer, PubSub.MessageProcessor messageProcessor) {
        return new Builder(pubsubOptions, subscription, deadlineRenewer, messageProcessor);
    }

    static final class Builder {
        private final PubSubOptions pubsubOptions;
        private final String subscription;
        private final AckDeadlineRenewer deadlineRenewer;
        private final PubSub.MessageProcessor messageProcessor;
        private Integer maxQueuedCallbacks;
        private GrpcServiceOptions.ExecutorFactory<ExecutorService> executorFactory;
        private Integer nextPullThreshold;

        Builder(PubSubOptions pubsubOptions, String subscription, AckDeadlineRenewer deadlineRenewer, PubSub.MessageProcessor messageProcessor) {
            this.pubsubOptions = pubsubOptions;
            this.subscription = subscription;
            this.deadlineRenewer = deadlineRenewer;
            this.messageProcessor = messageProcessor;
        }

        Builder maxQueuedCallbacks(Integer maxQueuedCallbacks) {
            this.maxQueuedCallbacks = maxQueuedCallbacks;
            return this;
        }

        Builder executorFactory(GrpcServiceOptions.ExecutorFactory<ExecutorService> executorFactory) {
            this.executorFactory = executorFactory;
            return this;
        }

        Builder nextPullThreshold(Integer nextPullThreshold) {
            this.nextPullThreshold = nextPullThreshold;
            return this;
        }

        MessageConsumerImpl build() {
            return new MessageConsumerImpl(this);
        }
    }

    class ConsumerRunnable
    implements Runnable {
        ConsumerRunnable() {
        }

        @Override
        public void run() {
            if (MessageConsumerImpl.this.closed) {
                return;
            }
            MessageConsumerImpl.this.pullerFuture = MessageConsumerImpl.this.pubsubRpc.pull(this.createPullRequest());
            MessageConsumerImpl.this.pullerFuture.addCallback(new PubSubRpc.PullCallback(){

                @Override
                public void success(PullResponse response) {
                    List messages = response.getReceivedMessagesList();
                    MessageConsumerImpl.this.queuedCallbacks.addAndGet(messages.size());
                    for (com.google.pubsub.v1.ReceivedMessage message : messages) {
                        MessageConsumerImpl.this.deadlineRenewer.add(MessageConsumerImpl.this.subscription, message.getAckId());
                        ReceivedMessage receivedMessage = ReceivedMessage.fromPb(MessageConsumerImpl.this.pubsub, MessageConsumerImpl.this.subscription, message);
                        MessageConsumerImpl.this.executor.execute(ConsumerRunnable.this.ackingRunnable(receivedMessage));
                    }
                    MessageConsumerImpl.this.nextPull();
                }

                @Override
                public void failure(Throwable error) {
                    if (!(error instanceof CancellationException)) {
                        MessageConsumerImpl.this.nextPull();
                    }
                }
            });
        }

        private PullRequest createPullRequest() {
            return PullRequest.newBuilder().setSubscription(SubscriberApi.formatSubscriptionName(MessageConsumerImpl.this.pubsubOptions.projectId(), MessageConsumerImpl.this.subscription)).setMaxMessages(MessageConsumerImpl.this.maxQueuedCallbacks - MessageConsumerImpl.this.queuedCallbacks.get()).setReturnImmediately(false).build();
        }

        private Runnable ackingRunnable(final ReceivedMessage receivedMessage) {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        MessageConsumerImpl.this.messageProcessor.process(receivedMessage);
                        MessageConsumerImpl.this.pubsub.ackAsync(receivedMessage.subscription(), receivedMessage.ackId(), new String[0]);
                    }
                    catch (Exception ex) {
                        MessageConsumerImpl.this.pubsub.nackAsync(receivedMessage.subscription(), receivedMessage.ackId(), new String[0]);
                    }
                    finally {
                        MessageConsumerImpl.this.deadlineRenewer.remove(receivedMessage.subscription(), receivedMessage.ackId());
                        MessageConsumerImpl.this.queuedCallbacks.decrementAndGet();
                        MessageConsumerImpl.this.pullIfNeeded();
                    }
                }
            };
        }
    }

    static class DefaultExecutorFactory
    implements GrpcServiceOptions.ExecutorFactory<ExecutorService> {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        DefaultExecutorFactory() {
        }

        public ExecutorService get() {
            return this.executor;
        }

        public void release(ExecutorService executor) {
            executor.shutdownNow();
        }
    }

    static class DefaultNextPullPolicy
    implements NextPullPolicy {
        final int maxQueuedCallbacks;
        final int nextPullThreshold;

        DefaultNextPullPolicy(int maxQueuedCallbacks, int nextPullThreshold) {
            this.maxQueuedCallbacks = maxQueuedCallbacks;
            this.nextPullThreshold = nextPullThreshold;
        }

        @Override
        public boolean shouldPull(int queuedCallbacks) {
            return this.maxQueuedCallbacks - queuedCallbacks >= this.nextPullThreshold;
        }
    }

    static interface NextPullPolicy {
        public boolean shouldPull(int var1);
    }
}

