/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorAsBackgroundResource;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.pubsub.v1.AtomicRoundRobin;
import com.google.cloud.pubsub.v1.MessageWaiter;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class Publisher {
    private static final Logger logger = Logger.getLogger(Publisher.class.getName());
    private final TopicName topicName;
    private final String cachedTopicNameString;
    private final BatchingSettings batchingSettings;
    private final RetrySettings retrySettings;
    private final LongRandom longRandom;
    private final Lock messagesBatchLock;
    private List<OutstandingPublish> messagesBatch;
    private int batchedBytes;
    private final AtomicBoolean activeAlarm;
    private final Channel[] channels;
    private final AtomicRoundRobin channelIndex;
    @Nullable
    private final CallCredentials callCredentials;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean shutdown;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final MessageWaiter messagesWaiter;
    private ScheduledFuture<?> currentAlarmFuture;

    public static long getApiMaxRequestElementCount() {
        return 1000L;
    }

    public static long getApiMaxRequestBytes() {
        return 10000000L;
    }

    private Publisher(Builder builder) throws IOException {
        this.topicName = builder.topicName;
        this.cachedTopicNameString = this.topicName.toString();
        this.batchingSettings = builder.batchingSettings;
        this.retrySettings = builder.retrySettings;
        this.longRandom = builder.longRandom;
        this.messagesBatch = new LinkedList<OutstandingPublish>();
        this.messagesBatchLock = new ReentrantLock();
        this.activeAlarm = new AtomicBoolean(false);
        this.executor = builder.executorProvider.getExecutor();
        if (builder.executorProvider.shouldAutoClose()) {
            this.closeables.add((AutoCloseable)new ExecutorAsBackgroundResource((ExecutorService)this.executor));
        }
        this.channels = new Channel[Runtime.getRuntime().availableProcessors()];
        TransportChannelProvider channelProvider = builder.channelProvider;
        if (channelProvider.needsExecutor()) {
            channelProvider = channelProvider.withExecutor(this.executor);
        }
        if (channelProvider.needsHeaders()) {
            channelProvider = channelProvider.withHeaders(builder.headerProvider.getHeaders());
        }
        if (channelProvider.needsEndpoint()) {
            channelProvider = channelProvider.withEndpoint(TopicAdminSettings.getDefaultEndpoint());
        }
        for (int i = 0; i < this.channels.length; ++i) {
            GrpcTransportChannel transportChannel = (GrpcTransportChannel)channelProvider.getTransportChannel();
            this.channels[i] = transportChannel.getChannel();
            if (!channelProvider.shouldAutoClose()) continue;
            this.closeables.add((AutoCloseable)transportChannel);
        }
        this.channelIndex = new AtomicRoundRobin(this.channels.length);
        Credentials credentials = builder.credentialsProvider.getCredentials();
        this.callCredentials = credentials == null ? null : MoreCallCredentials.from((Credentials)credentials);
        this.shutdown = new AtomicBoolean(false);
        this.messagesWaiter = new MessageWaiter();
    }

    public TopicName getTopicName() {
        return this.topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<String> publish(PubsubMessage message) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("Cannot publish on a shut-down publisher.");
        }
        final int messageSize = message.getSerializedSize();
        OutstandingBatch batchToSend = null;
        SettableApiFuture publishResult = SettableApiFuture.create();
        final OutstandingPublish outstandingPublish = new OutstandingPublish((SettableApiFuture<String>)publishResult, message);
        this.messagesBatchLock.lock();
        try {
            if (!this.messagesBatch.isEmpty() && this.hasBatchingBytes() && (long)(this.batchedBytes + messageSize) >= this.getMaxBatchBytes()) {
                batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
                this.messagesBatch = new LinkedList<OutstandingPublish>();
                this.batchedBytes = 0;
            }
            if (!this.hasBatchingBytes() || (long)messageSize < this.getMaxBatchBytes()) {
                this.batchedBytes += messageSize;
                this.messagesBatch.add(outstandingPublish);
                if ((long)this.messagesBatch.size() == this.getBatchingSettings().getElementCountThreshold()) {
                    batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
                    this.messagesBatch = new LinkedList<OutstandingPublish>();
                    this.batchedBytes = 0;
                }
            }
            if (!this.messagesBatch.isEmpty()) {
                this.setupDurationBasedPublishAlarm();
            } else if (this.currentAlarmFuture != null) {
                logger.log(Level.FINER, "Cancelling alarm, no more messages");
                if (this.activeAlarm.getAndSet(false)) {
                    this.currentAlarmFuture.cancel(false);
                }
            }
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.messagesWaiter.incrementPendingMessages(1);
        if (batchToSend != null) {
            logger.log(Level.FINER, "Scheduling a batch for immediate sending.");
            final OutstandingBatch finalBatchToSend = batchToSend;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Publisher.this.publishOutstandingBatch(finalBatchToSend);
                }
            });
        }
        if (this.hasBatchingBytes() && (long)messageSize >= this.getMaxBatchBytes()) {
            logger.log(Level.FINER, "Message exceeds the max batch bytes, scheduling it for immediate send.");
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Publisher.this.publishOutstandingBatch(new OutstandingBatch((List<OutstandingPublish>)ImmutableList.of((Object)outstandingPublish), messageSize));
                }
            });
        }
        return publishResult;
    }

    private void setupDurationBasedPublishAlarm() {
        if (!this.activeAlarm.getAndSet(true)) {
            long delayThresholdMs = this.getBatchingSettings().getDelayThreshold().toMillis();
            logger.log(Level.FINER, "Setting up alarm for the next {0} ms.", delayThresholdMs);
            this.currentAlarmFuture = this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    logger.log(Level.FINER, "Sending messages based on schedule.");
                    Publisher.this.activeAlarm.getAndSet(false);
                    Publisher.this.publishAllOutstanding();
                }
            }, delayThresholdMs, TimeUnit.MILLISECONDS);
        }
    }

    private void publishAllOutstanding() {
        OutstandingBatch batchToSend;
        this.messagesBatchLock.lock();
        try {
            if (this.messagesBatch.isEmpty()) {
                return;
            }
            batchToSend = new OutstandingBatch(this.messagesBatch, this.batchedBytes);
            this.messagesBatch = new LinkedList<OutstandingPublish>();
            this.batchedBytes = 0;
        }
        finally {
            this.messagesBatchLock.unlock();
        }
        this.publishOutstandingBatch(batchToSend);
    }

    private void publishOutstandingBatch(final OutstandingBatch outstandingBatch) {
        PublishRequest.Builder publishRequest = PublishRequest.newBuilder();
        publishRequest.setTopic(this.cachedTopicNameString);
        for (OutstandingPublish outstandingPublish : outstandingBatch.outstandingPublishes) {
            publishRequest.addMessages(outstandingPublish.message);
        }
        int currentChannel = this.channelIndex.next();
        long rpcTimeoutMs = Math.round((double)this.retrySettings.getInitialRpcTimeout().toMillis() * Math.pow(this.retrySettings.getRpcTimeoutMultiplier(), outstandingBatch.attempt - 1));
        rpcTimeoutMs = Math.min(rpcTimeoutMs, this.retrySettings.getMaxRpcTimeout().toMillis());
        PublisherGrpc.PublisherFutureStub stub = (PublisherGrpc.PublisherFutureStub)PublisherGrpc.newFutureStub((Channel)this.channels[currentChannel]).withDeadlineAfter(rpcTimeoutMs, TimeUnit.MILLISECONDS);
        if (this.callCredentials != null) {
            stub = (PublisherGrpc.PublisherFutureStub)stub.withCallCredentials(this.callCredentials);
        }
        Futures.addCallback((ListenableFuture)stub.publish(publishRequest.build()), (FutureCallback)new FutureCallback<PublishResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PublishResponse result) {
                try {
                    if (result.getMessageIdsCount() != outstandingBatch.size()) {
                        IllegalStateException t = new IllegalStateException(String.format("The publish result count %s does not match the expected %s results. Please contact Cloud Pub/Sub support if this frequently occurs", result.getMessageIdsCount(), outstandingBatch.size()));
                        for (OutstandingPublish oustandingMessage : outstandingBatch.outstandingPublishes) {
                            oustandingMessage.publishResult.setException((Throwable)t);
                        }
                        return;
                    }
                    Iterator<OutstandingPublish> messagesResultsIt = outstandingBatch.outstandingPublishes.iterator();
                    for (String messageId : result.getMessageIdsList()) {
                        messagesResultsIt.next().publishResult.set((Object)messageId);
                    }
                }
                finally {
                    Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                long nextBackoffDelay = Publisher.computeNextBackoffDelayMs(outstandingBatch, Publisher.this.retrySettings, Publisher.this.longRandom);
                if (!Publisher.this.isRetryable(t) || Publisher.this.retrySettings.getMaxAttempts() > 0 && outstandingBatch.getAttempt() > Publisher.this.retrySettings.getMaxAttempts() || System.currentTimeMillis() + nextBackoffDelay > outstandingBatch.creationTime + Publisher.this.retrySettings.getTotalTimeout().toMillis()) {
                    try {
                        ApiException gaxException = ApiExceptionFactory.createException((Throwable)t, (StatusCode)GrpcStatusCode.of((Status.Code)Status.fromThrowable((Throwable)t).getCode()), (boolean)false);
                        for (OutstandingPublish outstandingPublish : outstandingBatch.outstandingPublishes) {
                            outstandingPublish.publishResult.setException((Throwable)gaxException);
                        }
                    }
                    finally {
                        Publisher.this.messagesWaiter.incrementPendingMessages(-outstandingBatch.size());
                    }
                    return;
                }
                Publisher.this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Publisher.this.publishOutstandingBatch(outstandingBatch);
                    }
                }, nextBackoffDelay, TimeUnit.MILLISECONDS);
            }
        });
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    private long getMaxBatchBytes() {
        return this.getBatchingSettings().getRequestByteThreshold();
    }

    public void shutdown() throws Exception {
        if (this.shutdown.getAndSet(true)) {
            throw new IllegalStateException("Cannot shut down a publisher already shut-down.");
        }
        if (this.currentAlarmFuture != null && this.activeAlarm.getAndSet(false)) {
            this.currentAlarmFuture.cancel(false);
        }
        this.publishAllOutstanding();
        this.messagesWaiter.waitNoMessages();
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }

    private boolean hasBatchingBytes() {
        return this.getMaxBatchBytes() > 0L;
    }

    private static long computeNextBackoffDelayMs(OutstandingBatch outstandingBatch, RetrySettings retrySettings, LongRandom longRandom) {
        long delayMillis = Math.round((double)retrySettings.getInitialRetryDelay().toMillis() * Math.pow(retrySettings.getRetryDelayMultiplier(), outstandingBatch.attempt - 1));
        delayMillis = Math.min(retrySettings.getMaxRetryDelay().toMillis(), delayMillis);
        ++outstandingBatch.attempt;
        return longRandom.nextLong(0L, delayMillis);
    }

    private boolean isRetryable(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        switch (status.getCode()) {
            case ABORTED: 
            case CANCELLED: 
            case DEADLINE_EXCEEDED: 
            case INTERNAL: 
            case RESOURCE_EXHAUSTED: 
            case UNKNOWN: 
            case UNAVAILABLE: {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static Builder defaultBuilder(TopicName topicName) {
        return Publisher.newBuilder(topicName);
    }

    public static Builder newBuilder(TopicName topicName) {
        return new Builder(topicName);
    }

    public static final class Builder {
        static final Duration MIN_TOTAL_TIMEOUT = Duration.ofSeconds((long)10L);
        static final Duration MIN_RPC_TIMEOUT = Duration.ofMillis((long)10L);
        static final long DEFAULT_ELEMENT_COUNT_THRESHOLD = 100L;
        static final long DEFAULT_REQUEST_BYTES_THRESHOLD = 1000L;
        static final Duration DEFAULT_DELAY_THRESHOLD = Duration.ofMillis((long)1L);
        static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds((long)10L);
        static final Duration DEFAULT_TOTAL_TIMEOUT = MIN_TOTAL_TIMEOUT;
        static final BatchingSettings DEFAULT_BATCHING_SETTINGS = BatchingSettings.newBuilder().setDelayThreshold(DEFAULT_DELAY_THRESHOLD).setRequestByteThreshold(Long.valueOf(1000L)).setElementCountThreshold(Long.valueOf(100L)).build();
        static final RetrySettings DEFAULT_RETRY_SETTINGS = RetrySettings.newBuilder().setTotalTimeout(DEFAULT_TOTAL_TIMEOUT).setInitialRetryDelay(Duration.ofMillis((long)5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)Long.MAX_VALUE)).setInitialRpcTimeout(DEFAULT_RPC_TIMEOUT).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(DEFAULT_RPC_TIMEOUT).build();
        static final LongRandom DEFAULT_LONG_RANDOM = new LongRandom(){

            @Override
            public long nextLong(long least, long bound) {
                return ThreadLocalRandom.current().nextLong(least, bound);
            }
        };
        private static final int THREADS_PER_CPU = 5;
        static final ExecutorProvider DEFAULT_EXECUTOR_PROVIDER = InstantiatingExecutorProvider.newBuilder().setExecutorThreadCount(5 * Runtime.getRuntime().availableProcessors()).build();
        TopicName topicName;
        BatchingSettings batchingSettings = DEFAULT_BATCHING_SETTINGS;
        RetrySettings retrySettings = DEFAULT_RETRY_SETTINGS;
        LongRandom longRandom = DEFAULT_LONG_RANDOM;
        TransportChannelProvider channelProvider = TopicAdminSettings.defaultGrpcTransportProviderBuilder().build();
        HeaderProvider headerProvider = TopicAdminSettings.defaultApiClientHeaderProviderBuilder().build();
        ExecutorProvider executorProvider = DEFAULT_EXECUTOR_PROVIDER;
        CredentialsProvider credentialsProvider = TopicAdminSettings.defaultCredentialsProviderBuilder().build();

        private Builder(TopicName topic) {
            this.topicName = (TopicName)Preconditions.checkNotNull((Object)topic);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = (HeaderProvider)Preconditions.checkNotNull((Object)headerProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            Preconditions.checkNotNull((Object)batchingSettings);
            Preconditions.checkNotNull((Object)batchingSettings.getElementCountThreshold());
            Preconditions.checkArgument((batchingSettings.getElementCountThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getRequestByteThreshold());
            Preconditions.checkArgument((batchingSettings.getRequestByteThreshold() > 0L ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)batchingSettings.getDelayThreshold());
            Preconditions.checkArgument((batchingSettings.getDelayThreshold().toMillis() > 0L ? 1 : 0) != 0);
            this.batchingSettings = batchingSettings;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            Preconditions.checkArgument((retrySettings.getTotalTimeout().compareTo(MIN_TOTAL_TIMEOUT) >= 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((retrySettings.getInitialRpcTimeout().compareTo(MIN_RPC_TIMEOUT) >= 0 ? 1 : 0) != 0);
            this.retrySettings = retrySettings;
            return this;
        }

        @VisibleForTesting
        Builder setLongRandom(LongRandom longRandom) {
            this.longRandom = (LongRandom)Preconditions.checkNotNull((Object)longRandom);
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
            return this;
        }

        public Publisher build() throws IOException {
            return new Publisher(this);
        }
    }

    static interface LongRandom {
        public long nextLong(long var1, long var3);
    }

    private static final class OutstandingPublish {
        SettableApiFuture<String> publishResult;
        PubsubMessage message;

        OutstandingPublish(SettableApiFuture<String> publishResult, PubsubMessage message) {
            this.publishResult = publishResult;
            this.message = message;
        }
    }

    private static final class OutstandingBatch {
        final List<OutstandingPublish> outstandingPublishes;
        final long creationTime;
        int attempt;
        int batchSizeBytes;

        OutstandingBatch(List<OutstandingPublish> outstandingPublishes, int batchSizeBytes) {
            this.outstandingPublishes = outstandingPublishes;
            this.attempt = 1;
            this.creationTime = System.currentTimeMillis();
            this.batchSizeBytes = batchSizeBytes;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public int size() {
            return this.outstandingPublishes.size();
        }
    }
}

