/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogClient;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.stub.GrpcPrivateCatalogCallableFactory;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStub;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPrivateCatalogStub
extends PrivateCatalogStub {
    private static final MethodDescriptor<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchCatalogs").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchCatalogsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchCatalogsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchProductsRequest, SearchProductsResponse> searchProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchProductsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SearchVersionsRequest, SearchVersionsResponse> searchVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchVersionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsCallable;
    private final UnaryCallable<SearchCatalogsRequest, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsPagedCallable;
    private final UnaryCallable<SearchProductsRequest, SearchProductsResponse> searchProductsCallable;
    private final UnaryCallable<SearchProductsRequest, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsPagedCallable;
    private final UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> searchVersionsCallable;
    private final UnaryCallable<SearchVersionsRequest, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPrivateCatalogStub create(PrivateCatalogStubSettings settings) throws IOException {
        return new GrpcPrivateCatalogStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPrivateCatalogStub create(ClientContext clientContext) throws IOException {
        return new GrpcPrivateCatalogStub(PrivateCatalogStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPrivateCatalogStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPrivateCatalogStub(PrivateCatalogStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPrivateCatalogStub(PrivateCatalogStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPrivateCatalogCallableFactory());
    }

    protected GrpcPrivateCatalogStub(PrivateCatalogStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings searchCatalogsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchCatalogsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SearchCatalogsRequest>(){

            public Map<String, String> extract(SearchCatalogsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings searchProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchProductsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SearchProductsRequest>(){

            public Map<String, String> extract(SearchProductsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings searchVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SearchVersionsRequest>(){

            public Map<String, String> extract(SearchVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        this.searchCatalogsCallable = callableFactory.createUnaryCallable(searchCatalogsTransportSettings, settings.searchCatalogsSettings(), clientContext);
        this.searchCatalogsPagedCallable = callableFactory.createPagedCallable(searchCatalogsTransportSettings, settings.searchCatalogsSettings(), clientContext);
        this.searchProductsCallable = callableFactory.createUnaryCallable(searchProductsTransportSettings, settings.searchProductsSettings(), clientContext);
        this.searchProductsPagedCallable = callableFactory.createPagedCallable(searchProductsTransportSettings, settings.searchProductsSettings(), clientContext);
        this.searchVersionsCallable = callableFactory.createUnaryCallable(searchVersionsTransportSettings, settings.searchVersionsSettings(), clientContext);
        this.searchVersionsPagedCallable = callableFactory.createPagedCallable(searchVersionsTransportSettings, settings.searchVersionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsCallable() {
        return this.searchCatalogsCallable;
    }

    @Override
    public UnaryCallable<SearchCatalogsRequest, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsPagedCallable() {
        return this.searchCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchProductsRequest, SearchProductsResponse> searchProductsCallable() {
        return this.searchProductsCallable;
    }

    @Override
    public UnaryCallable<SearchProductsRequest, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsPagedCallable() {
        return this.searchProductsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> searchVersionsCallable() {
        return this.searchVersionsCallable;
    }

    @Override
    public UnaryCallable<SearchVersionsRequest, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsPagedCallable() {
        return this.searchVersionsPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

