/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parametermanager.v1.CreateParameterRequest;
import com.google.cloud.parametermanager.v1.CreateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterVersionRequest;
import com.google.cloud.parametermanager.v1.GetParameterRequest;
import com.google.cloud.parametermanager.v1.GetParameterVersionRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsResponse;
import com.google.cloud.parametermanager.v1.ListParametersRequest;
import com.google.cloud.parametermanager.v1.ListParametersResponse;
import com.google.cloud.parametermanager.v1.Parameter;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterVersion;
import com.google.cloud.parametermanager.v1.RenderParameterVersionRequest;
import com.google.cloud.parametermanager.v1.RenderParameterVersionResponse;
import com.google.cloud.parametermanager.v1.UpdateParameterRequest;
import com.google.cloud.parametermanager.v1.UpdateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.stub.GrpcParameterManagerStub;
import com.google.cloud.parametermanager.v1.stub.HttpJsonParameterManagerStub;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ParameterManagerStubSettings
extends StubSettings<ParameterManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse> listParametersSettings;
    private final UnaryCallSettings<GetParameterRequest, Parameter> getParameterSettings;
    private final UnaryCallSettings<CreateParameterRequest, Parameter> createParameterSettings;
    private final UnaryCallSettings<UpdateParameterRequest, Parameter> updateParameterSettings;
    private final UnaryCallSettings<DeleteParameterRequest, Empty> deleteParameterSettings;
    private final PagedCallSettings<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsSettings;
    private final UnaryCallSettings<GetParameterVersionRequest, ParameterVersion> getParameterVersionSettings;
    private final UnaryCallSettings<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionSettings;
    private final UnaryCallSettings<CreateParameterVersionRequest, ParameterVersion> createParameterVersionSettings;
    private final UnaryCallSettings<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionSettings;
    private final UnaryCallSettings<DeleteParameterVersionRequest, Empty> deleteParameterVersionSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListParametersRequest, ListParametersResponse, Parameter> LIST_PARAMETERS_PAGE_STR_DESC = new PagedListDescriptor<ListParametersRequest, ListParametersResponse, Parameter>(){

        public String emptyToken() {
            return "";
        }

        public ListParametersRequest injectToken(ListParametersRequest payload, String token) {
            return ListParametersRequest.newBuilder((ListParametersRequest)payload).setPageToken(token).build();
        }

        public ListParametersRequest injectPageSize(ListParametersRequest payload, int pageSize) {
            return ListParametersRequest.newBuilder((ListParametersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListParametersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListParametersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Parameter> extractResources(ListParametersResponse payload) {
            return payload.getParametersList();
        }
    };
    private static final PagedListDescriptor<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion> LIST_PARAMETER_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListParameterVersionsRequest injectToken(ListParameterVersionsRequest payload, String token) {
            return ListParameterVersionsRequest.newBuilder((ListParameterVersionsRequest)payload).setPageToken(token).build();
        }

        public ListParameterVersionsRequest injectPageSize(ListParameterVersionsRequest payload, int pageSize) {
            return ListParameterVersionsRequest.newBuilder((ListParameterVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListParameterVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListParameterVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ParameterVersion> extractResources(ListParameterVersionsResponse payload) {
            return payload.getParameterVersionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse> LIST_PARAMETERS_PAGE_STR_FACT = new PagedListResponseFactory<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse>(){

        public ApiFuture<ParameterManagerClient.ListParametersPagedResponse> getFuturePagedResponse(UnaryCallable<ListParametersRequest, ListParametersResponse> callable, ListParametersRequest request, ApiCallContext context, ApiFuture<ListParametersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PARAMETERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ParameterManagerClient.ListParametersPagedResponse.createAsync((PageContext<ListParametersRequest, ListParametersResponse, Parameter>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse> LIST_PARAMETER_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse>(){

        public ApiFuture<ParameterManagerClient.ListParameterVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> callable, ListParameterVersionsRequest request, ApiCallContext context, ApiFuture<ListParameterVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PARAMETER_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ParameterManagerClient.ListParameterVersionsPagedResponse.createAsync((PageContext<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse>(){

        public ApiFuture<ParameterManagerClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ParameterManagerClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse> listParametersSettings() {
        return this.listParametersSettings;
    }

    public UnaryCallSettings<GetParameterRequest, Parameter> getParameterSettings() {
        return this.getParameterSettings;
    }

    public UnaryCallSettings<CreateParameterRequest, Parameter> createParameterSettings() {
        return this.createParameterSettings;
    }

    public UnaryCallSettings<UpdateParameterRequest, Parameter> updateParameterSettings() {
        return this.updateParameterSettings;
    }

    public UnaryCallSettings<DeleteParameterRequest, Empty> deleteParameterSettings() {
        return this.deleteParameterSettings;
    }

    public PagedCallSettings<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsSettings() {
        return this.listParameterVersionsSettings;
    }

    public UnaryCallSettings<GetParameterVersionRequest, ParameterVersion> getParameterVersionSettings() {
        return this.getParameterVersionSettings;
    }

    public UnaryCallSettings<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionSettings() {
        return this.renderParameterVersionSettings;
    }

    public UnaryCallSettings<CreateParameterVersionRequest, ParameterVersion> createParameterVersionSettings() {
        return this.createParameterVersionSettings;
    }

    public UnaryCallSettings<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionSettings() {
        return this.updateParameterVersionSettings;
    }

    public UnaryCallSettings<DeleteParameterVersionRequest, Empty> deleteParameterVersionSettings() {
        return this.deleteParameterVersionSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ParameterManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcParameterManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonParameterManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "parametermanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "parametermanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "parametermanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ParameterManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ParameterManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ParameterManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ParameterManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ParameterManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listParametersSettings = settingsBuilder.listParametersSettings().build();
        this.getParameterSettings = settingsBuilder.getParameterSettings().build();
        this.createParameterSettings = settingsBuilder.createParameterSettings().build();
        this.updateParameterSettings = settingsBuilder.updateParameterSettings().build();
        this.deleteParameterSettings = settingsBuilder.deleteParameterSettings().build();
        this.listParameterVersionsSettings = settingsBuilder.listParameterVersionsSettings().build();
        this.getParameterVersionSettings = settingsBuilder.getParameterVersionSettings().build();
        this.renderParameterVersionSettings = settingsBuilder.renderParameterVersionSettings().build();
        this.createParameterVersionSettings = settingsBuilder.createParameterVersionSettings().build();
        this.updateParameterVersionSettings = settingsBuilder.updateParameterVersionSettings().build();
        this.deleteParameterVersionSettings = settingsBuilder.deleteParameterVersionSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ParameterManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse> listParametersSettings;
        private final UnaryCallSettings.Builder<GetParameterRequest, Parameter> getParameterSettings;
        private final UnaryCallSettings.Builder<CreateParameterRequest, Parameter> createParameterSettings;
        private final UnaryCallSettings.Builder<UpdateParameterRequest, Parameter> updateParameterSettings;
        private final UnaryCallSettings.Builder<DeleteParameterRequest, Empty> deleteParameterSettings;
        private final PagedCallSettings.Builder<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsSettings;
        private final UnaryCallSettings.Builder<GetParameterVersionRequest, ParameterVersion> getParameterVersionSettings;
        private final UnaryCallSettings.Builder<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionSettings;
        private final UnaryCallSettings.Builder<CreateParameterVersionRequest, ParameterVersion> createParameterVersionSettings;
        private final UnaryCallSettings.Builder<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionSettings;
        private final UnaryCallSettings.Builder<DeleteParameterVersionRequest, Empty> deleteParameterVersionSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listParametersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PARAMETERS_PAGE_STR_FACT);
            this.getParameterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createParameterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateParameterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteParameterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listParameterVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PARAMETER_VERSIONS_PAGE_STR_FACT);
            this.getParameterVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renderParameterVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createParameterVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateParameterVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteParameterVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listParametersSettings, this.getParameterSettings, this.createParameterSettings, this.updateParameterSettings, this.deleteParameterSettings, this.listParameterVersionsSettings, this.getParameterVersionSettings, this.renderParameterVersionSettings, this.createParameterVersionSettings, this.updateParameterVersionSettings, this.deleteParameterVersionSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ParameterManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listParametersSettings = settings.listParametersSettings.toBuilder();
            this.getParameterSettings = settings.getParameterSettings.toBuilder();
            this.createParameterSettings = settings.createParameterSettings.toBuilder();
            this.updateParameterSettings = settings.updateParameterSettings.toBuilder();
            this.deleteParameterSettings = settings.deleteParameterSettings.toBuilder();
            this.listParameterVersionsSettings = settings.listParameterVersionsSettings.toBuilder();
            this.getParameterVersionSettings = settings.getParameterVersionSettings.toBuilder();
            this.renderParameterVersionSettings = settings.renderParameterVersionSettings.toBuilder();
            this.createParameterVersionSettings = settings.createParameterVersionSettings.toBuilder();
            this.updateParameterVersionSettings = settings.updateParameterVersionSettings.toBuilder();
            this.deleteParameterVersionSettings = settings.deleteParameterVersionSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listParametersSettings, this.getParameterSettings, this.createParameterSettings, this.updateParameterSettings, this.deleteParameterSettings, this.listParameterVersionsSettings, this.getParameterVersionSettings, this.renderParameterVersionSettings, this.createParameterVersionSettings, this.updateParameterVersionSettings, this.deleteParameterVersionSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ParameterManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ParameterManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ParameterManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ParameterManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ParameterManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ParameterManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ParameterManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ParameterManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listParametersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getParameterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createParameterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateParameterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteParameterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listParameterVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getParameterVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renderParameterVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createParameterVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateParameterVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteParameterVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListParametersRequest, ListParametersResponse, ParameterManagerClient.ListParametersPagedResponse> listParametersSettings() {
            return this.listParametersSettings;
        }

        public UnaryCallSettings.Builder<GetParameterRequest, Parameter> getParameterSettings() {
            return this.getParameterSettings;
        }

        public UnaryCallSettings.Builder<CreateParameterRequest, Parameter> createParameterSettings() {
            return this.createParameterSettings;
        }

        public UnaryCallSettings.Builder<UpdateParameterRequest, Parameter> updateParameterSettings() {
            return this.updateParameterSettings;
        }

        public UnaryCallSettings.Builder<DeleteParameterRequest, Empty> deleteParameterSettings() {
            return this.deleteParameterSettings;
        }

        public PagedCallSettings.Builder<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsSettings() {
            return this.listParameterVersionsSettings;
        }

        public UnaryCallSettings.Builder<GetParameterVersionRequest, ParameterVersion> getParameterVersionSettings() {
            return this.getParameterVersionSettings;
        }

        public UnaryCallSettings.Builder<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionSettings() {
            return this.renderParameterVersionSettings;
        }

        public UnaryCallSettings.Builder<CreateParameterVersionRequest, ParameterVersion> createParameterVersionSettings() {
            return this.createParameterVersionSettings;
        }

        public UnaryCallSettings.Builder<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionSettings() {
            return this.updateParameterVersionSettings;
        }

        public UnaryCallSettings.Builder<DeleteParameterVersionRequest, Empty> deleteParameterVersionSettings() {
            return this.deleteParameterVersionSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ParameterManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ParameterManagerStubSettings build() throws IOException {
            return new ParameterManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

