/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parallelstore.v1beta.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parallelstore.v1beta.CreateInstanceRequest;
import com.google.cloud.parallelstore.v1beta.DeleteInstanceRequest;
import com.google.cloud.parallelstore.v1beta.GetInstanceRequest;
import com.google.cloud.parallelstore.v1beta.Instance;
import com.google.cloud.parallelstore.v1beta.ListInstancesRequest;
import com.google.cloud.parallelstore.v1beta.ListInstancesResponse;
import com.google.cloud.parallelstore.v1beta.OperationMetadata;
import com.google.cloud.parallelstore.v1beta.ParallelstoreClient;
import com.google.cloud.parallelstore.v1beta.UpdateInstanceRequest;
import com.google.cloud.parallelstore.v1beta.stub.HttpJsonParallelstoreCallableFactory;
import com.google.cloud.parallelstore.v1beta.stub.ParallelstoreStub;
import com.google.cloud.parallelstore.v1beta.stub.ParallelstoreStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonParallelstoreStub
extends ParallelstoreStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(OperationMetadata.getDescriptor()).add(Empty.getDescriptor()).add(Instance.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parallelstore.v1beta.Parallelstore/ListInstances").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/instances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListInstancesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parallelstore.v1beta.Parallelstore/GetInstance").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/instances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Instance.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parallelstore.v1beta.Parallelstore/CreateInstance").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/instances", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "instanceId", (Object)request.getInstanceId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instance", (Message)request.getInstance(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parallelstore.v1beta.Parallelstore/UpdateInstance").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{instance.name=projects/*/locations/*/instances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "instance.name", (Object)request.getInstance().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instance", (Message)request.getInstance(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parallelstore.v1beta.Parallelstore/DeleteInstance").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/instances/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, ParallelstoreClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ParallelstoreClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonParallelstoreStub create(ParallelstoreStubSettings settings) throws IOException {
        return new HttpJsonParallelstoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonParallelstoreStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonParallelstoreStub(ParallelstoreStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonParallelstoreStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonParallelstoreStub(ParallelstoreStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonParallelstoreStub(ParallelstoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonParallelstoreCallableFactory());
    }

    protected HttpJsonParallelstoreStub(ParallelstoreStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1beta/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1beta/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1beta/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listInstancesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("instance.name", String.valueOf(request.getInstance().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listInstancesMethodDescriptor);
        methodDescriptors.add(getInstanceMethodDescriptor);
        methodDescriptors.add(createInstanceMethodDescriptor);
        methodDescriptors.add(updateInstanceMethodDescriptor);
        methodDescriptors.add(deleteInstanceMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ParallelstoreClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ParallelstoreClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

