/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.osconfig.v1.OsConfigServiceSettings;
import com.google.cloud.osconfig.v1.PatchDeploymentName;
import com.google.cloud.osconfig.v1.PatchDeployments;
import com.google.cloud.osconfig.v1.PatchJobName;
import com.google.cloud.osconfig.v1.PatchJobs;
import com.google.cloud.osconfig.v1.ProjectName;
import com.google.cloud.osconfig.v1.stub.OsConfigServiceStub;
import com.google.cloud.osconfig.v1.stub.OsConfigServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OsConfigServiceClient
implements BackgroundResource {
    private final OsConfigServiceSettings settings;
    private final OsConfigServiceStub stub;

    public static final OsConfigServiceClient create() throws IOException {
        return OsConfigServiceClient.create(OsConfigServiceSettings.newBuilder().build());
    }

    public static final OsConfigServiceClient create(OsConfigServiceSettings settings) throws IOException {
        return new OsConfigServiceClient(settings);
    }

    public static final OsConfigServiceClient create(OsConfigServiceStub stub) {
        return new OsConfigServiceClient(stub);
    }

    protected OsConfigServiceClient(OsConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OsConfigServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected OsConfigServiceClient(OsConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OsConfigServiceSettings getSettings() {
        return this.settings;
    }

    public OsConfigServiceStub getStub() {
        return this.stub;
    }

    public final PatchJobs.PatchJob executePatchJob(PatchJobs.ExecutePatchJobRequest request) {
        return (PatchJobs.PatchJob)this.executePatchJobCallable().call((Object)request);
    }

    public final UnaryCallable<PatchJobs.ExecutePatchJobRequest, PatchJobs.PatchJob> executePatchJobCallable() {
        return this.stub.executePatchJobCallable();
    }

    public final PatchJobs.PatchJob getPatchJob(PatchJobName name) {
        PatchJobs.GetPatchJobRequest request = PatchJobs.GetPatchJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPatchJob(request);
    }

    public final PatchJobs.PatchJob getPatchJob(String name) {
        PatchJobs.GetPatchJobRequest request = PatchJobs.GetPatchJobRequest.newBuilder().setName(name).build();
        return this.getPatchJob(request);
    }

    public final PatchJobs.PatchJob getPatchJob(PatchJobs.GetPatchJobRequest request) {
        return (PatchJobs.PatchJob)this.getPatchJobCallable().call((Object)request);
    }

    public final UnaryCallable<PatchJobs.GetPatchJobRequest, PatchJobs.PatchJob> getPatchJobCallable() {
        return this.stub.getPatchJobCallable();
    }

    public final PatchJobs.PatchJob cancelPatchJob(PatchJobs.CancelPatchJobRequest request) {
        return (PatchJobs.PatchJob)this.cancelPatchJobCallable().call((Object)request);
    }

    public final UnaryCallable<PatchJobs.CancelPatchJobRequest, PatchJobs.PatchJob> cancelPatchJobCallable() {
        return this.stub.cancelPatchJobCallable();
    }

    public final ListPatchJobsPagedResponse listPatchJobs(ProjectName parent) {
        PatchJobs.ListPatchJobsRequest request = PatchJobs.ListPatchJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPatchJobs(request);
    }

    public final ListPatchJobsPagedResponse listPatchJobs(String parent) {
        PatchJobs.ListPatchJobsRequest request = PatchJobs.ListPatchJobsRequest.newBuilder().setParent(parent).build();
        return this.listPatchJobs(request);
    }

    public final ListPatchJobsPagedResponse listPatchJobs(PatchJobs.ListPatchJobsRequest request) {
        return (ListPatchJobsPagedResponse)((Object)this.listPatchJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<PatchJobs.ListPatchJobsRequest, ListPatchJobsPagedResponse> listPatchJobsPagedCallable() {
        return this.stub.listPatchJobsPagedCallable();
    }

    public final UnaryCallable<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse> listPatchJobsCallable() {
        return this.stub.listPatchJobsCallable();
    }

    public final ListPatchJobInstanceDetailsPagedResponse listPatchJobInstanceDetails(PatchJobName parent) {
        PatchJobs.ListPatchJobInstanceDetailsRequest request = PatchJobs.ListPatchJobInstanceDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPatchJobInstanceDetails(request);
    }

    public final ListPatchJobInstanceDetailsPagedResponse listPatchJobInstanceDetails(String parent) {
        PatchJobs.ListPatchJobInstanceDetailsRequest request = PatchJobs.ListPatchJobInstanceDetailsRequest.newBuilder().setParent(parent).build();
        return this.listPatchJobInstanceDetails(request);
    }

    public final ListPatchJobInstanceDetailsPagedResponse listPatchJobInstanceDetails(PatchJobs.ListPatchJobInstanceDetailsRequest request) {
        return (ListPatchJobInstanceDetailsPagedResponse)((Object)this.listPatchJobInstanceDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<PatchJobs.ListPatchJobInstanceDetailsRequest, ListPatchJobInstanceDetailsPagedResponse> listPatchJobInstanceDetailsPagedCallable() {
        return this.stub.listPatchJobInstanceDetailsPagedCallable();
    }

    public final UnaryCallable<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse> listPatchJobInstanceDetailsCallable() {
        return this.stub.listPatchJobInstanceDetailsCallable();
    }

    public final PatchDeployments.PatchDeployment createPatchDeployment(ProjectName parent, PatchDeployments.PatchDeployment patchDeployment, String patchDeploymentId) {
        PatchDeployments.CreatePatchDeploymentRequest request = PatchDeployments.CreatePatchDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPatchDeployment(patchDeployment).setPatchDeploymentId(patchDeploymentId).build();
        return this.createPatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment createPatchDeployment(String parent, PatchDeployments.PatchDeployment patchDeployment, String patchDeploymentId) {
        PatchDeployments.CreatePatchDeploymentRequest request = PatchDeployments.CreatePatchDeploymentRequest.newBuilder().setParent(parent).setPatchDeployment(patchDeployment).setPatchDeploymentId(patchDeploymentId).build();
        return this.createPatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment createPatchDeployment(PatchDeployments.CreatePatchDeploymentRequest request) {
        return (PatchDeployments.PatchDeployment)this.createPatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.CreatePatchDeploymentRequest, PatchDeployments.PatchDeployment> createPatchDeploymentCallable() {
        return this.stub.createPatchDeploymentCallable();
    }

    public final PatchDeployments.PatchDeployment getPatchDeployment(PatchDeploymentName name) {
        PatchDeployments.GetPatchDeploymentRequest request = PatchDeployments.GetPatchDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment getPatchDeployment(String name) {
        PatchDeployments.GetPatchDeploymentRequest request = PatchDeployments.GetPatchDeploymentRequest.newBuilder().setName(name).build();
        return this.getPatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment getPatchDeployment(PatchDeployments.GetPatchDeploymentRequest request) {
        return (PatchDeployments.PatchDeployment)this.getPatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.GetPatchDeploymentRequest, PatchDeployments.PatchDeployment> getPatchDeploymentCallable() {
        return this.stub.getPatchDeploymentCallable();
    }

    public final ListPatchDeploymentsPagedResponse listPatchDeployments(ProjectName parent) {
        PatchDeployments.ListPatchDeploymentsRequest request = PatchDeployments.ListPatchDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPatchDeployments(request);
    }

    public final ListPatchDeploymentsPagedResponse listPatchDeployments(String parent) {
        PatchDeployments.ListPatchDeploymentsRequest request = PatchDeployments.ListPatchDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listPatchDeployments(request);
    }

    public final ListPatchDeploymentsPagedResponse listPatchDeployments(PatchDeployments.ListPatchDeploymentsRequest request) {
        return (ListPatchDeploymentsPagedResponse)((Object)this.listPatchDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<PatchDeployments.ListPatchDeploymentsRequest, ListPatchDeploymentsPagedResponse> listPatchDeploymentsPagedCallable() {
        return this.stub.listPatchDeploymentsPagedCallable();
    }

    public final UnaryCallable<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse> listPatchDeploymentsCallable() {
        return this.stub.listPatchDeploymentsCallable();
    }

    public final void deletePatchDeployment(PatchDeploymentName name) {
        PatchDeployments.DeletePatchDeploymentRequest request = PatchDeployments.DeletePatchDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePatchDeployment(request);
    }

    public final void deletePatchDeployment(String name) {
        PatchDeployments.DeletePatchDeploymentRequest request = PatchDeployments.DeletePatchDeploymentRequest.newBuilder().setName(name).build();
        this.deletePatchDeployment(request);
    }

    public final void deletePatchDeployment(PatchDeployments.DeletePatchDeploymentRequest request) {
        this.deletePatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.DeletePatchDeploymentRequest, Empty> deletePatchDeploymentCallable() {
        return this.stub.deletePatchDeploymentCallable();
    }

    public final PatchDeployments.PatchDeployment updatePatchDeployment(PatchDeployments.PatchDeployment patchDeployment, FieldMask updateMask) {
        PatchDeployments.UpdatePatchDeploymentRequest request = PatchDeployments.UpdatePatchDeploymentRequest.newBuilder().setPatchDeployment(patchDeployment).setUpdateMask(updateMask).build();
        return this.updatePatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment updatePatchDeployment(PatchDeployments.UpdatePatchDeploymentRequest request) {
        return (PatchDeployments.PatchDeployment)this.updatePatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.UpdatePatchDeploymentRequest, PatchDeployments.PatchDeployment> updatePatchDeploymentCallable() {
        return this.stub.updatePatchDeploymentCallable();
    }

    public final PatchDeployments.PatchDeployment pausePatchDeployment(PatchDeploymentName name) {
        PatchDeployments.PausePatchDeploymentRequest request = PatchDeployments.PausePatchDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pausePatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment pausePatchDeployment(String name) {
        PatchDeployments.PausePatchDeploymentRequest request = PatchDeployments.PausePatchDeploymentRequest.newBuilder().setName(name).build();
        return this.pausePatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment pausePatchDeployment(PatchDeployments.PausePatchDeploymentRequest request) {
        return (PatchDeployments.PatchDeployment)this.pausePatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.PausePatchDeploymentRequest, PatchDeployments.PatchDeployment> pausePatchDeploymentCallable() {
        return this.stub.pausePatchDeploymentCallable();
    }

    public final PatchDeployments.PatchDeployment resumePatchDeployment(PatchDeploymentName name) {
        PatchDeployments.ResumePatchDeploymentRequest request = PatchDeployments.ResumePatchDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.resumePatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment resumePatchDeployment(String name) {
        PatchDeployments.ResumePatchDeploymentRequest request = PatchDeployments.ResumePatchDeploymentRequest.newBuilder().setName(name).build();
        return this.resumePatchDeployment(request);
    }

    public final PatchDeployments.PatchDeployment resumePatchDeployment(PatchDeployments.ResumePatchDeploymentRequest request) {
        return (PatchDeployments.PatchDeployment)this.resumePatchDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<PatchDeployments.ResumePatchDeploymentRequest, PatchDeployments.PatchDeployment> resumePatchDeploymentCallable() {
        return this.stub.resumePatchDeploymentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPatchDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment, ListPatchDeploymentsPage, ListPatchDeploymentsFixedSizeCollection> {
        private ListPatchDeploymentsFixedSizeCollection(List<ListPatchDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPatchDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListPatchDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListPatchDeploymentsFixedSizeCollection createCollection(List<ListPatchDeploymentsPage> pages, int collectionSize) {
            return new ListPatchDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPatchDeploymentsPage
    extends AbstractPage<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment, ListPatchDeploymentsPage> {
        private ListPatchDeploymentsPage(PageContext<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment> context, PatchDeployments.ListPatchDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListPatchDeploymentsPage createEmptyPage() {
            return new ListPatchDeploymentsPage(null, null);
        }

        protected ListPatchDeploymentsPage createPage(PageContext<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment> context, PatchDeployments.ListPatchDeploymentsResponse response) {
            return new ListPatchDeploymentsPage(context, response);
        }

        public ApiFuture<ListPatchDeploymentsPage> createPageAsync(PageContext<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment> context, ApiFuture<PatchDeployments.ListPatchDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPatchDeploymentsPagedResponse
    extends AbstractPagedListResponse<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment, ListPatchDeploymentsPage, ListPatchDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListPatchDeploymentsPagedResponse> createAsync(PageContext<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment> context, ApiFuture<PatchDeployments.ListPatchDeploymentsResponse> futureResponse) {
            ApiFuture<ListPatchDeploymentsPage> futurePage = ListPatchDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPatchDeploymentsPagedResponse((ListPatchDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPatchDeploymentsPagedResponse(ListPatchDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPatchDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPatchJobInstanceDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails, ListPatchJobInstanceDetailsPage, ListPatchJobInstanceDetailsFixedSizeCollection> {
        private ListPatchJobInstanceDetailsFixedSizeCollection(List<ListPatchJobInstanceDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPatchJobInstanceDetailsFixedSizeCollection createEmptyCollection() {
            return new ListPatchJobInstanceDetailsFixedSizeCollection(null, 0);
        }

        protected ListPatchJobInstanceDetailsFixedSizeCollection createCollection(List<ListPatchJobInstanceDetailsPage> pages, int collectionSize) {
            return new ListPatchJobInstanceDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPatchJobInstanceDetailsPage
    extends AbstractPage<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails, ListPatchJobInstanceDetailsPage> {
        private ListPatchJobInstanceDetailsPage(PageContext<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails> context, PatchJobs.ListPatchJobInstanceDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListPatchJobInstanceDetailsPage createEmptyPage() {
            return new ListPatchJobInstanceDetailsPage(null, null);
        }

        protected ListPatchJobInstanceDetailsPage createPage(PageContext<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails> context, PatchJobs.ListPatchJobInstanceDetailsResponse response) {
            return new ListPatchJobInstanceDetailsPage(context, response);
        }

        public ApiFuture<ListPatchJobInstanceDetailsPage> createPageAsync(PageContext<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails> context, ApiFuture<PatchJobs.ListPatchJobInstanceDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPatchJobInstanceDetailsPagedResponse
    extends AbstractPagedListResponse<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails, ListPatchJobInstanceDetailsPage, ListPatchJobInstanceDetailsFixedSizeCollection> {
        public static ApiFuture<ListPatchJobInstanceDetailsPagedResponse> createAsync(PageContext<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails> context, ApiFuture<PatchJobs.ListPatchJobInstanceDetailsResponse> futureResponse) {
            ApiFuture<ListPatchJobInstanceDetailsPage> futurePage = ListPatchJobInstanceDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPatchJobInstanceDetailsPagedResponse((ListPatchJobInstanceDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPatchJobInstanceDetailsPagedResponse(ListPatchJobInstanceDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPatchJobInstanceDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPatchJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob, ListPatchJobsPage, ListPatchJobsFixedSizeCollection> {
        private ListPatchJobsFixedSizeCollection(List<ListPatchJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPatchJobsFixedSizeCollection createEmptyCollection() {
            return new ListPatchJobsFixedSizeCollection(null, 0);
        }

        protected ListPatchJobsFixedSizeCollection createCollection(List<ListPatchJobsPage> pages, int collectionSize) {
            return new ListPatchJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPatchJobsPage
    extends AbstractPage<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob, ListPatchJobsPage> {
        private ListPatchJobsPage(PageContext<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob> context, PatchJobs.ListPatchJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListPatchJobsPage createEmptyPage() {
            return new ListPatchJobsPage(null, null);
        }

        protected ListPatchJobsPage createPage(PageContext<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob> context, PatchJobs.ListPatchJobsResponse response) {
            return new ListPatchJobsPage(context, response);
        }

        public ApiFuture<ListPatchJobsPage> createPageAsync(PageContext<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob> context, ApiFuture<PatchJobs.ListPatchJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPatchJobsPagedResponse
    extends AbstractPagedListResponse<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob, ListPatchJobsPage, ListPatchJobsFixedSizeCollection> {
        public static ApiFuture<ListPatchJobsPagedResponse> createAsync(PageContext<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob> context, ApiFuture<PatchJobs.ListPatchJobsResponse> futureResponse) {
            ApiFuture<ListPatchJobsPage> futurePage = ListPatchJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPatchJobsPagedResponse((ListPatchJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPatchJobsPagedResponse(ListPatchJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPatchJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

