/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1.CheckUpgradeRequest;
import com.google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse;
import com.google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.CreateUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.CreateUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.DatabaseFailoverRequest;
import com.google.cloud.orchestration.airflow.service.v1.DatabaseFailoverResponse;
import com.google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.Environment;
import com.google.cloud.orchestration.airflow.service.v1.EnvironmentsClient;
import com.google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesRequest;
import com.google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesResponse;
import com.google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.GetUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.GetUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsConfigMapsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsConfigMapsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsSecretsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsSecretsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListWorkloadsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListWorkloadsResponse;
import com.google.cloud.orchestration.airflow.service.v1.LoadSnapshotRequest;
import com.google.cloud.orchestration.airflow.service.v1.LoadSnapshotResponse;
import com.google.cloud.orchestration.airflow.service.v1.OperationMetadata;
import com.google.cloud.orchestration.airflow.service.v1.PollAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.SaveSnapshotRequest;
import com.google.cloud.orchestration.airflow.service.v1.SaveSnapshotResponse;
import com.google.cloud.orchestration.airflow.service.v1.StopAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.StopAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.UpdateUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.UpdateUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsConfigMap;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsSecret;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.GrpcEnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.HttpJsonEnvironmentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EnvironmentsStubSettings
extends StubSettings<EnvironmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
    private final OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
    private final OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
    private final OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
    private final UnaryCallSettings<ExecuteAirflowCommandRequest, ExecuteAirflowCommandResponse> executeAirflowCommandSettings;
    private final UnaryCallSettings<StopAirflowCommandRequest, StopAirflowCommandResponse> stopAirflowCommandSettings;
    private final UnaryCallSettings<PollAirflowCommandRequest, PollAirflowCommandResponse> pollAirflowCommandSettings;
    private final PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
    private final UnaryCallSettings<CheckUpgradeRequest, Operation> checkUpgradeSettings;
    private final OperationCallSettings<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings;
    private final UnaryCallSettings<CreateUserWorkloadsSecretRequest, UserWorkloadsSecret> createUserWorkloadsSecretSettings;
    private final UnaryCallSettings<GetUserWorkloadsSecretRequest, UserWorkloadsSecret> getUserWorkloadsSecretSettings;
    private final PagedCallSettings<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> listUserWorkloadsSecretsSettings;
    private final UnaryCallSettings<UpdateUserWorkloadsSecretRequest, UserWorkloadsSecret> updateUserWorkloadsSecretSettings;
    private final UnaryCallSettings<DeleteUserWorkloadsSecretRequest, Empty> deleteUserWorkloadsSecretSettings;
    private final UnaryCallSettings<CreateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> createUserWorkloadsConfigMapSettings;
    private final UnaryCallSettings<GetUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> getUserWorkloadsConfigMapSettings;
    private final PagedCallSettings<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> listUserWorkloadsConfigMapsSettings;
    private final UnaryCallSettings<UpdateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> updateUserWorkloadsConfigMapSettings;
    private final UnaryCallSettings<DeleteUserWorkloadsConfigMapRequest, Empty> deleteUserWorkloadsConfigMapSettings;
    private final UnaryCallSettings<SaveSnapshotRequest, Operation> saveSnapshotSettings;
    private final OperationCallSettings<SaveSnapshotRequest, SaveSnapshotResponse, OperationMetadata> saveSnapshotOperationSettings;
    private final UnaryCallSettings<LoadSnapshotRequest, Operation> loadSnapshotSettings;
    private final OperationCallSettings<LoadSnapshotRequest, LoadSnapshotResponse, OperationMetadata> loadSnapshotOperationSettings;
    private final UnaryCallSettings<DatabaseFailoverRequest, Operation> databaseFailoverSettings;
    private final OperationCallSettings<DatabaseFailoverRequest, DatabaseFailoverResponse, OperationMetadata> databaseFailoverOperationSettings;
    private final UnaryCallSettings<FetchDatabasePropertiesRequest, FetchDatabasePropertiesResponse> fetchDatabasePropertiesSettings;
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList();
        }
    };
    private static final PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload> LIST_WORKLOADS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkloadsRequest injectToken(ListWorkloadsRequest payload, String token) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageToken(token).build();
        }

        public ListWorkloadsRequest injectPageSize(ListWorkloadsRequest payload, int pageSize) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkloadsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkloadsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ListWorkloadsResponse.ComposerWorkload> extractResources(ListWorkloadsResponse payload) {
            return payload.getWorkloadsList();
        }
    };
    private static final PagedListDescriptor<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret> LIST_USER_WORKLOADS_SECRETS_PAGE_STR_DESC = new PagedListDescriptor<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret>(){

        public String emptyToken() {
            return "";
        }

        public ListUserWorkloadsSecretsRequest injectToken(ListUserWorkloadsSecretsRequest payload, String token) {
            return ListUserWorkloadsSecretsRequest.newBuilder((ListUserWorkloadsSecretsRequest)payload).setPageToken(token).build();
        }

        public ListUserWorkloadsSecretsRequest injectPageSize(ListUserWorkloadsSecretsRequest payload, int pageSize) {
            return ListUserWorkloadsSecretsRequest.newBuilder((ListUserWorkloadsSecretsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUserWorkloadsSecretsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUserWorkloadsSecretsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UserWorkloadsSecret> extractResources(ListUserWorkloadsSecretsResponse payload) {
            return payload.getUserWorkloadsSecretsList();
        }
    };
    private static final PagedListDescriptor<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap> LIST_USER_WORKLOADS_CONFIG_MAPS_PAGE_STR_DESC = new PagedListDescriptor<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap>(){

        public String emptyToken() {
            return "";
        }

        public ListUserWorkloadsConfigMapsRequest injectToken(ListUserWorkloadsConfigMapsRequest payload, String token) {
            return ListUserWorkloadsConfigMapsRequest.newBuilder((ListUserWorkloadsConfigMapsRequest)payload).setPageToken(token).build();
        }

        public ListUserWorkloadsConfigMapsRequest injectPageSize(ListUserWorkloadsConfigMapsRequest payload, int pageSize) {
            return ListUserWorkloadsConfigMapsRequest.newBuilder((ListUserWorkloadsConfigMapsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUserWorkloadsConfigMapsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUserWorkloadsConfigMapsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UserWorkloadsConfigMap> extractResources(ListUserWorkloadsConfigMapsResponse payload) {
            return payload.getUserWorkloadsConfigMapsList();
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse> LIST_WORKLOADS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListWorkloadsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> callable, ListWorkloadsRequest request, ApiCallContext context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKLOADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListWorkloadsPagedResponse.createAsync((PageContext<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> LIST_USER_WORKLOADS_SECRETS_PAGE_STR_FACT = new PagedListResponseFactory<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse> callable, ListUserWorkloadsSecretsRequest request, ApiCallContext context, ApiFuture<ListUserWorkloadsSecretsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USER_WORKLOADS_SECRETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse.createAsync((PageContext<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> LIST_USER_WORKLOADS_CONFIG_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse> callable, ListUserWorkloadsConfigMapsRequest request, ApiCallContext context, ApiFuture<ListUserWorkloadsConfigMapsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USER_WORKLOADS_CONFIG_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse.createAsync((PageContext<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    public OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
        return this.createEnvironmentOperationSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
        return this.updateEnvironmentSettings;
    }

    public OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
        return this.updateEnvironmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
        return this.deleteEnvironmentOperationSettings;
    }

    public UnaryCallSettings<ExecuteAirflowCommandRequest, ExecuteAirflowCommandResponse> executeAirflowCommandSettings() {
        return this.executeAirflowCommandSettings;
    }

    public UnaryCallSettings<StopAirflowCommandRequest, StopAirflowCommandResponse> stopAirflowCommandSettings() {
        return this.stopAirflowCommandSettings;
    }

    public UnaryCallSettings<PollAirflowCommandRequest, PollAirflowCommandResponse> pollAirflowCommandSettings() {
        return this.pollAirflowCommandSettings;
    }

    public PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
        return this.listWorkloadsSettings;
    }

    public UnaryCallSettings<CheckUpgradeRequest, Operation> checkUpgradeSettings() {
        return this.checkUpgradeSettings;
    }

    public OperationCallSettings<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings() {
        return this.checkUpgradeOperationSettings;
    }

    public UnaryCallSettings<CreateUserWorkloadsSecretRequest, UserWorkloadsSecret> createUserWorkloadsSecretSettings() {
        return this.createUserWorkloadsSecretSettings;
    }

    public UnaryCallSettings<GetUserWorkloadsSecretRequest, UserWorkloadsSecret> getUserWorkloadsSecretSettings() {
        return this.getUserWorkloadsSecretSettings;
    }

    public PagedCallSettings<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> listUserWorkloadsSecretsSettings() {
        return this.listUserWorkloadsSecretsSettings;
    }

    public UnaryCallSettings<UpdateUserWorkloadsSecretRequest, UserWorkloadsSecret> updateUserWorkloadsSecretSettings() {
        return this.updateUserWorkloadsSecretSettings;
    }

    public UnaryCallSettings<DeleteUserWorkloadsSecretRequest, Empty> deleteUserWorkloadsSecretSettings() {
        return this.deleteUserWorkloadsSecretSettings;
    }

    public UnaryCallSettings<CreateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> createUserWorkloadsConfigMapSettings() {
        return this.createUserWorkloadsConfigMapSettings;
    }

    public UnaryCallSettings<GetUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> getUserWorkloadsConfigMapSettings() {
        return this.getUserWorkloadsConfigMapSettings;
    }

    public PagedCallSettings<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> listUserWorkloadsConfigMapsSettings() {
        return this.listUserWorkloadsConfigMapsSettings;
    }

    public UnaryCallSettings<UpdateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> updateUserWorkloadsConfigMapSettings() {
        return this.updateUserWorkloadsConfigMapSettings;
    }

    public UnaryCallSettings<DeleteUserWorkloadsConfigMapRequest, Empty> deleteUserWorkloadsConfigMapSettings() {
        return this.deleteUserWorkloadsConfigMapSettings;
    }

    public UnaryCallSettings<SaveSnapshotRequest, Operation> saveSnapshotSettings() {
        return this.saveSnapshotSettings;
    }

    public OperationCallSettings<SaveSnapshotRequest, SaveSnapshotResponse, OperationMetadata> saveSnapshotOperationSettings() {
        return this.saveSnapshotOperationSettings;
    }

    public UnaryCallSettings<LoadSnapshotRequest, Operation> loadSnapshotSettings() {
        return this.loadSnapshotSettings;
    }

    public OperationCallSettings<LoadSnapshotRequest, LoadSnapshotResponse, OperationMetadata> loadSnapshotOperationSettings() {
        return this.loadSnapshotOperationSettings;
    }

    public UnaryCallSettings<DatabaseFailoverRequest, Operation> databaseFailoverSettings() {
        return this.databaseFailoverSettings;
    }

    public OperationCallSettings<DatabaseFailoverRequest, DatabaseFailoverResponse, OperationMetadata> databaseFailoverOperationSettings() {
        return this.databaseFailoverOperationSettings;
    }

    public UnaryCallSettings<FetchDatabasePropertiesRequest, FetchDatabasePropertiesResponse> fetchDatabasePropertiesSettings() {
        return this.fetchDatabasePropertiesSettings;
    }

    public EnvironmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEnvironmentsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEnvironmentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "composer";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "composer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "composer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnvironmentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EnvironmentsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EnvironmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.createEnvironmentOperationSettings = settingsBuilder.createEnvironmentOperationSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.updateEnvironmentSettings = settingsBuilder.updateEnvironmentSettings().build();
        this.updateEnvironmentOperationSettings = settingsBuilder.updateEnvironmentOperationSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.deleteEnvironmentOperationSettings = settingsBuilder.deleteEnvironmentOperationSettings().build();
        this.executeAirflowCommandSettings = settingsBuilder.executeAirflowCommandSettings().build();
        this.stopAirflowCommandSettings = settingsBuilder.stopAirflowCommandSettings().build();
        this.pollAirflowCommandSettings = settingsBuilder.pollAirflowCommandSettings().build();
        this.listWorkloadsSettings = settingsBuilder.listWorkloadsSettings().build();
        this.checkUpgradeSettings = settingsBuilder.checkUpgradeSettings().build();
        this.checkUpgradeOperationSettings = settingsBuilder.checkUpgradeOperationSettings().build();
        this.createUserWorkloadsSecretSettings = settingsBuilder.createUserWorkloadsSecretSettings().build();
        this.getUserWorkloadsSecretSettings = settingsBuilder.getUserWorkloadsSecretSettings().build();
        this.listUserWorkloadsSecretsSettings = settingsBuilder.listUserWorkloadsSecretsSettings().build();
        this.updateUserWorkloadsSecretSettings = settingsBuilder.updateUserWorkloadsSecretSettings().build();
        this.deleteUserWorkloadsSecretSettings = settingsBuilder.deleteUserWorkloadsSecretSettings().build();
        this.createUserWorkloadsConfigMapSettings = settingsBuilder.createUserWorkloadsConfigMapSettings().build();
        this.getUserWorkloadsConfigMapSettings = settingsBuilder.getUserWorkloadsConfigMapSettings().build();
        this.listUserWorkloadsConfigMapsSettings = settingsBuilder.listUserWorkloadsConfigMapsSettings().build();
        this.updateUserWorkloadsConfigMapSettings = settingsBuilder.updateUserWorkloadsConfigMapSettings().build();
        this.deleteUserWorkloadsConfigMapSettings = settingsBuilder.deleteUserWorkloadsConfigMapSettings().build();
        this.saveSnapshotSettings = settingsBuilder.saveSnapshotSettings().build();
        this.saveSnapshotOperationSettings = settingsBuilder.saveSnapshotOperationSettings().build();
        this.loadSnapshotSettings = settingsBuilder.loadSnapshotSettings().build();
        this.loadSnapshotOperationSettings = settingsBuilder.loadSnapshotOperationSettings().build();
        this.databaseFailoverSettings = settingsBuilder.databaseFailoverSettings().build();
        this.databaseFailoverOperationSettings = settingsBuilder.databaseFailoverOperationSettings().build();
        this.fetchDatabasePropertiesSettings = settingsBuilder.fetchDatabasePropertiesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EnvironmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
        private final OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
        private final OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
        private final OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<ExecuteAirflowCommandRequest, ExecuteAirflowCommandResponse> executeAirflowCommandSettings;
        private final UnaryCallSettings.Builder<StopAirflowCommandRequest, StopAirflowCommandResponse> stopAirflowCommandSettings;
        private final UnaryCallSettings.Builder<PollAirflowCommandRequest, PollAirflowCommandResponse> pollAirflowCommandSettings;
        private final PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
        private final UnaryCallSettings.Builder<CheckUpgradeRequest, Operation> checkUpgradeSettings;
        private final OperationCallSettings.Builder<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings;
        private final UnaryCallSettings.Builder<CreateUserWorkloadsSecretRequest, UserWorkloadsSecret> createUserWorkloadsSecretSettings;
        private final UnaryCallSettings.Builder<GetUserWorkloadsSecretRequest, UserWorkloadsSecret> getUserWorkloadsSecretSettings;
        private final PagedCallSettings.Builder<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> listUserWorkloadsSecretsSettings;
        private final UnaryCallSettings.Builder<UpdateUserWorkloadsSecretRequest, UserWorkloadsSecret> updateUserWorkloadsSecretSettings;
        private final UnaryCallSettings.Builder<DeleteUserWorkloadsSecretRequest, Empty> deleteUserWorkloadsSecretSettings;
        private final UnaryCallSettings.Builder<CreateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> createUserWorkloadsConfigMapSettings;
        private final UnaryCallSettings.Builder<GetUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> getUserWorkloadsConfigMapSettings;
        private final PagedCallSettings.Builder<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> listUserWorkloadsConfigMapsSettings;
        private final UnaryCallSettings.Builder<UpdateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> updateUserWorkloadsConfigMapSettings;
        private final UnaryCallSettings.Builder<DeleteUserWorkloadsConfigMapRequest, Empty> deleteUserWorkloadsConfigMapSettings;
        private final UnaryCallSettings.Builder<SaveSnapshotRequest, Operation> saveSnapshotSettings;
        private final OperationCallSettings.Builder<SaveSnapshotRequest, SaveSnapshotResponse, OperationMetadata> saveSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<LoadSnapshotRequest, Operation> loadSnapshotSettings;
        private final OperationCallSettings.Builder<LoadSnapshotRequest, LoadSnapshotResponse, OperationMetadata> loadSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<DatabaseFailoverRequest, Operation> databaseFailoverSettings;
        private final OperationCallSettings.Builder<DatabaseFailoverRequest, DatabaseFailoverResponse, OperationMetadata> databaseFailoverOperationSettings;
        private final UnaryCallSettings.Builder<FetchDatabasePropertiesRequest, FetchDatabasePropertiesResponse> fetchDatabasePropertiesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.updateEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.executeAirflowCommandSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopAirflowCommandSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pollAirflowCommandSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkloadsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKLOADS_PAGE_STR_FACT);
            this.checkUpgradeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkUpgradeOperationSettings = OperationCallSettings.newBuilder();
            this.createUserWorkloadsSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getUserWorkloadsSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUserWorkloadsSecretsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USER_WORKLOADS_SECRETS_PAGE_STR_FACT);
            this.updateUserWorkloadsSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteUserWorkloadsSecretSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createUserWorkloadsConfigMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getUserWorkloadsConfigMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUserWorkloadsConfigMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USER_WORKLOADS_CONFIG_MAPS_PAGE_STR_FACT);
            this.updateUserWorkloadsConfigMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteUserWorkloadsConfigMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.saveSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.saveSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.loadSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.loadSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.databaseFailoverSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.databaseFailoverOperationSettings = OperationCallSettings.newBuilder();
            this.fetchDatabasePropertiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEnvironmentSettings, this.getEnvironmentSettings, this.listEnvironmentsSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.executeAirflowCommandSettings, this.stopAirflowCommandSettings, this.pollAirflowCommandSettings, this.listWorkloadsSettings, this.checkUpgradeSettings, this.createUserWorkloadsSecretSettings, this.getUserWorkloadsSecretSettings, (Object[])new UnaryCallSettings.Builder[]{this.listUserWorkloadsSecretsSettings, this.updateUserWorkloadsSecretSettings, this.deleteUserWorkloadsSecretSettings, this.createUserWorkloadsConfigMapSettings, this.getUserWorkloadsConfigMapSettings, this.listUserWorkloadsConfigMapsSettings, this.updateUserWorkloadsConfigMapSettings, this.deleteUserWorkloadsConfigMapSettings, this.saveSnapshotSettings, this.loadSnapshotSettings, this.databaseFailoverSettings, this.fetchDatabasePropertiesSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EnvironmentsStubSettings settings) {
            super((StubSettings)settings);
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.createEnvironmentOperationSettings = settings.createEnvironmentOperationSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.updateEnvironmentSettings = settings.updateEnvironmentSettings.toBuilder();
            this.updateEnvironmentOperationSettings = settings.updateEnvironmentOperationSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.deleteEnvironmentOperationSettings = settings.deleteEnvironmentOperationSettings.toBuilder();
            this.executeAirflowCommandSettings = settings.executeAirflowCommandSettings.toBuilder();
            this.stopAirflowCommandSettings = settings.stopAirflowCommandSettings.toBuilder();
            this.pollAirflowCommandSettings = settings.pollAirflowCommandSettings.toBuilder();
            this.listWorkloadsSettings = settings.listWorkloadsSettings.toBuilder();
            this.checkUpgradeSettings = settings.checkUpgradeSettings.toBuilder();
            this.checkUpgradeOperationSettings = settings.checkUpgradeOperationSettings.toBuilder();
            this.createUserWorkloadsSecretSettings = settings.createUserWorkloadsSecretSettings.toBuilder();
            this.getUserWorkloadsSecretSettings = settings.getUserWorkloadsSecretSettings.toBuilder();
            this.listUserWorkloadsSecretsSettings = settings.listUserWorkloadsSecretsSettings.toBuilder();
            this.updateUserWorkloadsSecretSettings = settings.updateUserWorkloadsSecretSettings.toBuilder();
            this.deleteUserWorkloadsSecretSettings = settings.deleteUserWorkloadsSecretSettings.toBuilder();
            this.createUserWorkloadsConfigMapSettings = settings.createUserWorkloadsConfigMapSettings.toBuilder();
            this.getUserWorkloadsConfigMapSettings = settings.getUserWorkloadsConfigMapSettings.toBuilder();
            this.listUserWorkloadsConfigMapsSettings = settings.listUserWorkloadsConfigMapsSettings.toBuilder();
            this.updateUserWorkloadsConfigMapSettings = settings.updateUserWorkloadsConfigMapSettings.toBuilder();
            this.deleteUserWorkloadsConfigMapSettings = settings.deleteUserWorkloadsConfigMapSettings.toBuilder();
            this.saveSnapshotSettings = settings.saveSnapshotSettings.toBuilder();
            this.saveSnapshotOperationSettings = settings.saveSnapshotOperationSettings.toBuilder();
            this.loadSnapshotSettings = settings.loadSnapshotSettings.toBuilder();
            this.loadSnapshotOperationSettings = settings.loadSnapshotOperationSettings.toBuilder();
            this.databaseFailoverSettings = settings.databaseFailoverSettings.toBuilder();
            this.databaseFailoverOperationSettings = settings.databaseFailoverOperationSettings.toBuilder();
            this.fetchDatabasePropertiesSettings = settings.fetchDatabasePropertiesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEnvironmentSettings, this.getEnvironmentSettings, this.listEnvironmentsSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.executeAirflowCommandSettings, this.stopAirflowCommandSettings, this.pollAirflowCommandSettings, this.listWorkloadsSettings, this.checkUpgradeSettings, this.createUserWorkloadsSecretSettings, this.getUserWorkloadsSecretSettings, (Object[])new UnaryCallSettings.Builder[]{this.listUserWorkloadsSecretsSettings, this.updateUserWorkloadsSecretSettings, this.deleteUserWorkloadsSecretSettings, this.createUserWorkloadsConfigMapSettings, this.getUserWorkloadsConfigMapSettings, this.listUserWorkloadsConfigMapsSettings, this.updateUserWorkloadsConfigMapSettings, this.deleteUserWorkloadsConfigMapSettings, this.saveSnapshotSettings, this.loadSnapshotSettings, this.databaseFailoverSettings, this.fetchDatabasePropertiesSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EnvironmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EnvironmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EnvironmentsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EnvironmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.executeAirflowCommandSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.stopAirflowCommandSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.pollAirflowCommandSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listWorkloadsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.checkUpgradeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createUserWorkloadsSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getUserWorkloadsSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listUserWorkloadsSecretsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateUserWorkloadsSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteUserWorkloadsSecretSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createUserWorkloadsConfigMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getUserWorkloadsConfigMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listUserWorkloadsConfigMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateUserWorkloadsConfigMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteUserWorkloadsConfigMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.saveSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.loadSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.databaseFailoverSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchDatabasePropertiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.checkUpgradeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CheckUpgradeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.saveSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SaveSnapshotResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.loadSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LoadSnapshotResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.databaseFailoverOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DatabaseFailoverResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        public OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
            return this.createEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
            return this.updateEnvironmentSettings;
        }

        public OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
            return this.updateEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        public OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
            return this.deleteEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<ExecuteAirflowCommandRequest, ExecuteAirflowCommandResponse> executeAirflowCommandSettings() {
            return this.executeAirflowCommandSettings;
        }

        public UnaryCallSettings.Builder<StopAirflowCommandRequest, StopAirflowCommandResponse> stopAirflowCommandSettings() {
            return this.stopAirflowCommandSettings;
        }

        public UnaryCallSettings.Builder<PollAirflowCommandRequest, PollAirflowCommandResponse> pollAirflowCommandSettings() {
            return this.pollAirflowCommandSettings;
        }

        public PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, EnvironmentsClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
            return this.listWorkloadsSettings;
        }

        public UnaryCallSettings.Builder<CheckUpgradeRequest, Operation> checkUpgradeSettings() {
            return this.checkUpgradeSettings;
        }

        public OperationCallSettings.Builder<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings() {
            return this.checkUpgradeOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateUserWorkloadsSecretRequest, UserWorkloadsSecret> createUserWorkloadsSecretSettings() {
            return this.createUserWorkloadsSecretSettings;
        }

        public UnaryCallSettings.Builder<GetUserWorkloadsSecretRequest, UserWorkloadsSecret> getUserWorkloadsSecretSettings() {
            return this.getUserWorkloadsSecretSettings;
        }

        public PagedCallSettings.Builder<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, EnvironmentsClient.ListUserWorkloadsSecretsPagedResponse> listUserWorkloadsSecretsSettings() {
            return this.listUserWorkloadsSecretsSettings;
        }

        public UnaryCallSettings.Builder<UpdateUserWorkloadsSecretRequest, UserWorkloadsSecret> updateUserWorkloadsSecretSettings() {
            return this.updateUserWorkloadsSecretSettings;
        }

        public UnaryCallSettings.Builder<DeleteUserWorkloadsSecretRequest, Empty> deleteUserWorkloadsSecretSettings() {
            return this.deleteUserWorkloadsSecretSettings;
        }

        public UnaryCallSettings.Builder<CreateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> createUserWorkloadsConfigMapSettings() {
            return this.createUserWorkloadsConfigMapSettings;
        }

        public UnaryCallSettings.Builder<GetUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> getUserWorkloadsConfigMapSettings() {
            return this.getUserWorkloadsConfigMapSettings;
        }

        public PagedCallSettings.Builder<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, EnvironmentsClient.ListUserWorkloadsConfigMapsPagedResponse> listUserWorkloadsConfigMapsSettings() {
            return this.listUserWorkloadsConfigMapsSettings;
        }

        public UnaryCallSettings.Builder<UpdateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> updateUserWorkloadsConfigMapSettings() {
            return this.updateUserWorkloadsConfigMapSettings;
        }

        public UnaryCallSettings.Builder<DeleteUserWorkloadsConfigMapRequest, Empty> deleteUserWorkloadsConfigMapSettings() {
            return this.deleteUserWorkloadsConfigMapSettings;
        }

        public UnaryCallSettings.Builder<SaveSnapshotRequest, Operation> saveSnapshotSettings() {
            return this.saveSnapshotSettings;
        }

        public OperationCallSettings.Builder<SaveSnapshotRequest, SaveSnapshotResponse, OperationMetadata> saveSnapshotOperationSettings() {
            return this.saveSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<LoadSnapshotRequest, Operation> loadSnapshotSettings() {
            return this.loadSnapshotSettings;
        }

        public OperationCallSettings.Builder<LoadSnapshotRequest, LoadSnapshotResponse, OperationMetadata> loadSnapshotOperationSettings() {
            return this.loadSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<DatabaseFailoverRequest, Operation> databaseFailoverSettings() {
            return this.databaseFailoverSettings;
        }

        public OperationCallSettings.Builder<DatabaseFailoverRequest, DatabaseFailoverResponse, OperationMetadata> databaseFailoverOperationSettings() {
            return this.databaseFailoverOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchDatabasePropertiesRequest, FetchDatabasePropertiesResponse> fetchDatabasePropertiesSettings() {
            return this.fetchDatabasePropertiesSettings;
        }

        public EnvironmentsStubSettings build() throws IOException {
            return new EnvironmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

