/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.Environment;
import com.google.cloud.orchestration.airflow.service.v1.EnvironmentsClient;
import com.google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse;
import com.google.cloud.orchestration.airflow.service.v1.OperationMetadata;
import com.google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStubSettings;
import com.google.cloud.orchestration.airflow.service.v1.stub.HttpJsonEnvironmentsCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonEnvironmentsStub
extends EnvironmentsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Environment.getDescriptor()).add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateEnvironmentRequest, Operation> createEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orchestration.airflow.service.v1.Environments/CreateEnvironment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/environments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("environment", (Message)request.getEnvironment(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetEnvironmentRequest, Environment> getEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orchestration.airflow.service.v1.Environments/GetEnvironment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Environment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orchestration.airflow.service.v1.Environments/ListEnvironments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/environments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEnvironmentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateEnvironmentRequest, Operation> updateEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orchestration.airflow.service.v1.Environments/UpdateEnvironment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("environment", (Message)request.getEnvironment(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteEnvironmentRequest, Operation> deleteEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.orchestration.airflow.service.v1.Environments/DeleteEnvironment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable;
    private final OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable;
    private final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable;
    private final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable;
    private final UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable;
    private final UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable;
    private final OperationCallable<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationCallable;
    private final UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable;
    private final OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEnvironmentsStub create(EnvironmentsStubSettings settings) throws IOException {
        return new HttpJsonEnvironmentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEnvironmentsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEnvironmentsStub(EnvironmentsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEnvironmentsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEnvironmentsStub(EnvironmentsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEnvironmentsCallableFactory());
    }

    protected HttpJsonEnvironmentsStub(EnvironmentsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listEnvironmentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEnvironmentsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createEnvironmentCallable = callableFactory.createUnaryCallable(createEnvironmentTransportSettings, settings.createEnvironmentSettings(), clientContext);
        this.createEnvironmentOperationCallable = callableFactory.createOperationCallable(createEnvironmentTransportSettings, settings.createEnvironmentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getEnvironmentCallable = callableFactory.createUnaryCallable(getEnvironmentTransportSettings, settings.getEnvironmentSettings(), clientContext);
        this.listEnvironmentsCallable = callableFactory.createUnaryCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.listEnvironmentsPagedCallable = callableFactory.createPagedCallable(listEnvironmentsTransportSettings, settings.listEnvironmentsSettings(), clientContext);
        this.updateEnvironmentCallable = callableFactory.createUnaryCallable(updateEnvironmentTransportSettings, settings.updateEnvironmentSettings(), clientContext);
        this.updateEnvironmentOperationCallable = callableFactory.createOperationCallable(updateEnvironmentTransportSettings, settings.updateEnvironmentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteEnvironmentCallable = callableFactory.createUnaryCallable(deleteEnvironmentTransportSettings, settings.deleteEnvironmentSettings(), clientContext);
        this.deleteEnvironmentOperationCallable = callableFactory.createOperationCallable(deleteEnvironmentTransportSettings, settings.deleteEnvironmentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createEnvironmentMethodDescriptor);
        methodDescriptors.add(getEnvironmentMethodDescriptor);
        methodDescriptors.add(listEnvironmentsMethodDescriptor);
        methodDescriptors.add(updateEnvironmentMethodDescriptor);
        methodDescriptors.add(deleteEnvironmentMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.createEnvironmentCallable;
    }

    @Override
    public OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable() {
        return this.createEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.getEnvironmentCallable;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.listEnvironmentsCallable;
    }

    @Override
    public UnaryCallable<ListEnvironmentsRequest, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.listEnvironmentsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable() {
        return this.updateEnvironmentCallable;
    }

    @Override
    public OperationCallable<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationCallable() {
        return this.updateEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable() {
        return this.deleteEnvironmentCallable;
    }

    @Override
    public OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable() {
        return this.deleteEnvironmentOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

