/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.Environment;
import com.google.cloud.orchestration.airflow.service.v1.EnvironmentsSettings;
import com.google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse;
import com.google.cloud.orchestration.airflow.service.v1.OperationMetadata;
import com.google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EnvironmentsClient
implements BackgroundResource {
    private final EnvironmentsSettings settings;
    private final EnvironmentsStub stub;
    private final OperationsClient operationsClient;

    public static final EnvironmentsClient create() throws IOException {
        return EnvironmentsClient.create(EnvironmentsSettings.newBuilder().build());
    }

    public static final EnvironmentsClient create(EnvironmentsSettings settings) throws IOException {
        return new EnvironmentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EnvironmentsClient create(EnvironmentsStub stub) {
        return new EnvironmentsClient(stub);
    }

    protected EnvironmentsClient(EnvironmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EnvironmentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EnvironmentsClient(EnvironmentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EnvironmentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnvironmentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(String parent, Environment environment) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent).setEnvironment(environment).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable() {
        return this.stub.createEnvironmentOperationCallable();
    }

    public final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(String name, Environment environment, FieldMask updateMask) {
        UpdateEnvironmentRequest request = UpdateEnvironmentRequest.newBuilder().setName(name).setEnvironment(environment).setUpdateMask(updateMask).build();
        return this.updateEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationCallable() {
        return this.stub.updateEnvironmentOperationCallable();
    }

    public final UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable() {
        return this.stub.updateEnvironmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(String name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name).build();
        return this.deleteEnvironmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable() {
        return this.stub.deleteEnvironmentOperationCallable();
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

