/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.oracledatabase.v1.AutonomousDatabase;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseBackup;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet;
import com.google.cloud.oracledatabase.v1.AutonomousDatabaseName;
import com.google.cloud.oracledatabase.v1.AutonomousDbVersion;
import com.google.cloud.oracledatabase.v1.CloudExadataInfrastructure;
import com.google.cloud.oracledatabase.v1.CloudExadataInfrastructureName;
import com.google.cloud.oracledatabase.v1.CloudVmCluster;
import com.google.cloud.oracledatabase.v1.CloudVmClusterName;
import com.google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.CreateDbSystemRequest;
import com.google.cloud.oracledatabase.v1.CreateExadbVmClusterRequest;
import com.google.cloud.oracledatabase.v1.CreateExascaleDbStorageVaultRequest;
import com.google.cloud.oracledatabase.v1.CreateOdbNetworkRequest;
import com.google.cloud.oracledatabase.v1.CreateOdbSubnetRequest;
import com.google.cloud.oracledatabase.v1.Database;
import com.google.cloud.oracledatabase.v1.DatabaseCharacterSet;
import com.google.cloud.oracledatabase.v1.DatabaseName;
import com.google.cloud.oracledatabase.v1.DbNode;
import com.google.cloud.oracledatabase.v1.DbServer;
import com.google.cloud.oracledatabase.v1.DbSystem;
import com.google.cloud.oracledatabase.v1.DbSystemInitialStorageSize;
import com.google.cloud.oracledatabase.v1.DbSystemName;
import com.google.cloud.oracledatabase.v1.DbSystemShape;
import com.google.cloud.oracledatabase.v1.DbVersion;
import com.google.cloud.oracledatabase.v1.DeleteAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.DeleteCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.DeleteDbSystemRequest;
import com.google.cloud.oracledatabase.v1.DeleteExadbVmClusterRequest;
import com.google.cloud.oracledatabase.v1.DeleteExascaleDbStorageVaultRequest;
import com.google.cloud.oracledatabase.v1.DeleteOdbNetworkRequest;
import com.google.cloud.oracledatabase.v1.DeleteOdbSubnetRequest;
import com.google.cloud.oracledatabase.v1.Entitlement;
import com.google.cloud.oracledatabase.v1.ExadbVmCluster;
import com.google.cloud.oracledatabase.v1.ExadbVmClusterName;
import com.google.cloud.oracledatabase.v1.ExascaleDbStorageVault;
import com.google.cloud.oracledatabase.v1.ExascaleDbStorageVaultName;
import com.google.cloud.oracledatabase.v1.FailoverAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest;
import com.google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletResponse;
import com.google.cloud.oracledatabase.v1.GenerateType;
import com.google.cloud.oracledatabase.v1.GetAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GetCloudExadataInfrastructureRequest;
import com.google.cloud.oracledatabase.v1.GetCloudVmClusterRequest;
import com.google.cloud.oracledatabase.v1.GetDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GetDbSystemRequest;
import com.google.cloud.oracledatabase.v1.GetExadbVmClusterRequest;
import com.google.cloud.oracledatabase.v1.GetExascaleDbStorageVaultRequest;
import com.google.cloud.oracledatabase.v1.GetOdbNetworkRequest;
import com.google.cloud.oracledatabase.v1.GetOdbSubnetRequest;
import com.google.cloud.oracledatabase.v1.GetPluggableDatabaseRequest;
import com.google.cloud.oracledatabase.v1.GiVersion;
import com.google.cloud.oracledatabase.v1.GiVersionName;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresRequest;
import com.google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersRequest;
import com.google.cloud.oracledatabase.v1.ListCloudVmClustersResponse;
import com.google.cloud.oracledatabase.v1.ListDatabaseCharacterSetsRequest;
import com.google.cloud.oracledatabase.v1.ListDatabaseCharacterSetsResponse;
import com.google.cloud.oracledatabase.v1.ListDatabasesRequest;
import com.google.cloud.oracledatabase.v1.ListDatabasesResponse;
import com.google.cloud.oracledatabase.v1.ListDbNodesRequest;
import com.google.cloud.oracledatabase.v1.ListDbNodesResponse;
import com.google.cloud.oracledatabase.v1.ListDbServersRequest;
import com.google.cloud.oracledatabase.v1.ListDbServersResponse;
import com.google.cloud.oracledatabase.v1.ListDbSystemInitialStorageSizesRequest;
import com.google.cloud.oracledatabase.v1.ListDbSystemInitialStorageSizesResponse;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesRequest;
import com.google.cloud.oracledatabase.v1.ListDbSystemShapesResponse;
import com.google.cloud.oracledatabase.v1.ListDbSystemsRequest;
import com.google.cloud.oracledatabase.v1.ListDbSystemsResponse;
import com.google.cloud.oracledatabase.v1.ListDbVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListDbVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListEntitlementsRequest;
import com.google.cloud.oracledatabase.v1.ListEntitlementsResponse;
import com.google.cloud.oracledatabase.v1.ListExadbVmClustersRequest;
import com.google.cloud.oracledatabase.v1.ListExadbVmClustersResponse;
import com.google.cloud.oracledatabase.v1.ListExascaleDbStorageVaultsRequest;
import com.google.cloud.oracledatabase.v1.ListExascaleDbStorageVaultsResponse;
import com.google.cloud.oracledatabase.v1.ListGiVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListGiVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListMinorVersionsRequest;
import com.google.cloud.oracledatabase.v1.ListMinorVersionsResponse;
import com.google.cloud.oracledatabase.v1.ListOdbNetworksRequest;
import com.google.cloud.oracledatabase.v1.ListOdbNetworksResponse;
import com.google.cloud.oracledatabase.v1.ListOdbSubnetsRequest;
import com.google.cloud.oracledatabase.v1.ListOdbSubnetsResponse;
import com.google.cloud.oracledatabase.v1.ListPluggableDatabasesRequest;
import com.google.cloud.oracledatabase.v1.ListPluggableDatabasesResponse;
import com.google.cloud.oracledatabase.v1.LocationName;
import com.google.cloud.oracledatabase.v1.MinorVersion;
import com.google.cloud.oracledatabase.v1.OdbNetwork;
import com.google.cloud.oracledatabase.v1.OdbNetworkName;
import com.google.cloud.oracledatabase.v1.OdbSubnet;
import com.google.cloud.oracledatabase.v1.OdbSubnetName;
import com.google.cloud.oracledatabase.v1.OperationMetadata;
import com.google.cloud.oracledatabase.v1.OracleDatabaseSettings;
import com.google.cloud.oracledatabase.v1.PluggableDatabase;
import com.google.cloud.oracledatabase.v1.PluggableDatabaseName;
import com.google.cloud.oracledatabase.v1.RemoveVirtualMachineExadbVmClusterRequest;
import com.google.cloud.oracledatabase.v1.RestartAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.StartAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.StopAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.SwitchoverAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.UpdateAutonomousDatabaseRequest;
import com.google.cloud.oracledatabase.v1.UpdateExadbVmClusterRequest;
import com.google.cloud.oracledatabase.v1.stub.OracleDatabaseStub;
import com.google.cloud.oracledatabase.v1.stub.OracleDatabaseStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OracleDatabaseClient
implements BackgroundResource {
    private final OracleDatabaseSettings settings;
    private final OracleDatabaseStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final OracleDatabaseClient create() throws IOException {
        return OracleDatabaseClient.create(OracleDatabaseSettings.newBuilder().build());
    }

    public static final OracleDatabaseClient create(OracleDatabaseSettings settings) throws IOException {
        return new OracleDatabaseClient(settings);
    }

    public static final OracleDatabaseClient create(OracleDatabaseStub stub) {
        return new OracleDatabaseClient(stub);
    }

    protected OracleDatabaseClient(OracleDatabaseSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OracleDatabaseStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected OracleDatabaseClient(OracleDatabaseStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final OracleDatabaseSettings getSettings() {
        return this.settings;
    }

    public OracleDatabaseStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(LocationName parent) {
        ListCloudExadataInfrastructuresRequest request = ListCloudExadataInfrastructuresRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudExadataInfrastructures(request);
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(String parent) {
        ListCloudExadataInfrastructuresRequest request = ListCloudExadataInfrastructuresRequest.newBuilder().setParent(parent).build();
        return this.listCloudExadataInfrastructures(request);
    }

    public final ListCloudExadataInfrastructuresPagedResponse listCloudExadataInfrastructures(ListCloudExadataInfrastructuresRequest request) {
        return (ListCloudExadataInfrastructuresPagedResponse)((Object)this.listCloudExadataInfrastructuresPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresPagedResponse> listCloudExadataInfrastructuresPagedCallable() {
        return this.stub.listCloudExadataInfrastructuresPagedCallable();
    }

    public final UnaryCallable<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse> listCloudExadataInfrastructuresCallable() {
        return this.stub.listCloudExadataInfrastructuresCallable();
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(CloudExadataInfrastructureName name) {
        GetCloudExadataInfrastructureRequest request = GetCloudExadataInfrastructureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudExadataInfrastructure(request);
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(String name) {
        GetCloudExadataInfrastructureRequest request = GetCloudExadataInfrastructureRequest.newBuilder().setName(name).build();
        return this.getCloudExadataInfrastructure(request);
    }

    public final CloudExadataInfrastructure getCloudExadataInfrastructure(GetCloudExadataInfrastructureRequest request) {
        return (CloudExadataInfrastructure)this.getCloudExadataInfrastructureCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudExadataInfrastructureRequest, CloudExadataInfrastructure> getCloudExadataInfrastructureCallable() {
        return this.stub.getCloudExadataInfrastructureCallable();
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(LocationName parent, CloudExadataInfrastructure cloudExadataInfrastructure, String cloudExadataInfrastructureId) {
        CreateCloudExadataInfrastructureRequest request = CreateCloudExadataInfrastructureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloudExadataInfrastructure(cloudExadataInfrastructure).setCloudExadataInfrastructureId(cloudExadataInfrastructureId).build();
        return this.createCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(String parent, CloudExadataInfrastructure cloudExadataInfrastructure, String cloudExadataInfrastructureId) {
        CreateCloudExadataInfrastructureRequest request = CreateCloudExadataInfrastructureRequest.newBuilder().setParent(parent).setCloudExadataInfrastructure(cloudExadataInfrastructure).setCloudExadataInfrastructureId(cloudExadataInfrastructureId).build();
        return this.createCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureAsync(CreateCloudExadataInfrastructureRequest request) {
        return this.createCloudExadataInfrastructureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCloudExadataInfrastructureRequest, CloudExadataInfrastructure, OperationMetadata> createCloudExadataInfrastructureOperationCallable() {
        return this.stub.createCloudExadataInfrastructureOperationCallable();
    }

    public final UnaryCallable<CreateCloudExadataInfrastructureRequest, Operation> createCloudExadataInfrastructureCallable() {
        return this.stub.createCloudExadataInfrastructureCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(CloudExadataInfrastructureName name) {
        DeleteCloudExadataInfrastructureRequest request = DeleteCloudExadataInfrastructureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(String name) {
        DeleteCloudExadataInfrastructureRequest request = DeleteCloudExadataInfrastructureRequest.newBuilder().setName(name).build();
        return this.deleteCloudExadataInfrastructureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudExadataInfrastructureAsync(DeleteCloudExadataInfrastructureRequest request) {
        return this.deleteCloudExadataInfrastructureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCloudExadataInfrastructureRequest, Empty, OperationMetadata> deleteCloudExadataInfrastructureOperationCallable() {
        return this.stub.deleteCloudExadataInfrastructureOperationCallable();
    }

    public final UnaryCallable<DeleteCloudExadataInfrastructureRequest, Operation> deleteCloudExadataInfrastructureCallable() {
        return this.stub.deleteCloudExadataInfrastructureCallable();
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(LocationName parent) {
        ListCloudVmClustersRequest request = ListCloudVmClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudVmClusters(request);
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(String parent) {
        ListCloudVmClustersRequest request = ListCloudVmClustersRequest.newBuilder().setParent(parent).build();
        return this.listCloudVmClusters(request);
    }

    public final ListCloudVmClustersPagedResponse listCloudVmClusters(ListCloudVmClustersRequest request) {
        return (ListCloudVmClustersPagedResponse)((Object)this.listCloudVmClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudVmClustersRequest, ListCloudVmClustersPagedResponse> listCloudVmClustersPagedCallable() {
        return this.stub.listCloudVmClustersPagedCallable();
    }

    public final UnaryCallable<ListCloudVmClustersRequest, ListCloudVmClustersResponse> listCloudVmClustersCallable() {
        return this.stub.listCloudVmClustersCallable();
    }

    public final CloudVmCluster getCloudVmCluster(CloudVmClusterName name) {
        GetCloudVmClusterRequest request = GetCloudVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudVmCluster(request);
    }

    public final CloudVmCluster getCloudVmCluster(String name) {
        GetCloudVmClusterRequest request = GetCloudVmClusterRequest.newBuilder().setName(name).build();
        return this.getCloudVmCluster(request);
    }

    public final CloudVmCluster getCloudVmCluster(GetCloudVmClusterRequest request) {
        return (CloudVmCluster)this.getCloudVmClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudVmClusterRequest, CloudVmCluster> getCloudVmClusterCallable() {
        return this.stub.getCloudVmClusterCallable();
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(LocationName parent, CloudVmCluster cloudVmCluster, String cloudVmClusterId) {
        CreateCloudVmClusterRequest request = CreateCloudVmClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloudVmCluster(cloudVmCluster).setCloudVmClusterId(cloudVmClusterId).build();
        return this.createCloudVmClusterAsync(request);
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(String parent, CloudVmCluster cloudVmCluster, String cloudVmClusterId) {
        CreateCloudVmClusterRequest request = CreateCloudVmClusterRequest.newBuilder().setParent(parent).setCloudVmCluster(cloudVmCluster).setCloudVmClusterId(cloudVmClusterId).build();
        return this.createCloudVmClusterAsync(request);
    }

    public final OperationFuture<CloudVmCluster, OperationMetadata> createCloudVmClusterAsync(CreateCloudVmClusterRequest request) {
        return this.createCloudVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCloudVmClusterRequest, CloudVmCluster, OperationMetadata> createCloudVmClusterOperationCallable() {
        return this.stub.createCloudVmClusterOperationCallable();
    }

    public final UnaryCallable<CreateCloudVmClusterRequest, Operation> createCloudVmClusterCallable() {
        return this.stub.createCloudVmClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(CloudVmClusterName name) {
        DeleteCloudVmClusterRequest request = DeleteCloudVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCloudVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(String name) {
        DeleteCloudVmClusterRequest request = DeleteCloudVmClusterRequest.newBuilder().setName(name).build();
        return this.deleteCloudVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCloudVmClusterAsync(DeleteCloudVmClusterRequest request) {
        return this.deleteCloudVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCloudVmClusterRequest, Empty, OperationMetadata> deleteCloudVmClusterOperationCallable() {
        return this.stub.deleteCloudVmClusterOperationCallable();
    }

    public final UnaryCallable<DeleteCloudVmClusterRequest, Operation> deleteCloudVmClusterCallable() {
        return this.stub.deleteCloudVmClusterCallable();
    }

    public final ListEntitlementsPagedResponse listEntitlements(LocationName parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(String parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(ListEntitlementsRequest request) {
        return (ListEntitlementsPagedResponse)((Object)this.listEntitlementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsPagedResponse> listEntitlementsPagedCallable() {
        return this.stub.listEntitlementsPagedCallable();
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> listEntitlementsCallable() {
        return this.stub.listEntitlementsCallable();
    }

    public final ListDbServersPagedResponse listDbServers(CloudExadataInfrastructureName parent) {
        ListDbServersRequest request = ListDbServersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbServers(request);
    }

    public final ListDbServersPagedResponse listDbServers(String parent) {
        ListDbServersRequest request = ListDbServersRequest.newBuilder().setParent(parent).build();
        return this.listDbServers(request);
    }

    public final ListDbServersPagedResponse listDbServers(ListDbServersRequest request) {
        return (ListDbServersPagedResponse)((Object)this.listDbServersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbServersRequest, ListDbServersPagedResponse> listDbServersPagedCallable() {
        return this.stub.listDbServersPagedCallable();
    }

    public final UnaryCallable<ListDbServersRequest, ListDbServersResponse> listDbServersCallable() {
        return this.stub.listDbServersCallable();
    }

    public final ListDbNodesPagedResponse listDbNodes(CloudVmClusterName parent) {
        ListDbNodesRequest request = ListDbNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbNodes(request);
    }

    public final ListDbNodesPagedResponse listDbNodes(ExadbVmClusterName parent) {
        ListDbNodesRequest request = ListDbNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbNodes(request);
    }

    public final ListDbNodesPagedResponse listDbNodes(String parent) {
        ListDbNodesRequest request = ListDbNodesRequest.newBuilder().setParent(parent).build();
        return this.listDbNodes(request);
    }

    public final ListDbNodesPagedResponse listDbNodes(ListDbNodesRequest request) {
        return (ListDbNodesPagedResponse)((Object)this.listDbNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbNodesRequest, ListDbNodesPagedResponse> listDbNodesPagedCallable() {
        return this.stub.listDbNodesPagedCallable();
    }

    public final UnaryCallable<ListDbNodesRequest, ListDbNodesResponse> listDbNodesCallable() {
        return this.stub.listDbNodesCallable();
    }

    public final ListGiVersionsPagedResponse listGiVersions(LocationName parent) {
        ListGiVersionsRequest request = ListGiVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGiVersions(request);
    }

    public final ListGiVersionsPagedResponse listGiVersions(String parent) {
        ListGiVersionsRequest request = ListGiVersionsRequest.newBuilder().setParent(parent).build();
        return this.listGiVersions(request);
    }

    public final ListGiVersionsPagedResponse listGiVersions(ListGiVersionsRequest request) {
        return (ListGiVersionsPagedResponse)((Object)this.listGiVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGiVersionsRequest, ListGiVersionsPagedResponse> listGiVersionsPagedCallable() {
        return this.stub.listGiVersionsPagedCallable();
    }

    public final UnaryCallable<ListGiVersionsRequest, ListGiVersionsResponse> listGiVersionsCallable() {
        return this.stub.listGiVersionsCallable();
    }

    public final ListMinorVersionsPagedResponse listMinorVersions(GiVersionName parent) {
        ListMinorVersionsRequest request = ListMinorVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMinorVersions(request);
    }

    public final ListMinorVersionsPagedResponse listMinorVersions(String parent) {
        ListMinorVersionsRequest request = ListMinorVersionsRequest.newBuilder().setParent(parent).build();
        return this.listMinorVersions(request);
    }

    public final ListMinorVersionsPagedResponse listMinorVersions(ListMinorVersionsRequest request) {
        return (ListMinorVersionsPagedResponse)((Object)this.listMinorVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMinorVersionsRequest, ListMinorVersionsPagedResponse> listMinorVersionsPagedCallable() {
        return this.stub.listMinorVersionsPagedCallable();
    }

    public final UnaryCallable<ListMinorVersionsRequest, ListMinorVersionsResponse> listMinorVersionsCallable() {
        return this.stub.listMinorVersionsCallable();
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(LocationName parent) {
        ListDbSystemShapesRequest request = ListDbSystemShapesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbSystemShapes(request);
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(String parent) {
        ListDbSystemShapesRequest request = ListDbSystemShapesRequest.newBuilder().setParent(parent).build();
        return this.listDbSystemShapes(request);
    }

    public final ListDbSystemShapesPagedResponse listDbSystemShapes(ListDbSystemShapesRequest request) {
        return (ListDbSystemShapesPagedResponse)((Object)this.listDbSystemShapesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbSystemShapesRequest, ListDbSystemShapesPagedResponse> listDbSystemShapesPagedCallable() {
        return this.stub.listDbSystemShapesPagedCallable();
    }

    public final UnaryCallable<ListDbSystemShapesRequest, ListDbSystemShapesResponse> listDbSystemShapesCallable() {
        return this.stub.listDbSystemShapesCallable();
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(LocationName parent) {
        ListAutonomousDatabasesRequest request = ListAutonomousDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabases(request);
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(String parent) {
        ListAutonomousDatabasesRequest request = ListAutonomousDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabases(request);
    }

    public final ListAutonomousDatabasesPagedResponse listAutonomousDatabases(ListAutonomousDatabasesRequest request) {
        return (ListAutonomousDatabasesPagedResponse)((Object)this.listAutonomousDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabasesRequest, ListAutonomousDatabasesPagedResponse> listAutonomousDatabasesPagedCallable() {
        return this.stub.listAutonomousDatabasesPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> listAutonomousDatabasesCallable() {
        return this.stub.listAutonomousDatabasesCallable();
    }

    public final AutonomousDatabase getAutonomousDatabase(AutonomousDatabaseName name) {
        GetAutonomousDatabaseRequest request = GetAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAutonomousDatabase(request);
    }

    public final AutonomousDatabase getAutonomousDatabase(String name) {
        GetAutonomousDatabaseRequest request = GetAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.getAutonomousDatabase(request);
    }

    public final AutonomousDatabase getAutonomousDatabase(GetAutonomousDatabaseRequest request) {
        return (AutonomousDatabase)this.getAutonomousDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutonomousDatabaseRequest, AutonomousDatabase> getAutonomousDatabaseCallable() {
        return this.stub.getAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(LocationName parent, AutonomousDatabase autonomousDatabase, String autonomousDatabaseId) {
        CreateAutonomousDatabaseRequest request = CreateAutonomousDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAutonomousDatabase(autonomousDatabase).setAutonomousDatabaseId(autonomousDatabaseId).build();
        return this.createAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(String parent, AutonomousDatabase autonomousDatabase, String autonomousDatabaseId) {
        CreateAutonomousDatabaseRequest request = CreateAutonomousDatabaseRequest.newBuilder().setParent(parent).setAutonomousDatabase(autonomousDatabase).setAutonomousDatabaseId(autonomousDatabaseId).build();
        return this.createAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> createAutonomousDatabaseAsync(CreateAutonomousDatabaseRequest request) {
        return this.createAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> createAutonomousDatabaseOperationCallable() {
        return this.stub.createAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<CreateAutonomousDatabaseRequest, Operation> createAutonomousDatabaseCallable() {
        return this.stub.createAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> updateAutonomousDatabaseAsync(AutonomousDatabase autonomousDatabase, FieldMask updateMask) {
        UpdateAutonomousDatabaseRequest request = UpdateAutonomousDatabaseRequest.newBuilder().setAutonomousDatabase(autonomousDatabase).setUpdateMask(updateMask).build();
        return this.updateAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> updateAutonomousDatabaseAsync(UpdateAutonomousDatabaseRequest request) {
        return this.updateAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> updateAutonomousDatabaseOperationCallable() {
        return this.stub.updateAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<UpdateAutonomousDatabaseRequest, Operation> updateAutonomousDatabaseCallable() {
        return this.stub.updateAutonomousDatabaseCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        DeleteAutonomousDatabaseRequest request = DeleteAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(String name) {
        DeleteAutonomousDatabaseRequest request = DeleteAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.deleteAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutonomousDatabaseAsync(DeleteAutonomousDatabaseRequest request) {
        return this.deleteAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAutonomousDatabaseRequest, Empty, OperationMetadata> deleteAutonomousDatabaseOperationCallable() {
        return this.stub.deleteAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<DeleteAutonomousDatabaseRequest, Operation> deleteAutonomousDatabaseCallable() {
        return this.stub.deleteAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(AutonomousDatabaseName name, Timestamp restoreTime) {
        RestoreAutonomousDatabaseRequest request = RestoreAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setRestoreTime(restoreTime).build();
        return this.restoreAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(String name, Timestamp restoreTime) {
        RestoreAutonomousDatabaseRequest request = RestoreAutonomousDatabaseRequest.newBuilder().setName(name).setRestoreTime(restoreTime).build();
        return this.restoreAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseAsync(RestoreAutonomousDatabaseRequest request) {
        return this.restoreAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restoreAutonomousDatabaseOperationCallable() {
        return this.stub.restoreAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<RestoreAutonomousDatabaseRequest, Operation> restoreAutonomousDatabaseCallable() {
        return this.stub.restoreAutonomousDatabaseCallable();
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(AutonomousDatabaseName name, GenerateType type, boolean isRegional, String password) {
        GenerateAutonomousDatabaseWalletRequest request = GenerateAutonomousDatabaseWalletRequest.newBuilder().setName(name == null ? null : name.toString()).setType(type).setIsRegional(isRegional).setPassword(password).build();
        return this.generateAutonomousDatabaseWallet(request);
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(String name, GenerateType type, boolean isRegional, String password) {
        GenerateAutonomousDatabaseWalletRequest request = GenerateAutonomousDatabaseWalletRequest.newBuilder().setName(name).setType(type).setIsRegional(isRegional).setPassword(password).build();
        return this.generateAutonomousDatabaseWallet(request);
    }

    public final GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest request) {
        return (GenerateAutonomousDatabaseWalletResponse)this.generateAutonomousDatabaseWalletCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWalletCallable() {
        return this.stub.generateAutonomousDatabaseWalletCallable();
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(LocationName parent) {
        ListAutonomousDbVersionsRequest request = ListAutonomousDbVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDbVersions(request);
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(String parent) {
        ListAutonomousDbVersionsRequest request = ListAutonomousDbVersionsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDbVersions(request);
    }

    public final ListAutonomousDbVersionsPagedResponse listAutonomousDbVersions(ListAutonomousDbVersionsRequest request) {
        return (ListAutonomousDbVersionsPagedResponse)((Object)this.listAutonomousDbVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsPagedResponse> listAutonomousDbVersionsPagedCallable() {
        return this.stub.listAutonomousDbVersionsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse> listAutonomousDbVersionsCallable() {
        return this.stub.listAutonomousDbVersionsCallable();
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(LocationName parent) {
        ListAutonomousDatabaseCharacterSetsRequest request = ListAutonomousDatabaseCharacterSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabaseCharacterSets(request);
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(String parent) {
        ListAutonomousDatabaseCharacterSetsRequest request = ListAutonomousDatabaseCharacterSetsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabaseCharacterSets(request);
    }

    public final ListAutonomousDatabaseCharacterSetsPagedResponse listAutonomousDatabaseCharacterSets(ListAutonomousDatabaseCharacterSetsRequest request) {
        return (ListAutonomousDatabaseCharacterSetsPagedResponse)((Object)this.listAutonomousDatabaseCharacterSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsPagedResponse> listAutonomousDatabaseCharacterSetsPagedCallable() {
        return this.stub.listAutonomousDatabaseCharacterSetsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse> listAutonomousDatabaseCharacterSetsCallable() {
        return this.stub.listAutonomousDatabaseCharacterSetsCallable();
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(LocationName parent) {
        ListAutonomousDatabaseBackupsRequest request = ListAutonomousDatabaseBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutonomousDatabaseBackups(request);
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(String parent) {
        ListAutonomousDatabaseBackupsRequest request = ListAutonomousDatabaseBackupsRequest.newBuilder().setParent(parent).build();
        return this.listAutonomousDatabaseBackups(request);
    }

    public final ListAutonomousDatabaseBackupsPagedResponse listAutonomousDatabaseBackups(ListAutonomousDatabaseBackupsRequest request) {
        return (ListAutonomousDatabaseBackupsPagedResponse)((Object)this.listAutonomousDatabaseBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsPagedResponse> listAutonomousDatabaseBackupsPagedCallable() {
        return this.stub.listAutonomousDatabaseBackupsPagedCallable();
    }

    public final UnaryCallable<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> listAutonomousDatabaseBackupsCallable() {
        return this.stub.listAutonomousDatabaseBackupsCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        StopAutonomousDatabaseRequest request = StopAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(String name) {
        StopAutonomousDatabaseRequest request = StopAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.stopAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseAsync(StopAutonomousDatabaseRequest request) {
        return this.stopAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> stopAutonomousDatabaseOperationCallable() {
        return this.stub.stopAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<StopAutonomousDatabaseRequest, Operation> stopAutonomousDatabaseCallable() {
        return this.stub.stopAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        StartAutonomousDatabaseRequest request = StartAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(String name) {
        StartAutonomousDatabaseRequest request = StartAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.startAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> startAutonomousDatabaseAsync(StartAutonomousDatabaseRequest request) {
        return this.startAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> startAutonomousDatabaseOperationCallable() {
        return this.stub.startAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<StartAutonomousDatabaseRequest, Operation> startAutonomousDatabaseCallable() {
        return this.stub.startAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(AutonomousDatabaseName name) {
        RestartAutonomousDatabaseRequest request = RestartAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.restartAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(String name) {
        RestartAutonomousDatabaseRequest request = RestartAutonomousDatabaseRequest.newBuilder().setName(name).build();
        return this.restartAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseAsync(RestartAutonomousDatabaseRequest request) {
        return this.restartAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> restartAutonomousDatabaseOperationCallable() {
        return this.stub.restartAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<RestartAutonomousDatabaseRequest, Operation> restartAutonomousDatabaseCallable() {
        return this.stub.restartAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseAsync(AutonomousDatabaseName name, AutonomousDatabaseName peerAutonomousDatabase) {
        SwitchoverAutonomousDatabaseRequest request = SwitchoverAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setPeerAutonomousDatabase(peerAutonomousDatabase == null ? null : peerAutonomousDatabase.toString()).build();
        return this.switchoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseAsync(AutonomousDatabaseName name, String peerAutonomousDatabase) {
        SwitchoverAutonomousDatabaseRequest request = SwitchoverAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setPeerAutonomousDatabase(peerAutonomousDatabase).build();
        return this.switchoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseAsync(String name, AutonomousDatabaseName peerAutonomousDatabase) {
        SwitchoverAutonomousDatabaseRequest request = SwitchoverAutonomousDatabaseRequest.newBuilder().setName(name).setPeerAutonomousDatabase(peerAutonomousDatabase == null ? null : peerAutonomousDatabase.toString()).build();
        return this.switchoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseAsync(String name, String peerAutonomousDatabase) {
        SwitchoverAutonomousDatabaseRequest request = SwitchoverAutonomousDatabaseRequest.newBuilder().setName(name).setPeerAutonomousDatabase(peerAutonomousDatabase).build();
        return this.switchoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseAsync(SwitchoverAutonomousDatabaseRequest request) {
        return this.switchoverAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SwitchoverAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> switchoverAutonomousDatabaseOperationCallable() {
        return this.stub.switchoverAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<SwitchoverAutonomousDatabaseRequest, Operation> switchoverAutonomousDatabaseCallable() {
        return this.stub.switchoverAutonomousDatabaseCallable();
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseAsync(AutonomousDatabaseName name, AutonomousDatabaseName peerAutonomousDatabase) {
        FailoverAutonomousDatabaseRequest request = FailoverAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setPeerAutonomousDatabase(peerAutonomousDatabase == null ? null : peerAutonomousDatabase.toString()).build();
        return this.failoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseAsync(AutonomousDatabaseName name, String peerAutonomousDatabase) {
        FailoverAutonomousDatabaseRequest request = FailoverAutonomousDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).setPeerAutonomousDatabase(peerAutonomousDatabase).build();
        return this.failoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseAsync(String name, AutonomousDatabaseName peerAutonomousDatabase) {
        FailoverAutonomousDatabaseRequest request = FailoverAutonomousDatabaseRequest.newBuilder().setName(name).setPeerAutonomousDatabase(peerAutonomousDatabase == null ? null : peerAutonomousDatabase.toString()).build();
        return this.failoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseAsync(String name, String peerAutonomousDatabase) {
        FailoverAutonomousDatabaseRequest request = FailoverAutonomousDatabaseRequest.newBuilder().setName(name).setPeerAutonomousDatabase(peerAutonomousDatabase).build();
        return this.failoverAutonomousDatabaseAsync(request);
    }

    public final OperationFuture<AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseAsync(FailoverAutonomousDatabaseRequest request) {
        return this.failoverAutonomousDatabaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<FailoverAutonomousDatabaseRequest, AutonomousDatabase, OperationMetadata> failoverAutonomousDatabaseOperationCallable() {
        return this.stub.failoverAutonomousDatabaseOperationCallable();
    }

    public final UnaryCallable<FailoverAutonomousDatabaseRequest, Operation> failoverAutonomousDatabaseCallable() {
        return this.stub.failoverAutonomousDatabaseCallable();
    }

    public final ListOdbNetworksPagedResponse listOdbNetworks(LocationName parent) {
        ListOdbNetworksRequest request = ListOdbNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOdbNetworks(request);
    }

    public final ListOdbNetworksPagedResponse listOdbNetworks(String parent) {
        ListOdbNetworksRequest request = ListOdbNetworksRequest.newBuilder().setParent(parent).build();
        return this.listOdbNetworks(request);
    }

    public final ListOdbNetworksPagedResponse listOdbNetworks(ListOdbNetworksRequest request) {
        return (ListOdbNetworksPagedResponse)((Object)this.listOdbNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOdbNetworksRequest, ListOdbNetworksPagedResponse> listOdbNetworksPagedCallable() {
        return this.stub.listOdbNetworksPagedCallable();
    }

    public final UnaryCallable<ListOdbNetworksRequest, ListOdbNetworksResponse> listOdbNetworksCallable() {
        return this.stub.listOdbNetworksCallable();
    }

    public final OdbNetwork getOdbNetwork(OdbNetworkName name) {
        GetOdbNetworkRequest request = GetOdbNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOdbNetwork(request);
    }

    public final OdbNetwork getOdbNetwork(String name) {
        GetOdbNetworkRequest request = GetOdbNetworkRequest.newBuilder().setName(name).build();
        return this.getOdbNetwork(request);
    }

    public final OdbNetwork getOdbNetwork(GetOdbNetworkRequest request) {
        return (OdbNetwork)this.getOdbNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetOdbNetworkRequest, OdbNetwork> getOdbNetworkCallable() {
        return this.stub.getOdbNetworkCallable();
    }

    public final OperationFuture<OdbNetwork, OperationMetadata> createOdbNetworkAsync(LocationName parent, OdbNetwork odbNetwork, String odbNetworkId) {
        CreateOdbNetworkRequest request = CreateOdbNetworkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOdbNetwork(odbNetwork).setOdbNetworkId(odbNetworkId).build();
        return this.createOdbNetworkAsync(request);
    }

    public final OperationFuture<OdbNetwork, OperationMetadata> createOdbNetworkAsync(String parent, OdbNetwork odbNetwork, String odbNetworkId) {
        CreateOdbNetworkRequest request = CreateOdbNetworkRequest.newBuilder().setParent(parent).setOdbNetwork(odbNetwork).setOdbNetworkId(odbNetworkId).build();
        return this.createOdbNetworkAsync(request);
    }

    public final OperationFuture<OdbNetwork, OperationMetadata> createOdbNetworkAsync(CreateOdbNetworkRequest request) {
        return this.createOdbNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateOdbNetworkRequest, OdbNetwork, OperationMetadata> createOdbNetworkOperationCallable() {
        return this.stub.createOdbNetworkOperationCallable();
    }

    public final UnaryCallable<CreateOdbNetworkRequest, Operation> createOdbNetworkCallable() {
        return this.stub.createOdbNetworkCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbNetworkAsync(OdbNetworkName name) {
        DeleteOdbNetworkRequest request = DeleteOdbNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteOdbNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbNetworkAsync(String name) {
        DeleteOdbNetworkRequest request = DeleteOdbNetworkRequest.newBuilder().setName(name).build();
        return this.deleteOdbNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbNetworkAsync(DeleteOdbNetworkRequest request) {
        return this.deleteOdbNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOdbNetworkRequest, Empty, OperationMetadata> deleteOdbNetworkOperationCallable() {
        return this.stub.deleteOdbNetworkOperationCallable();
    }

    public final UnaryCallable<DeleteOdbNetworkRequest, Operation> deleteOdbNetworkCallable() {
        return this.stub.deleteOdbNetworkCallable();
    }

    public final ListOdbSubnetsPagedResponse listOdbSubnets(OdbNetworkName parent) {
        ListOdbSubnetsRequest request = ListOdbSubnetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOdbSubnets(request);
    }

    public final ListOdbSubnetsPagedResponse listOdbSubnets(String parent) {
        ListOdbSubnetsRequest request = ListOdbSubnetsRequest.newBuilder().setParent(parent).build();
        return this.listOdbSubnets(request);
    }

    public final ListOdbSubnetsPagedResponse listOdbSubnets(ListOdbSubnetsRequest request) {
        return (ListOdbSubnetsPagedResponse)((Object)this.listOdbSubnetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOdbSubnetsRequest, ListOdbSubnetsPagedResponse> listOdbSubnetsPagedCallable() {
        return this.stub.listOdbSubnetsPagedCallable();
    }

    public final UnaryCallable<ListOdbSubnetsRequest, ListOdbSubnetsResponse> listOdbSubnetsCallable() {
        return this.stub.listOdbSubnetsCallable();
    }

    public final OdbSubnet getOdbSubnet(OdbSubnetName name) {
        GetOdbSubnetRequest request = GetOdbSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOdbSubnet(request);
    }

    public final OdbSubnet getOdbSubnet(String name) {
        GetOdbSubnetRequest request = GetOdbSubnetRequest.newBuilder().setName(name).build();
        return this.getOdbSubnet(request);
    }

    public final OdbSubnet getOdbSubnet(GetOdbSubnetRequest request) {
        return (OdbSubnet)this.getOdbSubnetCallable().call((Object)request);
    }

    public final UnaryCallable<GetOdbSubnetRequest, OdbSubnet> getOdbSubnetCallable() {
        return this.stub.getOdbSubnetCallable();
    }

    public final OperationFuture<OdbSubnet, OperationMetadata> createOdbSubnetAsync(OdbNetworkName parent, OdbSubnet odbSubnet, String odbSubnetId) {
        CreateOdbSubnetRequest request = CreateOdbSubnetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOdbSubnet(odbSubnet).setOdbSubnetId(odbSubnetId).build();
        return this.createOdbSubnetAsync(request);
    }

    public final OperationFuture<OdbSubnet, OperationMetadata> createOdbSubnetAsync(String parent, OdbSubnet odbSubnet, String odbSubnetId) {
        CreateOdbSubnetRequest request = CreateOdbSubnetRequest.newBuilder().setParent(parent).setOdbSubnet(odbSubnet).setOdbSubnetId(odbSubnetId).build();
        return this.createOdbSubnetAsync(request);
    }

    public final OperationFuture<OdbSubnet, OperationMetadata> createOdbSubnetAsync(CreateOdbSubnetRequest request) {
        return this.createOdbSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateOdbSubnetRequest, OdbSubnet, OperationMetadata> createOdbSubnetOperationCallable() {
        return this.stub.createOdbSubnetOperationCallable();
    }

    public final UnaryCallable<CreateOdbSubnetRequest, Operation> createOdbSubnetCallable() {
        return this.stub.createOdbSubnetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbSubnetAsync(OdbSubnetName name) {
        DeleteOdbSubnetRequest request = DeleteOdbSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteOdbSubnetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbSubnetAsync(String name) {
        DeleteOdbSubnetRequest request = DeleteOdbSubnetRequest.newBuilder().setName(name).build();
        return this.deleteOdbSubnetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOdbSubnetAsync(DeleteOdbSubnetRequest request) {
        return this.deleteOdbSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOdbSubnetRequest, Empty, OperationMetadata> deleteOdbSubnetOperationCallable() {
        return this.stub.deleteOdbSubnetOperationCallable();
    }

    public final UnaryCallable<DeleteOdbSubnetRequest, Operation> deleteOdbSubnetCallable() {
        return this.stub.deleteOdbSubnetCallable();
    }

    public final ListExadbVmClustersPagedResponse listExadbVmClusters(LocationName parent) {
        ListExadbVmClustersRequest request = ListExadbVmClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExadbVmClusters(request);
    }

    public final ListExadbVmClustersPagedResponse listExadbVmClusters(String parent) {
        ListExadbVmClustersRequest request = ListExadbVmClustersRequest.newBuilder().setParent(parent).build();
        return this.listExadbVmClusters(request);
    }

    public final ListExadbVmClustersPagedResponse listExadbVmClusters(ListExadbVmClustersRequest request) {
        return (ListExadbVmClustersPagedResponse)((Object)this.listExadbVmClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExadbVmClustersRequest, ListExadbVmClustersPagedResponse> listExadbVmClustersPagedCallable() {
        return this.stub.listExadbVmClustersPagedCallable();
    }

    public final UnaryCallable<ListExadbVmClustersRequest, ListExadbVmClustersResponse> listExadbVmClustersCallable() {
        return this.stub.listExadbVmClustersCallable();
    }

    public final ExadbVmCluster getExadbVmCluster(ExadbVmClusterName name) {
        GetExadbVmClusterRequest request = GetExadbVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExadbVmCluster(request);
    }

    public final ExadbVmCluster getExadbVmCluster(String name) {
        GetExadbVmClusterRequest request = GetExadbVmClusterRequest.newBuilder().setName(name).build();
        return this.getExadbVmCluster(request);
    }

    public final ExadbVmCluster getExadbVmCluster(GetExadbVmClusterRequest request) {
        return (ExadbVmCluster)this.getExadbVmClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetExadbVmClusterRequest, ExadbVmCluster> getExadbVmClusterCallable() {
        return this.stub.getExadbVmClusterCallable();
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> createExadbVmClusterAsync(LocationName parent, ExadbVmCluster exadbVmCluster, String exadbVmClusterId) {
        CreateExadbVmClusterRequest request = CreateExadbVmClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExadbVmCluster(exadbVmCluster).setExadbVmClusterId(exadbVmClusterId).build();
        return this.createExadbVmClusterAsync(request);
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> createExadbVmClusterAsync(String parent, ExadbVmCluster exadbVmCluster, String exadbVmClusterId) {
        CreateExadbVmClusterRequest request = CreateExadbVmClusterRequest.newBuilder().setParent(parent).setExadbVmCluster(exadbVmCluster).setExadbVmClusterId(exadbVmClusterId).build();
        return this.createExadbVmClusterAsync(request);
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> createExadbVmClusterAsync(CreateExadbVmClusterRequest request) {
        return this.createExadbVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExadbVmClusterRequest, ExadbVmCluster, OperationMetadata> createExadbVmClusterOperationCallable() {
        return this.stub.createExadbVmClusterOperationCallable();
    }

    public final UnaryCallable<CreateExadbVmClusterRequest, Operation> createExadbVmClusterCallable() {
        return this.stub.createExadbVmClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExadbVmClusterAsync(ExadbVmClusterName name) {
        DeleteExadbVmClusterRequest request = DeleteExadbVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExadbVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExadbVmClusterAsync(String name) {
        DeleteExadbVmClusterRequest request = DeleteExadbVmClusterRequest.newBuilder().setName(name).build();
        return this.deleteExadbVmClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExadbVmClusterAsync(DeleteExadbVmClusterRequest request) {
        return this.deleteExadbVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExadbVmClusterRequest, Empty, OperationMetadata> deleteExadbVmClusterOperationCallable() {
        return this.stub.deleteExadbVmClusterOperationCallable();
    }

    public final UnaryCallable<DeleteExadbVmClusterRequest, Operation> deleteExadbVmClusterCallable() {
        return this.stub.deleteExadbVmClusterCallable();
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> updateExadbVmClusterAsync(ExadbVmCluster exadbVmCluster, FieldMask updateMask) {
        UpdateExadbVmClusterRequest request = UpdateExadbVmClusterRequest.newBuilder().setExadbVmCluster(exadbVmCluster).setUpdateMask(updateMask).build();
        return this.updateExadbVmClusterAsync(request);
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> updateExadbVmClusterAsync(UpdateExadbVmClusterRequest request) {
        return this.updateExadbVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateExadbVmClusterRequest, ExadbVmCluster, OperationMetadata> updateExadbVmClusterOperationCallable() {
        return this.stub.updateExadbVmClusterOperationCallable();
    }

    public final UnaryCallable<UpdateExadbVmClusterRequest, Operation> updateExadbVmClusterCallable() {
        return this.stub.updateExadbVmClusterCallable();
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> removeVirtualMachineExadbVmClusterAsync(ExadbVmClusterName name, List<String> hostnames) {
        RemoveVirtualMachineExadbVmClusterRequest request = RemoveVirtualMachineExadbVmClusterRequest.newBuilder().setName(name == null ? null : name.toString()).addAllHostnames(hostnames).build();
        return this.removeVirtualMachineExadbVmClusterAsync(request);
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> removeVirtualMachineExadbVmClusterAsync(String name, List<String> hostnames) {
        RemoveVirtualMachineExadbVmClusterRequest request = RemoveVirtualMachineExadbVmClusterRequest.newBuilder().setName(name).addAllHostnames(hostnames).build();
        return this.removeVirtualMachineExadbVmClusterAsync(request);
    }

    public final OperationFuture<ExadbVmCluster, OperationMetadata> removeVirtualMachineExadbVmClusterAsync(RemoveVirtualMachineExadbVmClusterRequest request) {
        return this.removeVirtualMachineExadbVmClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveVirtualMachineExadbVmClusterRequest, ExadbVmCluster, OperationMetadata> removeVirtualMachineExadbVmClusterOperationCallable() {
        return this.stub.removeVirtualMachineExadbVmClusterOperationCallable();
    }

    public final UnaryCallable<RemoveVirtualMachineExadbVmClusterRequest, Operation> removeVirtualMachineExadbVmClusterCallable() {
        return this.stub.removeVirtualMachineExadbVmClusterCallable();
    }

    public final ListExascaleDbStorageVaultsPagedResponse listExascaleDbStorageVaults(LocationName parent) {
        ListExascaleDbStorageVaultsRequest request = ListExascaleDbStorageVaultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExascaleDbStorageVaults(request);
    }

    public final ListExascaleDbStorageVaultsPagedResponse listExascaleDbStorageVaults(String parent) {
        ListExascaleDbStorageVaultsRequest request = ListExascaleDbStorageVaultsRequest.newBuilder().setParent(parent).build();
        return this.listExascaleDbStorageVaults(request);
    }

    public final ListExascaleDbStorageVaultsPagedResponse listExascaleDbStorageVaults(ListExascaleDbStorageVaultsRequest request) {
        return (ListExascaleDbStorageVaultsPagedResponse)((Object)this.listExascaleDbStorageVaultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsPagedResponse> listExascaleDbStorageVaultsPagedCallable() {
        return this.stub.listExascaleDbStorageVaultsPagedCallable();
    }

    public final UnaryCallable<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse> listExascaleDbStorageVaultsCallable() {
        return this.stub.listExascaleDbStorageVaultsCallable();
    }

    public final ExascaleDbStorageVault getExascaleDbStorageVault(ExascaleDbStorageVaultName name) {
        GetExascaleDbStorageVaultRequest request = GetExascaleDbStorageVaultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExascaleDbStorageVault(request);
    }

    public final ExascaleDbStorageVault getExascaleDbStorageVault(String name) {
        GetExascaleDbStorageVaultRequest request = GetExascaleDbStorageVaultRequest.newBuilder().setName(name).build();
        return this.getExascaleDbStorageVault(request);
    }

    public final ExascaleDbStorageVault getExascaleDbStorageVault(GetExascaleDbStorageVaultRequest request) {
        return (ExascaleDbStorageVault)this.getExascaleDbStorageVaultCallable().call((Object)request);
    }

    public final UnaryCallable<GetExascaleDbStorageVaultRequest, ExascaleDbStorageVault> getExascaleDbStorageVaultCallable() {
        return this.stub.getExascaleDbStorageVaultCallable();
    }

    public final OperationFuture<ExascaleDbStorageVault, OperationMetadata> createExascaleDbStorageVaultAsync(LocationName parent, ExascaleDbStorageVault exascaleDbStorageVault, String exascaleDbStorageVaultId) {
        CreateExascaleDbStorageVaultRequest request = CreateExascaleDbStorageVaultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExascaleDbStorageVault(exascaleDbStorageVault).setExascaleDbStorageVaultId(exascaleDbStorageVaultId).build();
        return this.createExascaleDbStorageVaultAsync(request);
    }

    public final OperationFuture<ExascaleDbStorageVault, OperationMetadata> createExascaleDbStorageVaultAsync(String parent, ExascaleDbStorageVault exascaleDbStorageVault, String exascaleDbStorageVaultId) {
        CreateExascaleDbStorageVaultRequest request = CreateExascaleDbStorageVaultRequest.newBuilder().setParent(parent).setExascaleDbStorageVault(exascaleDbStorageVault).setExascaleDbStorageVaultId(exascaleDbStorageVaultId).build();
        return this.createExascaleDbStorageVaultAsync(request);
    }

    public final OperationFuture<ExascaleDbStorageVault, OperationMetadata> createExascaleDbStorageVaultAsync(CreateExascaleDbStorageVaultRequest request) {
        return this.createExascaleDbStorageVaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExascaleDbStorageVaultRequest, ExascaleDbStorageVault, OperationMetadata> createExascaleDbStorageVaultOperationCallable() {
        return this.stub.createExascaleDbStorageVaultOperationCallable();
    }

    public final UnaryCallable<CreateExascaleDbStorageVaultRequest, Operation> createExascaleDbStorageVaultCallable() {
        return this.stub.createExascaleDbStorageVaultCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExascaleDbStorageVaultAsync(ExascaleDbStorageVaultName name) {
        DeleteExascaleDbStorageVaultRequest request = DeleteExascaleDbStorageVaultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExascaleDbStorageVaultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExascaleDbStorageVaultAsync(String name) {
        DeleteExascaleDbStorageVaultRequest request = DeleteExascaleDbStorageVaultRequest.newBuilder().setName(name).build();
        return this.deleteExascaleDbStorageVaultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExascaleDbStorageVaultAsync(DeleteExascaleDbStorageVaultRequest request) {
        return this.deleteExascaleDbStorageVaultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExascaleDbStorageVaultRequest, Empty, OperationMetadata> deleteExascaleDbStorageVaultOperationCallable() {
        return this.stub.deleteExascaleDbStorageVaultOperationCallable();
    }

    public final UnaryCallable<DeleteExascaleDbStorageVaultRequest, Operation> deleteExascaleDbStorageVaultCallable() {
        return this.stub.deleteExascaleDbStorageVaultCallable();
    }

    public final ListDbSystemInitialStorageSizesPagedResponse listDbSystemInitialStorageSizes(LocationName parent) {
        ListDbSystemInitialStorageSizesRequest request = ListDbSystemInitialStorageSizesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbSystemInitialStorageSizes(request);
    }

    public final ListDbSystemInitialStorageSizesPagedResponse listDbSystemInitialStorageSizes(String parent) {
        ListDbSystemInitialStorageSizesRequest request = ListDbSystemInitialStorageSizesRequest.newBuilder().setParent(parent).build();
        return this.listDbSystemInitialStorageSizes(request);
    }

    public final ListDbSystemInitialStorageSizesPagedResponse listDbSystemInitialStorageSizes(ListDbSystemInitialStorageSizesRequest request) {
        return (ListDbSystemInitialStorageSizesPagedResponse)((Object)this.listDbSystemInitialStorageSizesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesPagedResponse> listDbSystemInitialStorageSizesPagedCallable() {
        return this.stub.listDbSystemInitialStorageSizesPagedCallable();
    }

    public final UnaryCallable<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse> listDbSystemInitialStorageSizesCallable() {
        return this.stub.listDbSystemInitialStorageSizesCallable();
    }

    public final ListDatabasesPagedResponse listDatabases(LocationName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesPagedResponse)((Object)this.listDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesPagedResponse> listDatabasesPagedCallable() {
        return this.stub.listDatabasesPagedCallable();
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final Database getDatabase(DatabaseName name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(String name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(GetDatabaseRequest request) {
        return (Database)this.getDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.stub.getDatabaseCallable();
    }

    public final ListPluggableDatabasesPagedResponse listPluggableDatabases(LocationName parent) {
        ListPluggableDatabasesRequest request = ListPluggableDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPluggableDatabases(request);
    }

    public final ListPluggableDatabasesPagedResponse listPluggableDatabases(String parent) {
        ListPluggableDatabasesRequest request = ListPluggableDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listPluggableDatabases(request);
    }

    public final ListPluggableDatabasesPagedResponse listPluggableDatabases(ListPluggableDatabasesRequest request) {
        return (ListPluggableDatabasesPagedResponse)((Object)this.listPluggableDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPluggableDatabasesRequest, ListPluggableDatabasesPagedResponse> listPluggableDatabasesPagedCallable() {
        return this.stub.listPluggableDatabasesPagedCallable();
    }

    public final UnaryCallable<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse> listPluggableDatabasesCallable() {
        return this.stub.listPluggableDatabasesCallable();
    }

    public final PluggableDatabase getPluggableDatabase(PluggableDatabaseName name) {
        GetPluggableDatabaseRequest request = GetPluggableDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPluggableDatabase(request);
    }

    public final PluggableDatabase getPluggableDatabase(String name) {
        GetPluggableDatabaseRequest request = GetPluggableDatabaseRequest.newBuilder().setName(name).build();
        return this.getPluggableDatabase(request);
    }

    public final PluggableDatabase getPluggableDatabase(GetPluggableDatabaseRequest request) {
        return (PluggableDatabase)this.getPluggableDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetPluggableDatabaseRequest, PluggableDatabase> getPluggableDatabaseCallable() {
        return this.stub.getPluggableDatabaseCallable();
    }

    public final ListDbSystemsPagedResponse listDbSystems(LocationName parent) {
        ListDbSystemsRequest request = ListDbSystemsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbSystems(request);
    }

    public final ListDbSystemsPagedResponse listDbSystems(String parent) {
        ListDbSystemsRequest request = ListDbSystemsRequest.newBuilder().setParent(parent).build();
        return this.listDbSystems(request);
    }

    public final ListDbSystemsPagedResponse listDbSystems(ListDbSystemsRequest request) {
        return (ListDbSystemsPagedResponse)((Object)this.listDbSystemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbSystemsRequest, ListDbSystemsPagedResponse> listDbSystemsPagedCallable() {
        return this.stub.listDbSystemsPagedCallable();
    }

    public final UnaryCallable<ListDbSystemsRequest, ListDbSystemsResponse> listDbSystemsCallable() {
        return this.stub.listDbSystemsCallable();
    }

    public final DbSystem getDbSystem(DbSystemName name) {
        GetDbSystemRequest request = GetDbSystemRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDbSystem(request);
    }

    public final DbSystem getDbSystem(String name) {
        GetDbSystemRequest request = GetDbSystemRequest.newBuilder().setName(name).build();
        return this.getDbSystem(request);
    }

    public final DbSystem getDbSystem(GetDbSystemRequest request) {
        return (DbSystem)this.getDbSystemCallable().call((Object)request);
    }

    public final UnaryCallable<GetDbSystemRequest, DbSystem> getDbSystemCallable() {
        return this.stub.getDbSystemCallable();
    }

    public final OperationFuture<DbSystem, OperationMetadata> createDbSystemAsync(LocationName parent, DbSystem dbSystem, String dbSystemId) {
        CreateDbSystemRequest request = CreateDbSystemRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDbSystem(dbSystem).setDbSystemId(dbSystemId).build();
        return this.createDbSystemAsync(request);
    }

    public final OperationFuture<DbSystem, OperationMetadata> createDbSystemAsync(String parent, DbSystem dbSystem, String dbSystemId) {
        CreateDbSystemRequest request = CreateDbSystemRequest.newBuilder().setParent(parent).setDbSystem(dbSystem).setDbSystemId(dbSystemId).build();
        return this.createDbSystemAsync(request);
    }

    public final OperationFuture<DbSystem, OperationMetadata> createDbSystemAsync(CreateDbSystemRequest request) {
        return this.createDbSystemOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDbSystemRequest, DbSystem, OperationMetadata> createDbSystemOperationCallable() {
        return this.stub.createDbSystemOperationCallable();
    }

    public final UnaryCallable<CreateDbSystemRequest, Operation> createDbSystemCallable() {
        return this.stub.createDbSystemCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDbSystemAsync(DbSystemName name) {
        DeleteDbSystemRequest request = DeleteDbSystemRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDbSystemAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDbSystemAsync(String name) {
        DeleteDbSystemRequest request = DeleteDbSystemRequest.newBuilder().setName(name).build();
        return this.deleteDbSystemAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDbSystemAsync(DeleteDbSystemRequest request) {
        return this.deleteDbSystemOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDbSystemRequest, Empty, OperationMetadata> deleteDbSystemOperationCallable() {
        return this.stub.deleteDbSystemOperationCallable();
    }

    public final UnaryCallable<DeleteDbSystemRequest, Operation> deleteDbSystemCallable() {
        return this.stub.deleteDbSystemCallable();
    }

    public final ListDbVersionsPagedResponse listDbVersions(LocationName parent) {
        ListDbVersionsRequest request = ListDbVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDbVersions(request);
    }

    public final ListDbVersionsPagedResponse listDbVersions(String parent) {
        ListDbVersionsRequest request = ListDbVersionsRequest.newBuilder().setParent(parent).build();
        return this.listDbVersions(request);
    }

    public final ListDbVersionsPagedResponse listDbVersions(ListDbVersionsRequest request) {
        return (ListDbVersionsPagedResponse)((Object)this.listDbVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDbVersionsRequest, ListDbVersionsPagedResponse> listDbVersionsPagedCallable() {
        return this.stub.listDbVersionsPagedCallable();
    }

    public final UnaryCallable<ListDbVersionsRequest, ListDbVersionsResponse> listDbVersionsCallable() {
        return this.stub.listDbVersionsCallable();
    }

    public final ListDatabaseCharacterSetsPagedResponse listDatabaseCharacterSets(LocationName parent) {
        ListDatabaseCharacterSetsRequest request = ListDatabaseCharacterSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabaseCharacterSets(request);
    }

    public final ListDatabaseCharacterSetsPagedResponse listDatabaseCharacterSets(String parent) {
        ListDatabaseCharacterSetsRequest request = ListDatabaseCharacterSetsRequest.newBuilder().setParent(parent).build();
        return this.listDatabaseCharacterSets(request);
    }

    public final ListDatabaseCharacterSetsPagedResponse listDatabaseCharacterSets(ListDatabaseCharacterSetsRequest request) {
        return (ListDatabaseCharacterSetsPagedResponse)((Object)this.listDatabaseCharacterSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsPagedResponse> listDatabaseCharacterSetsPagedCallable() {
        return this.stub.listDatabaseCharacterSetsPagedCallable();
    }

    public final UnaryCallable<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse> listDatabaseCharacterSetsCallable() {
        return this.stub.listDatabaseCharacterSetsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabaseCharacterSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet, ListDatabaseCharacterSetsPage, ListDatabaseCharacterSetsFixedSizeCollection> {
        private ListDatabaseCharacterSetsFixedSizeCollection(List<ListDatabaseCharacterSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabaseCharacterSetsFixedSizeCollection createEmptyCollection() {
            return new ListDatabaseCharacterSetsFixedSizeCollection(null, 0);
        }

        protected ListDatabaseCharacterSetsFixedSizeCollection createCollection(List<ListDatabaseCharacterSetsPage> pages, int collectionSize) {
            return new ListDatabaseCharacterSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabaseCharacterSetsPage
    extends AbstractPage<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet, ListDatabaseCharacterSetsPage> {
        private ListDatabaseCharacterSetsPage(PageContext<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet> context, ListDatabaseCharacterSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabaseCharacterSetsPage createEmptyPage() {
            return new ListDatabaseCharacterSetsPage(null, null);
        }

        protected ListDatabaseCharacterSetsPage createPage(PageContext<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet> context, ListDatabaseCharacterSetsResponse response) {
            return new ListDatabaseCharacterSetsPage(context, response);
        }

        public ApiFuture<ListDatabaseCharacterSetsPage> createPageAsync(PageContext<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet> context, ApiFuture<ListDatabaseCharacterSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabaseCharacterSetsPagedResponse
    extends AbstractPagedListResponse<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet, ListDatabaseCharacterSetsPage, ListDatabaseCharacterSetsFixedSizeCollection> {
        public static ApiFuture<ListDatabaseCharacterSetsPagedResponse> createAsync(PageContext<ListDatabaseCharacterSetsRequest, ListDatabaseCharacterSetsResponse, DatabaseCharacterSet> context, ApiFuture<ListDatabaseCharacterSetsResponse> futureResponse) {
            ApiFuture<ListDatabaseCharacterSetsPage> futurePage = ListDatabaseCharacterSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabaseCharacterSetsPagedResponse((ListDatabaseCharacterSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabaseCharacterSetsPagedResponse(ListDatabaseCharacterSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabaseCharacterSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion, ListDbVersionsPage, ListDbVersionsFixedSizeCollection> {
        private ListDbVersionsFixedSizeCollection(List<ListDbVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbVersionsFixedSizeCollection createEmptyCollection() {
            return new ListDbVersionsFixedSizeCollection(null, 0);
        }

        protected ListDbVersionsFixedSizeCollection createCollection(List<ListDbVersionsPage> pages, int collectionSize) {
            return new ListDbVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbVersionsPage
    extends AbstractPage<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion, ListDbVersionsPage> {
        private ListDbVersionsPage(PageContext<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion> context, ListDbVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListDbVersionsPage createEmptyPage() {
            return new ListDbVersionsPage(null, null);
        }

        protected ListDbVersionsPage createPage(PageContext<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion> context, ListDbVersionsResponse response) {
            return new ListDbVersionsPage(context, response);
        }

        public ApiFuture<ListDbVersionsPage> createPageAsync(PageContext<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion> context, ApiFuture<ListDbVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbVersionsPagedResponse
    extends AbstractPagedListResponse<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion, ListDbVersionsPage, ListDbVersionsFixedSizeCollection> {
        public static ApiFuture<ListDbVersionsPagedResponse> createAsync(PageContext<ListDbVersionsRequest, ListDbVersionsResponse, DbVersion> context, ApiFuture<ListDbVersionsResponse> futureResponse) {
            ApiFuture<ListDbVersionsPage> futurePage = ListDbVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbVersionsPagedResponse((ListDbVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbVersionsPagedResponse(ListDbVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbSystemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem, ListDbSystemsPage, ListDbSystemsFixedSizeCollection> {
        private ListDbSystemsFixedSizeCollection(List<ListDbSystemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbSystemsFixedSizeCollection createEmptyCollection() {
            return new ListDbSystemsFixedSizeCollection(null, 0);
        }

        protected ListDbSystemsFixedSizeCollection createCollection(List<ListDbSystemsPage> pages, int collectionSize) {
            return new ListDbSystemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbSystemsPage
    extends AbstractPage<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem, ListDbSystemsPage> {
        private ListDbSystemsPage(PageContext<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem> context, ListDbSystemsResponse response) {
            super(context, (Object)response);
        }

        private static ListDbSystemsPage createEmptyPage() {
            return new ListDbSystemsPage(null, null);
        }

        protected ListDbSystemsPage createPage(PageContext<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem> context, ListDbSystemsResponse response) {
            return new ListDbSystemsPage(context, response);
        }

        public ApiFuture<ListDbSystemsPage> createPageAsync(PageContext<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem> context, ApiFuture<ListDbSystemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbSystemsPagedResponse
    extends AbstractPagedListResponse<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem, ListDbSystemsPage, ListDbSystemsFixedSizeCollection> {
        public static ApiFuture<ListDbSystemsPagedResponse> createAsync(PageContext<ListDbSystemsRequest, ListDbSystemsResponse, DbSystem> context, ApiFuture<ListDbSystemsResponse> futureResponse) {
            ApiFuture<ListDbSystemsPage> futurePage = ListDbSystemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbSystemsPagedResponse((ListDbSystemsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbSystemsPagedResponse(ListDbSystemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbSystemsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPluggableDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase, ListPluggableDatabasesPage, ListPluggableDatabasesFixedSizeCollection> {
        private ListPluggableDatabasesFixedSizeCollection(List<ListPluggableDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPluggableDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListPluggableDatabasesFixedSizeCollection(null, 0);
        }

        protected ListPluggableDatabasesFixedSizeCollection createCollection(List<ListPluggableDatabasesPage> pages, int collectionSize) {
            return new ListPluggableDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPluggableDatabasesPage
    extends AbstractPage<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase, ListPluggableDatabasesPage> {
        private ListPluggableDatabasesPage(PageContext<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase> context, ListPluggableDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListPluggableDatabasesPage createEmptyPage() {
            return new ListPluggableDatabasesPage(null, null);
        }

        protected ListPluggableDatabasesPage createPage(PageContext<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase> context, ListPluggableDatabasesResponse response) {
            return new ListPluggableDatabasesPage(context, response);
        }

        public ApiFuture<ListPluggableDatabasesPage> createPageAsync(PageContext<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase> context, ApiFuture<ListPluggableDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPluggableDatabasesPagedResponse
    extends AbstractPagedListResponse<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase, ListPluggableDatabasesPage, ListPluggableDatabasesFixedSizeCollection> {
        public static ApiFuture<ListPluggableDatabasesPagedResponse> createAsync(PageContext<ListPluggableDatabasesRequest, ListPluggableDatabasesResponse, PluggableDatabase> context, ApiFuture<ListPluggableDatabasesResponse> futureResponse) {
            ApiFuture<ListPluggableDatabasesPage> futurePage = ListPluggableDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPluggableDatabasesPagedResponse((ListPluggableDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPluggableDatabasesPagedResponse(ListPluggableDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPluggableDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        private ListDatabasesFixedSizeCollection(List<ListDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListDatabasesFixedSizeCollection(null, 0);
        }

        protected ListDatabasesFixedSizeCollection createCollection(List<ListDatabasesPage> pages, int collectionSize) {
            return new ListDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabasesPage
    extends AbstractPage<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage> {
        private ListDatabasesPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabasesPage createEmptyPage() {
            return new ListDatabasesPage(null, null);
        }

        protected ListDatabasesPage createPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            return new ListDatabasesPage(context, response);
        }

        public ApiFuture<ListDatabasesPage> createPageAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabasesPagedResponse
    extends AbstractPagedListResponse<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        public static ApiFuture<ListDatabasesPagedResponse> createAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            ApiFuture<ListDatabasesPage> futurePage = ListDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatabasesPagedResponse((ListDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabasesPagedResponse(ListDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbSystemInitialStorageSizesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize, ListDbSystemInitialStorageSizesPage, ListDbSystemInitialStorageSizesFixedSizeCollection> {
        private ListDbSystemInitialStorageSizesFixedSizeCollection(List<ListDbSystemInitialStorageSizesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbSystemInitialStorageSizesFixedSizeCollection createEmptyCollection() {
            return new ListDbSystemInitialStorageSizesFixedSizeCollection(null, 0);
        }

        protected ListDbSystemInitialStorageSizesFixedSizeCollection createCollection(List<ListDbSystemInitialStorageSizesPage> pages, int collectionSize) {
            return new ListDbSystemInitialStorageSizesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbSystemInitialStorageSizesPage
    extends AbstractPage<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize, ListDbSystemInitialStorageSizesPage> {
        private ListDbSystemInitialStorageSizesPage(PageContext<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize> context, ListDbSystemInitialStorageSizesResponse response) {
            super(context, (Object)response);
        }

        private static ListDbSystemInitialStorageSizesPage createEmptyPage() {
            return new ListDbSystemInitialStorageSizesPage(null, null);
        }

        protected ListDbSystemInitialStorageSizesPage createPage(PageContext<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize> context, ListDbSystemInitialStorageSizesResponse response) {
            return new ListDbSystemInitialStorageSizesPage(context, response);
        }

        public ApiFuture<ListDbSystemInitialStorageSizesPage> createPageAsync(PageContext<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize> context, ApiFuture<ListDbSystemInitialStorageSizesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbSystemInitialStorageSizesPagedResponse
    extends AbstractPagedListResponse<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize, ListDbSystemInitialStorageSizesPage, ListDbSystemInitialStorageSizesFixedSizeCollection> {
        public static ApiFuture<ListDbSystemInitialStorageSizesPagedResponse> createAsync(PageContext<ListDbSystemInitialStorageSizesRequest, ListDbSystemInitialStorageSizesResponse, DbSystemInitialStorageSize> context, ApiFuture<ListDbSystemInitialStorageSizesResponse> futureResponse) {
            ApiFuture<ListDbSystemInitialStorageSizesPage> futurePage = ListDbSystemInitialStorageSizesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbSystemInitialStorageSizesPagedResponse((ListDbSystemInitialStorageSizesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbSystemInitialStorageSizesPagedResponse(ListDbSystemInitialStorageSizesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbSystemInitialStorageSizesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExascaleDbStorageVaultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault, ListExascaleDbStorageVaultsPage, ListExascaleDbStorageVaultsFixedSizeCollection> {
        private ListExascaleDbStorageVaultsFixedSizeCollection(List<ListExascaleDbStorageVaultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExascaleDbStorageVaultsFixedSizeCollection createEmptyCollection() {
            return new ListExascaleDbStorageVaultsFixedSizeCollection(null, 0);
        }

        protected ListExascaleDbStorageVaultsFixedSizeCollection createCollection(List<ListExascaleDbStorageVaultsPage> pages, int collectionSize) {
            return new ListExascaleDbStorageVaultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExascaleDbStorageVaultsPage
    extends AbstractPage<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault, ListExascaleDbStorageVaultsPage> {
        private ListExascaleDbStorageVaultsPage(PageContext<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault> context, ListExascaleDbStorageVaultsResponse response) {
            super(context, (Object)response);
        }

        private static ListExascaleDbStorageVaultsPage createEmptyPage() {
            return new ListExascaleDbStorageVaultsPage(null, null);
        }

        protected ListExascaleDbStorageVaultsPage createPage(PageContext<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault> context, ListExascaleDbStorageVaultsResponse response) {
            return new ListExascaleDbStorageVaultsPage(context, response);
        }

        public ApiFuture<ListExascaleDbStorageVaultsPage> createPageAsync(PageContext<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault> context, ApiFuture<ListExascaleDbStorageVaultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExascaleDbStorageVaultsPagedResponse
    extends AbstractPagedListResponse<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault, ListExascaleDbStorageVaultsPage, ListExascaleDbStorageVaultsFixedSizeCollection> {
        public static ApiFuture<ListExascaleDbStorageVaultsPagedResponse> createAsync(PageContext<ListExascaleDbStorageVaultsRequest, ListExascaleDbStorageVaultsResponse, ExascaleDbStorageVault> context, ApiFuture<ListExascaleDbStorageVaultsResponse> futureResponse) {
            ApiFuture<ListExascaleDbStorageVaultsPage> futurePage = ListExascaleDbStorageVaultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExascaleDbStorageVaultsPagedResponse((ListExascaleDbStorageVaultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExascaleDbStorageVaultsPagedResponse(ListExascaleDbStorageVaultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExascaleDbStorageVaultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExadbVmClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster, ListExadbVmClustersPage, ListExadbVmClustersFixedSizeCollection> {
        private ListExadbVmClustersFixedSizeCollection(List<ListExadbVmClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExadbVmClustersFixedSizeCollection createEmptyCollection() {
            return new ListExadbVmClustersFixedSizeCollection(null, 0);
        }

        protected ListExadbVmClustersFixedSizeCollection createCollection(List<ListExadbVmClustersPage> pages, int collectionSize) {
            return new ListExadbVmClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExadbVmClustersPage
    extends AbstractPage<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster, ListExadbVmClustersPage> {
        private ListExadbVmClustersPage(PageContext<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster> context, ListExadbVmClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListExadbVmClustersPage createEmptyPage() {
            return new ListExadbVmClustersPage(null, null);
        }

        protected ListExadbVmClustersPage createPage(PageContext<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster> context, ListExadbVmClustersResponse response) {
            return new ListExadbVmClustersPage(context, response);
        }

        public ApiFuture<ListExadbVmClustersPage> createPageAsync(PageContext<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster> context, ApiFuture<ListExadbVmClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExadbVmClustersPagedResponse
    extends AbstractPagedListResponse<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster, ListExadbVmClustersPage, ListExadbVmClustersFixedSizeCollection> {
        public static ApiFuture<ListExadbVmClustersPagedResponse> createAsync(PageContext<ListExadbVmClustersRequest, ListExadbVmClustersResponse, ExadbVmCluster> context, ApiFuture<ListExadbVmClustersResponse> futureResponse) {
            ApiFuture<ListExadbVmClustersPage> futurePage = ListExadbVmClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExadbVmClustersPagedResponse((ListExadbVmClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExadbVmClustersPagedResponse(ListExadbVmClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExadbVmClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOdbSubnetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet, ListOdbSubnetsPage, ListOdbSubnetsFixedSizeCollection> {
        private ListOdbSubnetsFixedSizeCollection(List<ListOdbSubnetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOdbSubnetsFixedSizeCollection createEmptyCollection() {
            return new ListOdbSubnetsFixedSizeCollection(null, 0);
        }

        protected ListOdbSubnetsFixedSizeCollection createCollection(List<ListOdbSubnetsPage> pages, int collectionSize) {
            return new ListOdbSubnetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOdbSubnetsPage
    extends AbstractPage<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet, ListOdbSubnetsPage> {
        private ListOdbSubnetsPage(PageContext<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet> context, ListOdbSubnetsResponse response) {
            super(context, (Object)response);
        }

        private static ListOdbSubnetsPage createEmptyPage() {
            return new ListOdbSubnetsPage(null, null);
        }

        protected ListOdbSubnetsPage createPage(PageContext<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet> context, ListOdbSubnetsResponse response) {
            return new ListOdbSubnetsPage(context, response);
        }

        public ApiFuture<ListOdbSubnetsPage> createPageAsync(PageContext<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet> context, ApiFuture<ListOdbSubnetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOdbSubnetsPagedResponse
    extends AbstractPagedListResponse<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet, ListOdbSubnetsPage, ListOdbSubnetsFixedSizeCollection> {
        public static ApiFuture<ListOdbSubnetsPagedResponse> createAsync(PageContext<ListOdbSubnetsRequest, ListOdbSubnetsResponse, OdbSubnet> context, ApiFuture<ListOdbSubnetsResponse> futureResponse) {
            ApiFuture<ListOdbSubnetsPage> futurePage = ListOdbSubnetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOdbSubnetsPagedResponse((ListOdbSubnetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOdbSubnetsPagedResponse(ListOdbSubnetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOdbSubnetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOdbNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork, ListOdbNetworksPage, ListOdbNetworksFixedSizeCollection> {
        private ListOdbNetworksFixedSizeCollection(List<ListOdbNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOdbNetworksFixedSizeCollection createEmptyCollection() {
            return new ListOdbNetworksFixedSizeCollection(null, 0);
        }

        protected ListOdbNetworksFixedSizeCollection createCollection(List<ListOdbNetworksPage> pages, int collectionSize) {
            return new ListOdbNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOdbNetworksPage
    extends AbstractPage<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork, ListOdbNetworksPage> {
        private ListOdbNetworksPage(PageContext<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork> context, ListOdbNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListOdbNetworksPage createEmptyPage() {
            return new ListOdbNetworksPage(null, null);
        }

        protected ListOdbNetworksPage createPage(PageContext<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork> context, ListOdbNetworksResponse response) {
            return new ListOdbNetworksPage(context, response);
        }

        public ApiFuture<ListOdbNetworksPage> createPageAsync(PageContext<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork> context, ApiFuture<ListOdbNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOdbNetworksPagedResponse
    extends AbstractPagedListResponse<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork, ListOdbNetworksPage, ListOdbNetworksFixedSizeCollection> {
        public static ApiFuture<ListOdbNetworksPagedResponse> createAsync(PageContext<ListOdbNetworksRequest, ListOdbNetworksResponse, OdbNetwork> context, ApiFuture<ListOdbNetworksResponse> futureResponse) {
            ApiFuture<ListOdbNetworksPage> futurePage = ListOdbNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOdbNetworksPagedResponse((ListOdbNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOdbNetworksPagedResponse(ListOdbNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOdbNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabaseBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage, ListAutonomousDatabaseBackupsFixedSizeCollection> {
        private ListAutonomousDatabaseBackupsFixedSizeCollection(List<ListAutonomousDatabaseBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabaseBackupsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabaseBackupsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabaseBackupsFixedSizeCollection createCollection(List<ListAutonomousDatabaseBackupsPage> pages, int collectionSize) {
            return new ListAutonomousDatabaseBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabaseBackupsPage
    extends AbstractPage<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage> {
        private ListAutonomousDatabaseBackupsPage(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ListAutonomousDatabaseBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabaseBackupsPage createEmptyPage() {
            return new ListAutonomousDatabaseBackupsPage(null, null);
        }

        protected ListAutonomousDatabaseBackupsPage createPage(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ListAutonomousDatabaseBackupsResponse response) {
            return new ListAutonomousDatabaseBackupsPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabaseBackupsPage> createPageAsync(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ApiFuture<ListAutonomousDatabaseBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabaseBackupsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup, ListAutonomousDatabaseBackupsPage, ListAutonomousDatabaseBackupsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabaseBackupsPagedResponse> createAsync(PageContext<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackup> context, ApiFuture<ListAutonomousDatabaseBackupsResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabaseBackupsPage> futurePage = ListAutonomousDatabaseBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabaseBackupsPagedResponse((ListAutonomousDatabaseBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabaseBackupsPagedResponse(ListAutonomousDatabaseBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabaseBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage, ListAutonomousDatabaseCharacterSetsFixedSizeCollection> {
        private ListAutonomousDatabaseCharacterSetsFixedSizeCollection(List<ListAutonomousDatabaseCharacterSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabaseCharacterSetsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabaseCharacterSetsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabaseCharacterSetsFixedSizeCollection createCollection(List<ListAutonomousDatabaseCharacterSetsPage> pages, int collectionSize) {
            return new ListAutonomousDatabaseCharacterSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsPage
    extends AbstractPage<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage> {
        private ListAutonomousDatabaseCharacterSetsPage(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ListAutonomousDatabaseCharacterSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabaseCharacterSetsPage createEmptyPage() {
            return new ListAutonomousDatabaseCharacterSetsPage(null, null);
        }

        protected ListAutonomousDatabaseCharacterSetsPage createPage(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ListAutonomousDatabaseCharacterSetsResponse response) {
            return new ListAutonomousDatabaseCharacterSetsPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabaseCharacterSetsPage> createPageAsync(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ApiFuture<ListAutonomousDatabaseCharacterSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabaseCharacterSetsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet, ListAutonomousDatabaseCharacterSetsPage, ListAutonomousDatabaseCharacterSetsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabaseCharacterSetsPagedResponse> createAsync(PageContext<ListAutonomousDatabaseCharacterSetsRequest, ListAutonomousDatabaseCharacterSetsResponse, AutonomousDatabaseCharacterSet> context, ApiFuture<ListAutonomousDatabaseCharacterSetsResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabaseCharacterSetsPage> futurePage = ListAutonomousDatabaseCharacterSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabaseCharacterSetsPagedResponse((ListAutonomousDatabaseCharacterSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabaseCharacterSetsPagedResponse(ListAutonomousDatabaseCharacterSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabaseCharacterSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDbVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage, ListAutonomousDbVersionsFixedSizeCollection> {
        private ListAutonomousDbVersionsFixedSizeCollection(List<ListAutonomousDbVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDbVersionsFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDbVersionsFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDbVersionsFixedSizeCollection createCollection(List<ListAutonomousDbVersionsPage> pages, int collectionSize) {
            return new ListAutonomousDbVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDbVersionsPage
    extends AbstractPage<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage> {
        private ListAutonomousDbVersionsPage(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ListAutonomousDbVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDbVersionsPage createEmptyPage() {
            return new ListAutonomousDbVersionsPage(null, null);
        }

        protected ListAutonomousDbVersionsPage createPage(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ListAutonomousDbVersionsResponse response) {
            return new ListAutonomousDbVersionsPage(context, response);
        }

        public ApiFuture<ListAutonomousDbVersionsPage> createPageAsync(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ApiFuture<ListAutonomousDbVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDbVersionsPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion, ListAutonomousDbVersionsPage, ListAutonomousDbVersionsFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDbVersionsPagedResponse> createAsync(PageContext<ListAutonomousDbVersionsRequest, ListAutonomousDbVersionsResponse, AutonomousDbVersion> context, ApiFuture<ListAutonomousDbVersionsResponse> futureResponse) {
            ApiFuture<ListAutonomousDbVersionsPage> futurePage = ListAutonomousDbVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDbVersionsPagedResponse((ListAutonomousDbVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDbVersionsPagedResponse(ListAutonomousDbVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDbVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutonomousDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage, ListAutonomousDatabasesFixedSizeCollection> {
        private ListAutonomousDatabasesFixedSizeCollection(List<ListAutonomousDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutonomousDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListAutonomousDatabasesFixedSizeCollection(null, 0);
        }

        protected ListAutonomousDatabasesFixedSizeCollection createCollection(List<ListAutonomousDatabasesPage> pages, int collectionSize) {
            return new ListAutonomousDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutonomousDatabasesPage
    extends AbstractPage<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage> {
        private ListAutonomousDatabasesPage(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ListAutonomousDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListAutonomousDatabasesPage createEmptyPage() {
            return new ListAutonomousDatabasesPage(null, null);
        }

        protected ListAutonomousDatabasesPage createPage(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ListAutonomousDatabasesResponse response) {
            return new ListAutonomousDatabasesPage(context, response);
        }

        public ApiFuture<ListAutonomousDatabasesPage> createPageAsync(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ApiFuture<ListAutonomousDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutonomousDatabasesPagedResponse
    extends AbstractPagedListResponse<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase, ListAutonomousDatabasesPage, ListAutonomousDatabasesFixedSizeCollection> {
        public static ApiFuture<ListAutonomousDatabasesPagedResponse> createAsync(PageContext<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabase> context, ApiFuture<ListAutonomousDatabasesResponse> futureResponse) {
            ApiFuture<ListAutonomousDatabasesPage> futurePage = ListAutonomousDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutonomousDatabasesPagedResponse((ListAutonomousDatabasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutonomousDatabasesPagedResponse(ListAutonomousDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutonomousDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbSystemShapesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage, ListDbSystemShapesFixedSizeCollection> {
        private ListDbSystemShapesFixedSizeCollection(List<ListDbSystemShapesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbSystemShapesFixedSizeCollection createEmptyCollection() {
            return new ListDbSystemShapesFixedSizeCollection(null, 0);
        }

        protected ListDbSystemShapesFixedSizeCollection createCollection(List<ListDbSystemShapesPage> pages, int collectionSize) {
            return new ListDbSystemShapesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbSystemShapesPage
    extends AbstractPage<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage> {
        private ListDbSystemShapesPage(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ListDbSystemShapesResponse response) {
            super(context, (Object)response);
        }

        private static ListDbSystemShapesPage createEmptyPage() {
            return new ListDbSystemShapesPage(null, null);
        }

        protected ListDbSystemShapesPage createPage(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ListDbSystemShapesResponse response) {
            return new ListDbSystemShapesPage(context, response);
        }

        public ApiFuture<ListDbSystemShapesPage> createPageAsync(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ApiFuture<ListDbSystemShapesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbSystemShapesPagedResponse
    extends AbstractPagedListResponse<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape, ListDbSystemShapesPage, ListDbSystemShapesFixedSizeCollection> {
        public static ApiFuture<ListDbSystemShapesPagedResponse> createAsync(PageContext<ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShape> context, ApiFuture<ListDbSystemShapesResponse> futureResponse) {
            ApiFuture<ListDbSystemShapesPage> futurePage = ListDbSystemShapesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbSystemShapesPagedResponse((ListDbSystemShapesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbSystemShapesPagedResponse(ListDbSystemShapesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbSystemShapesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMinorVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion, ListMinorVersionsPage, ListMinorVersionsFixedSizeCollection> {
        private ListMinorVersionsFixedSizeCollection(List<ListMinorVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMinorVersionsFixedSizeCollection createEmptyCollection() {
            return new ListMinorVersionsFixedSizeCollection(null, 0);
        }

        protected ListMinorVersionsFixedSizeCollection createCollection(List<ListMinorVersionsPage> pages, int collectionSize) {
            return new ListMinorVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMinorVersionsPage
    extends AbstractPage<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion, ListMinorVersionsPage> {
        private ListMinorVersionsPage(PageContext<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion> context, ListMinorVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListMinorVersionsPage createEmptyPage() {
            return new ListMinorVersionsPage(null, null);
        }

        protected ListMinorVersionsPage createPage(PageContext<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion> context, ListMinorVersionsResponse response) {
            return new ListMinorVersionsPage(context, response);
        }

        public ApiFuture<ListMinorVersionsPage> createPageAsync(PageContext<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion> context, ApiFuture<ListMinorVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMinorVersionsPagedResponse
    extends AbstractPagedListResponse<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion, ListMinorVersionsPage, ListMinorVersionsFixedSizeCollection> {
        public static ApiFuture<ListMinorVersionsPagedResponse> createAsync(PageContext<ListMinorVersionsRequest, ListMinorVersionsResponse, MinorVersion> context, ApiFuture<ListMinorVersionsResponse> futureResponse) {
            ApiFuture<ListMinorVersionsPage> futurePage = ListMinorVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMinorVersionsPagedResponse((ListMinorVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMinorVersionsPagedResponse(ListMinorVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMinorVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGiVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage, ListGiVersionsFixedSizeCollection> {
        private ListGiVersionsFixedSizeCollection(List<ListGiVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGiVersionsFixedSizeCollection createEmptyCollection() {
            return new ListGiVersionsFixedSizeCollection(null, 0);
        }

        protected ListGiVersionsFixedSizeCollection createCollection(List<ListGiVersionsPage> pages, int collectionSize) {
            return new ListGiVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGiVersionsPage
    extends AbstractPage<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage> {
        private ListGiVersionsPage(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ListGiVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListGiVersionsPage createEmptyPage() {
            return new ListGiVersionsPage(null, null);
        }

        protected ListGiVersionsPage createPage(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ListGiVersionsResponse response) {
            return new ListGiVersionsPage(context, response);
        }

        public ApiFuture<ListGiVersionsPage> createPageAsync(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ApiFuture<ListGiVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGiVersionsPagedResponse
    extends AbstractPagedListResponse<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion, ListGiVersionsPage, ListGiVersionsFixedSizeCollection> {
        public static ApiFuture<ListGiVersionsPagedResponse> createAsync(PageContext<ListGiVersionsRequest, ListGiVersionsResponse, GiVersion> context, ApiFuture<ListGiVersionsResponse> futureResponse) {
            ApiFuture<ListGiVersionsPage> futurePage = ListGiVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGiVersionsPagedResponse((ListGiVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGiVersionsPagedResponse(ListGiVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGiVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage, ListDbNodesFixedSizeCollection> {
        private ListDbNodesFixedSizeCollection(List<ListDbNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbNodesFixedSizeCollection createEmptyCollection() {
            return new ListDbNodesFixedSizeCollection(null, 0);
        }

        protected ListDbNodesFixedSizeCollection createCollection(List<ListDbNodesPage> pages, int collectionSize) {
            return new ListDbNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbNodesPage
    extends AbstractPage<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage> {
        private ListDbNodesPage(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ListDbNodesResponse response) {
            super(context, (Object)response);
        }

        private static ListDbNodesPage createEmptyPage() {
            return new ListDbNodesPage(null, null);
        }

        protected ListDbNodesPage createPage(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ListDbNodesResponse response) {
            return new ListDbNodesPage(context, response);
        }

        public ApiFuture<ListDbNodesPage> createPageAsync(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ApiFuture<ListDbNodesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbNodesPagedResponse
    extends AbstractPagedListResponse<ListDbNodesRequest, ListDbNodesResponse, DbNode, ListDbNodesPage, ListDbNodesFixedSizeCollection> {
        public static ApiFuture<ListDbNodesPagedResponse> createAsync(PageContext<ListDbNodesRequest, ListDbNodesResponse, DbNode> context, ApiFuture<ListDbNodesResponse> futureResponse) {
            ApiFuture<ListDbNodesPage> futurePage = ListDbNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbNodesPagedResponse((ListDbNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbNodesPagedResponse(ListDbNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbNodesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDbServersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage, ListDbServersFixedSizeCollection> {
        private ListDbServersFixedSizeCollection(List<ListDbServersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDbServersFixedSizeCollection createEmptyCollection() {
            return new ListDbServersFixedSizeCollection(null, 0);
        }

        protected ListDbServersFixedSizeCollection createCollection(List<ListDbServersPage> pages, int collectionSize) {
            return new ListDbServersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDbServersPage
    extends AbstractPage<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage> {
        private ListDbServersPage(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ListDbServersResponse response) {
            super(context, (Object)response);
        }

        private static ListDbServersPage createEmptyPage() {
            return new ListDbServersPage(null, null);
        }

        protected ListDbServersPage createPage(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ListDbServersResponse response) {
            return new ListDbServersPage(context, response);
        }

        public ApiFuture<ListDbServersPage> createPageAsync(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ApiFuture<ListDbServersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDbServersPagedResponse
    extends AbstractPagedListResponse<ListDbServersRequest, ListDbServersResponse, DbServer, ListDbServersPage, ListDbServersFixedSizeCollection> {
        public static ApiFuture<ListDbServersPagedResponse> createAsync(PageContext<ListDbServersRequest, ListDbServersResponse, DbServer> context, ApiFuture<ListDbServersResponse> futureResponse) {
            ApiFuture<ListDbServersPage> futurePage = ListDbServersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDbServersPagedResponse((ListDbServersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDbServersPagedResponse(ListDbServersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDbServersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntitlementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        private ListEntitlementsFixedSizeCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitlementsFixedSizeCollection createEmptyCollection() {
            return new ListEntitlementsFixedSizeCollection(null, 0);
        }

        protected ListEntitlementsFixedSizeCollection createCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            return new ListEntitlementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitlementsPage
    extends AbstractPage<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage> {
        private ListEntitlementsPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitlementsPage createEmptyPage() {
            return new ListEntitlementsPage(null, null);
        }

        protected ListEntitlementsPage createPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            return new ListEntitlementsPage(context, response);
        }

        public ApiFuture<ListEntitlementsPage> createPageAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitlementsPagedResponse
    extends AbstractPagedListResponse<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        public static ApiFuture<ListEntitlementsPagedResponse> createAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            ApiFuture<ListEntitlementsPage> futurePage = ListEntitlementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitlementsPagedResponse((ListEntitlementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitlementsPagedResponse(ListEntitlementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitlementsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudVmClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage, ListCloudVmClustersFixedSizeCollection> {
        private ListCloudVmClustersFixedSizeCollection(List<ListCloudVmClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudVmClustersFixedSizeCollection createEmptyCollection() {
            return new ListCloudVmClustersFixedSizeCollection(null, 0);
        }

        protected ListCloudVmClustersFixedSizeCollection createCollection(List<ListCloudVmClustersPage> pages, int collectionSize) {
            return new ListCloudVmClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudVmClustersPage
    extends AbstractPage<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage> {
        private ListCloudVmClustersPage(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ListCloudVmClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudVmClustersPage createEmptyPage() {
            return new ListCloudVmClustersPage(null, null);
        }

        protected ListCloudVmClustersPage createPage(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ListCloudVmClustersResponse response) {
            return new ListCloudVmClustersPage(context, response);
        }

        public ApiFuture<ListCloudVmClustersPage> createPageAsync(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ApiFuture<ListCloudVmClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudVmClustersPagedResponse
    extends AbstractPagedListResponse<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster, ListCloudVmClustersPage, ListCloudVmClustersFixedSizeCollection> {
        public static ApiFuture<ListCloudVmClustersPagedResponse> createAsync(PageContext<ListCloudVmClustersRequest, ListCloudVmClustersResponse, CloudVmCluster> context, ApiFuture<ListCloudVmClustersResponse> futureResponse) {
            ApiFuture<ListCloudVmClustersPage> futurePage = ListCloudVmClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudVmClustersPagedResponse((ListCloudVmClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudVmClustersPagedResponse(ListCloudVmClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudVmClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudExadataInfrastructuresFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage, ListCloudExadataInfrastructuresFixedSizeCollection> {
        private ListCloudExadataInfrastructuresFixedSizeCollection(List<ListCloudExadataInfrastructuresPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudExadataInfrastructuresFixedSizeCollection createEmptyCollection() {
            return new ListCloudExadataInfrastructuresFixedSizeCollection(null, 0);
        }

        protected ListCloudExadataInfrastructuresFixedSizeCollection createCollection(List<ListCloudExadataInfrastructuresPage> pages, int collectionSize) {
            return new ListCloudExadataInfrastructuresFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudExadataInfrastructuresPage
    extends AbstractPage<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage> {
        private ListCloudExadataInfrastructuresPage(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ListCloudExadataInfrastructuresResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudExadataInfrastructuresPage createEmptyPage() {
            return new ListCloudExadataInfrastructuresPage(null, null);
        }

        protected ListCloudExadataInfrastructuresPage createPage(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ListCloudExadataInfrastructuresResponse response) {
            return new ListCloudExadataInfrastructuresPage(context, response);
        }

        public ApiFuture<ListCloudExadataInfrastructuresPage> createPageAsync(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ApiFuture<ListCloudExadataInfrastructuresResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudExadataInfrastructuresPagedResponse
    extends AbstractPagedListResponse<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure, ListCloudExadataInfrastructuresPage, ListCloudExadataInfrastructuresFixedSizeCollection> {
        public static ApiFuture<ListCloudExadataInfrastructuresPagedResponse> createAsync(PageContext<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse, CloudExadataInfrastructure> context, ApiFuture<ListCloudExadataInfrastructuresResponse> futureResponse) {
            ApiFuture<ListCloudExadataInfrastructuresPage> futurePage = ListCloudExadataInfrastructuresPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudExadataInfrastructuresPagedResponse((ListCloudExadataInfrastructuresPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudExadataInfrastructuresPagedResponse(ListCloudExadataInfrastructuresPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudExadataInfrastructuresFixedSizeCollection.createEmptyCollection());
        }
    }
}

