/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.notebooks.v1.CreateRuntimeRequest;
import com.google.cloud.notebooks.v1.DeleteRuntimeRequest;
import com.google.cloud.notebooks.v1.GetRuntimeRequest;
import com.google.cloud.notebooks.v1.ListRuntimesRequest;
import com.google.cloud.notebooks.v1.ListRuntimesResponse;
import com.google.cloud.notebooks.v1.ManagedNotebookServiceClient;
import com.google.cloud.notebooks.v1.OperationMetadata;
import com.google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest;
import com.google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse;
import com.google.cloud.notebooks.v1.ReportRuntimeEventRequest;
import com.google.cloud.notebooks.v1.ResetRuntimeRequest;
import com.google.cloud.notebooks.v1.Runtime;
import com.google.cloud.notebooks.v1.StartRuntimeRequest;
import com.google.cloud.notebooks.v1.StopRuntimeRequest;
import com.google.cloud.notebooks.v1.SwitchRuntimeRequest;
import com.google.cloud.notebooks.v1.stub.GrpcManagedNotebookServiceStub;
import com.google.cloud.notebooks.v1.stub.ManagedNotebookServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ManagedNotebookServiceStubSettings
extends StubSettings<ManagedNotebookServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesSettings;
    private final UnaryCallSettings<GetRuntimeRequest, Runtime> getRuntimeSettings;
    private final UnaryCallSettings<CreateRuntimeRequest, Operation> createRuntimeSettings;
    private final OperationCallSettings<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationSettings;
    private final UnaryCallSettings<DeleteRuntimeRequest, Operation> deleteRuntimeSettings;
    private final OperationCallSettings<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationSettings;
    private final UnaryCallSettings<StartRuntimeRequest, Operation> startRuntimeSettings;
    private final OperationCallSettings<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationSettings;
    private final UnaryCallSettings<StopRuntimeRequest, Operation> stopRuntimeSettings;
    private final OperationCallSettings<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationSettings;
    private final UnaryCallSettings<SwitchRuntimeRequest, Operation> switchRuntimeSettings;
    private final OperationCallSettings<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationSettings;
    private final UnaryCallSettings<ResetRuntimeRequest, Operation> resetRuntimeSettings;
    private final OperationCallSettings<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationSettings;
    private final UnaryCallSettings<ReportRuntimeEventRequest, Operation> reportRuntimeEventSettings;
    private final OperationCallSettings<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationSettings;
    private final UnaryCallSettings<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalSettings;
    private static final PagedListDescriptor<ListRuntimesRequest, ListRuntimesResponse, Runtime> LIST_RUNTIMES_PAGE_STR_DESC = new PagedListDescriptor<ListRuntimesRequest, ListRuntimesResponse, Runtime>(){

        public String emptyToken() {
            return "";
        }

        public ListRuntimesRequest injectToken(ListRuntimesRequest payload, String token) {
            return ListRuntimesRequest.newBuilder((ListRuntimesRequest)payload).setPageToken(token).build();
        }

        public ListRuntimesRequest injectPageSize(ListRuntimesRequest payload, int pageSize) {
            return ListRuntimesRequest.newBuilder((ListRuntimesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuntimesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuntimesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Runtime> extractResources(ListRuntimesResponse payload) {
            return payload.getRuntimesList() == null ? ImmutableList.of() : payload.getRuntimesList();
        }
    };
    private static final PagedListResponseFactory<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse> LIST_RUNTIMES_PAGE_STR_FACT = new PagedListResponseFactory<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse>(){

        public ApiFuture<ManagedNotebookServiceClient.ListRuntimesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> callable, ListRuntimesRequest request, ApiCallContext context, ApiFuture<ListRuntimesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RUNTIMES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ManagedNotebookServiceClient.ListRuntimesPagedResponse.createAsync((PageContext<ListRuntimesRequest, ListRuntimesResponse, Runtime>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesSettings() {
        return this.listRuntimesSettings;
    }

    public UnaryCallSettings<GetRuntimeRequest, Runtime> getRuntimeSettings() {
        return this.getRuntimeSettings;
    }

    public UnaryCallSettings<CreateRuntimeRequest, Operation> createRuntimeSettings() {
        return this.createRuntimeSettings;
    }

    public OperationCallSettings<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationSettings() {
        return this.createRuntimeOperationSettings;
    }

    public UnaryCallSettings<DeleteRuntimeRequest, Operation> deleteRuntimeSettings() {
        return this.deleteRuntimeSettings;
    }

    public OperationCallSettings<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationSettings() {
        return this.deleteRuntimeOperationSettings;
    }

    public UnaryCallSettings<StartRuntimeRequest, Operation> startRuntimeSettings() {
        return this.startRuntimeSettings;
    }

    public OperationCallSettings<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationSettings() {
        return this.startRuntimeOperationSettings;
    }

    public UnaryCallSettings<StopRuntimeRequest, Operation> stopRuntimeSettings() {
        return this.stopRuntimeSettings;
    }

    public OperationCallSettings<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationSettings() {
        return this.stopRuntimeOperationSettings;
    }

    public UnaryCallSettings<SwitchRuntimeRequest, Operation> switchRuntimeSettings() {
        return this.switchRuntimeSettings;
    }

    public OperationCallSettings<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationSettings() {
        return this.switchRuntimeOperationSettings;
    }

    public UnaryCallSettings<ResetRuntimeRequest, Operation> resetRuntimeSettings() {
        return this.resetRuntimeSettings;
    }

    public OperationCallSettings<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationSettings() {
        return this.resetRuntimeOperationSettings;
    }

    public UnaryCallSettings<ReportRuntimeEventRequest, Operation> reportRuntimeEventSettings() {
        return this.reportRuntimeEventSettings;
    }

    public OperationCallSettings<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationSettings() {
        return this.reportRuntimeEventOperationSettings;
    }

    public UnaryCallSettings<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalSettings() {
        return this.refreshRuntimeTokenInternalSettings;
    }

    public ManagedNotebookServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcManagedNotebookServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "notebooks.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "notebooks.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ManagedNotebookServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ManagedNotebookServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ManagedNotebookServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listRuntimesSettings = settingsBuilder.listRuntimesSettings().build();
        this.getRuntimeSettings = settingsBuilder.getRuntimeSettings().build();
        this.createRuntimeSettings = settingsBuilder.createRuntimeSettings().build();
        this.createRuntimeOperationSettings = settingsBuilder.createRuntimeOperationSettings().build();
        this.deleteRuntimeSettings = settingsBuilder.deleteRuntimeSettings().build();
        this.deleteRuntimeOperationSettings = settingsBuilder.deleteRuntimeOperationSettings().build();
        this.startRuntimeSettings = settingsBuilder.startRuntimeSettings().build();
        this.startRuntimeOperationSettings = settingsBuilder.startRuntimeOperationSettings().build();
        this.stopRuntimeSettings = settingsBuilder.stopRuntimeSettings().build();
        this.stopRuntimeOperationSettings = settingsBuilder.stopRuntimeOperationSettings().build();
        this.switchRuntimeSettings = settingsBuilder.switchRuntimeSettings().build();
        this.switchRuntimeOperationSettings = settingsBuilder.switchRuntimeOperationSettings().build();
        this.resetRuntimeSettings = settingsBuilder.resetRuntimeSettings().build();
        this.resetRuntimeOperationSettings = settingsBuilder.resetRuntimeOperationSettings().build();
        this.reportRuntimeEventSettings = settingsBuilder.reportRuntimeEventSettings().build();
        this.reportRuntimeEventOperationSettings = settingsBuilder.reportRuntimeEventOperationSettings().build();
        this.refreshRuntimeTokenInternalSettings = settingsBuilder.refreshRuntimeTokenInternalSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ManagedNotebookServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesSettings;
        private final UnaryCallSettings.Builder<GetRuntimeRequest, Runtime> getRuntimeSettings;
        private final UnaryCallSettings.Builder<CreateRuntimeRequest, Operation> createRuntimeSettings;
        private final OperationCallSettings.Builder<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRuntimeRequest, Operation> deleteRuntimeSettings;
        private final OperationCallSettings.Builder<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<StartRuntimeRequest, Operation> startRuntimeSettings;
        private final OperationCallSettings.Builder<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<StopRuntimeRequest, Operation> stopRuntimeSettings;
        private final OperationCallSettings.Builder<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<SwitchRuntimeRequest, Operation> switchRuntimeSettings;
        private final OperationCallSettings.Builder<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<ResetRuntimeRequest, Operation> resetRuntimeSettings;
        private final OperationCallSettings.Builder<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationSettings;
        private final UnaryCallSettings.Builder<ReportRuntimeEventRequest, Operation> reportRuntimeEventSettings;
        private final OperationCallSettings.Builder<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationSettings;
        private final UnaryCallSettings.Builder<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listRuntimesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RUNTIMES_PAGE_STR_FACT);
            this.getRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.startRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.stopRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.switchRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.switchRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.resetRuntimeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetRuntimeOperationSettings = OperationCallSettings.newBuilder();
            this.reportRuntimeEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reportRuntimeEventOperationSettings = OperationCallSettings.newBuilder();
            this.refreshRuntimeTokenInternalSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRuntimesSettings, this.getRuntimeSettings, this.createRuntimeSettings, this.deleteRuntimeSettings, this.startRuntimeSettings, this.stopRuntimeSettings, this.switchRuntimeSettings, this.resetRuntimeSettings, this.reportRuntimeEventSettings, this.refreshRuntimeTokenInternalSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ManagedNotebookServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listRuntimesSettings = settings.listRuntimesSettings.toBuilder();
            this.getRuntimeSettings = settings.getRuntimeSettings.toBuilder();
            this.createRuntimeSettings = settings.createRuntimeSettings.toBuilder();
            this.createRuntimeOperationSettings = settings.createRuntimeOperationSettings.toBuilder();
            this.deleteRuntimeSettings = settings.deleteRuntimeSettings.toBuilder();
            this.deleteRuntimeOperationSettings = settings.deleteRuntimeOperationSettings.toBuilder();
            this.startRuntimeSettings = settings.startRuntimeSettings.toBuilder();
            this.startRuntimeOperationSettings = settings.startRuntimeOperationSettings.toBuilder();
            this.stopRuntimeSettings = settings.stopRuntimeSettings.toBuilder();
            this.stopRuntimeOperationSettings = settings.stopRuntimeOperationSettings.toBuilder();
            this.switchRuntimeSettings = settings.switchRuntimeSettings.toBuilder();
            this.switchRuntimeOperationSettings = settings.switchRuntimeOperationSettings.toBuilder();
            this.resetRuntimeSettings = settings.resetRuntimeSettings.toBuilder();
            this.resetRuntimeOperationSettings = settings.resetRuntimeOperationSettings.toBuilder();
            this.reportRuntimeEventSettings = settings.reportRuntimeEventSettings.toBuilder();
            this.reportRuntimeEventOperationSettings = settings.reportRuntimeEventOperationSettings.toBuilder();
            this.refreshRuntimeTokenInternalSettings = settings.refreshRuntimeTokenInternalSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRuntimesSettings, this.getRuntimeSettings, this.createRuntimeSettings, this.deleteRuntimeSettings, this.startRuntimeSettings, this.stopRuntimeSettings, this.switchRuntimeSettings, this.resetRuntimeSettings, this.reportRuntimeEventSettings, this.refreshRuntimeTokenInternalSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ManagedNotebookServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ManagedNotebookServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ManagedNotebookServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ManagedNotebookServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ManagedNotebookServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listRuntimesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.switchRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resetRuntimeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.reportRuntimeEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.refreshRuntimeTokenInternalSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.switchRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resetRuntimeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reportRuntimeEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Runtime.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesSettings() {
            return this.listRuntimesSettings;
        }

        public UnaryCallSettings.Builder<GetRuntimeRequest, Runtime> getRuntimeSettings() {
            return this.getRuntimeSettings;
        }

        public UnaryCallSettings.Builder<CreateRuntimeRequest, Operation> createRuntimeSettings() {
            return this.createRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationSettings() {
            return this.createRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRuntimeRequest, Operation> deleteRuntimeSettings() {
            return this.deleteRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationSettings() {
            return this.deleteRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<StartRuntimeRequest, Operation> startRuntimeSettings() {
            return this.startRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationSettings() {
            return this.startRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<StopRuntimeRequest, Operation> stopRuntimeSettings() {
            return this.stopRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationSettings() {
            return this.stopRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<SwitchRuntimeRequest, Operation> switchRuntimeSettings() {
            return this.switchRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationSettings() {
            return this.switchRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetRuntimeRequest, Operation> resetRuntimeSettings() {
            return this.resetRuntimeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationSettings() {
            return this.resetRuntimeOperationSettings;
        }

        public UnaryCallSettings.Builder<ReportRuntimeEventRequest, Operation> reportRuntimeEventSettings() {
            return this.reportRuntimeEventSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationSettings() {
            return this.reportRuntimeEventOperationSettings;
        }

        public UnaryCallSettings.Builder<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalSettings() {
            return this.refreshRuntimeTokenInternalSettings;
        }

        public ManagedNotebookServiceStubSettings build() throws IOException {
            return new ManagedNotebookServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

