/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkservices.v1.AuthzExtension;
import com.google.cloud.networkservices.v1.AuthzExtensionName;
import com.google.cloud.networkservices.v1.CreateAuthzExtensionRequest;
import com.google.cloud.networkservices.v1.CreateLbEdgeExtensionRequest;
import com.google.cloud.networkservices.v1.CreateLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.CreateLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteAuthzExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteLbEdgeExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.DepServiceSettings;
import com.google.cloud.networkservices.v1.GetAuthzExtensionRequest;
import com.google.cloud.networkservices.v1.GetLbEdgeExtensionRequest;
import com.google.cloud.networkservices.v1.GetLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.GetLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.LbEdgeExtension;
import com.google.cloud.networkservices.v1.LbEdgeExtensionName;
import com.google.cloud.networkservices.v1.LbRouteExtension;
import com.google.cloud.networkservices.v1.LbRouteExtensionName;
import com.google.cloud.networkservices.v1.LbTrafficExtension;
import com.google.cloud.networkservices.v1.LbTrafficExtensionName;
import com.google.cloud.networkservices.v1.ListAuthzExtensionsRequest;
import com.google.cloud.networkservices.v1.ListAuthzExtensionsResponse;
import com.google.cloud.networkservices.v1.ListLbEdgeExtensionsRequest;
import com.google.cloud.networkservices.v1.ListLbEdgeExtensionsResponse;
import com.google.cloud.networkservices.v1.ListLbRouteExtensionsRequest;
import com.google.cloud.networkservices.v1.ListLbRouteExtensionsResponse;
import com.google.cloud.networkservices.v1.ListLbTrafficExtensionsRequest;
import com.google.cloud.networkservices.v1.ListLbTrafficExtensionsResponse;
import com.google.cloud.networkservices.v1.LocationName;
import com.google.cloud.networkservices.v1.OperationMetadata;
import com.google.cloud.networkservices.v1.UpdateAuthzExtensionRequest;
import com.google.cloud.networkservices.v1.UpdateLbEdgeExtensionRequest;
import com.google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.stub.DepServiceStub;
import com.google.cloud.networkservices.v1.stub.DepServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DepServiceClient
implements BackgroundResource {
    private final DepServiceSettings settings;
    private final DepServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DepServiceClient create() throws IOException {
        return DepServiceClient.create(DepServiceSettings.newBuilder().build());
    }

    public static final DepServiceClient create(DepServiceSettings settings) throws IOException {
        return new DepServiceClient(settings);
    }

    public static final DepServiceClient create(DepServiceStub stub) {
        return new DepServiceClient(stub);
    }

    protected DepServiceClient(DepServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DepServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DepServiceClient(DepServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DepServiceSettings getSettings() {
        return this.settings;
    }

    public DepServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListLbTrafficExtensionsPagedResponse listLbTrafficExtensions(LocationName parent) {
        ListLbTrafficExtensionsRequest request = ListLbTrafficExtensionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLbTrafficExtensions(request);
    }

    public final ListLbTrafficExtensionsPagedResponse listLbTrafficExtensions(String parent) {
        ListLbTrafficExtensionsRequest request = ListLbTrafficExtensionsRequest.newBuilder().setParent(parent).build();
        return this.listLbTrafficExtensions(request);
    }

    public final ListLbTrafficExtensionsPagedResponse listLbTrafficExtensions(ListLbTrafficExtensionsRequest request) {
        return (ListLbTrafficExtensionsPagedResponse)((Object)this.listLbTrafficExtensionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsPagedResponse> listLbTrafficExtensionsPagedCallable() {
        return this.stub.listLbTrafficExtensionsPagedCallable();
    }

    public final UnaryCallable<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse> listLbTrafficExtensionsCallable() {
        return this.stub.listLbTrafficExtensionsCallable();
    }

    public final LbTrafficExtension getLbTrafficExtension(LbTrafficExtensionName name) {
        GetLbTrafficExtensionRequest request = GetLbTrafficExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLbTrafficExtension(request);
    }

    public final LbTrafficExtension getLbTrafficExtension(String name) {
        GetLbTrafficExtensionRequest request = GetLbTrafficExtensionRequest.newBuilder().setName(name).build();
        return this.getLbTrafficExtension(request);
    }

    public final LbTrafficExtension getLbTrafficExtension(GetLbTrafficExtensionRequest request) {
        return (LbTrafficExtension)this.getLbTrafficExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<GetLbTrafficExtensionRequest, LbTrafficExtension> getLbTrafficExtensionCallable() {
        return this.stub.getLbTrafficExtensionCallable();
    }

    public final OperationFuture<LbTrafficExtension, OperationMetadata> createLbTrafficExtensionAsync(LocationName parent, LbTrafficExtension lbTrafficExtension, String lbTrafficExtensionId) {
        CreateLbTrafficExtensionRequest request = CreateLbTrafficExtensionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLbTrafficExtension(lbTrafficExtension).setLbTrafficExtensionId(lbTrafficExtensionId).build();
        return this.createLbTrafficExtensionAsync(request);
    }

    public final OperationFuture<LbTrafficExtension, OperationMetadata> createLbTrafficExtensionAsync(String parent, LbTrafficExtension lbTrafficExtension, String lbTrafficExtensionId) {
        CreateLbTrafficExtensionRequest request = CreateLbTrafficExtensionRequest.newBuilder().setParent(parent).setLbTrafficExtension(lbTrafficExtension).setLbTrafficExtensionId(lbTrafficExtensionId).build();
        return this.createLbTrafficExtensionAsync(request);
    }

    public final OperationFuture<LbTrafficExtension, OperationMetadata> createLbTrafficExtensionAsync(CreateLbTrafficExtensionRequest request) {
        return this.createLbTrafficExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> createLbTrafficExtensionOperationCallable() {
        return this.stub.createLbTrafficExtensionOperationCallable();
    }

    public final UnaryCallable<CreateLbTrafficExtensionRequest, Operation> createLbTrafficExtensionCallable() {
        return this.stub.createLbTrafficExtensionCallable();
    }

    public final OperationFuture<LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionAsync(LbTrafficExtension lbTrafficExtension, FieldMask updateMask) {
        UpdateLbTrafficExtensionRequest request = UpdateLbTrafficExtensionRequest.newBuilder().setLbTrafficExtension(lbTrafficExtension).setUpdateMask(updateMask).build();
        return this.updateLbTrafficExtensionAsync(request);
    }

    public final OperationFuture<LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionAsync(UpdateLbTrafficExtensionRequest request) {
        return this.updateLbTrafficExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionOperationCallable() {
        return this.stub.updateLbTrafficExtensionOperationCallable();
    }

    public final UnaryCallable<UpdateLbTrafficExtensionRequest, Operation> updateLbTrafficExtensionCallable() {
        return this.stub.updateLbTrafficExtensionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbTrafficExtensionAsync(LbTrafficExtensionName name) {
        DeleteLbTrafficExtensionRequest request = DeleteLbTrafficExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLbTrafficExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbTrafficExtensionAsync(String name) {
        DeleteLbTrafficExtensionRequest request = DeleteLbTrafficExtensionRequest.newBuilder().setName(name).build();
        return this.deleteLbTrafficExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbTrafficExtensionAsync(DeleteLbTrafficExtensionRequest request) {
        return this.deleteLbTrafficExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLbTrafficExtensionRequest, Empty, OperationMetadata> deleteLbTrafficExtensionOperationCallable() {
        return this.stub.deleteLbTrafficExtensionOperationCallable();
    }

    public final UnaryCallable<DeleteLbTrafficExtensionRequest, Operation> deleteLbTrafficExtensionCallable() {
        return this.stub.deleteLbTrafficExtensionCallable();
    }

    public final ListLbRouteExtensionsPagedResponse listLbRouteExtensions(LocationName parent) {
        ListLbRouteExtensionsRequest request = ListLbRouteExtensionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLbRouteExtensions(request);
    }

    public final ListLbRouteExtensionsPagedResponse listLbRouteExtensions(String parent) {
        ListLbRouteExtensionsRequest request = ListLbRouteExtensionsRequest.newBuilder().setParent(parent).build();
        return this.listLbRouteExtensions(request);
    }

    public final ListLbRouteExtensionsPagedResponse listLbRouteExtensions(ListLbRouteExtensionsRequest request) {
        return (ListLbRouteExtensionsPagedResponse)((Object)this.listLbRouteExtensionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLbRouteExtensionsRequest, ListLbRouteExtensionsPagedResponse> listLbRouteExtensionsPagedCallable() {
        return this.stub.listLbRouteExtensionsPagedCallable();
    }

    public final UnaryCallable<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse> listLbRouteExtensionsCallable() {
        return this.stub.listLbRouteExtensionsCallable();
    }

    public final LbRouteExtension getLbRouteExtension(LbRouteExtensionName name) {
        GetLbRouteExtensionRequest request = GetLbRouteExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLbRouteExtension(request);
    }

    public final LbRouteExtension getLbRouteExtension(String name) {
        GetLbRouteExtensionRequest request = GetLbRouteExtensionRequest.newBuilder().setName(name).build();
        return this.getLbRouteExtension(request);
    }

    public final LbRouteExtension getLbRouteExtension(GetLbRouteExtensionRequest request) {
        return (LbRouteExtension)this.getLbRouteExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<GetLbRouteExtensionRequest, LbRouteExtension> getLbRouteExtensionCallable() {
        return this.stub.getLbRouteExtensionCallable();
    }

    public final OperationFuture<LbRouteExtension, OperationMetadata> createLbRouteExtensionAsync(LocationName parent, LbRouteExtension lbRouteExtension, String lbRouteExtensionId) {
        CreateLbRouteExtensionRequest request = CreateLbRouteExtensionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLbRouteExtension(lbRouteExtension).setLbRouteExtensionId(lbRouteExtensionId).build();
        return this.createLbRouteExtensionAsync(request);
    }

    public final OperationFuture<LbRouteExtension, OperationMetadata> createLbRouteExtensionAsync(String parent, LbRouteExtension lbRouteExtension, String lbRouteExtensionId) {
        CreateLbRouteExtensionRequest request = CreateLbRouteExtensionRequest.newBuilder().setParent(parent).setLbRouteExtension(lbRouteExtension).setLbRouteExtensionId(lbRouteExtensionId).build();
        return this.createLbRouteExtensionAsync(request);
    }

    public final OperationFuture<LbRouteExtension, OperationMetadata> createLbRouteExtensionAsync(CreateLbRouteExtensionRequest request) {
        return this.createLbRouteExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> createLbRouteExtensionOperationCallable() {
        return this.stub.createLbRouteExtensionOperationCallable();
    }

    public final UnaryCallable<CreateLbRouteExtensionRequest, Operation> createLbRouteExtensionCallable() {
        return this.stub.createLbRouteExtensionCallable();
    }

    public final OperationFuture<LbRouteExtension, OperationMetadata> updateLbRouteExtensionAsync(LbRouteExtension lbRouteExtension, FieldMask updateMask) {
        UpdateLbRouteExtensionRequest request = UpdateLbRouteExtensionRequest.newBuilder().setLbRouteExtension(lbRouteExtension).setUpdateMask(updateMask).build();
        return this.updateLbRouteExtensionAsync(request);
    }

    public final OperationFuture<LbRouteExtension, OperationMetadata> updateLbRouteExtensionAsync(UpdateLbRouteExtensionRequest request) {
        return this.updateLbRouteExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> updateLbRouteExtensionOperationCallable() {
        return this.stub.updateLbRouteExtensionOperationCallable();
    }

    public final UnaryCallable<UpdateLbRouteExtensionRequest, Operation> updateLbRouteExtensionCallable() {
        return this.stub.updateLbRouteExtensionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbRouteExtensionAsync(LbRouteExtensionName name) {
        DeleteLbRouteExtensionRequest request = DeleteLbRouteExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLbRouteExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbRouteExtensionAsync(String name) {
        DeleteLbRouteExtensionRequest request = DeleteLbRouteExtensionRequest.newBuilder().setName(name).build();
        return this.deleteLbRouteExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbRouteExtensionAsync(DeleteLbRouteExtensionRequest request) {
        return this.deleteLbRouteExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLbRouteExtensionRequest, Empty, OperationMetadata> deleteLbRouteExtensionOperationCallable() {
        return this.stub.deleteLbRouteExtensionOperationCallable();
    }

    public final UnaryCallable<DeleteLbRouteExtensionRequest, Operation> deleteLbRouteExtensionCallable() {
        return this.stub.deleteLbRouteExtensionCallable();
    }

    public final ListLbEdgeExtensionsPagedResponse listLbEdgeExtensions(LocationName parent) {
        ListLbEdgeExtensionsRequest request = ListLbEdgeExtensionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLbEdgeExtensions(request);
    }

    public final ListLbEdgeExtensionsPagedResponse listLbEdgeExtensions(String parent) {
        ListLbEdgeExtensionsRequest request = ListLbEdgeExtensionsRequest.newBuilder().setParent(parent).build();
        return this.listLbEdgeExtensions(request);
    }

    public final ListLbEdgeExtensionsPagedResponse listLbEdgeExtensions(ListLbEdgeExtensionsRequest request) {
        return (ListLbEdgeExtensionsPagedResponse)((Object)this.listLbEdgeExtensionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsPagedResponse> listLbEdgeExtensionsPagedCallable() {
        return this.stub.listLbEdgeExtensionsPagedCallable();
    }

    public final UnaryCallable<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse> listLbEdgeExtensionsCallable() {
        return this.stub.listLbEdgeExtensionsCallable();
    }

    public final LbEdgeExtension getLbEdgeExtension(LbEdgeExtensionName name) {
        GetLbEdgeExtensionRequest request = GetLbEdgeExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLbEdgeExtension(request);
    }

    public final LbEdgeExtension getLbEdgeExtension(String name) {
        GetLbEdgeExtensionRequest request = GetLbEdgeExtensionRequest.newBuilder().setName(name).build();
        return this.getLbEdgeExtension(request);
    }

    public final LbEdgeExtension getLbEdgeExtension(GetLbEdgeExtensionRequest request) {
        return (LbEdgeExtension)this.getLbEdgeExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<GetLbEdgeExtensionRequest, LbEdgeExtension> getLbEdgeExtensionCallable() {
        return this.stub.getLbEdgeExtensionCallable();
    }

    public final OperationFuture<LbEdgeExtension, OperationMetadata> createLbEdgeExtensionAsync(LocationName parent, LbEdgeExtension lbEdgeExtension, String lbEdgeExtensionId) {
        CreateLbEdgeExtensionRequest request = CreateLbEdgeExtensionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLbEdgeExtension(lbEdgeExtension).setLbEdgeExtensionId(lbEdgeExtensionId).build();
        return this.createLbEdgeExtensionAsync(request);
    }

    public final OperationFuture<LbEdgeExtension, OperationMetadata> createLbEdgeExtensionAsync(String parent, LbEdgeExtension lbEdgeExtension, String lbEdgeExtensionId) {
        CreateLbEdgeExtensionRequest request = CreateLbEdgeExtensionRequest.newBuilder().setParent(parent).setLbEdgeExtension(lbEdgeExtension).setLbEdgeExtensionId(lbEdgeExtensionId).build();
        return this.createLbEdgeExtensionAsync(request);
    }

    public final OperationFuture<LbEdgeExtension, OperationMetadata> createLbEdgeExtensionAsync(CreateLbEdgeExtensionRequest request) {
        return this.createLbEdgeExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLbEdgeExtensionRequest, LbEdgeExtension, OperationMetadata> createLbEdgeExtensionOperationCallable() {
        return this.stub.createLbEdgeExtensionOperationCallable();
    }

    public final UnaryCallable<CreateLbEdgeExtensionRequest, Operation> createLbEdgeExtensionCallable() {
        return this.stub.createLbEdgeExtensionCallable();
    }

    public final OperationFuture<LbEdgeExtension, OperationMetadata> updateLbEdgeExtensionAsync(LbEdgeExtension lbEdgeExtension, FieldMask updateMask) {
        UpdateLbEdgeExtensionRequest request = UpdateLbEdgeExtensionRequest.newBuilder().setLbEdgeExtension(lbEdgeExtension).setUpdateMask(updateMask).build();
        return this.updateLbEdgeExtensionAsync(request);
    }

    public final OperationFuture<LbEdgeExtension, OperationMetadata> updateLbEdgeExtensionAsync(UpdateLbEdgeExtensionRequest request) {
        return this.updateLbEdgeExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLbEdgeExtensionRequest, LbEdgeExtension, OperationMetadata> updateLbEdgeExtensionOperationCallable() {
        return this.stub.updateLbEdgeExtensionOperationCallable();
    }

    public final UnaryCallable<UpdateLbEdgeExtensionRequest, Operation> updateLbEdgeExtensionCallable() {
        return this.stub.updateLbEdgeExtensionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbEdgeExtensionAsync(LbEdgeExtensionName name) {
        DeleteLbEdgeExtensionRequest request = DeleteLbEdgeExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLbEdgeExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbEdgeExtensionAsync(String name) {
        DeleteLbEdgeExtensionRequest request = DeleteLbEdgeExtensionRequest.newBuilder().setName(name).build();
        return this.deleteLbEdgeExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLbEdgeExtensionAsync(DeleteLbEdgeExtensionRequest request) {
        return this.deleteLbEdgeExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLbEdgeExtensionRequest, Empty, OperationMetadata> deleteLbEdgeExtensionOperationCallable() {
        return this.stub.deleteLbEdgeExtensionOperationCallable();
    }

    public final UnaryCallable<DeleteLbEdgeExtensionRequest, Operation> deleteLbEdgeExtensionCallable() {
        return this.stub.deleteLbEdgeExtensionCallable();
    }

    public final ListAuthzExtensionsPagedResponse listAuthzExtensions(LocationName parent) {
        ListAuthzExtensionsRequest request = ListAuthzExtensionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAuthzExtensions(request);
    }

    public final ListAuthzExtensionsPagedResponse listAuthzExtensions(String parent) {
        ListAuthzExtensionsRequest request = ListAuthzExtensionsRequest.newBuilder().setParent(parent).build();
        return this.listAuthzExtensions(request);
    }

    public final ListAuthzExtensionsPagedResponse listAuthzExtensions(ListAuthzExtensionsRequest request) {
        return (ListAuthzExtensionsPagedResponse)((Object)this.listAuthzExtensionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAuthzExtensionsRequest, ListAuthzExtensionsPagedResponse> listAuthzExtensionsPagedCallable() {
        return this.stub.listAuthzExtensionsPagedCallable();
    }

    public final UnaryCallable<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse> listAuthzExtensionsCallable() {
        return this.stub.listAuthzExtensionsCallable();
    }

    public final AuthzExtension getAuthzExtension(AuthzExtensionName name) {
        GetAuthzExtensionRequest request = GetAuthzExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAuthzExtension(request);
    }

    public final AuthzExtension getAuthzExtension(String name) {
        GetAuthzExtensionRequest request = GetAuthzExtensionRequest.newBuilder().setName(name).build();
        return this.getAuthzExtension(request);
    }

    public final AuthzExtension getAuthzExtension(GetAuthzExtensionRequest request) {
        return (AuthzExtension)this.getAuthzExtensionCallable().call((Object)request);
    }

    public final UnaryCallable<GetAuthzExtensionRequest, AuthzExtension> getAuthzExtensionCallable() {
        return this.stub.getAuthzExtensionCallable();
    }

    public final OperationFuture<AuthzExtension, OperationMetadata> createAuthzExtensionAsync(LocationName parent, AuthzExtension authzExtension, String authzExtensionId) {
        CreateAuthzExtensionRequest request = CreateAuthzExtensionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAuthzExtension(authzExtension).setAuthzExtensionId(authzExtensionId).build();
        return this.createAuthzExtensionAsync(request);
    }

    public final OperationFuture<AuthzExtension, OperationMetadata> createAuthzExtensionAsync(String parent, AuthzExtension authzExtension, String authzExtensionId) {
        CreateAuthzExtensionRequest request = CreateAuthzExtensionRequest.newBuilder().setParent(parent).setAuthzExtension(authzExtension).setAuthzExtensionId(authzExtensionId).build();
        return this.createAuthzExtensionAsync(request);
    }

    public final OperationFuture<AuthzExtension, OperationMetadata> createAuthzExtensionAsync(CreateAuthzExtensionRequest request) {
        return this.createAuthzExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAuthzExtensionRequest, AuthzExtension, OperationMetadata> createAuthzExtensionOperationCallable() {
        return this.stub.createAuthzExtensionOperationCallable();
    }

    public final UnaryCallable<CreateAuthzExtensionRequest, Operation> createAuthzExtensionCallable() {
        return this.stub.createAuthzExtensionCallable();
    }

    public final OperationFuture<AuthzExtension, OperationMetadata> updateAuthzExtensionAsync(AuthzExtension authzExtension, FieldMask updateMask) {
        UpdateAuthzExtensionRequest request = UpdateAuthzExtensionRequest.newBuilder().setAuthzExtension(authzExtension).setUpdateMask(updateMask).build();
        return this.updateAuthzExtensionAsync(request);
    }

    public final OperationFuture<AuthzExtension, OperationMetadata> updateAuthzExtensionAsync(UpdateAuthzExtensionRequest request) {
        return this.updateAuthzExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAuthzExtensionRequest, AuthzExtension, OperationMetadata> updateAuthzExtensionOperationCallable() {
        return this.stub.updateAuthzExtensionOperationCallable();
    }

    public final UnaryCallable<UpdateAuthzExtensionRequest, Operation> updateAuthzExtensionCallable() {
        return this.stub.updateAuthzExtensionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthzExtensionAsync(AuthzExtensionName name) {
        DeleteAuthzExtensionRequest request = DeleteAuthzExtensionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAuthzExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthzExtensionAsync(String name) {
        DeleteAuthzExtensionRequest request = DeleteAuthzExtensionRequest.newBuilder().setName(name).build();
        return this.deleteAuthzExtensionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAuthzExtensionAsync(DeleteAuthzExtensionRequest request) {
        return this.deleteAuthzExtensionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAuthzExtensionRequest, Empty, OperationMetadata> deleteAuthzExtensionOperationCallable() {
        return this.stub.deleteAuthzExtensionOperationCallable();
    }

    public final UnaryCallable<DeleteAuthzExtensionRequest, Operation> deleteAuthzExtensionCallable() {
        return this.stub.deleteAuthzExtensionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAuthzExtensionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension, ListAuthzExtensionsPage, ListAuthzExtensionsFixedSizeCollection> {
        private ListAuthzExtensionsFixedSizeCollection(List<ListAuthzExtensionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAuthzExtensionsFixedSizeCollection createEmptyCollection() {
            return new ListAuthzExtensionsFixedSizeCollection(null, 0);
        }

        protected ListAuthzExtensionsFixedSizeCollection createCollection(List<ListAuthzExtensionsPage> pages, int collectionSize) {
            return new ListAuthzExtensionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAuthzExtensionsPage
    extends AbstractPage<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension, ListAuthzExtensionsPage> {
        private ListAuthzExtensionsPage(PageContext<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension> context, ListAuthzExtensionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAuthzExtensionsPage createEmptyPage() {
            return new ListAuthzExtensionsPage(null, null);
        }

        protected ListAuthzExtensionsPage createPage(PageContext<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension> context, ListAuthzExtensionsResponse response) {
            return new ListAuthzExtensionsPage(context, response);
        }

        public ApiFuture<ListAuthzExtensionsPage> createPageAsync(PageContext<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension> context, ApiFuture<ListAuthzExtensionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAuthzExtensionsPagedResponse
    extends AbstractPagedListResponse<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension, ListAuthzExtensionsPage, ListAuthzExtensionsFixedSizeCollection> {
        public static ApiFuture<ListAuthzExtensionsPagedResponse> createAsync(PageContext<ListAuthzExtensionsRequest, ListAuthzExtensionsResponse, AuthzExtension> context, ApiFuture<ListAuthzExtensionsResponse> futureResponse) {
            ApiFuture<ListAuthzExtensionsPage> futurePage = ListAuthzExtensionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAuthzExtensionsPagedResponse((ListAuthzExtensionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAuthzExtensionsPagedResponse(ListAuthzExtensionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAuthzExtensionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLbEdgeExtensionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension, ListLbEdgeExtensionsPage, ListLbEdgeExtensionsFixedSizeCollection> {
        private ListLbEdgeExtensionsFixedSizeCollection(List<ListLbEdgeExtensionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLbEdgeExtensionsFixedSizeCollection createEmptyCollection() {
            return new ListLbEdgeExtensionsFixedSizeCollection(null, 0);
        }

        protected ListLbEdgeExtensionsFixedSizeCollection createCollection(List<ListLbEdgeExtensionsPage> pages, int collectionSize) {
            return new ListLbEdgeExtensionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLbEdgeExtensionsPage
    extends AbstractPage<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension, ListLbEdgeExtensionsPage> {
        private ListLbEdgeExtensionsPage(PageContext<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension> context, ListLbEdgeExtensionsResponse response) {
            super(context, (Object)response);
        }

        private static ListLbEdgeExtensionsPage createEmptyPage() {
            return new ListLbEdgeExtensionsPage(null, null);
        }

        protected ListLbEdgeExtensionsPage createPage(PageContext<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension> context, ListLbEdgeExtensionsResponse response) {
            return new ListLbEdgeExtensionsPage(context, response);
        }

        public ApiFuture<ListLbEdgeExtensionsPage> createPageAsync(PageContext<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension> context, ApiFuture<ListLbEdgeExtensionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLbEdgeExtensionsPagedResponse
    extends AbstractPagedListResponse<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension, ListLbEdgeExtensionsPage, ListLbEdgeExtensionsFixedSizeCollection> {
        public static ApiFuture<ListLbEdgeExtensionsPagedResponse> createAsync(PageContext<ListLbEdgeExtensionsRequest, ListLbEdgeExtensionsResponse, LbEdgeExtension> context, ApiFuture<ListLbEdgeExtensionsResponse> futureResponse) {
            ApiFuture<ListLbEdgeExtensionsPage> futurePage = ListLbEdgeExtensionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLbEdgeExtensionsPagedResponse((ListLbEdgeExtensionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLbEdgeExtensionsPagedResponse(ListLbEdgeExtensionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLbEdgeExtensionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLbRouteExtensionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension, ListLbRouteExtensionsPage, ListLbRouteExtensionsFixedSizeCollection> {
        private ListLbRouteExtensionsFixedSizeCollection(List<ListLbRouteExtensionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLbRouteExtensionsFixedSizeCollection createEmptyCollection() {
            return new ListLbRouteExtensionsFixedSizeCollection(null, 0);
        }

        protected ListLbRouteExtensionsFixedSizeCollection createCollection(List<ListLbRouteExtensionsPage> pages, int collectionSize) {
            return new ListLbRouteExtensionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLbRouteExtensionsPage
    extends AbstractPage<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension, ListLbRouteExtensionsPage> {
        private ListLbRouteExtensionsPage(PageContext<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension> context, ListLbRouteExtensionsResponse response) {
            super(context, (Object)response);
        }

        private static ListLbRouteExtensionsPage createEmptyPage() {
            return new ListLbRouteExtensionsPage(null, null);
        }

        protected ListLbRouteExtensionsPage createPage(PageContext<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension> context, ListLbRouteExtensionsResponse response) {
            return new ListLbRouteExtensionsPage(context, response);
        }

        public ApiFuture<ListLbRouteExtensionsPage> createPageAsync(PageContext<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension> context, ApiFuture<ListLbRouteExtensionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLbRouteExtensionsPagedResponse
    extends AbstractPagedListResponse<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension, ListLbRouteExtensionsPage, ListLbRouteExtensionsFixedSizeCollection> {
        public static ApiFuture<ListLbRouteExtensionsPagedResponse> createAsync(PageContext<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension> context, ApiFuture<ListLbRouteExtensionsResponse> futureResponse) {
            ApiFuture<ListLbRouteExtensionsPage> futurePage = ListLbRouteExtensionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLbRouteExtensionsPagedResponse((ListLbRouteExtensionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLbRouteExtensionsPagedResponse(ListLbRouteExtensionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLbRouteExtensionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLbTrafficExtensionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension, ListLbTrafficExtensionsPage, ListLbTrafficExtensionsFixedSizeCollection> {
        private ListLbTrafficExtensionsFixedSizeCollection(List<ListLbTrafficExtensionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLbTrafficExtensionsFixedSizeCollection createEmptyCollection() {
            return new ListLbTrafficExtensionsFixedSizeCollection(null, 0);
        }

        protected ListLbTrafficExtensionsFixedSizeCollection createCollection(List<ListLbTrafficExtensionsPage> pages, int collectionSize) {
            return new ListLbTrafficExtensionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLbTrafficExtensionsPage
    extends AbstractPage<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension, ListLbTrafficExtensionsPage> {
        private ListLbTrafficExtensionsPage(PageContext<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension> context, ListLbTrafficExtensionsResponse response) {
            super(context, (Object)response);
        }

        private static ListLbTrafficExtensionsPage createEmptyPage() {
            return new ListLbTrafficExtensionsPage(null, null);
        }

        protected ListLbTrafficExtensionsPage createPage(PageContext<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension> context, ListLbTrafficExtensionsResponse response) {
            return new ListLbTrafficExtensionsPage(context, response);
        }

        public ApiFuture<ListLbTrafficExtensionsPage> createPageAsync(PageContext<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension> context, ApiFuture<ListLbTrafficExtensionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLbTrafficExtensionsPagedResponse
    extends AbstractPagedListResponse<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension, ListLbTrafficExtensionsPage, ListLbTrafficExtensionsFixedSizeCollection> {
        public static ApiFuture<ListLbTrafficExtensionsPagedResponse> createAsync(PageContext<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension> context, ApiFuture<ListLbTrafficExtensionsResponse> futureResponse) {
            ApiFuture<ListLbTrafficExtensionsPage> futurePage = ListLbTrafficExtensionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLbTrafficExtensionsPagedResponse((ListLbTrafficExtensionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLbTrafficExtensionsPagedResponse(ListLbTrafficExtensionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLbTrafficExtensionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

