/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkservices.v1.CreateEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.CreateGatewayRequest;
import com.google.cloud.networkservices.v1.CreateGrpcRouteRequest;
import com.google.cloud.networkservices.v1.CreateHttpRouteRequest;
import com.google.cloud.networkservices.v1.CreateMeshRequest;
import com.google.cloud.networkservices.v1.CreateServiceBindingRequest;
import com.google.cloud.networkservices.v1.CreateServiceLbPolicyRequest;
import com.google.cloud.networkservices.v1.CreateTcpRouteRequest;
import com.google.cloud.networkservices.v1.CreateTlsRouteRequest;
import com.google.cloud.networkservices.v1.DeleteEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.DeleteGatewayRequest;
import com.google.cloud.networkservices.v1.DeleteGrpcRouteRequest;
import com.google.cloud.networkservices.v1.DeleteHttpRouteRequest;
import com.google.cloud.networkservices.v1.DeleteMeshRequest;
import com.google.cloud.networkservices.v1.DeleteServiceBindingRequest;
import com.google.cloud.networkservices.v1.DeleteServiceLbPolicyRequest;
import com.google.cloud.networkservices.v1.DeleteTcpRouteRequest;
import com.google.cloud.networkservices.v1.DeleteTlsRouteRequest;
import com.google.cloud.networkservices.v1.EndpointPolicy;
import com.google.cloud.networkservices.v1.EndpointPolicyName;
import com.google.cloud.networkservices.v1.Gateway;
import com.google.cloud.networkservices.v1.GatewayName;
import com.google.cloud.networkservices.v1.GatewayRouteView;
import com.google.cloud.networkservices.v1.GatewayRouteViewName;
import com.google.cloud.networkservices.v1.GetEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.GetGatewayRequest;
import com.google.cloud.networkservices.v1.GetGatewayRouteViewRequest;
import com.google.cloud.networkservices.v1.GetGrpcRouteRequest;
import com.google.cloud.networkservices.v1.GetHttpRouteRequest;
import com.google.cloud.networkservices.v1.GetMeshRequest;
import com.google.cloud.networkservices.v1.GetMeshRouteViewRequest;
import com.google.cloud.networkservices.v1.GetServiceBindingRequest;
import com.google.cloud.networkservices.v1.GetServiceLbPolicyRequest;
import com.google.cloud.networkservices.v1.GetTcpRouteRequest;
import com.google.cloud.networkservices.v1.GetTlsRouteRequest;
import com.google.cloud.networkservices.v1.GrpcRoute;
import com.google.cloud.networkservices.v1.GrpcRouteName;
import com.google.cloud.networkservices.v1.HttpRoute;
import com.google.cloud.networkservices.v1.HttpRouteName;
import com.google.cloud.networkservices.v1.ListEndpointPoliciesRequest;
import com.google.cloud.networkservices.v1.ListEndpointPoliciesResponse;
import com.google.cloud.networkservices.v1.ListGatewayRouteViewsRequest;
import com.google.cloud.networkservices.v1.ListGatewayRouteViewsResponse;
import com.google.cloud.networkservices.v1.ListGatewaysRequest;
import com.google.cloud.networkservices.v1.ListGatewaysResponse;
import com.google.cloud.networkservices.v1.ListGrpcRoutesRequest;
import com.google.cloud.networkservices.v1.ListGrpcRoutesResponse;
import com.google.cloud.networkservices.v1.ListHttpRoutesRequest;
import com.google.cloud.networkservices.v1.ListHttpRoutesResponse;
import com.google.cloud.networkservices.v1.ListMeshRouteViewsRequest;
import com.google.cloud.networkservices.v1.ListMeshRouteViewsResponse;
import com.google.cloud.networkservices.v1.ListMeshesRequest;
import com.google.cloud.networkservices.v1.ListMeshesResponse;
import com.google.cloud.networkservices.v1.ListServiceBindingsRequest;
import com.google.cloud.networkservices.v1.ListServiceBindingsResponse;
import com.google.cloud.networkservices.v1.ListServiceLbPoliciesRequest;
import com.google.cloud.networkservices.v1.ListServiceLbPoliciesResponse;
import com.google.cloud.networkservices.v1.ListTcpRoutesRequest;
import com.google.cloud.networkservices.v1.ListTcpRoutesResponse;
import com.google.cloud.networkservices.v1.ListTlsRoutesRequest;
import com.google.cloud.networkservices.v1.ListTlsRoutesResponse;
import com.google.cloud.networkservices.v1.LocationName;
import com.google.cloud.networkservices.v1.Mesh;
import com.google.cloud.networkservices.v1.MeshName;
import com.google.cloud.networkservices.v1.MeshRouteView;
import com.google.cloud.networkservices.v1.MeshRouteViewName;
import com.google.cloud.networkservices.v1.NetworkServicesSettings;
import com.google.cloud.networkservices.v1.OperationMetadata;
import com.google.cloud.networkservices.v1.ServiceBinding;
import com.google.cloud.networkservices.v1.ServiceBindingName;
import com.google.cloud.networkservices.v1.ServiceLbPolicy;
import com.google.cloud.networkservices.v1.ServiceLbPolicyName;
import com.google.cloud.networkservices.v1.TcpRoute;
import com.google.cloud.networkservices.v1.TcpRouteName;
import com.google.cloud.networkservices.v1.TlsRoute;
import com.google.cloud.networkservices.v1.TlsRouteName;
import com.google.cloud.networkservices.v1.UpdateEndpointPolicyRequest;
import com.google.cloud.networkservices.v1.UpdateGatewayRequest;
import com.google.cloud.networkservices.v1.UpdateGrpcRouteRequest;
import com.google.cloud.networkservices.v1.UpdateHttpRouteRequest;
import com.google.cloud.networkservices.v1.UpdateMeshRequest;
import com.google.cloud.networkservices.v1.UpdateServiceBindingRequest;
import com.google.cloud.networkservices.v1.UpdateServiceLbPolicyRequest;
import com.google.cloud.networkservices.v1.UpdateTcpRouteRequest;
import com.google.cloud.networkservices.v1.UpdateTlsRouteRequest;
import com.google.cloud.networkservices.v1.stub.NetworkServicesStub;
import com.google.cloud.networkservices.v1.stub.NetworkServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkServicesClient
implements BackgroundResource {
    private final NetworkServicesSettings settings;
    private final NetworkServicesStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final NetworkServicesClient create() throws IOException {
        return NetworkServicesClient.create(NetworkServicesSettings.newBuilder().build());
    }

    public static final NetworkServicesClient create(NetworkServicesSettings settings) throws IOException {
        return new NetworkServicesClient(settings);
    }

    public static final NetworkServicesClient create(NetworkServicesStub stub) {
        return new NetworkServicesClient(stub);
    }

    protected NetworkServicesClient(NetworkServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkServicesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected NetworkServicesClient(NetworkServicesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final NetworkServicesSettings getSettings() {
        return this.settings;
    }

    public NetworkServicesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListEndpointPoliciesPagedResponse listEndpointPolicies(LocationName parent) {
        ListEndpointPoliciesRequest request = ListEndpointPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEndpointPolicies(request);
    }

    public final ListEndpointPoliciesPagedResponse listEndpointPolicies(String parent) {
        ListEndpointPoliciesRequest request = ListEndpointPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listEndpointPolicies(request);
    }

    public final ListEndpointPoliciesPagedResponse listEndpointPolicies(ListEndpointPoliciesRequest request) {
        return (ListEndpointPoliciesPagedResponse)((Object)this.listEndpointPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEndpointPoliciesRequest, ListEndpointPoliciesPagedResponse> listEndpointPoliciesPagedCallable() {
        return this.stub.listEndpointPoliciesPagedCallable();
    }

    public final UnaryCallable<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse> listEndpointPoliciesCallable() {
        return this.stub.listEndpointPoliciesCallable();
    }

    public final EndpointPolicy getEndpointPolicy(EndpointPolicyName name) {
        GetEndpointPolicyRequest request = GetEndpointPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEndpointPolicy(request);
    }

    public final EndpointPolicy getEndpointPolicy(String name) {
        GetEndpointPolicyRequest request = GetEndpointPolicyRequest.newBuilder().setName(name).build();
        return this.getEndpointPolicy(request);
    }

    public final EndpointPolicy getEndpointPolicy(GetEndpointPolicyRequest request) {
        return (EndpointPolicy)this.getEndpointPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetEndpointPolicyRequest, EndpointPolicy> getEndpointPolicyCallable() {
        return this.stub.getEndpointPolicyCallable();
    }

    public final OperationFuture<EndpointPolicy, OperationMetadata> createEndpointPolicyAsync(LocationName parent, EndpointPolicy endpointPolicy, String endpointPolicyId) {
        CreateEndpointPolicyRequest request = CreateEndpointPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpointPolicy(endpointPolicy).setEndpointPolicyId(endpointPolicyId).build();
        return this.createEndpointPolicyAsync(request);
    }

    public final OperationFuture<EndpointPolicy, OperationMetadata> createEndpointPolicyAsync(String parent, EndpointPolicy endpointPolicy, String endpointPolicyId) {
        CreateEndpointPolicyRequest request = CreateEndpointPolicyRequest.newBuilder().setParent(parent).setEndpointPolicy(endpointPolicy).setEndpointPolicyId(endpointPolicyId).build();
        return this.createEndpointPolicyAsync(request);
    }

    public final OperationFuture<EndpointPolicy, OperationMetadata> createEndpointPolicyAsync(CreateEndpointPolicyRequest request) {
        return this.createEndpointPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> createEndpointPolicyOperationCallable() {
        return this.stub.createEndpointPolicyOperationCallable();
    }

    public final UnaryCallable<CreateEndpointPolicyRequest, Operation> createEndpointPolicyCallable() {
        return this.stub.createEndpointPolicyCallable();
    }

    public final OperationFuture<EndpointPolicy, OperationMetadata> updateEndpointPolicyAsync(EndpointPolicy endpointPolicy, FieldMask updateMask) {
        UpdateEndpointPolicyRequest request = UpdateEndpointPolicyRequest.newBuilder().setEndpointPolicy(endpointPolicy).setUpdateMask(updateMask).build();
        return this.updateEndpointPolicyAsync(request);
    }

    public final OperationFuture<EndpointPolicy, OperationMetadata> updateEndpointPolicyAsync(UpdateEndpointPolicyRequest request) {
        return this.updateEndpointPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEndpointPolicyRequest, EndpointPolicy, OperationMetadata> updateEndpointPolicyOperationCallable() {
        return this.stub.updateEndpointPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateEndpointPolicyRequest, Operation> updateEndpointPolicyCallable() {
        return this.stub.updateEndpointPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointPolicyAsync(EndpointPolicyName name) {
        DeleteEndpointPolicyRequest request = DeleteEndpointPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEndpointPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointPolicyAsync(String name) {
        DeleteEndpointPolicyRequest request = DeleteEndpointPolicyRequest.newBuilder().setName(name).build();
        return this.deleteEndpointPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointPolicyAsync(DeleteEndpointPolicyRequest request) {
        return this.deleteEndpointPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEndpointPolicyRequest, Empty, OperationMetadata> deleteEndpointPolicyOperationCallable() {
        return this.stub.deleteEndpointPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteEndpointPolicyRequest, Operation> deleteEndpointPolicyCallable() {
        return this.stub.deleteEndpointPolicyCallable();
    }

    public final ListGatewaysPagedResponse listGateways(LocationName parent) {
        ListGatewaysRequest request = ListGatewaysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGateways(request);
    }

    public final ListGatewaysPagedResponse listGateways(String parent) {
        ListGatewaysRequest request = ListGatewaysRequest.newBuilder().setParent(parent).build();
        return this.listGateways(request);
    }

    public final ListGatewaysPagedResponse listGateways(ListGatewaysRequest request) {
        return (ListGatewaysPagedResponse)((Object)this.listGatewaysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGatewaysRequest, ListGatewaysPagedResponse> listGatewaysPagedCallable() {
        return this.stub.listGatewaysPagedCallable();
    }

    public final UnaryCallable<ListGatewaysRequest, ListGatewaysResponse> listGatewaysCallable() {
        return this.stub.listGatewaysCallable();
    }

    public final Gateway getGateway(GatewayName name) {
        GetGatewayRequest request = GetGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGateway(request);
    }

    public final Gateway getGateway(String name) {
        GetGatewayRequest request = GetGatewayRequest.newBuilder().setName(name).build();
        return this.getGateway(request);
    }

    public final Gateway getGateway(GetGatewayRequest request) {
        return (Gateway)this.getGatewayCallable().call((Object)request);
    }

    public final UnaryCallable<GetGatewayRequest, Gateway> getGatewayCallable() {
        return this.stub.getGatewayCallable();
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(LocationName parent, Gateway gateway, String gatewayId) {
        CreateGatewayRequest request = CreateGatewayRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGateway(gateway).setGatewayId(gatewayId).build();
        return this.createGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(String parent, Gateway gateway, String gatewayId) {
        CreateGatewayRequest request = CreateGatewayRequest.newBuilder().setParent(parent).setGateway(gateway).setGatewayId(gatewayId).build();
        return this.createGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> createGatewayAsync(CreateGatewayRequest request) {
        return this.createGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGatewayRequest, Gateway, OperationMetadata> createGatewayOperationCallable() {
        return this.stub.createGatewayOperationCallable();
    }

    public final UnaryCallable<CreateGatewayRequest, Operation> createGatewayCallable() {
        return this.stub.createGatewayCallable();
    }

    public final OperationFuture<Gateway, OperationMetadata> updateGatewayAsync(Gateway gateway, FieldMask updateMask) {
        UpdateGatewayRequest request = UpdateGatewayRequest.newBuilder().setGateway(gateway).setUpdateMask(updateMask).build();
        return this.updateGatewayAsync(request);
    }

    public final OperationFuture<Gateway, OperationMetadata> updateGatewayAsync(UpdateGatewayRequest request) {
        return this.updateGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGatewayRequest, Gateway, OperationMetadata> updateGatewayOperationCallable() {
        return this.stub.updateGatewayOperationCallable();
    }

    public final UnaryCallable<UpdateGatewayRequest, Operation> updateGatewayCallable() {
        return this.stub.updateGatewayCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(GatewayName name) {
        DeleteGatewayRequest request = DeleteGatewayRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGatewayAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(String name) {
        DeleteGatewayRequest request = DeleteGatewayRequest.newBuilder().setName(name).build();
        return this.deleteGatewayAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGatewayAsync(DeleteGatewayRequest request) {
        return this.deleteGatewayOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGatewayRequest, Empty, OperationMetadata> deleteGatewayOperationCallable() {
        return this.stub.deleteGatewayOperationCallable();
    }

    public final UnaryCallable<DeleteGatewayRequest, Operation> deleteGatewayCallable() {
        return this.stub.deleteGatewayCallable();
    }

    public final ListGrpcRoutesPagedResponse listGrpcRoutes(LocationName parent) {
        ListGrpcRoutesRequest request = ListGrpcRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGrpcRoutes(request);
    }

    public final ListGrpcRoutesPagedResponse listGrpcRoutes(String parent) {
        ListGrpcRoutesRequest request = ListGrpcRoutesRequest.newBuilder().setParent(parent).build();
        return this.listGrpcRoutes(request);
    }

    public final ListGrpcRoutesPagedResponse listGrpcRoutes(ListGrpcRoutesRequest request) {
        return (ListGrpcRoutesPagedResponse)((Object)this.listGrpcRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGrpcRoutesRequest, ListGrpcRoutesPagedResponse> listGrpcRoutesPagedCallable() {
        return this.stub.listGrpcRoutesPagedCallable();
    }

    public final UnaryCallable<ListGrpcRoutesRequest, ListGrpcRoutesResponse> listGrpcRoutesCallable() {
        return this.stub.listGrpcRoutesCallable();
    }

    public final GrpcRoute getGrpcRoute(GrpcRouteName name) {
        GetGrpcRouteRequest request = GetGrpcRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGrpcRoute(request);
    }

    public final GrpcRoute getGrpcRoute(String name) {
        GetGrpcRouteRequest request = GetGrpcRouteRequest.newBuilder().setName(name).build();
        return this.getGrpcRoute(request);
    }

    public final GrpcRoute getGrpcRoute(GetGrpcRouteRequest request) {
        return (GrpcRoute)this.getGrpcRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetGrpcRouteRequest, GrpcRoute> getGrpcRouteCallable() {
        return this.stub.getGrpcRouteCallable();
    }

    public final OperationFuture<GrpcRoute, OperationMetadata> createGrpcRouteAsync(LocationName parent, GrpcRoute grpcRoute, String grpcRouteId) {
        CreateGrpcRouteRequest request = CreateGrpcRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGrpcRoute(grpcRoute).setGrpcRouteId(grpcRouteId).build();
        return this.createGrpcRouteAsync(request);
    }

    public final OperationFuture<GrpcRoute, OperationMetadata> createGrpcRouteAsync(String parent, GrpcRoute grpcRoute, String grpcRouteId) {
        CreateGrpcRouteRequest request = CreateGrpcRouteRequest.newBuilder().setParent(parent).setGrpcRoute(grpcRoute).setGrpcRouteId(grpcRouteId).build();
        return this.createGrpcRouteAsync(request);
    }

    public final OperationFuture<GrpcRoute, OperationMetadata> createGrpcRouteAsync(CreateGrpcRouteRequest request) {
        return this.createGrpcRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGrpcRouteRequest, GrpcRoute, OperationMetadata> createGrpcRouteOperationCallable() {
        return this.stub.createGrpcRouteOperationCallable();
    }

    public final UnaryCallable<CreateGrpcRouteRequest, Operation> createGrpcRouteCallable() {
        return this.stub.createGrpcRouteCallable();
    }

    public final OperationFuture<GrpcRoute, OperationMetadata> updateGrpcRouteAsync(GrpcRoute grpcRoute, FieldMask updateMask) {
        UpdateGrpcRouteRequest request = UpdateGrpcRouteRequest.newBuilder().setGrpcRoute(grpcRoute).setUpdateMask(updateMask).build();
        return this.updateGrpcRouteAsync(request);
    }

    public final OperationFuture<GrpcRoute, OperationMetadata> updateGrpcRouteAsync(UpdateGrpcRouteRequest request) {
        return this.updateGrpcRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGrpcRouteRequest, GrpcRoute, OperationMetadata> updateGrpcRouteOperationCallable() {
        return this.stub.updateGrpcRouteOperationCallable();
    }

    public final UnaryCallable<UpdateGrpcRouteRequest, Operation> updateGrpcRouteCallable() {
        return this.stub.updateGrpcRouteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGrpcRouteAsync(GrpcRouteName name) {
        DeleteGrpcRouteRequest request = DeleteGrpcRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGrpcRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGrpcRouteAsync(String name) {
        DeleteGrpcRouteRequest request = DeleteGrpcRouteRequest.newBuilder().setName(name).build();
        return this.deleteGrpcRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGrpcRouteAsync(DeleteGrpcRouteRequest request) {
        return this.deleteGrpcRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGrpcRouteRequest, Empty, OperationMetadata> deleteGrpcRouteOperationCallable() {
        return this.stub.deleteGrpcRouteOperationCallable();
    }

    public final UnaryCallable<DeleteGrpcRouteRequest, Operation> deleteGrpcRouteCallable() {
        return this.stub.deleteGrpcRouteCallable();
    }

    public final ListHttpRoutesPagedResponse listHttpRoutes(LocationName parent) {
        ListHttpRoutesRequest request = ListHttpRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHttpRoutes(request);
    }

    public final ListHttpRoutesPagedResponse listHttpRoutes(String parent) {
        ListHttpRoutesRequest request = ListHttpRoutesRequest.newBuilder().setParent(parent).build();
        return this.listHttpRoutes(request);
    }

    public final ListHttpRoutesPagedResponse listHttpRoutes(ListHttpRoutesRequest request) {
        return (ListHttpRoutesPagedResponse)((Object)this.listHttpRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHttpRoutesRequest, ListHttpRoutesPagedResponse> listHttpRoutesPagedCallable() {
        return this.stub.listHttpRoutesPagedCallable();
    }

    public final UnaryCallable<ListHttpRoutesRequest, ListHttpRoutesResponse> listHttpRoutesCallable() {
        return this.stub.listHttpRoutesCallable();
    }

    public final HttpRoute getHttpRoute(HttpRouteName name) {
        GetHttpRouteRequest request = GetHttpRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHttpRoute(request);
    }

    public final HttpRoute getHttpRoute(String name) {
        GetHttpRouteRequest request = GetHttpRouteRequest.newBuilder().setName(name).build();
        return this.getHttpRoute(request);
    }

    public final HttpRoute getHttpRoute(GetHttpRouteRequest request) {
        return (HttpRoute)this.getHttpRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetHttpRouteRequest, HttpRoute> getHttpRouteCallable() {
        return this.stub.getHttpRouteCallable();
    }

    public final OperationFuture<HttpRoute, OperationMetadata> createHttpRouteAsync(LocationName parent, HttpRoute httpRoute, String httpRouteId) {
        CreateHttpRouteRequest request = CreateHttpRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHttpRoute(httpRoute).setHttpRouteId(httpRouteId).build();
        return this.createHttpRouteAsync(request);
    }

    public final OperationFuture<HttpRoute, OperationMetadata> createHttpRouteAsync(String parent, HttpRoute httpRoute, String httpRouteId) {
        CreateHttpRouteRequest request = CreateHttpRouteRequest.newBuilder().setParent(parent).setHttpRoute(httpRoute).setHttpRouteId(httpRouteId).build();
        return this.createHttpRouteAsync(request);
    }

    public final OperationFuture<HttpRoute, OperationMetadata> createHttpRouteAsync(CreateHttpRouteRequest request) {
        return this.createHttpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHttpRouteRequest, HttpRoute, OperationMetadata> createHttpRouteOperationCallable() {
        return this.stub.createHttpRouteOperationCallable();
    }

    public final UnaryCallable<CreateHttpRouteRequest, Operation> createHttpRouteCallable() {
        return this.stub.createHttpRouteCallable();
    }

    public final OperationFuture<HttpRoute, OperationMetadata> updateHttpRouteAsync(HttpRoute httpRoute, FieldMask updateMask) {
        UpdateHttpRouteRequest request = UpdateHttpRouteRequest.newBuilder().setHttpRoute(httpRoute).setUpdateMask(updateMask).build();
        return this.updateHttpRouteAsync(request);
    }

    public final OperationFuture<HttpRoute, OperationMetadata> updateHttpRouteAsync(UpdateHttpRouteRequest request) {
        return this.updateHttpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHttpRouteRequest, HttpRoute, OperationMetadata> updateHttpRouteOperationCallable() {
        return this.stub.updateHttpRouteOperationCallable();
    }

    public final UnaryCallable<UpdateHttpRouteRequest, Operation> updateHttpRouteCallable() {
        return this.stub.updateHttpRouteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHttpRouteAsync(HttpRouteName name) {
        DeleteHttpRouteRequest request = DeleteHttpRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHttpRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHttpRouteAsync(String name) {
        DeleteHttpRouteRequest request = DeleteHttpRouteRequest.newBuilder().setName(name).build();
        return this.deleteHttpRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHttpRouteAsync(DeleteHttpRouteRequest request) {
        return this.deleteHttpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHttpRouteRequest, Empty, OperationMetadata> deleteHttpRouteOperationCallable() {
        return this.stub.deleteHttpRouteOperationCallable();
    }

    public final UnaryCallable<DeleteHttpRouteRequest, Operation> deleteHttpRouteCallable() {
        return this.stub.deleteHttpRouteCallable();
    }

    public final ListTcpRoutesPagedResponse listTcpRoutes(LocationName parent) {
        ListTcpRoutesRequest request = ListTcpRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTcpRoutes(request);
    }

    public final ListTcpRoutesPagedResponse listTcpRoutes(String parent) {
        ListTcpRoutesRequest request = ListTcpRoutesRequest.newBuilder().setParent(parent).build();
        return this.listTcpRoutes(request);
    }

    public final ListTcpRoutesPagedResponse listTcpRoutes(ListTcpRoutesRequest request) {
        return (ListTcpRoutesPagedResponse)((Object)this.listTcpRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTcpRoutesRequest, ListTcpRoutesPagedResponse> listTcpRoutesPagedCallable() {
        return this.stub.listTcpRoutesPagedCallable();
    }

    public final UnaryCallable<ListTcpRoutesRequest, ListTcpRoutesResponse> listTcpRoutesCallable() {
        return this.stub.listTcpRoutesCallable();
    }

    public final TcpRoute getTcpRoute(TcpRouteName name) {
        GetTcpRouteRequest request = GetTcpRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTcpRoute(request);
    }

    public final TcpRoute getTcpRoute(String name) {
        GetTcpRouteRequest request = GetTcpRouteRequest.newBuilder().setName(name).build();
        return this.getTcpRoute(request);
    }

    public final TcpRoute getTcpRoute(GetTcpRouteRequest request) {
        return (TcpRoute)this.getTcpRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetTcpRouteRequest, TcpRoute> getTcpRouteCallable() {
        return this.stub.getTcpRouteCallable();
    }

    public final OperationFuture<TcpRoute, OperationMetadata> createTcpRouteAsync(LocationName parent, TcpRoute tcpRoute, String tcpRouteId) {
        CreateTcpRouteRequest request = CreateTcpRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTcpRoute(tcpRoute).setTcpRouteId(tcpRouteId).build();
        return this.createTcpRouteAsync(request);
    }

    public final OperationFuture<TcpRoute, OperationMetadata> createTcpRouteAsync(String parent, TcpRoute tcpRoute, String tcpRouteId) {
        CreateTcpRouteRequest request = CreateTcpRouteRequest.newBuilder().setParent(parent).setTcpRoute(tcpRoute).setTcpRouteId(tcpRouteId).build();
        return this.createTcpRouteAsync(request);
    }

    public final OperationFuture<TcpRoute, OperationMetadata> createTcpRouteAsync(CreateTcpRouteRequest request) {
        return this.createTcpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTcpRouteRequest, TcpRoute, OperationMetadata> createTcpRouteOperationCallable() {
        return this.stub.createTcpRouteOperationCallable();
    }

    public final UnaryCallable<CreateTcpRouteRequest, Operation> createTcpRouteCallable() {
        return this.stub.createTcpRouteCallable();
    }

    public final OperationFuture<TcpRoute, OperationMetadata> updateTcpRouteAsync(TcpRoute tcpRoute, FieldMask updateMask) {
        UpdateTcpRouteRequest request = UpdateTcpRouteRequest.newBuilder().setTcpRoute(tcpRoute).setUpdateMask(updateMask).build();
        return this.updateTcpRouteAsync(request);
    }

    public final OperationFuture<TcpRoute, OperationMetadata> updateTcpRouteAsync(UpdateTcpRouteRequest request) {
        return this.updateTcpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTcpRouteRequest, TcpRoute, OperationMetadata> updateTcpRouteOperationCallable() {
        return this.stub.updateTcpRouteOperationCallable();
    }

    public final UnaryCallable<UpdateTcpRouteRequest, Operation> updateTcpRouteCallable() {
        return this.stub.updateTcpRouteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTcpRouteAsync(TcpRouteName name) {
        DeleteTcpRouteRequest request = DeleteTcpRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTcpRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTcpRouteAsync(String name) {
        DeleteTcpRouteRequest request = DeleteTcpRouteRequest.newBuilder().setName(name).build();
        return this.deleteTcpRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTcpRouteAsync(DeleteTcpRouteRequest request) {
        return this.deleteTcpRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTcpRouteRequest, Empty, OperationMetadata> deleteTcpRouteOperationCallable() {
        return this.stub.deleteTcpRouteOperationCallable();
    }

    public final UnaryCallable<DeleteTcpRouteRequest, Operation> deleteTcpRouteCallable() {
        return this.stub.deleteTcpRouteCallable();
    }

    public final ListTlsRoutesPagedResponse listTlsRoutes(LocationName parent) {
        ListTlsRoutesRequest request = ListTlsRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTlsRoutes(request);
    }

    public final ListTlsRoutesPagedResponse listTlsRoutes(String parent) {
        ListTlsRoutesRequest request = ListTlsRoutesRequest.newBuilder().setParent(parent).build();
        return this.listTlsRoutes(request);
    }

    public final ListTlsRoutesPagedResponse listTlsRoutes(ListTlsRoutesRequest request) {
        return (ListTlsRoutesPagedResponse)((Object)this.listTlsRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTlsRoutesRequest, ListTlsRoutesPagedResponse> listTlsRoutesPagedCallable() {
        return this.stub.listTlsRoutesPagedCallable();
    }

    public final UnaryCallable<ListTlsRoutesRequest, ListTlsRoutesResponse> listTlsRoutesCallable() {
        return this.stub.listTlsRoutesCallable();
    }

    public final TlsRoute getTlsRoute(TlsRouteName name) {
        GetTlsRouteRequest request = GetTlsRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTlsRoute(request);
    }

    public final TlsRoute getTlsRoute(String name) {
        GetTlsRouteRequest request = GetTlsRouteRequest.newBuilder().setName(name).build();
        return this.getTlsRoute(request);
    }

    public final TlsRoute getTlsRoute(GetTlsRouteRequest request) {
        return (TlsRoute)this.getTlsRouteCallable().call((Object)request);
    }

    public final UnaryCallable<GetTlsRouteRequest, TlsRoute> getTlsRouteCallable() {
        return this.stub.getTlsRouteCallable();
    }

    public final OperationFuture<TlsRoute, OperationMetadata> createTlsRouteAsync(LocationName parent, TlsRoute tlsRoute, String tlsRouteId) {
        CreateTlsRouteRequest request = CreateTlsRouteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTlsRoute(tlsRoute).setTlsRouteId(tlsRouteId).build();
        return this.createTlsRouteAsync(request);
    }

    public final OperationFuture<TlsRoute, OperationMetadata> createTlsRouteAsync(String parent, TlsRoute tlsRoute, String tlsRouteId) {
        CreateTlsRouteRequest request = CreateTlsRouteRequest.newBuilder().setParent(parent).setTlsRoute(tlsRoute).setTlsRouteId(tlsRouteId).build();
        return this.createTlsRouteAsync(request);
    }

    public final OperationFuture<TlsRoute, OperationMetadata> createTlsRouteAsync(CreateTlsRouteRequest request) {
        return this.createTlsRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTlsRouteRequest, TlsRoute, OperationMetadata> createTlsRouteOperationCallable() {
        return this.stub.createTlsRouteOperationCallable();
    }

    public final UnaryCallable<CreateTlsRouteRequest, Operation> createTlsRouteCallable() {
        return this.stub.createTlsRouteCallable();
    }

    public final OperationFuture<TlsRoute, OperationMetadata> updateTlsRouteAsync(TlsRoute tlsRoute, FieldMask updateMask) {
        UpdateTlsRouteRequest request = UpdateTlsRouteRequest.newBuilder().setTlsRoute(tlsRoute).setUpdateMask(updateMask).build();
        return this.updateTlsRouteAsync(request);
    }

    public final OperationFuture<TlsRoute, OperationMetadata> updateTlsRouteAsync(UpdateTlsRouteRequest request) {
        return this.updateTlsRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTlsRouteRequest, TlsRoute, OperationMetadata> updateTlsRouteOperationCallable() {
        return this.stub.updateTlsRouteOperationCallable();
    }

    public final UnaryCallable<UpdateTlsRouteRequest, Operation> updateTlsRouteCallable() {
        return this.stub.updateTlsRouteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTlsRouteAsync(TlsRouteName name) {
        DeleteTlsRouteRequest request = DeleteTlsRouteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTlsRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTlsRouteAsync(String name) {
        DeleteTlsRouteRequest request = DeleteTlsRouteRequest.newBuilder().setName(name).build();
        return this.deleteTlsRouteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTlsRouteAsync(DeleteTlsRouteRequest request) {
        return this.deleteTlsRouteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTlsRouteRequest, Empty, OperationMetadata> deleteTlsRouteOperationCallable() {
        return this.stub.deleteTlsRouteOperationCallable();
    }

    public final UnaryCallable<DeleteTlsRouteRequest, Operation> deleteTlsRouteCallable() {
        return this.stub.deleteTlsRouteCallable();
    }

    public final ListServiceBindingsPagedResponse listServiceBindings(LocationName parent) {
        ListServiceBindingsRequest request = ListServiceBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceBindings(request);
    }

    public final ListServiceBindingsPagedResponse listServiceBindings(String parent) {
        ListServiceBindingsRequest request = ListServiceBindingsRequest.newBuilder().setParent(parent).build();
        return this.listServiceBindings(request);
    }

    public final ListServiceBindingsPagedResponse listServiceBindings(ListServiceBindingsRequest request) {
        return (ListServiceBindingsPagedResponse)((Object)this.listServiceBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceBindingsRequest, ListServiceBindingsPagedResponse> listServiceBindingsPagedCallable() {
        return this.stub.listServiceBindingsPagedCallable();
    }

    public final UnaryCallable<ListServiceBindingsRequest, ListServiceBindingsResponse> listServiceBindingsCallable() {
        return this.stub.listServiceBindingsCallable();
    }

    public final ServiceBinding getServiceBinding(ServiceBindingName name) {
        GetServiceBindingRequest request = GetServiceBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceBinding(request);
    }

    public final ServiceBinding getServiceBinding(String name) {
        GetServiceBindingRequest request = GetServiceBindingRequest.newBuilder().setName(name).build();
        return this.getServiceBinding(request);
    }

    public final ServiceBinding getServiceBinding(GetServiceBindingRequest request) {
        return (ServiceBinding)this.getServiceBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceBindingRequest, ServiceBinding> getServiceBindingCallable() {
        return this.stub.getServiceBindingCallable();
    }

    public final OperationFuture<ServiceBinding, OperationMetadata> createServiceBindingAsync(LocationName parent, ServiceBinding serviceBinding, String serviceBindingId) {
        CreateServiceBindingRequest request = CreateServiceBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceBinding(serviceBinding).setServiceBindingId(serviceBindingId).build();
        return this.createServiceBindingAsync(request);
    }

    public final OperationFuture<ServiceBinding, OperationMetadata> createServiceBindingAsync(String parent, ServiceBinding serviceBinding, String serviceBindingId) {
        CreateServiceBindingRequest request = CreateServiceBindingRequest.newBuilder().setParent(parent).setServiceBinding(serviceBinding).setServiceBindingId(serviceBindingId).build();
        return this.createServiceBindingAsync(request);
    }

    public final OperationFuture<ServiceBinding, OperationMetadata> createServiceBindingAsync(CreateServiceBindingRequest request) {
        return this.createServiceBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceBindingRequest, ServiceBinding, OperationMetadata> createServiceBindingOperationCallable() {
        return this.stub.createServiceBindingOperationCallable();
    }

    public final UnaryCallable<CreateServiceBindingRequest, Operation> createServiceBindingCallable() {
        return this.stub.createServiceBindingCallable();
    }

    public final OperationFuture<ServiceBinding, OperationMetadata> updateServiceBindingAsync(ServiceBinding serviceBinding, FieldMask updateMask) {
        UpdateServiceBindingRequest request = UpdateServiceBindingRequest.newBuilder().setServiceBinding(serviceBinding).setUpdateMask(updateMask).build();
        return this.updateServiceBindingAsync(request);
    }

    public final OperationFuture<ServiceBinding, OperationMetadata> updateServiceBindingAsync(UpdateServiceBindingRequest request) {
        return this.updateServiceBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceBindingRequest, ServiceBinding, OperationMetadata> updateServiceBindingOperationCallable() {
        return this.stub.updateServiceBindingOperationCallable();
    }

    public final UnaryCallable<UpdateServiceBindingRequest, Operation> updateServiceBindingCallable() {
        return this.stub.updateServiceBindingCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceBindingAsync(ServiceBindingName name) {
        DeleteServiceBindingRequest request = DeleteServiceBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceBindingAsync(String name) {
        DeleteServiceBindingRequest request = DeleteServiceBindingRequest.newBuilder().setName(name).build();
        return this.deleteServiceBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceBindingAsync(DeleteServiceBindingRequest request) {
        return this.deleteServiceBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceBindingRequest, Empty, OperationMetadata> deleteServiceBindingOperationCallable() {
        return this.stub.deleteServiceBindingOperationCallable();
    }

    public final UnaryCallable<DeleteServiceBindingRequest, Operation> deleteServiceBindingCallable() {
        return this.stub.deleteServiceBindingCallable();
    }

    public final ListMeshesPagedResponse listMeshes(LocationName parent) {
        ListMeshesRequest request = ListMeshesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMeshes(request);
    }

    public final ListMeshesPagedResponse listMeshes(String parent) {
        ListMeshesRequest request = ListMeshesRequest.newBuilder().setParent(parent).build();
        return this.listMeshes(request);
    }

    public final ListMeshesPagedResponse listMeshes(ListMeshesRequest request) {
        return (ListMeshesPagedResponse)((Object)this.listMeshesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMeshesRequest, ListMeshesPagedResponse> listMeshesPagedCallable() {
        return this.stub.listMeshesPagedCallable();
    }

    public final UnaryCallable<ListMeshesRequest, ListMeshesResponse> listMeshesCallable() {
        return this.stub.listMeshesCallable();
    }

    public final Mesh getMesh(MeshName name) {
        GetMeshRequest request = GetMeshRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMesh(request);
    }

    public final Mesh getMesh(String name) {
        GetMeshRequest request = GetMeshRequest.newBuilder().setName(name).build();
        return this.getMesh(request);
    }

    public final Mesh getMesh(GetMeshRequest request) {
        return (Mesh)this.getMeshCallable().call((Object)request);
    }

    public final UnaryCallable<GetMeshRequest, Mesh> getMeshCallable() {
        return this.stub.getMeshCallable();
    }

    public final OperationFuture<Mesh, OperationMetadata> createMeshAsync(LocationName parent, Mesh mesh, String meshId) {
        CreateMeshRequest request = CreateMeshRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMesh(mesh).setMeshId(meshId).build();
        return this.createMeshAsync(request);
    }

    public final OperationFuture<Mesh, OperationMetadata> createMeshAsync(String parent, Mesh mesh, String meshId) {
        CreateMeshRequest request = CreateMeshRequest.newBuilder().setParent(parent).setMesh(mesh).setMeshId(meshId).build();
        return this.createMeshAsync(request);
    }

    public final OperationFuture<Mesh, OperationMetadata> createMeshAsync(CreateMeshRequest request) {
        return this.createMeshOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMeshRequest, Mesh, OperationMetadata> createMeshOperationCallable() {
        return this.stub.createMeshOperationCallable();
    }

    public final UnaryCallable<CreateMeshRequest, Operation> createMeshCallable() {
        return this.stub.createMeshCallable();
    }

    public final OperationFuture<Mesh, OperationMetadata> updateMeshAsync(Mesh mesh, FieldMask updateMask) {
        UpdateMeshRequest request = UpdateMeshRequest.newBuilder().setMesh(mesh).setUpdateMask(updateMask).build();
        return this.updateMeshAsync(request);
    }

    public final OperationFuture<Mesh, OperationMetadata> updateMeshAsync(UpdateMeshRequest request) {
        return this.updateMeshOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMeshRequest, Mesh, OperationMetadata> updateMeshOperationCallable() {
        return this.stub.updateMeshOperationCallable();
    }

    public final UnaryCallable<UpdateMeshRequest, Operation> updateMeshCallable() {
        return this.stub.updateMeshCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMeshAsync(MeshName name) {
        DeleteMeshRequest request = DeleteMeshRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMeshAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMeshAsync(String name) {
        DeleteMeshRequest request = DeleteMeshRequest.newBuilder().setName(name).build();
        return this.deleteMeshAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMeshAsync(DeleteMeshRequest request) {
        return this.deleteMeshOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMeshRequest, Empty, OperationMetadata> deleteMeshOperationCallable() {
        return this.stub.deleteMeshOperationCallable();
    }

    public final UnaryCallable<DeleteMeshRequest, Operation> deleteMeshCallable() {
        return this.stub.deleteMeshCallable();
    }

    public final ListServiceLbPoliciesPagedResponse listServiceLbPolicies(LocationName parent) {
        ListServiceLbPoliciesRequest request = ListServiceLbPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceLbPolicies(request);
    }

    public final ListServiceLbPoliciesPagedResponse listServiceLbPolicies(String parent) {
        ListServiceLbPoliciesRequest request = ListServiceLbPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listServiceLbPolicies(request);
    }

    public final ListServiceLbPoliciesPagedResponse listServiceLbPolicies(ListServiceLbPoliciesRequest request) {
        return (ListServiceLbPoliciesPagedResponse)((Object)this.listServiceLbPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceLbPoliciesRequest, ListServiceLbPoliciesPagedResponse> listServiceLbPoliciesPagedCallable() {
        return this.stub.listServiceLbPoliciesPagedCallable();
    }

    public final UnaryCallable<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse> listServiceLbPoliciesCallable() {
        return this.stub.listServiceLbPoliciesCallable();
    }

    public final ServiceLbPolicy getServiceLbPolicy(ServiceLbPolicyName name) {
        GetServiceLbPolicyRequest request = GetServiceLbPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceLbPolicy(request);
    }

    public final ServiceLbPolicy getServiceLbPolicy(String name) {
        GetServiceLbPolicyRequest request = GetServiceLbPolicyRequest.newBuilder().setName(name).build();
        return this.getServiceLbPolicy(request);
    }

    public final ServiceLbPolicy getServiceLbPolicy(GetServiceLbPolicyRequest request) {
        return (ServiceLbPolicy)this.getServiceLbPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceLbPolicyRequest, ServiceLbPolicy> getServiceLbPolicyCallable() {
        return this.stub.getServiceLbPolicyCallable();
    }

    public final OperationFuture<ServiceLbPolicy, OperationMetadata> createServiceLbPolicyAsync(LocationName parent, ServiceLbPolicy serviceLbPolicy, String serviceLbPolicyId) {
        CreateServiceLbPolicyRequest request = CreateServiceLbPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceLbPolicy(serviceLbPolicy).setServiceLbPolicyId(serviceLbPolicyId).build();
        return this.createServiceLbPolicyAsync(request);
    }

    public final OperationFuture<ServiceLbPolicy, OperationMetadata> createServiceLbPolicyAsync(String parent, ServiceLbPolicy serviceLbPolicy, String serviceLbPolicyId) {
        CreateServiceLbPolicyRequest request = CreateServiceLbPolicyRequest.newBuilder().setParent(parent).setServiceLbPolicy(serviceLbPolicy).setServiceLbPolicyId(serviceLbPolicyId).build();
        return this.createServiceLbPolicyAsync(request);
    }

    public final OperationFuture<ServiceLbPolicy, OperationMetadata> createServiceLbPolicyAsync(CreateServiceLbPolicyRequest request) {
        return this.createServiceLbPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceLbPolicyRequest, ServiceLbPolicy, OperationMetadata> createServiceLbPolicyOperationCallable() {
        return this.stub.createServiceLbPolicyOperationCallable();
    }

    public final UnaryCallable<CreateServiceLbPolicyRequest, Operation> createServiceLbPolicyCallable() {
        return this.stub.createServiceLbPolicyCallable();
    }

    public final OperationFuture<ServiceLbPolicy, OperationMetadata> updateServiceLbPolicyAsync(ServiceLbPolicy serviceLbPolicy, FieldMask updateMask) {
        UpdateServiceLbPolicyRequest request = UpdateServiceLbPolicyRequest.newBuilder().setServiceLbPolicy(serviceLbPolicy).setUpdateMask(updateMask).build();
        return this.updateServiceLbPolicyAsync(request);
    }

    public final OperationFuture<ServiceLbPolicy, OperationMetadata> updateServiceLbPolicyAsync(UpdateServiceLbPolicyRequest request) {
        return this.updateServiceLbPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceLbPolicyRequest, ServiceLbPolicy, OperationMetadata> updateServiceLbPolicyOperationCallable() {
        return this.stub.updateServiceLbPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateServiceLbPolicyRequest, Operation> updateServiceLbPolicyCallable() {
        return this.stub.updateServiceLbPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceLbPolicyAsync(ServiceLbPolicyName name) {
        DeleteServiceLbPolicyRequest request = DeleteServiceLbPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceLbPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceLbPolicyAsync(String name) {
        DeleteServiceLbPolicyRequest request = DeleteServiceLbPolicyRequest.newBuilder().setName(name).build();
        return this.deleteServiceLbPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceLbPolicyAsync(DeleteServiceLbPolicyRequest request) {
        return this.deleteServiceLbPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceLbPolicyRequest, Empty, OperationMetadata> deleteServiceLbPolicyOperationCallable() {
        return this.stub.deleteServiceLbPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteServiceLbPolicyRequest, Operation> deleteServiceLbPolicyCallable() {
        return this.stub.deleteServiceLbPolicyCallable();
    }

    public final GatewayRouteView getGatewayRouteView(GatewayRouteViewName name) {
        GetGatewayRouteViewRequest request = GetGatewayRouteViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGatewayRouteView(request);
    }

    public final GatewayRouteView getGatewayRouteView(String name) {
        GetGatewayRouteViewRequest request = GetGatewayRouteViewRequest.newBuilder().setName(name).build();
        return this.getGatewayRouteView(request);
    }

    public final GatewayRouteView getGatewayRouteView(GetGatewayRouteViewRequest request) {
        return (GatewayRouteView)this.getGatewayRouteViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetGatewayRouteViewRequest, GatewayRouteView> getGatewayRouteViewCallable() {
        return this.stub.getGatewayRouteViewCallable();
    }

    public final MeshRouteView getMeshRouteView(MeshRouteViewName name) {
        GetMeshRouteViewRequest request = GetMeshRouteViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMeshRouteView(request);
    }

    public final MeshRouteView getMeshRouteView(String name) {
        GetMeshRouteViewRequest request = GetMeshRouteViewRequest.newBuilder().setName(name).build();
        return this.getMeshRouteView(request);
    }

    public final MeshRouteView getMeshRouteView(GetMeshRouteViewRequest request) {
        return (MeshRouteView)this.getMeshRouteViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetMeshRouteViewRequest, MeshRouteView> getMeshRouteViewCallable() {
        return this.stub.getMeshRouteViewCallable();
    }

    public final ListGatewayRouteViewsPagedResponse listGatewayRouteViews(GatewayName parent) {
        ListGatewayRouteViewsRequest request = ListGatewayRouteViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGatewayRouteViews(request);
    }

    public final ListGatewayRouteViewsPagedResponse listGatewayRouteViews(String parent) {
        ListGatewayRouteViewsRequest request = ListGatewayRouteViewsRequest.newBuilder().setParent(parent).build();
        return this.listGatewayRouteViews(request);
    }

    public final ListGatewayRouteViewsPagedResponse listGatewayRouteViews(ListGatewayRouteViewsRequest request) {
        return (ListGatewayRouteViewsPagedResponse)((Object)this.listGatewayRouteViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGatewayRouteViewsRequest, ListGatewayRouteViewsPagedResponse> listGatewayRouteViewsPagedCallable() {
        return this.stub.listGatewayRouteViewsPagedCallable();
    }

    public final UnaryCallable<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse> listGatewayRouteViewsCallable() {
        return this.stub.listGatewayRouteViewsCallable();
    }

    public final ListMeshRouteViewsPagedResponse listMeshRouteViews(MeshName parent) {
        ListMeshRouteViewsRequest request = ListMeshRouteViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMeshRouteViews(request);
    }

    public final ListMeshRouteViewsPagedResponse listMeshRouteViews(String parent) {
        ListMeshRouteViewsRequest request = ListMeshRouteViewsRequest.newBuilder().setParent(parent).build();
        return this.listMeshRouteViews(request);
    }

    public final ListMeshRouteViewsPagedResponse listMeshRouteViews(ListMeshRouteViewsRequest request) {
        return (ListMeshRouteViewsPagedResponse)((Object)this.listMeshRouteViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMeshRouteViewsRequest, ListMeshRouteViewsPagedResponse> listMeshRouteViewsPagedCallable() {
        return this.stub.listMeshRouteViewsPagedCallable();
    }

    public final UnaryCallable<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse> listMeshRouteViewsCallable() {
        return this.stub.listMeshRouteViewsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMeshRouteViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView, ListMeshRouteViewsPage, ListMeshRouteViewsFixedSizeCollection> {
        private ListMeshRouteViewsFixedSizeCollection(List<ListMeshRouteViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMeshRouteViewsFixedSizeCollection createEmptyCollection() {
            return new ListMeshRouteViewsFixedSizeCollection(null, 0);
        }

        protected ListMeshRouteViewsFixedSizeCollection createCollection(List<ListMeshRouteViewsPage> pages, int collectionSize) {
            return new ListMeshRouteViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMeshRouteViewsPage
    extends AbstractPage<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView, ListMeshRouteViewsPage> {
        private ListMeshRouteViewsPage(PageContext<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView> context, ListMeshRouteViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListMeshRouteViewsPage createEmptyPage() {
            return new ListMeshRouteViewsPage(null, null);
        }

        protected ListMeshRouteViewsPage createPage(PageContext<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView> context, ListMeshRouteViewsResponse response) {
            return new ListMeshRouteViewsPage(context, response);
        }

        public ApiFuture<ListMeshRouteViewsPage> createPageAsync(PageContext<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView> context, ApiFuture<ListMeshRouteViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMeshRouteViewsPagedResponse
    extends AbstractPagedListResponse<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView, ListMeshRouteViewsPage, ListMeshRouteViewsFixedSizeCollection> {
        public static ApiFuture<ListMeshRouteViewsPagedResponse> createAsync(PageContext<ListMeshRouteViewsRequest, ListMeshRouteViewsResponse, MeshRouteView> context, ApiFuture<ListMeshRouteViewsResponse> futureResponse) {
            ApiFuture<ListMeshRouteViewsPage> futurePage = ListMeshRouteViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMeshRouteViewsPagedResponse((ListMeshRouteViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMeshRouteViewsPagedResponse(ListMeshRouteViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMeshRouteViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGatewayRouteViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView, ListGatewayRouteViewsPage, ListGatewayRouteViewsFixedSizeCollection> {
        private ListGatewayRouteViewsFixedSizeCollection(List<ListGatewayRouteViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGatewayRouteViewsFixedSizeCollection createEmptyCollection() {
            return new ListGatewayRouteViewsFixedSizeCollection(null, 0);
        }

        protected ListGatewayRouteViewsFixedSizeCollection createCollection(List<ListGatewayRouteViewsPage> pages, int collectionSize) {
            return new ListGatewayRouteViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGatewayRouteViewsPage
    extends AbstractPage<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView, ListGatewayRouteViewsPage> {
        private ListGatewayRouteViewsPage(PageContext<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView> context, ListGatewayRouteViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListGatewayRouteViewsPage createEmptyPage() {
            return new ListGatewayRouteViewsPage(null, null);
        }

        protected ListGatewayRouteViewsPage createPage(PageContext<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView> context, ListGatewayRouteViewsResponse response) {
            return new ListGatewayRouteViewsPage(context, response);
        }

        public ApiFuture<ListGatewayRouteViewsPage> createPageAsync(PageContext<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView> context, ApiFuture<ListGatewayRouteViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGatewayRouteViewsPagedResponse
    extends AbstractPagedListResponse<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView, ListGatewayRouteViewsPage, ListGatewayRouteViewsFixedSizeCollection> {
        public static ApiFuture<ListGatewayRouteViewsPagedResponse> createAsync(PageContext<ListGatewayRouteViewsRequest, ListGatewayRouteViewsResponse, GatewayRouteView> context, ApiFuture<ListGatewayRouteViewsResponse> futureResponse) {
            ApiFuture<ListGatewayRouteViewsPage> futurePage = ListGatewayRouteViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGatewayRouteViewsPagedResponse((ListGatewayRouteViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGatewayRouteViewsPagedResponse(ListGatewayRouteViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGatewayRouteViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceLbPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy, ListServiceLbPoliciesPage, ListServiceLbPoliciesFixedSizeCollection> {
        private ListServiceLbPoliciesFixedSizeCollection(List<ListServiceLbPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceLbPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListServiceLbPoliciesFixedSizeCollection(null, 0);
        }

        protected ListServiceLbPoliciesFixedSizeCollection createCollection(List<ListServiceLbPoliciesPage> pages, int collectionSize) {
            return new ListServiceLbPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceLbPoliciesPage
    extends AbstractPage<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy, ListServiceLbPoliciesPage> {
        private ListServiceLbPoliciesPage(PageContext<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy> context, ListServiceLbPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceLbPoliciesPage createEmptyPage() {
            return new ListServiceLbPoliciesPage(null, null);
        }

        protected ListServiceLbPoliciesPage createPage(PageContext<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy> context, ListServiceLbPoliciesResponse response) {
            return new ListServiceLbPoliciesPage(context, response);
        }

        public ApiFuture<ListServiceLbPoliciesPage> createPageAsync(PageContext<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy> context, ApiFuture<ListServiceLbPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceLbPoliciesPagedResponse
    extends AbstractPagedListResponse<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy, ListServiceLbPoliciesPage, ListServiceLbPoliciesFixedSizeCollection> {
        public static ApiFuture<ListServiceLbPoliciesPagedResponse> createAsync(PageContext<ListServiceLbPoliciesRequest, ListServiceLbPoliciesResponse, ServiceLbPolicy> context, ApiFuture<ListServiceLbPoliciesResponse> futureResponse) {
            ApiFuture<ListServiceLbPoliciesPage> futurePage = ListServiceLbPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceLbPoliciesPagedResponse((ListServiceLbPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceLbPoliciesPagedResponse(ListServiceLbPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceLbPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMeshesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMeshesRequest, ListMeshesResponse, Mesh, ListMeshesPage, ListMeshesFixedSizeCollection> {
        private ListMeshesFixedSizeCollection(List<ListMeshesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMeshesFixedSizeCollection createEmptyCollection() {
            return new ListMeshesFixedSizeCollection(null, 0);
        }

        protected ListMeshesFixedSizeCollection createCollection(List<ListMeshesPage> pages, int collectionSize) {
            return new ListMeshesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMeshesPage
    extends AbstractPage<ListMeshesRequest, ListMeshesResponse, Mesh, ListMeshesPage> {
        private ListMeshesPage(PageContext<ListMeshesRequest, ListMeshesResponse, Mesh> context, ListMeshesResponse response) {
            super(context, (Object)response);
        }

        private static ListMeshesPage createEmptyPage() {
            return new ListMeshesPage(null, null);
        }

        protected ListMeshesPage createPage(PageContext<ListMeshesRequest, ListMeshesResponse, Mesh> context, ListMeshesResponse response) {
            return new ListMeshesPage(context, response);
        }

        public ApiFuture<ListMeshesPage> createPageAsync(PageContext<ListMeshesRequest, ListMeshesResponse, Mesh> context, ApiFuture<ListMeshesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMeshesPagedResponse
    extends AbstractPagedListResponse<ListMeshesRequest, ListMeshesResponse, Mesh, ListMeshesPage, ListMeshesFixedSizeCollection> {
        public static ApiFuture<ListMeshesPagedResponse> createAsync(PageContext<ListMeshesRequest, ListMeshesResponse, Mesh> context, ApiFuture<ListMeshesResponse> futureResponse) {
            ApiFuture<ListMeshesPage> futurePage = ListMeshesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMeshesPagedResponse((ListMeshesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMeshesPagedResponse(ListMeshesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMeshesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding, ListServiceBindingsPage, ListServiceBindingsFixedSizeCollection> {
        private ListServiceBindingsFixedSizeCollection(List<ListServiceBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceBindingsFixedSizeCollection createEmptyCollection() {
            return new ListServiceBindingsFixedSizeCollection(null, 0);
        }

        protected ListServiceBindingsFixedSizeCollection createCollection(List<ListServiceBindingsPage> pages, int collectionSize) {
            return new ListServiceBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceBindingsPage
    extends AbstractPage<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding, ListServiceBindingsPage> {
        private ListServiceBindingsPage(PageContext<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding> context, ListServiceBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceBindingsPage createEmptyPage() {
            return new ListServiceBindingsPage(null, null);
        }

        protected ListServiceBindingsPage createPage(PageContext<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding> context, ListServiceBindingsResponse response) {
            return new ListServiceBindingsPage(context, response);
        }

        public ApiFuture<ListServiceBindingsPage> createPageAsync(PageContext<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding> context, ApiFuture<ListServiceBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceBindingsPagedResponse
    extends AbstractPagedListResponse<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding, ListServiceBindingsPage, ListServiceBindingsFixedSizeCollection> {
        public static ApiFuture<ListServiceBindingsPagedResponse> createAsync(PageContext<ListServiceBindingsRequest, ListServiceBindingsResponse, ServiceBinding> context, ApiFuture<ListServiceBindingsResponse> futureResponse) {
            ApiFuture<ListServiceBindingsPage> futurePage = ListServiceBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceBindingsPagedResponse((ListServiceBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceBindingsPagedResponse(ListServiceBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTlsRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute, ListTlsRoutesPage, ListTlsRoutesFixedSizeCollection> {
        private ListTlsRoutesFixedSizeCollection(List<ListTlsRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTlsRoutesFixedSizeCollection createEmptyCollection() {
            return new ListTlsRoutesFixedSizeCollection(null, 0);
        }

        protected ListTlsRoutesFixedSizeCollection createCollection(List<ListTlsRoutesPage> pages, int collectionSize) {
            return new ListTlsRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTlsRoutesPage
    extends AbstractPage<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute, ListTlsRoutesPage> {
        private ListTlsRoutesPage(PageContext<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute> context, ListTlsRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListTlsRoutesPage createEmptyPage() {
            return new ListTlsRoutesPage(null, null);
        }

        protected ListTlsRoutesPage createPage(PageContext<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute> context, ListTlsRoutesResponse response) {
            return new ListTlsRoutesPage(context, response);
        }

        public ApiFuture<ListTlsRoutesPage> createPageAsync(PageContext<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute> context, ApiFuture<ListTlsRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTlsRoutesPagedResponse
    extends AbstractPagedListResponse<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute, ListTlsRoutesPage, ListTlsRoutesFixedSizeCollection> {
        public static ApiFuture<ListTlsRoutesPagedResponse> createAsync(PageContext<ListTlsRoutesRequest, ListTlsRoutesResponse, TlsRoute> context, ApiFuture<ListTlsRoutesResponse> futureResponse) {
            ApiFuture<ListTlsRoutesPage> futurePage = ListTlsRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTlsRoutesPagedResponse((ListTlsRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTlsRoutesPagedResponse(ListTlsRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTlsRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTcpRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute, ListTcpRoutesPage, ListTcpRoutesFixedSizeCollection> {
        private ListTcpRoutesFixedSizeCollection(List<ListTcpRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTcpRoutesFixedSizeCollection createEmptyCollection() {
            return new ListTcpRoutesFixedSizeCollection(null, 0);
        }

        protected ListTcpRoutesFixedSizeCollection createCollection(List<ListTcpRoutesPage> pages, int collectionSize) {
            return new ListTcpRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTcpRoutesPage
    extends AbstractPage<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute, ListTcpRoutesPage> {
        private ListTcpRoutesPage(PageContext<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute> context, ListTcpRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListTcpRoutesPage createEmptyPage() {
            return new ListTcpRoutesPage(null, null);
        }

        protected ListTcpRoutesPage createPage(PageContext<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute> context, ListTcpRoutesResponse response) {
            return new ListTcpRoutesPage(context, response);
        }

        public ApiFuture<ListTcpRoutesPage> createPageAsync(PageContext<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute> context, ApiFuture<ListTcpRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTcpRoutesPagedResponse
    extends AbstractPagedListResponse<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute, ListTcpRoutesPage, ListTcpRoutesFixedSizeCollection> {
        public static ApiFuture<ListTcpRoutesPagedResponse> createAsync(PageContext<ListTcpRoutesRequest, ListTcpRoutesResponse, TcpRoute> context, ApiFuture<ListTcpRoutesResponse> futureResponse) {
            ApiFuture<ListTcpRoutesPage> futurePage = ListTcpRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTcpRoutesPagedResponse((ListTcpRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTcpRoutesPagedResponse(ListTcpRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTcpRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHttpRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute, ListHttpRoutesPage, ListHttpRoutesFixedSizeCollection> {
        private ListHttpRoutesFixedSizeCollection(List<ListHttpRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHttpRoutesFixedSizeCollection createEmptyCollection() {
            return new ListHttpRoutesFixedSizeCollection(null, 0);
        }

        protected ListHttpRoutesFixedSizeCollection createCollection(List<ListHttpRoutesPage> pages, int collectionSize) {
            return new ListHttpRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHttpRoutesPage
    extends AbstractPage<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute, ListHttpRoutesPage> {
        private ListHttpRoutesPage(PageContext<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute> context, ListHttpRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListHttpRoutesPage createEmptyPage() {
            return new ListHttpRoutesPage(null, null);
        }

        protected ListHttpRoutesPage createPage(PageContext<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute> context, ListHttpRoutesResponse response) {
            return new ListHttpRoutesPage(context, response);
        }

        public ApiFuture<ListHttpRoutesPage> createPageAsync(PageContext<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute> context, ApiFuture<ListHttpRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHttpRoutesPagedResponse
    extends AbstractPagedListResponse<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute, ListHttpRoutesPage, ListHttpRoutesFixedSizeCollection> {
        public static ApiFuture<ListHttpRoutesPagedResponse> createAsync(PageContext<ListHttpRoutesRequest, ListHttpRoutesResponse, HttpRoute> context, ApiFuture<ListHttpRoutesResponse> futureResponse) {
            ApiFuture<ListHttpRoutesPage> futurePage = ListHttpRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHttpRoutesPagedResponse((ListHttpRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHttpRoutesPagedResponse(ListHttpRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHttpRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGrpcRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute, ListGrpcRoutesPage, ListGrpcRoutesFixedSizeCollection> {
        private ListGrpcRoutesFixedSizeCollection(List<ListGrpcRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGrpcRoutesFixedSizeCollection createEmptyCollection() {
            return new ListGrpcRoutesFixedSizeCollection(null, 0);
        }

        protected ListGrpcRoutesFixedSizeCollection createCollection(List<ListGrpcRoutesPage> pages, int collectionSize) {
            return new ListGrpcRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGrpcRoutesPage
    extends AbstractPage<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute, ListGrpcRoutesPage> {
        private ListGrpcRoutesPage(PageContext<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute> context, ListGrpcRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListGrpcRoutesPage createEmptyPage() {
            return new ListGrpcRoutesPage(null, null);
        }

        protected ListGrpcRoutesPage createPage(PageContext<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute> context, ListGrpcRoutesResponse response) {
            return new ListGrpcRoutesPage(context, response);
        }

        public ApiFuture<ListGrpcRoutesPage> createPageAsync(PageContext<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute> context, ApiFuture<ListGrpcRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGrpcRoutesPagedResponse
    extends AbstractPagedListResponse<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute, ListGrpcRoutesPage, ListGrpcRoutesFixedSizeCollection> {
        public static ApiFuture<ListGrpcRoutesPagedResponse> createAsync(PageContext<ListGrpcRoutesRequest, ListGrpcRoutesResponse, GrpcRoute> context, ApiFuture<ListGrpcRoutesResponse> futureResponse) {
            ApiFuture<ListGrpcRoutesPage> futurePage = ListGrpcRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGrpcRoutesPagedResponse((ListGrpcRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGrpcRoutesPagedResponse(ListGrpcRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGrpcRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGatewaysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage, ListGatewaysFixedSizeCollection> {
        private ListGatewaysFixedSizeCollection(List<ListGatewaysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGatewaysFixedSizeCollection createEmptyCollection() {
            return new ListGatewaysFixedSizeCollection(null, 0);
        }

        protected ListGatewaysFixedSizeCollection createCollection(List<ListGatewaysPage> pages, int collectionSize) {
            return new ListGatewaysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGatewaysPage
    extends AbstractPage<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage> {
        private ListGatewaysPage(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ListGatewaysResponse response) {
            super(context, (Object)response);
        }

        private static ListGatewaysPage createEmptyPage() {
            return new ListGatewaysPage(null, null);
        }

        protected ListGatewaysPage createPage(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ListGatewaysResponse response) {
            return new ListGatewaysPage(context, response);
        }

        public ApiFuture<ListGatewaysPage> createPageAsync(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ApiFuture<ListGatewaysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGatewaysPagedResponse
    extends AbstractPagedListResponse<ListGatewaysRequest, ListGatewaysResponse, Gateway, ListGatewaysPage, ListGatewaysFixedSizeCollection> {
        public static ApiFuture<ListGatewaysPagedResponse> createAsync(PageContext<ListGatewaysRequest, ListGatewaysResponse, Gateway> context, ApiFuture<ListGatewaysResponse> futureResponse) {
            ApiFuture<ListGatewaysPage> futurePage = ListGatewaysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGatewaysPagedResponse((ListGatewaysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGatewaysPagedResponse(ListGatewaysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGatewaysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEndpointPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy, ListEndpointPoliciesPage, ListEndpointPoliciesFixedSizeCollection> {
        private ListEndpointPoliciesFixedSizeCollection(List<ListEndpointPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEndpointPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListEndpointPoliciesFixedSizeCollection(null, 0);
        }

        protected ListEndpointPoliciesFixedSizeCollection createCollection(List<ListEndpointPoliciesPage> pages, int collectionSize) {
            return new ListEndpointPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEndpointPoliciesPage
    extends AbstractPage<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy, ListEndpointPoliciesPage> {
        private ListEndpointPoliciesPage(PageContext<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy> context, ListEndpointPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListEndpointPoliciesPage createEmptyPage() {
            return new ListEndpointPoliciesPage(null, null);
        }

        protected ListEndpointPoliciesPage createPage(PageContext<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy> context, ListEndpointPoliciesResponse response) {
            return new ListEndpointPoliciesPage(context, response);
        }

        public ApiFuture<ListEndpointPoliciesPage> createPageAsync(PageContext<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy> context, ApiFuture<ListEndpointPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEndpointPoliciesPagedResponse
    extends AbstractPagedListResponse<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy, ListEndpointPoliciesPage, ListEndpointPoliciesFixedSizeCollection> {
        public static ApiFuture<ListEndpointPoliciesPagedResponse> createAsync(PageContext<ListEndpointPoliciesRequest, ListEndpointPoliciesResponse, EndpointPolicy> context, ApiFuture<ListEndpointPoliciesResponse> futureResponse) {
            ApiFuture<ListEndpointPoliciesPage> futurePage = ListEndpointPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEndpointPoliciesPagedResponse((ListEndpointPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEndpointPoliciesPagedResponse(ListEndpointPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEndpointPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

