/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.AcceptHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.AcceptSpokeUpdateRequest;
import com.google.cloud.networkconnectivity.v1.AcceptSpokeUpdateResponse;
import com.google.cloud.networkconnectivity.v1.CreateHubRequest;
import com.google.cloud.networkconnectivity.v1.CreateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.DeleteHubRequest;
import com.google.cloud.networkconnectivity.v1.DeleteSpokeRequest;
import com.google.cloud.networkconnectivity.v1.GetGroupRequest;
import com.google.cloud.networkconnectivity.v1.GetHubRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteRequest;
import com.google.cloud.networkconnectivity.v1.GetRouteTableRequest;
import com.google.cloud.networkconnectivity.v1.GetSpokeRequest;
import com.google.cloud.networkconnectivity.v1.Group;
import com.google.cloud.networkconnectivity.v1.Hub;
import com.google.cloud.networkconnectivity.v1.HubServiceClient;
import com.google.cloud.networkconnectivity.v1.ListGroupsRequest;
import com.google.cloud.networkconnectivity.v1.ListGroupsResponse;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListHubSpokesResponse;
import com.google.cloud.networkconnectivity.v1.ListHubsRequest;
import com.google.cloud.networkconnectivity.v1.ListHubsResponse;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesRequest;
import com.google.cloud.networkconnectivity.v1.ListRouteTablesResponse;
import com.google.cloud.networkconnectivity.v1.ListRoutesRequest;
import com.google.cloud.networkconnectivity.v1.ListRoutesResponse;
import com.google.cloud.networkconnectivity.v1.ListSpokesRequest;
import com.google.cloud.networkconnectivity.v1.ListSpokesResponse;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.QueryHubStatusRequest;
import com.google.cloud.networkconnectivity.v1.QueryHubStatusResponse;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeRequest;
import com.google.cloud.networkconnectivity.v1.RejectHubSpokeResponse;
import com.google.cloud.networkconnectivity.v1.RejectSpokeUpdateRequest;
import com.google.cloud.networkconnectivity.v1.RejectSpokeUpdateResponse;
import com.google.cloud.networkconnectivity.v1.Route;
import com.google.cloud.networkconnectivity.v1.RouteTable;
import com.google.cloud.networkconnectivity.v1.Spoke;
import com.google.cloud.networkconnectivity.v1.UpdateGroupRequest;
import com.google.cloud.networkconnectivity.v1.UpdateHubRequest;
import com.google.cloud.networkconnectivity.v1.UpdateSpokeRequest;
import com.google.cloud.networkconnectivity.v1.stub.GrpcHubServiceCallableFactory;
import com.google.cloud.networkconnectivity.v1.stub.HubServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.HubServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcHubServiceStub
extends HubServiceStub {
    private static final MethodDescriptor<ListHubsRequest, ListHubsResponse> listHubsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListHubs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListHubsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListHubsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetHubRequest, Hub> getHubMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/GetHub").setRequestMarshaller(ProtoUtils.marshaller((Message)GetHubRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Hub.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateHubRequest, Operation> createHubMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/CreateHub").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateHubRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateHubRequest, Operation> updateHubMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/UpdateHub").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateHubRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteHubRequest, Operation> deleteHubMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/DeleteHub").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteHubRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListHubSpokesRequest, ListHubSpokesResponse> listHubSpokesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListHubSpokes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListHubSpokesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListHubSpokesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<QueryHubStatusRequest, QueryHubStatusResponse> queryHubStatusMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/QueryHubStatus").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryHubStatusRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryHubStatusResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSpokesRequest, ListSpokesResponse> listSpokesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListSpokes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSpokesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSpokesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetSpokeRequest, Spoke> getSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/GetSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Spoke.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateSpokeRequest, Operation> createSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/CreateSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSpokeRequest, Operation> updateSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/UpdateSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RejectHubSpokeRequest, Operation> rejectHubSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/RejectHubSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)RejectHubSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AcceptHubSpokeRequest, Operation> acceptHubSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/AcceptHubSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)AcceptHubSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AcceptSpokeUpdateRequest, Operation> acceptSpokeUpdateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/AcceptSpokeUpdate").setRequestMarshaller(ProtoUtils.marshaller((Message)AcceptSpokeUpdateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RejectSpokeUpdateRequest, Operation> rejectSpokeUpdateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/RejectSpokeUpdate").setRequestMarshaller(ProtoUtils.marshaller((Message)RejectSpokeUpdateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSpokeRequest, Operation> deleteSpokeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/DeleteSpoke").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSpokeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetRouteTableRequest, RouteTable> getRouteTableMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/GetRouteTable").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRouteTableRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RouteTable.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetRouteRequest, Route> getRouteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/GetRoute").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRouteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Route.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListRoutesRequest, ListRoutesResponse> listRoutesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListRoutes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRoutesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRoutesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListRouteTablesRequest, ListRouteTablesResponse> listRouteTablesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListRouteTables").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRouteTablesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRouteTablesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGroupRequest, Group> getGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/GetGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Group.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListGroupsRequest, ListGroupsResponse> listGroupsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/ListGroups").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGroupsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGroupsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGroupRequest, Operation> updateGroupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.networkconnectivity.v1.HubService/UpdateGroup").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGroupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListHubsRequest, ListHubsResponse> listHubsCallable;
    private final UnaryCallable<ListHubsRequest, HubServiceClient.ListHubsPagedResponse> listHubsPagedCallable;
    private final UnaryCallable<GetHubRequest, Hub> getHubCallable;
    private final UnaryCallable<CreateHubRequest, Operation> createHubCallable;
    private final OperationCallable<CreateHubRequest, Hub, OperationMetadata> createHubOperationCallable;
    private final UnaryCallable<UpdateHubRequest, Operation> updateHubCallable;
    private final OperationCallable<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationCallable;
    private final UnaryCallable<DeleteHubRequest, Operation> deleteHubCallable;
    private final OperationCallable<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationCallable;
    private final UnaryCallable<ListHubSpokesRequest, ListHubSpokesResponse> listHubSpokesCallable;
    private final UnaryCallable<ListHubSpokesRequest, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesPagedCallable;
    private final UnaryCallable<QueryHubStatusRequest, QueryHubStatusResponse> queryHubStatusCallable;
    private final UnaryCallable<QueryHubStatusRequest, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusPagedCallable;
    private final UnaryCallable<ListSpokesRequest, ListSpokesResponse> listSpokesCallable;
    private final UnaryCallable<ListSpokesRequest, HubServiceClient.ListSpokesPagedResponse> listSpokesPagedCallable;
    private final UnaryCallable<GetSpokeRequest, Spoke> getSpokeCallable;
    private final UnaryCallable<CreateSpokeRequest, Operation> createSpokeCallable;
    private final OperationCallable<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationCallable;
    private final UnaryCallable<UpdateSpokeRequest, Operation> updateSpokeCallable;
    private final OperationCallable<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationCallable;
    private final UnaryCallable<RejectHubSpokeRequest, Operation> rejectHubSpokeCallable;
    private final OperationCallable<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationCallable;
    private final UnaryCallable<AcceptHubSpokeRequest, Operation> acceptHubSpokeCallable;
    private final OperationCallable<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationCallable;
    private final UnaryCallable<AcceptSpokeUpdateRequest, Operation> acceptSpokeUpdateCallable;
    private final OperationCallable<AcceptSpokeUpdateRequest, AcceptSpokeUpdateResponse, OperationMetadata> acceptSpokeUpdateOperationCallable;
    private final UnaryCallable<RejectSpokeUpdateRequest, Operation> rejectSpokeUpdateCallable;
    private final OperationCallable<RejectSpokeUpdateRequest, RejectSpokeUpdateResponse, OperationMetadata> rejectSpokeUpdateOperationCallable;
    private final UnaryCallable<DeleteSpokeRequest, Operation> deleteSpokeCallable;
    private final OperationCallable<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationCallable;
    private final UnaryCallable<GetRouteTableRequest, RouteTable> getRouteTableCallable;
    private final UnaryCallable<GetRouteRequest, Route> getRouteCallable;
    private final UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable;
    private final UnaryCallable<ListRoutesRequest, HubServiceClient.ListRoutesPagedResponse> listRoutesPagedCallable;
    private final UnaryCallable<ListRouteTablesRequest, ListRouteTablesResponse> listRouteTablesCallable;
    private final UnaryCallable<ListRouteTablesRequest, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesPagedCallable;
    private final UnaryCallable<GetGroupRequest, Group> getGroupCallable;
    private final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable;
    private final UnaryCallable<ListGroupsRequest, HubServiceClient.ListGroupsPagedResponse> listGroupsPagedCallable;
    private final UnaryCallable<UpdateGroupRequest, Operation> updateGroupCallable;
    private final OperationCallable<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, HubServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcHubServiceStub create(HubServiceStubSettings settings) throws IOException {
        return new GrpcHubServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcHubServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcHubServiceStub(HubServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcHubServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcHubServiceStub(HubServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcHubServiceStub(HubServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcHubServiceCallableFactory());
    }

    protected GrpcHubServiceStub(HubServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listHubsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listHubsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getHubTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getHubMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createHubTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createHubMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateHubTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateHubMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("hub.name", String.valueOf(request.getHub().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteHubTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteHubMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listHubSpokesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listHubSpokesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings queryHubStatusTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryHubStatusMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSpokesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSpokesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("spoke.name", String.valueOf(request.getSpoke().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings rejectHubSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rejectHubSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings acceptHubSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acceptHubSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings acceptSpokeUpdateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acceptSpokeUpdateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings rejectSpokeUpdateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rejectSpokeUpdateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSpokeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSpokeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getRouteTableTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRouteTableMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getRouteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRouteMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRoutesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRoutesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listRouteTablesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRouteTablesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGroupsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGroupsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGroupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGroupMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("group.name", String.valueOf(request.getGroup().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listHubsCallable = callableFactory.createUnaryCallable(listHubsTransportSettings, settings.listHubsSettings(), clientContext);
        this.listHubsPagedCallable = callableFactory.createPagedCallable(listHubsTransportSettings, settings.listHubsSettings(), clientContext);
        this.getHubCallable = callableFactory.createUnaryCallable(getHubTransportSettings, settings.getHubSettings(), clientContext);
        this.createHubCallable = callableFactory.createUnaryCallable(createHubTransportSettings, settings.createHubSettings(), clientContext);
        this.createHubOperationCallable = callableFactory.createOperationCallable(createHubTransportSettings, settings.createHubOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateHubCallable = callableFactory.createUnaryCallable(updateHubTransportSettings, settings.updateHubSettings(), clientContext);
        this.updateHubOperationCallable = callableFactory.createOperationCallable(updateHubTransportSettings, settings.updateHubOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteHubCallable = callableFactory.createUnaryCallable(deleteHubTransportSettings, settings.deleteHubSettings(), clientContext);
        this.deleteHubOperationCallable = callableFactory.createOperationCallable(deleteHubTransportSettings, settings.deleteHubOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listHubSpokesCallable = callableFactory.createUnaryCallable(listHubSpokesTransportSettings, settings.listHubSpokesSettings(), clientContext);
        this.listHubSpokesPagedCallable = callableFactory.createPagedCallable(listHubSpokesTransportSettings, settings.listHubSpokesSettings(), clientContext);
        this.queryHubStatusCallable = callableFactory.createUnaryCallable(queryHubStatusTransportSettings, settings.queryHubStatusSettings(), clientContext);
        this.queryHubStatusPagedCallable = callableFactory.createPagedCallable(queryHubStatusTransportSettings, settings.queryHubStatusSettings(), clientContext);
        this.listSpokesCallable = callableFactory.createUnaryCallable(listSpokesTransportSettings, settings.listSpokesSettings(), clientContext);
        this.listSpokesPagedCallable = callableFactory.createPagedCallable(listSpokesTransportSettings, settings.listSpokesSettings(), clientContext);
        this.getSpokeCallable = callableFactory.createUnaryCallable(getSpokeTransportSettings, settings.getSpokeSettings(), clientContext);
        this.createSpokeCallable = callableFactory.createUnaryCallable(createSpokeTransportSettings, settings.createSpokeSettings(), clientContext);
        this.createSpokeOperationCallable = callableFactory.createOperationCallable(createSpokeTransportSettings, settings.createSpokeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateSpokeCallable = callableFactory.createUnaryCallable(updateSpokeTransportSettings, settings.updateSpokeSettings(), clientContext);
        this.updateSpokeOperationCallable = callableFactory.createOperationCallable(updateSpokeTransportSettings, settings.updateSpokeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.rejectHubSpokeCallable = callableFactory.createUnaryCallable(rejectHubSpokeTransportSettings, settings.rejectHubSpokeSettings(), clientContext);
        this.rejectHubSpokeOperationCallable = callableFactory.createOperationCallable(rejectHubSpokeTransportSettings, settings.rejectHubSpokeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.acceptHubSpokeCallable = callableFactory.createUnaryCallable(acceptHubSpokeTransportSettings, settings.acceptHubSpokeSettings(), clientContext);
        this.acceptHubSpokeOperationCallable = callableFactory.createOperationCallable(acceptHubSpokeTransportSettings, settings.acceptHubSpokeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.acceptSpokeUpdateCallable = callableFactory.createUnaryCallable(acceptSpokeUpdateTransportSettings, settings.acceptSpokeUpdateSettings(), clientContext);
        this.acceptSpokeUpdateOperationCallable = callableFactory.createOperationCallable(acceptSpokeUpdateTransportSettings, settings.acceptSpokeUpdateOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.rejectSpokeUpdateCallable = callableFactory.createUnaryCallable(rejectSpokeUpdateTransportSettings, settings.rejectSpokeUpdateSettings(), clientContext);
        this.rejectSpokeUpdateOperationCallable = callableFactory.createOperationCallable(rejectSpokeUpdateTransportSettings, settings.rejectSpokeUpdateOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteSpokeCallable = callableFactory.createUnaryCallable(deleteSpokeTransportSettings, settings.deleteSpokeSettings(), clientContext);
        this.deleteSpokeOperationCallable = callableFactory.createOperationCallable(deleteSpokeTransportSettings, settings.deleteSpokeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getRouteTableCallable = callableFactory.createUnaryCallable(getRouteTableTransportSettings, settings.getRouteTableSettings(), clientContext);
        this.getRouteCallable = callableFactory.createUnaryCallable(getRouteTransportSettings, settings.getRouteSettings(), clientContext);
        this.listRoutesCallable = callableFactory.createUnaryCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.listRoutesPagedCallable = callableFactory.createPagedCallable(listRoutesTransportSettings, settings.listRoutesSettings(), clientContext);
        this.listRouteTablesCallable = callableFactory.createUnaryCallable(listRouteTablesTransportSettings, settings.listRouteTablesSettings(), clientContext);
        this.listRouteTablesPagedCallable = callableFactory.createPagedCallable(listRouteTablesTransportSettings, settings.listRouteTablesSettings(), clientContext);
        this.getGroupCallable = callableFactory.createUnaryCallable(getGroupTransportSettings, settings.getGroupSettings(), clientContext);
        this.listGroupsCallable = callableFactory.createUnaryCallable(listGroupsTransportSettings, settings.listGroupsSettings(), clientContext);
        this.listGroupsPagedCallable = callableFactory.createPagedCallable(listGroupsTransportSettings, settings.listGroupsSettings(), clientContext);
        this.updateGroupCallable = callableFactory.createUnaryCallable(updateGroupTransportSettings, settings.updateGroupSettings(), clientContext);
        this.updateGroupOperationCallable = callableFactory.createOperationCallable(updateGroupTransportSettings, settings.updateGroupOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListHubsRequest, ListHubsResponse> listHubsCallable() {
        return this.listHubsCallable;
    }

    @Override
    public UnaryCallable<ListHubsRequest, HubServiceClient.ListHubsPagedResponse> listHubsPagedCallable() {
        return this.listHubsPagedCallable;
    }

    @Override
    public UnaryCallable<GetHubRequest, Hub> getHubCallable() {
        return this.getHubCallable;
    }

    @Override
    public UnaryCallable<CreateHubRequest, Operation> createHubCallable() {
        return this.createHubCallable;
    }

    @Override
    public OperationCallable<CreateHubRequest, Hub, OperationMetadata> createHubOperationCallable() {
        return this.createHubOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateHubRequest, Operation> updateHubCallable() {
        return this.updateHubCallable;
    }

    @Override
    public OperationCallable<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationCallable() {
        return this.updateHubOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteHubRequest, Operation> deleteHubCallable() {
        return this.deleteHubCallable;
    }

    @Override
    public OperationCallable<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationCallable() {
        return this.deleteHubOperationCallable;
    }

    @Override
    public UnaryCallable<ListHubSpokesRequest, ListHubSpokesResponse> listHubSpokesCallable() {
        return this.listHubSpokesCallable;
    }

    @Override
    public UnaryCallable<ListHubSpokesRequest, HubServiceClient.ListHubSpokesPagedResponse> listHubSpokesPagedCallable() {
        return this.listHubSpokesPagedCallable;
    }

    @Override
    public UnaryCallable<QueryHubStatusRequest, QueryHubStatusResponse> queryHubStatusCallable() {
        return this.queryHubStatusCallable;
    }

    @Override
    public UnaryCallable<QueryHubStatusRequest, HubServiceClient.QueryHubStatusPagedResponse> queryHubStatusPagedCallable() {
        return this.queryHubStatusPagedCallable;
    }

    @Override
    public UnaryCallable<ListSpokesRequest, ListSpokesResponse> listSpokesCallable() {
        return this.listSpokesCallable;
    }

    @Override
    public UnaryCallable<ListSpokesRequest, HubServiceClient.ListSpokesPagedResponse> listSpokesPagedCallable() {
        return this.listSpokesPagedCallable;
    }

    @Override
    public UnaryCallable<GetSpokeRequest, Spoke> getSpokeCallable() {
        return this.getSpokeCallable;
    }

    @Override
    public UnaryCallable<CreateSpokeRequest, Operation> createSpokeCallable() {
        return this.createSpokeCallable;
    }

    @Override
    public OperationCallable<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationCallable() {
        return this.createSpokeOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateSpokeRequest, Operation> updateSpokeCallable() {
        return this.updateSpokeCallable;
    }

    @Override
    public OperationCallable<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationCallable() {
        return this.updateSpokeOperationCallable;
    }

    @Override
    public UnaryCallable<RejectHubSpokeRequest, Operation> rejectHubSpokeCallable() {
        return this.rejectHubSpokeCallable;
    }

    @Override
    public OperationCallable<RejectHubSpokeRequest, RejectHubSpokeResponse, OperationMetadata> rejectHubSpokeOperationCallable() {
        return this.rejectHubSpokeOperationCallable;
    }

    @Override
    public UnaryCallable<AcceptHubSpokeRequest, Operation> acceptHubSpokeCallable() {
        return this.acceptHubSpokeCallable;
    }

    @Override
    public OperationCallable<AcceptHubSpokeRequest, AcceptHubSpokeResponse, OperationMetadata> acceptHubSpokeOperationCallable() {
        return this.acceptHubSpokeOperationCallable;
    }

    @Override
    public UnaryCallable<AcceptSpokeUpdateRequest, Operation> acceptSpokeUpdateCallable() {
        return this.acceptSpokeUpdateCallable;
    }

    @Override
    public OperationCallable<AcceptSpokeUpdateRequest, AcceptSpokeUpdateResponse, OperationMetadata> acceptSpokeUpdateOperationCallable() {
        return this.acceptSpokeUpdateOperationCallable;
    }

    @Override
    public UnaryCallable<RejectSpokeUpdateRequest, Operation> rejectSpokeUpdateCallable() {
        return this.rejectSpokeUpdateCallable;
    }

    @Override
    public OperationCallable<RejectSpokeUpdateRequest, RejectSpokeUpdateResponse, OperationMetadata> rejectSpokeUpdateOperationCallable() {
        return this.rejectSpokeUpdateOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSpokeRequest, Operation> deleteSpokeCallable() {
        return this.deleteSpokeCallable;
    }

    @Override
    public OperationCallable<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationCallable() {
        return this.deleteSpokeOperationCallable;
    }

    @Override
    public UnaryCallable<GetRouteTableRequest, RouteTable> getRouteTableCallable() {
        return this.getRouteTableCallable;
    }

    @Override
    public UnaryCallable<GetRouteRequest, Route> getRouteCallable() {
        return this.getRouteCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, ListRoutesResponse> listRoutesCallable() {
        return this.listRoutesCallable;
    }

    @Override
    public UnaryCallable<ListRoutesRequest, HubServiceClient.ListRoutesPagedResponse> listRoutesPagedCallable() {
        return this.listRoutesPagedCallable;
    }

    @Override
    public UnaryCallable<ListRouteTablesRequest, ListRouteTablesResponse> listRouteTablesCallable() {
        return this.listRouteTablesCallable;
    }

    @Override
    public UnaryCallable<ListRouteTablesRequest, HubServiceClient.ListRouteTablesPagedResponse> listRouteTablesPagedCallable() {
        return this.listRouteTablesPagedCallable;
    }

    @Override
    public UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.getGroupCallable;
    }

    @Override
    public UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.listGroupsCallable;
    }

    @Override
    public UnaryCallable<ListGroupsRequest, HubServiceClient.ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.listGroupsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateGroupRequest, Operation> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public OperationCallable<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationCallable() {
        return this.updateGroupOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, HubServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

