/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.CrossNetworkAutomationServiceSettings;
import com.google.cloud.networkconnectivity.v1.DeleteServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceClassesRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceClassesResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionMapsRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionMapsResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionTokensRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionTokensResponse;
import com.google.cloud.networkconnectivity.v1.LocationName;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.ServiceClass;
import com.google.cloud.networkconnectivity.v1.ServiceClassName;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionMap;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionMapName;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionPolicy;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionPolicyName;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionToken;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionTokenName;
import com.google.cloud.networkconnectivity.v1.UpdateServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.stub.CrossNetworkAutomationServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.CrossNetworkAutomationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CrossNetworkAutomationServiceClient
implements BackgroundResource {
    private final CrossNetworkAutomationServiceSettings settings;
    private final CrossNetworkAutomationServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CrossNetworkAutomationServiceClient create() throws IOException {
        return CrossNetworkAutomationServiceClient.create(CrossNetworkAutomationServiceSettings.newBuilder().build());
    }

    public static final CrossNetworkAutomationServiceClient create(CrossNetworkAutomationServiceSettings settings) throws IOException {
        return new CrossNetworkAutomationServiceClient(settings);
    }

    public static final CrossNetworkAutomationServiceClient create(CrossNetworkAutomationServiceStub stub) {
        return new CrossNetworkAutomationServiceClient(stub);
    }

    protected CrossNetworkAutomationServiceClient(CrossNetworkAutomationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CrossNetworkAutomationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected CrossNetworkAutomationServiceClient(CrossNetworkAutomationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CrossNetworkAutomationServiceSettings getSettings() {
        return this.settings;
    }

    public CrossNetworkAutomationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListServiceConnectionMapsPagedResponse listServiceConnectionMaps(LocationName parent) {
        ListServiceConnectionMapsRequest request = ListServiceConnectionMapsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceConnectionMaps(request);
    }

    public final ListServiceConnectionMapsPagedResponse listServiceConnectionMaps(String parent) {
        ListServiceConnectionMapsRequest request = ListServiceConnectionMapsRequest.newBuilder().setParent(parent).build();
        return this.listServiceConnectionMaps(request);
    }

    public final ListServiceConnectionMapsPagedResponse listServiceConnectionMaps(ListServiceConnectionMapsRequest request) {
        return (ListServiceConnectionMapsPagedResponse)((Object)this.listServiceConnectionMapsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceConnectionMapsRequest, ListServiceConnectionMapsPagedResponse> listServiceConnectionMapsPagedCallable() {
        return this.stub.listServiceConnectionMapsPagedCallable();
    }

    public final UnaryCallable<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse> listServiceConnectionMapsCallable() {
        return this.stub.listServiceConnectionMapsCallable();
    }

    public final ServiceConnectionMap getServiceConnectionMap(ServiceConnectionMapName name) {
        GetServiceConnectionMapRequest request = GetServiceConnectionMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceConnectionMap(request);
    }

    public final ServiceConnectionMap getServiceConnectionMap(String name) {
        GetServiceConnectionMapRequest request = GetServiceConnectionMapRequest.newBuilder().setName(name).build();
        return this.getServiceConnectionMap(request);
    }

    public final ServiceConnectionMap getServiceConnectionMap(GetServiceConnectionMapRequest request) {
        return (ServiceConnectionMap)this.getServiceConnectionMapCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceConnectionMapRequest, ServiceConnectionMap> getServiceConnectionMapCallable() {
        return this.stub.getServiceConnectionMapCallable();
    }

    public final OperationFuture<ServiceConnectionMap, OperationMetadata> createServiceConnectionMapAsync(LocationName parent, ServiceConnectionMap serviceConnectionMap, String serviceConnectionMapId) {
        CreateServiceConnectionMapRequest request = CreateServiceConnectionMapRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceConnectionMap(serviceConnectionMap).setServiceConnectionMapId(serviceConnectionMapId).build();
        return this.createServiceConnectionMapAsync(request);
    }

    public final OperationFuture<ServiceConnectionMap, OperationMetadata> createServiceConnectionMapAsync(String parent, ServiceConnectionMap serviceConnectionMap, String serviceConnectionMapId) {
        CreateServiceConnectionMapRequest request = CreateServiceConnectionMapRequest.newBuilder().setParent(parent).setServiceConnectionMap(serviceConnectionMap).setServiceConnectionMapId(serviceConnectionMapId).build();
        return this.createServiceConnectionMapAsync(request);
    }

    public final OperationFuture<ServiceConnectionMap, OperationMetadata> createServiceConnectionMapAsync(CreateServiceConnectionMapRequest request) {
        return this.createServiceConnectionMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> createServiceConnectionMapOperationCallable() {
        return this.stub.createServiceConnectionMapOperationCallable();
    }

    public final UnaryCallable<CreateServiceConnectionMapRequest, Operation> createServiceConnectionMapCallable() {
        return this.stub.createServiceConnectionMapCallable();
    }

    public final OperationFuture<ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapAsync(ServiceConnectionMap serviceConnectionMap, FieldMask updateMask) {
        UpdateServiceConnectionMapRequest request = UpdateServiceConnectionMapRequest.newBuilder().setServiceConnectionMap(serviceConnectionMap).setUpdateMask(updateMask).build();
        return this.updateServiceConnectionMapAsync(request);
    }

    public final OperationFuture<ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapAsync(UpdateServiceConnectionMapRequest request) {
        return this.updateServiceConnectionMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapOperationCallable() {
        return this.stub.updateServiceConnectionMapOperationCallable();
    }

    public final UnaryCallable<UpdateServiceConnectionMapRequest, Operation> updateServiceConnectionMapCallable() {
        return this.stub.updateServiceConnectionMapCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionMapAsync(ServiceConnectionMapName name) {
        DeleteServiceConnectionMapRequest request = DeleteServiceConnectionMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceConnectionMapAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionMapAsync(String name) {
        DeleteServiceConnectionMapRequest request = DeleteServiceConnectionMapRequest.newBuilder().setName(name).build();
        return this.deleteServiceConnectionMapAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionMapAsync(DeleteServiceConnectionMapRequest request) {
        return this.deleteServiceConnectionMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceConnectionMapRequest, Empty, OperationMetadata> deleteServiceConnectionMapOperationCallable() {
        return this.stub.deleteServiceConnectionMapOperationCallable();
    }

    public final UnaryCallable<DeleteServiceConnectionMapRequest, Operation> deleteServiceConnectionMapCallable() {
        return this.stub.deleteServiceConnectionMapCallable();
    }

    public final ListServiceConnectionPoliciesPagedResponse listServiceConnectionPolicies(LocationName parent) {
        ListServiceConnectionPoliciesRequest request = ListServiceConnectionPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceConnectionPolicies(request);
    }

    public final ListServiceConnectionPoliciesPagedResponse listServiceConnectionPolicies(String parent) {
        ListServiceConnectionPoliciesRequest request = ListServiceConnectionPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listServiceConnectionPolicies(request);
    }

    public final ListServiceConnectionPoliciesPagedResponse listServiceConnectionPolicies(ListServiceConnectionPoliciesRequest request) {
        return (ListServiceConnectionPoliciesPagedResponse)((Object)this.listServiceConnectionPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesPagedResponse> listServiceConnectionPoliciesPagedCallable() {
        return this.stub.listServiceConnectionPoliciesPagedCallable();
    }

    public final UnaryCallable<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse> listServiceConnectionPoliciesCallable() {
        return this.stub.listServiceConnectionPoliciesCallable();
    }

    public final ServiceConnectionPolicy getServiceConnectionPolicy(ServiceConnectionPolicyName name) {
        GetServiceConnectionPolicyRequest request = GetServiceConnectionPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceConnectionPolicy(request);
    }

    public final ServiceConnectionPolicy getServiceConnectionPolicy(String name) {
        GetServiceConnectionPolicyRequest request = GetServiceConnectionPolicyRequest.newBuilder().setName(name).build();
        return this.getServiceConnectionPolicy(request);
    }

    public final ServiceConnectionPolicy getServiceConnectionPolicy(GetServiceConnectionPolicyRequest request) {
        return (ServiceConnectionPolicy)this.getServiceConnectionPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceConnectionPolicyRequest, ServiceConnectionPolicy> getServiceConnectionPolicyCallable() {
        return this.stub.getServiceConnectionPolicyCallable();
    }

    public final OperationFuture<ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyAsync(LocationName parent, ServiceConnectionPolicy serviceConnectionPolicy, String serviceConnectionPolicyId) {
        CreateServiceConnectionPolicyRequest request = CreateServiceConnectionPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceConnectionPolicy(serviceConnectionPolicy).setServiceConnectionPolicyId(serviceConnectionPolicyId).build();
        return this.createServiceConnectionPolicyAsync(request);
    }

    public final OperationFuture<ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyAsync(String parent, ServiceConnectionPolicy serviceConnectionPolicy, String serviceConnectionPolicyId) {
        CreateServiceConnectionPolicyRequest request = CreateServiceConnectionPolicyRequest.newBuilder().setParent(parent).setServiceConnectionPolicy(serviceConnectionPolicy).setServiceConnectionPolicyId(serviceConnectionPolicyId).build();
        return this.createServiceConnectionPolicyAsync(request);
    }

    public final OperationFuture<ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyAsync(CreateServiceConnectionPolicyRequest request) {
        return this.createServiceConnectionPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyOperationCallable() {
        return this.stub.createServiceConnectionPolicyOperationCallable();
    }

    public final UnaryCallable<CreateServiceConnectionPolicyRequest, Operation> createServiceConnectionPolicyCallable() {
        return this.stub.createServiceConnectionPolicyCallable();
    }

    public final OperationFuture<ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyAsync(ServiceConnectionPolicy serviceConnectionPolicy, FieldMask updateMask) {
        UpdateServiceConnectionPolicyRequest request = UpdateServiceConnectionPolicyRequest.newBuilder().setServiceConnectionPolicy(serviceConnectionPolicy).setUpdateMask(updateMask).build();
        return this.updateServiceConnectionPolicyAsync(request);
    }

    public final OperationFuture<ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyAsync(UpdateServiceConnectionPolicyRequest request) {
        return this.updateServiceConnectionPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyOperationCallable() {
        return this.stub.updateServiceConnectionPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateServiceConnectionPolicyRequest, Operation> updateServiceConnectionPolicyCallable() {
        return this.stub.updateServiceConnectionPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionPolicyAsync(ServiceConnectionPolicyName name) {
        DeleteServiceConnectionPolicyRequest request = DeleteServiceConnectionPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceConnectionPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionPolicyAsync(String name) {
        DeleteServiceConnectionPolicyRequest request = DeleteServiceConnectionPolicyRequest.newBuilder().setName(name).build();
        return this.deleteServiceConnectionPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionPolicyAsync(DeleteServiceConnectionPolicyRequest request) {
        return this.deleteServiceConnectionPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceConnectionPolicyRequest, Empty, OperationMetadata> deleteServiceConnectionPolicyOperationCallable() {
        return this.stub.deleteServiceConnectionPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteServiceConnectionPolicyRequest, Operation> deleteServiceConnectionPolicyCallable() {
        return this.stub.deleteServiceConnectionPolicyCallable();
    }

    public final ListServiceClassesPagedResponse listServiceClasses(LocationName parent) {
        ListServiceClassesRequest request = ListServiceClassesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceClasses(request);
    }

    public final ListServiceClassesPagedResponse listServiceClasses(String parent) {
        ListServiceClassesRequest request = ListServiceClassesRequest.newBuilder().setParent(parent).build();
        return this.listServiceClasses(request);
    }

    public final ListServiceClassesPagedResponse listServiceClasses(ListServiceClassesRequest request) {
        return (ListServiceClassesPagedResponse)((Object)this.listServiceClassesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceClassesRequest, ListServiceClassesPagedResponse> listServiceClassesPagedCallable() {
        return this.stub.listServiceClassesPagedCallable();
    }

    public final UnaryCallable<ListServiceClassesRequest, ListServiceClassesResponse> listServiceClassesCallable() {
        return this.stub.listServiceClassesCallable();
    }

    public final ServiceClass getServiceClass(ServiceClassName name) {
        GetServiceClassRequest request = GetServiceClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceClass(request);
    }

    public final ServiceClass getServiceClass(String name) {
        GetServiceClassRequest request = GetServiceClassRequest.newBuilder().setName(name).build();
        return this.getServiceClass(request);
    }

    public final ServiceClass getServiceClass(GetServiceClassRequest request) {
        return (ServiceClass)this.getServiceClassCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceClassRequest, ServiceClass> getServiceClassCallable() {
        return this.stub.getServiceClassCallable();
    }

    public final OperationFuture<ServiceClass, OperationMetadata> updateServiceClassAsync(ServiceClass serviceClass, FieldMask updateMask) {
        UpdateServiceClassRequest request = UpdateServiceClassRequest.newBuilder().setServiceClass(serviceClass).setUpdateMask(updateMask).build();
        return this.updateServiceClassAsync(request);
    }

    public final OperationFuture<ServiceClass, OperationMetadata> updateServiceClassAsync(UpdateServiceClassRequest request) {
        return this.updateServiceClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceClassRequest, ServiceClass, OperationMetadata> updateServiceClassOperationCallable() {
        return this.stub.updateServiceClassOperationCallable();
    }

    public final UnaryCallable<UpdateServiceClassRequest, Operation> updateServiceClassCallable() {
        return this.stub.updateServiceClassCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceClassAsync(ServiceClassName name) {
        DeleteServiceClassRequest request = DeleteServiceClassRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceClassAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceClassAsync(String name) {
        DeleteServiceClassRequest request = DeleteServiceClassRequest.newBuilder().setName(name).build();
        return this.deleteServiceClassAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceClassAsync(DeleteServiceClassRequest request) {
        return this.deleteServiceClassOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceClassRequest, Empty, OperationMetadata> deleteServiceClassOperationCallable() {
        return this.stub.deleteServiceClassOperationCallable();
    }

    public final UnaryCallable<DeleteServiceClassRequest, Operation> deleteServiceClassCallable() {
        return this.stub.deleteServiceClassCallable();
    }

    public final ServiceConnectionToken getServiceConnectionToken(ServiceConnectionTokenName name) {
        GetServiceConnectionTokenRequest request = GetServiceConnectionTokenRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServiceConnectionToken(request);
    }

    public final ServiceConnectionToken getServiceConnectionToken(String name) {
        GetServiceConnectionTokenRequest request = GetServiceConnectionTokenRequest.newBuilder().setName(name).build();
        return this.getServiceConnectionToken(request);
    }

    public final ServiceConnectionToken getServiceConnectionToken(GetServiceConnectionTokenRequest request) {
        return (ServiceConnectionToken)this.getServiceConnectionTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceConnectionTokenRequest, ServiceConnectionToken> getServiceConnectionTokenCallable() {
        return this.stub.getServiceConnectionTokenCallable();
    }

    public final ListServiceConnectionTokensPagedResponse listServiceConnectionTokens(LocationName parent) {
        ListServiceConnectionTokensRequest request = ListServiceConnectionTokensRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServiceConnectionTokens(request);
    }

    public final ListServiceConnectionTokensPagedResponse listServiceConnectionTokens(String parent) {
        ListServiceConnectionTokensRequest request = ListServiceConnectionTokensRequest.newBuilder().setParent(parent).build();
        return this.listServiceConnectionTokens(request);
    }

    public final ListServiceConnectionTokensPagedResponse listServiceConnectionTokens(ListServiceConnectionTokensRequest request) {
        return (ListServiceConnectionTokensPagedResponse)((Object)this.listServiceConnectionTokensPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceConnectionTokensRequest, ListServiceConnectionTokensPagedResponse> listServiceConnectionTokensPagedCallable() {
        return this.stub.listServiceConnectionTokensPagedCallable();
    }

    public final UnaryCallable<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse> listServiceConnectionTokensCallable() {
        return this.stub.listServiceConnectionTokensCallable();
    }

    public final OperationFuture<ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenAsync(LocationName parent, ServiceConnectionToken serviceConnectionToken, String serviceConnectionTokenId) {
        CreateServiceConnectionTokenRequest request = CreateServiceConnectionTokenRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServiceConnectionToken(serviceConnectionToken).setServiceConnectionTokenId(serviceConnectionTokenId).build();
        return this.createServiceConnectionTokenAsync(request);
    }

    public final OperationFuture<ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenAsync(String parent, ServiceConnectionToken serviceConnectionToken, String serviceConnectionTokenId) {
        CreateServiceConnectionTokenRequest request = CreateServiceConnectionTokenRequest.newBuilder().setParent(parent).setServiceConnectionToken(serviceConnectionToken).setServiceConnectionTokenId(serviceConnectionTokenId).build();
        return this.createServiceConnectionTokenAsync(request);
    }

    public final OperationFuture<ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenAsync(CreateServiceConnectionTokenRequest request) {
        return this.createServiceConnectionTokenOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceConnectionTokenRequest, ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenOperationCallable() {
        return this.stub.createServiceConnectionTokenOperationCallable();
    }

    public final UnaryCallable<CreateServiceConnectionTokenRequest, Operation> createServiceConnectionTokenCallable() {
        return this.stub.createServiceConnectionTokenCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionTokenAsync(ServiceConnectionTokenName name) {
        DeleteServiceConnectionTokenRequest request = DeleteServiceConnectionTokenRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceConnectionTokenAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionTokenAsync(String name) {
        DeleteServiceConnectionTokenRequest request = DeleteServiceConnectionTokenRequest.newBuilder().setName(name).build();
        return this.deleteServiceConnectionTokenAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceConnectionTokenAsync(DeleteServiceConnectionTokenRequest request) {
        return this.deleteServiceConnectionTokenOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceConnectionTokenRequest, Empty, OperationMetadata> deleteServiceConnectionTokenOperationCallable() {
        return this.stub.deleteServiceConnectionTokenOperationCallable();
    }

    public final UnaryCallable<DeleteServiceConnectionTokenRequest, Operation> deleteServiceConnectionTokenCallable() {
        return this.stub.deleteServiceConnectionTokenCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceConnectionTokensFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken, ListServiceConnectionTokensPage, ListServiceConnectionTokensFixedSizeCollection> {
        private ListServiceConnectionTokensFixedSizeCollection(List<ListServiceConnectionTokensPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceConnectionTokensFixedSizeCollection createEmptyCollection() {
            return new ListServiceConnectionTokensFixedSizeCollection(null, 0);
        }

        protected ListServiceConnectionTokensFixedSizeCollection createCollection(List<ListServiceConnectionTokensPage> pages, int collectionSize) {
            return new ListServiceConnectionTokensFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceConnectionTokensPage
    extends AbstractPage<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken, ListServiceConnectionTokensPage> {
        private ListServiceConnectionTokensPage(PageContext<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken> context, ListServiceConnectionTokensResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceConnectionTokensPage createEmptyPage() {
            return new ListServiceConnectionTokensPage(null, null);
        }

        protected ListServiceConnectionTokensPage createPage(PageContext<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken> context, ListServiceConnectionTokensResponse response) {
            return new ListServiceConnectionTokensPage(context, response);
        }

        public ApiFuture<ListServiceConnectionTokensPage> createPageAsync(PageContext<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken> context, ApiFuture<ListServiceConnectionTokensResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceConnectionTokensPagedResponse
    extends AbstractPagedListResponse<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken, ListServiceConnectionTokensPage, ListServiceConnectionTokensFixedSizeCollection> {
        public static ApiFuture<ListServiceConnectionTokensPagedResponse> createAsync(PageContext<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken> context, ApiFuture<ListServiceConnectionTokensResponse> futureResponse) {
            ApiFuture<ListServiceConnectionTokensPage> futurePage = ListServiceConnectionTokensPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceConnectionTokensPagedResponse((ListServiceConnectionTokensPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceConnectionTokensPagedResponse(ListServiceConnectionTokensPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceConnectionTokensFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceClassesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass, ListServiceClassesPage, ListServiceClassesFixedSizeCollection> {
        private ListServiceClassesFixedSizeCollection(List<ListServiceClassesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceClassesFixedSizeCollection createEmptyCollection() {
            return new ListServiceClassesFixedSizeCollection(null, 0);
        }

        protected ListServiceClassesFixedSizeCollection createCollection(List<ListServiceClassesPage> pages, int collectionSize) {
            return new ListServiceClassesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceClassesPage
    extends AbstractPage<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass, ListServiceClassesPage> {
        private ListServiceClassesPage(PageContext<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass> context, ListServiceClassesResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceClassesPage createEmptyPage() {
            return new ListServiceClassesPage(null, null);
        }

        protected ListServiceClassesPage createPage(PageContext<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass> context, ListServiceClassesResponse response) {
            return new ListServiceClassesPage(context, response);
        }

        public ApiFuture<ListServiceClassesPage> createPageAsync(PageContext<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass> context, ApiFuture<ListServiceClassesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceClassesPagedResponse
    extends AbstractPagedListResponse<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass, ListServiceClassesPage, ListServiceClassesFixedSizeCollection> {
        public static ApiFuture<ListServiceClassesPagedResponse> createAsync(PageContext<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass> context, ApiFuture<ListServiceClassesResponse> futureResponse) {
            ApiFuture<ListServiceClassesPage> futurePage = ListServiceClassesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceClassesPagedResponse((ListServiceClassesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceClassesPagedResponse(ListServiceClassesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceClassesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceConnectionPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy, ListServiceConnectionPoliciesPage, ListServiceConnectionPoliciesFixedSizeCollection> {
        private ListServiceConnectionPoliciesFixedSizeCollection(List<ListServiceConnectionPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceConnectionPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListServiceConnectionPoliciesFixedSizeCollection(null, 0);
        }

        protected ListServiceConnectionPoliciesFixedSizeCollection createCollection(List<ListServiceConnectionPoliciesPage> pages, int collectionSize) {
            return new ListServiceConnectionPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceConnectionPoliciesPage
    extends AbstractPage<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy, ListServiceConnectionPoliciesPage> {
        private ListServiceConnectionPoliciesPage(PageContext<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy> context, ListServiceConnectionPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceConnectionPoliciesPage createEmptyPage() {
            return new ListServiceConnectionPoliciesPage(null, null);
        }

        protected ListServiceConnectionPoliciesPage createPage(PageContext<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy> context, ListServiceConnectionPoliciesResponse response) {
            return new ListServiceConnectionPoliciesPage(context, response);
        }

        public ApiFuture<ListServiceConnectionPoliciesPage> createPageAsync(PageContext<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy> context, ApiFuture<ListServiceConnectionPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceConnectionPoliciesPagedResponse
    extends AbstractPagedListResponse<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy, ListServiceConnectionPoliciesPage, ListServiceConnectionPoliciesFixedSizeCollection> {
        public static ApiFuture<ListServiceConnectionPoliciesPagedResponse> createAsync(PageContext<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy> context, ApiFuture<ListServiceConnectionPoliciesResponse> futureResponse) {
            ApiFuture<ListServiceConnectionPoliciesPage> futurePage = ListServiceConnectionPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceConnectionPoliciesPagedResponse((ListServiceConnectionPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceConnectionPoliciesPagedResponse(ListServiceConnectionPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceConnectionPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServiceConnectionMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap, ListServiceConnectionMapsPage, ListServiceConnectionMapsFixedSizeCollection> {
        private ListServiceConnectionMapsFixedSizeCollection(List<ListServiceConnectionMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServiceConnectionMapsFixedSizeCollection createEmptyCollection() {
            return new ListServiceConnectionMapsFixedSizeCollection(null, 0);
        }

        protected ListServiceConnectionMapsFixedSizeCollection createCollection(List<ListServiceConnectionMapsPage> pages, int collectionSize) {
            return new ListServiceConnectionMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServiceConnectionMapsPage
    extends AbstractPage<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap, ListServiceConnectionMapsPage> {
        private ListServiceConnectionMapsPage(PageContext<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap> context, ListServiceConnectionMapsResponse response) {
            super(context, (Object)response);
        }

        private static ListServiceConnectionMapsPage createEmptyPage() {
            return new ListServiceConnectionMapsPage(null, null);
        }

        protected ListServiceConnectionMapsPage createPage(PageContext<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap> context, ListServiceConnectionMapsResponse response) {
            return new ListServiceConnectionMapsPage(context, response);
        }

        public ApiFuture<ListServiceConnectionMapsPage> createPageAsync(PageContext<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap> context, ApiFuture<ListServiceConnectionMapsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServiceConnectionMapsPagedResponse
    extends AbstractPagedListResponse<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap, ListServiceConnectionMapsPage, ListServiceConnectionMapsFixedSizeCollection> {
        public static ApiFuture<ListServiceConnectionMapsPagedResponse> createAsync(PageContext<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap> context, ApiFuture<ListServiceConnectionMapsResponse> futureResponse) {
            ApiFuture<ListServiceConnectionMapsPage> futurePage = ListServiceConnectionMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServiceConnectionMapsPagedResponse((ListServiceConnectionMapsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServiceConnectionMapsPagedResponse(ListServiceConnectionMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServiceConnectionMapsFixedSizeCollection.createEmptyCollection());
        }
    }
}

