/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkconnectivity.v1alpha1.CreateHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.CreateSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.DeleteHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.DeleteSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.GetHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.GetSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.Hub;
import com.google.cloud.networkconnectivity.v1alpha1.HubServiceClient;
import com.google.cloud.networkconnectivity.v1alpha1.ListHubsRequest;
import com.google.cloud.networkconnectivity.v1alpha1.ListHubsResponse;
import com.google.cloud.networkconnectivity.v1alpha1.ListSpokesRequest;
import com.google.cloud.networkconnectivity.v1alpha1.ListSpokesResponse;
import com.google.cloud.networkconnectivity.v1alpha1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1alpha1.Spoke;
import com.google.cloud.networkconnectivity.v1alpha1.UpdateHubRequest;
import com.google.cloud.networkconnectivity.v1alpha1.UpdateSpokeRequest;
import com.google.cloud.networkconnectivity.v1alpha1.stub.GrpcHubServiceStub;
import com.google.cloud.networkconnectivity.v1alpha1.stub.HubServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class HubServiceStubSettings
extends StubSettings<HubServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings;
    private final UnaryCallSettings<GetHubRequest, Hub> getHubSettings;
    private final UnaryCallSettings<CreateHubRequest, Operation> createHubSettings;
    private final OperationCallSettings<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings;
    private final UnaryCallSettings<UpdateHubRequest, Operation> updateHubSettings;
    private final OperationCallSettings<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings;
    private final UnaryCallSettings<DeleteHubRequest, Operation> deleteHubSettings;
    private final OperationCallSettings<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings;
    private final PagedCallSettings<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings;
    private final UnaryCallSettings<GetSpokeRequest, Spoke> getSpokeSettings;
    private final UnaryCallSettings<CreateSpokeRequest, Operation> createSpokeSettings;
    private final OperationCallSettings<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings;
    private final UnaryCallSettings<UpdateSpokeRequest, Operation> updateSpokeSettings;
    private final OperationCallSettings<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings;
    private final UnaryCallSettings<DeleteSpokeRequest, Operation> deleteSpokeSettings;
    private final OperationCallSettings<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings;
    private static final PagedListDescriptor<ListHubsRequest, ListHubsResponse, Hub> LIST_HUBS_PAGE_STR_DESC = new PagedListDescriptor<ListHubsRequest, ListHubsResponse, Hub>(){

        public String emptyToken() {
            return "";
        }

        public ListHubsRequest injectToken(ListHubsRequest payload, String token) {
            return ListHubsRequest.newBuilder((ListHubsRequest)payload).setPageToken(token).build();
        }

        public ListHubsRequest injectPageSize(ListHubsRequest payload, int pageSize) {
            return ListHubsRequest.newBuilder((ListHubsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListHubsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListHubsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Hub> extractResources(ListHubsResponse payload) {
            return payload.getHubsList() == null ? ImmutableList.of() : payload.getHubsList();
        }
    };
    private static final PagedListDescriptor<ListSpokesRequest, ListSpokesResponse, Spoke> LIST_SPOKES_PAGE_STR_DESC = new PagedListDescriptor<ListSpokesRequest, ListSpokesResponse, Spoke>(){

        public String emptyToken() {
            return "";
        }

        public ListSpokesRequest injectToken(ListSpokesRequest payload, String token) {
            return ListSpokesRequest.newBuilder((ListSpokesRequest)payload).setPageToken(token).build();
        }

        public ListSpokesRequest injectPageSize(ListSpokesRequest payload, int pageSize) {
            return ListSpokesRequest.newBuilder((ListSpokesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSpokesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSpokesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Spoke> extractResources(ListSpokesResponse payload) {
            return payload.getSpokesList() == null ? ImmutableList.of() : payload.getSpokesList();
        }
    };
    private static final PagedListResponseFactory<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> LIST_HUBS_PAGE_STR_FACT = new PagedListResponseFactory<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse>(){

        public ApiFuture<HubServiceClient.ListHubsPagedResponse> getFuturePagedResponse(UnaryCallable<ListHubsRequest, ListHubsResponse> callable, ListHubsRequest request, ApiCallContext context, ApiFuture<ListHubsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_HUBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListHubsPagedResponse.createAsync((PageContext<ListHubsRequest, ListHubsResponse, Hub>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> LIST_SPOKES_PAGE_STR_FACT = new PagedListResponseFactory<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse>(){

        public ApiFuture<HubServiceClient.ListSpokesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSpokesRequest, ListSpokesResponse> callable, ListSpokesRequest request, ApiCallContext context, ApiFuture<ListSpokesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SPOKES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return HubServiceClient.ListSpokesPagedResponse.createAsync((PageContext<ListSpokesRequest, ListSpokesResponse, Spoke>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings() {
        return this.listHubsSettings;
    }

    public UnaryCallSettings<GetHubRequest, Hub> getHubSettings() {
        return this.getHubSettings;
    }

    public UnaryCallSettings<CreateHubRequest, Operation> createHubSettings() {
        return this.createHubSettings;
    }

    public OperationCallSettings<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings() {
        return this.createHubOperationSettings;
    }

    public UnaryCallSettings<UpdateHubRequest, Operation> updateHubSettings() {
        return this.updateHubSettings;
    }

    public OperationCallSettings<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings() {
        return this.updateHubOperationSettings;
    }

    public UnaryCallSettings<DeleteHubRequest, Operation> deleteHubSettings() {
        return this.deleteHubSettings;
    }

    public OperationCallSettings<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings() {
        return this.deleteHubOperationSettings;
    }

    public PagedCallSettings<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings() {
        return this.listSpokesSettings;
    }

    public UnaryCallSettings<GetSpokeRequest, Spoke> getSpokeSettings() {
        return this.getSpokeSettings;
    }

    public UnaryCallSettings<CreateSpokeRequest, Operation> createSpokeSettings() {
        return this.createSpokeSettings;
    }

    public OperationCallSettings<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings() {
        return this.createSpokeOperationSettings;
    }

    public UnaryCallSettings<UpdateSpokeRequest, Operation> updateSpokeSettings() {
        return this.updateSpokeSettings;
    }

    public OperationCallSettings<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings() {
        return this.updateSpokeOperationSettings;
    }

    public UnaryCallSettings<DeleteSpokeRequest, Operation> deleteSpokeSettings() {
        return this.deleteSpokeSettings;
    }

    public OperationCallSettings<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings() {
        return this.deleteSpokeOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public HubServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcHubServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "networkconnectivity.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return HubServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(HubServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected HubServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listHubsSettings = settingsBuilder.listHubsSettings().build();
        this.getHubSettings = settingsBuilder.getHubSettings().build();
        this.createHubSettings = settingsBuilder.createHubSettings().build();
        this.createHubOperationSettings = settingsBuilder.createHubOperationSettings().build();
        this.updateHubSettings = settingsBuilder.updateHubSettings().build();
        this.updateHubOperationSettings = settingsBuilder.updateHubOperationSettings().build();
        this.deleteHubSettings = settingsBuilder.deleteHubSettings().build();
        this.deleteHubOperationSettings = settingsBuilder.deleteHubOperationSettings().build();
        this.listSpokesSettings = settingsBuilder.listSpokesSettings().build();
        this.getSpokeSettings = settingsBuilder.getSpokeSettings().build();
        this.createSpokeSettings = settingsBuilder.createSpokeSettings().build();
        this.createSpokeOperationSettings = settingsBuilder.createSpokeOperationSettings().build();
        this.updateSpokeSettings = settingsBuilder.updateSpokeSettings().build();
        this.updateSpokeOperationSettings = settingsBuilder.updateSpokeOperationSettings().build();
        this.deleteSpokeSettings = settingsBuilder.deleteSpokeSettings().build();
        this.deleteSpokeOperationSettings = settingsBuilder.deleteSpokeOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<HubServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings;
        private final UnaryCallSettings.Builder<GetHubRequest, Hub> getHubSettings;
        private final UnaryCallSettings.Builder<CreateHubRequest, Operation> createHubSettings;
        private final OperationCallSettings.Builder<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings;
        private final UnaryCallSettings.Builder<UpdateHubRequest, Operation> updateHubSettings;
        private final OperationCallSettings.Builder<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings;
        private final UnaryCallSettings.Builder<DeleteHubRequest, Operation> deleteHubSettings;
        private final OperationCallSettings.Builder<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings;
        private final PagedCallSettings.Builder<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings;
        private final UnaryCallSettings.Builder<GetSpokeRequest, Spoke> getSpokeSettings;
        private final UnaryCallSettings.Builder<CreateSpokeRequest, Operation> createSpokeSettings;
        private final OperationCallSettings.Builder<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSpokeRequest, Operation> updateSpokeSettings;
        private final OperationCallSettings.Builder<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSpokeRequest, Operation> deleteSpokeSettings;
        private final OperationCallSettings.Builder<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listHubsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_HUBS_PAGE_STR_FACT);
            this.getHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createHubOperationSettings = OperationCallSettings.newBuilder();
            this.updateHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateHubOperationSettings = OperationCallSettings.newBuilder();
            this.deleteHubSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteHubOperationSettings = OperationCallSettings.newBuilder();
            this.listSpokesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SPOKES_PAGE_STR_FACT);
            this.getSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.updateSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSpokeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSpokeOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listHubsSettings, this.getHubSettings, this.createHubSettings, this.updateHubSettings, this.deleteHubSettings, this.listSpokesSettings, this.getSpokeSettings, this.createSpokeSettings, this.updateSpokeSettings, this.deleteSpokeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(HubServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listHubsSettings = settings.listHubsSettings.toBuilder();
            this.getHubSettings = settings.getHubSettings.toBuilder();
            this.createHubSettings = settings.createHubSettings.toBuilder();
            this.createHubOperationSettings = settings.createHubOperationSettings.toBuilder();
            this.updateHubSettings = settings.updateHubSettings.toBuilder();
            this.updateHubOperationSettings = settings.updateHubOperationSettings.toBuilder();
            this.deleteHubSettings = settings.deleteHubSettings.toBuilder();
            this.deleteHubOperationSettings = settings.deleteHubOperationSettings.toBuilder();
            this.listSpokesSettings = settings.listSpokesSettings.toBuilder();
            this.getSpokeSettings = settings.getSpokeSettings.toBuilder();
            this.createSpokeSettings = settings.createSpokeSettings.toBuilder();
            this.createSpokeOperationSettings = settings.createSpokeOperationSettings.toBuilder();
            this.updateSpokeSettings = settings.updateSpokeSettings.toBuilder();
            this.updateSpokeOperationSettings = settings.updateSpokeOperationSettings.toBuilder();
            this.deleteSpokeSettings = settings.deleteSpokeSettings.toBuilder();
            this.deleteSpokeOperationSettings = settings.deleteSpokeOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listHubsSettings, this.getHubSettings, this.createHubSettings, this.updateHubSettings, this.deleteHubSettings, this.listSpokesSettings, this.getSpokeSettings, this.createSpokeSettings, this.updateSpokeSettings, this.deleteSpokeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(HubServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)HubServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)HubServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(HubServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listHubsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteHubSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSpokesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSpokeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Hub.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Hub.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteHubOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Spoke.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Spoke.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSpokeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListHubsRequest, ListHubsResponse, HubServiceClient.ListHubsPagedResponse> listHubsSettings() {
            return this.listHubsSettings;
        }

        public UnaryCallSettings.Builder<GetHubRequest, Hub> getHubSettings() {
            return this.getHubSettings;
        }

        public UnaryCallSettings.Builder<CreateHubRequest, Operation> createHubSettings() {
            return this.createHubSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateHubRequest, Hub, OperationMetadata> createHubOperationSettings() {
            return this.createHubOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateHubRequest, Operation> updateHubSettings() {
            return this.updateHubSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateHubRequest, Hub, OperationMetadata> updateHubOperationSettings() {
            return this.updateHubOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteHubRequest, Operation> deleteHubSettings() {
            return this.deleteHubSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteHubRequest, Empty, OperationMetadata> deleteHubOperationSettings() {
            return this.deleteHubOperationSettings;
        }

        public PagedCallSettings.Builder<ListSpokesRequest, ListSpokesResponse, HubServiceClient.ListSpokesPagedResponse> listSpokesSettings() {
            return this.listSpokesSettings;
        }

        public UnaryCallSettings.Builder<GetSpokeRequest, Spoke> getSpokeSettings() {
            return this.getSpokeSettings;
        }

        public UnaryCallSettings.Builder<CreateSpokeRequest, Operation> createSpokeSettings() {
            return this.createSpokeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSpokeRequest, Spoke, OperationMetadata> createSpokeOperationSettings() {
            return this.createSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpokeRequest, Operation> updateSpokeSettings() {
            return this.updateSpokeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateSpokeRequest, Spoke, OperationMetadata> updateSpokeOperationSettings() {
            return this.updateSpokeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSpokeRequest, Operation> deleteSpokeSettings() {
            return this.deleteSpokeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSpokeRequest, Empty, OperationMetadata> deleteSpokeOperationSettings() {
            return this.deleteSpokeOperationSettings;
        }

        public HubServiceStubSettings build() throws IOException {
            return new HubServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

