/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networksecurity.v1.AddAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.AddressGroup;
import com.google.cloud.networksecurity.v1.CloneAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.CreateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.DeleteAddressGroupRequest;
import com.google.cloud.networksecurity.v1.GetAddressGroupRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupReferencesResponse;
import com.google.cloud.networksecurity.v1.ListAddressGroupsRequest;
import com.google.cloud.networksecurity.v1.ListAddressGroupsResponse;
import com.google.cloud.networksecurity.v1.OperationMetadata;
import com.google.cloud.networksecurity.v1.OrganizationAddressGroupServiceClient;
import com.google.cloud.networksecurity.v1.RemoveAddressGroupItemsRequest;
import com.google.cloud.networksecurity.v1.UpdateAddressGroupRequest;
import com.google.cloud.networksecurity.v1.stub.GrpcOrganizationAddressGroupServiceStub;
import com.google.cloud.networksecurity.v1.stub.OrganizationAddressGroupServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OrganizationAddressGroupServiceStubSettings
extends StubSettings<OrganizationAddressGroupServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsSettings;
    private final UnaryCallSettings<GetAddressGroupRequest, AddressGroup> getAddressGroupSettings;
    private final UnaryCallSettings<CreateAddressGroupRequest, Operation> createAddressGroupSettings;
    private final OperationCallSettings<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationSettings;
    private final UnaryCallSettings<UpdateAddressGroupRequest, Operation> updateAddressGroupSettings;
    private final OperationCallSettings<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationSettings;
    private final UnaryCallSettings<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsSettings;
    private final OperationCallSettings<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationSettings;
    private final UnaryCallSettings<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsSettings;
    private final OperationCallSettings<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationSettings;
    private final UnaryCallSettings<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsSettings;
    private final OperationCallSettings<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationSettings;
    private final UnaryCallSettings<DeleteAddressGroupRequest, Operation> deleteAddressGroupSettings;
    private final OperationCallSettings<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationSettings;
    private final PagedCallSettings<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup> LIST_ADDRESS_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListAddressGroupsRequest injectToken(ListAddressGroupsRequest payload, String token) {
            return ListAddressGroupsRequest.newBuilder((ListAddressGroupsRequest)payload).setPageToken(token).build();
        }

        public ListAddressGroupsRequest injectPageSize(ListAddressGroupsRequest payload, int pageSize) {
            return ListAddressGroupsRequest.newBuilder((ListAddressGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAddressGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAddressGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AddressGroup> extractResources(ListAddressGroupsResponse payload) {
            return payload.getAddressGroupsList();
        }
    };
    private static final PagedListDescriptor<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference> LIST_ADDRESS_GROUP_REFERENCES_PAGE_STR_DESC = new PagedListDescriptor<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference>(){

        public String emptyToken() {
            return "";
        }

        public ListAddressGroupReferencesRequest injectToken(ListAddressGroupReferencesRequest payload, String token) {
            return ListAddressGroupReferencesRequest.newBuilder((ListAddressGroupReferencesRequest)payload).setPageToken(token).build();
        }

        public ListAddressGroupReferencesRequest injectPageSize(ListAddressGroupReferencesRequest payload, int pageSize) {
            return ListAddressGroupReferencesRequest.newBuilder((ListAddressGroupReferencesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAddressGroupReferencesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAddressGroupReferencesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ListAddressGroupReferencesResponse.AddressGroupReference> extractResources(ListAddressGroupReferencesResponse payload) {
            return payload.getAddressGroupReferencesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> LIST_ADDRESS_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse>(){

        public ApiFuture<OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAddressGroupsRequest, ListAddressGroupsResponse> callable, ListAddressGroupsRequest request, ApiCallContext context, ApiFuture<ListAddressGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADDRESS_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse.createAsync((PageContext<ListAddressGroupsRequest, ListAddressGroupsResponse, AddressGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> LIST_ADDRESS_GROUP_REFERENCES_PAGE_STR_FACT = new PagedListResponseFactory<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse>(){

        public ApiFuture<OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse> callable, ListAddressGroupReferencesRequest request, ApiCallContext context, ApiFuture<ListAddressGroupReferencesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ADDRESS_GROUP_REFERENCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse.createAsync((PageContext<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, ListAddressGroupReferencesResponse.AddressGroupReference>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrganizationAddressGroupServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsSettings() {
        return this.listAddressGroupsSettings;
    }

    public UnaryCallSettings<GetAddressGroupRequest, AddressGroup> getAddressGroupSettings() {
        return this.getAddressGroupSettings;
    }

    public UnaryCallSettings<CreateAddressGroupRequest, Operation> createAddressGroupSettings() {
        return this.createAddressGroupSettings;
    }

    public OperationCallSettings<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationSettings() {
        return this.createAddressGroupOperationSettings;
    }

    public UnaryCallSettings<UpdateAddressGroupRequest, Operation> updateAddressGroupSettings() {
        return this.updateAddressGroupSettings;
    }

    public OperationCallSettings<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationSettings() {
        return this.updateAddressGroupOperationSettings;
    }

    public UnaryCallSettings<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsSettings() {
        return this.addAddressGroupItemsSettings;
    }

    public OperationCallSettings<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationSettings() {
        return this.addAddressGroupItemsOperationSettings;
    }

    public UnaryCallSettings<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsSettings() {
        return this.removeAddressGroupItemsSettings;
    }

    public OperationCallSettings<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationSettings() {
        return this.removeAddressGroupItemsOperationSettings;
    }

    public UnaryCallSettings<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsSettings() {
        return this.cloneAddressGroupItemsSettings;
    }

    public OperationCallSettings<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationSettings() {
        return this.cloneAddressGroupItemsOperationSettings;
    }

    public UnaryCallSettings<DeleteAddressGroupRequest, Operation> deleteAddressGroupSettings() {
        return this.deleteAddressGroupSettings;
    }

    public OperationCallSettings<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationSettings() {
        return this.deleteAddressGroupOperationSettings;
    }

    public PagedCallSettings<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesSettings() {
        return this.listAddressGroupReferencesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public OrganizationAddressGroupServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOrganizationAddressGroupServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networksecurity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networksecurity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networksecurity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OrganizationAddressGroupServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OrganizationAddressGroupServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OrganizationAddressGroupServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAddressGroupsSettings = settingsBuilder.listAddressGroupsSettings().build();
        this.getAddressGroupSettings = settingsBuilder.getAddressGroupSettings().build();
        this.createAddressGroupSettings = settingsBuilder.createAddressGroupSettings().build();
        this.createAddressGroupOperationSettings = settingsBuilder.createAddressGroupOperationSettings().build();
        this.updateAddressGroupSettings = settingsBuilder.updateAddressGroupSettings().build();
        this.updateAddressGroupOperationSettings = settingsBuilder.updateAddressGroupOperationSettings().build();
        this.addAddressGroupItemsSettings = settingsBuilder.addAddressGroupItemsSettings().build();
        this.addAddressGroupItemsOperationSettings = settingsBuilder.addAddressGroupItemsOperationSettings().build();
        this.removeAddressGroupItemsSettings = settingsBuilder.removeAddressGroupItemsSettings().build();
        this.removeAddressGroupItemsOperationSettings = settingsBuilder.removeAddressGroupItemsOperationSettings().build();
        this.cloneAddressGroupItemsSettings = settingsBuilder.cloneAddressGroupItemsSettings().build();
        this.cloneAddressGroupItemsOperationSettings = settingsBuilder.cloneAddressGroupItemsOperationSettings().build();
        this.deleteAddressGroupSettings = settingsBuilder.deleteAddressGroupSettings().build();
        this.deleteAddressGroupOperationSettings = settingsBuilder.deleteAddressGroupOperationSettings().build();
        this.listAddressGroupReferencesSettings = settingsBuilder.listAddressGroupReferencesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OrganizationAddressGroupServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsSettings;
        private final UnaryCallSettings.Builder<GetAddressGroupRequest, AddressGroup> getAddressGroupSettings;
        private final UnaryCallSettings.Builder<CreateAddressGroupRequest, Operation> createAddressGroupSettings;
        private final OperationCallSettings.Builder<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAddressGroupRequest, Operation> updateAddressGroupSettings;
        private final OperationCallSettings.Builder<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationSettings;
        private final UnaryCallSettings.Builder<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsSettings;
        private final OperationCallSettings.Builder<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationSettings;
        private final UnaryCallSettings.Builder<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsSettings;
        private final OperationCallSettings.Builder<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationSettings;
        private final UnaryCallSettings.Builder<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsSettings;
        private final OperationCallSettings.Builder<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAddressGroupRequest, Operation> deleteAddressGroupSettings;
        private final OperationCallSettings.Builder<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationSettings;
        private final PagedCallSettings.Builder<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAddressGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADDRESS_GROUPS_PAGE_STR_FACT);
            this.getAddressGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAddressGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAddressGroupOperationSettings = OperationCallSettings.newBuilder();
            this.updateAddressGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAddressGroupOperationSettings = OperationCallSettings.newBuilder();
            this.addAddressGroupItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addAddressGroupItemsOperationSettings = OperationCallSettings.newBuilder();
            this.removeAddressGroupItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAddressGroupItemsOperationSettings = OperationCallSettings.newBuilder();
            this.cloneAddressGroupItemsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cloneAddressGroupItemsOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAddressGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAddressGroupOperationSettings = OperationCallSettings.newBuilder();
            this.listAddressGroupReferencesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ADDRESS_GROUP_REFERENCES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAddressGroupsSettings, this.getAddressGroupSettings, this.createAddressGroupSettings, this.updateAddressGroupSettings, this.addAddressGroupItemsSettings, this.removeAddressGroupItemsSettings, this.cloneAddressGroupItemsSettings, this.deleteAddressGroupSettings, this.listAddressGroupReferencesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(OrganizationAddressGroupServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAddressGroupsSettings = settings.listAddressGroupsSettings.toBuilder();
            this.getAddressGroupSettings = settings.getAddressGroupSettings.toBuilder();
            this.createAddressGroupSettings = settings.createAddressGroupSettings.toBuilder();
            this.createAddressGroupOperationSettings = settings.createAddressGroupOperationSettings.toBuilder();
            this.updateAddressGroupSettings = settings.updateAddressGroupSettings.toBuilder();
            this.updateAddressGroupOperationSettings = settings.updateAddressGroupOperationSettings.toBuilder();
            this.addAddressGroupItemsSettings = settings.addAddressGroupItemsSettings.toBuilder();
            this.addAddressGroupItemsOperationSettings = settings.addAddressGroupItemsOperationSettings.toBuilder();
            this.removeAddressGroupItemsSettings = settings.removeAddressGroupItemsSettings.toBuilder();
            this.removeAddressGroupItemsOperationSettings = settings.removeAddressGroupItemsOperationSettings.toBuilder();
            this.cloneAddressGroupItemsSettings = settings.cloneAddressGroupItemsSettings.toBuilder();
            this.cloneAddressGroupItemsOperationSettings = settings.cloneAddressGroupItemsOperationSettings.toBuilder();
            this.deleteAddressGroupSettings = settings.deleteAddressGroupSettings.toBuilder();
            this.deleteAddressGroupOperationSettings = settings.deleteAddressGroupOperationSettings.toBuilder();
            this.listAddressGroupReferencesSettings = settings.listAddressGroupReferencesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAddressGroupsSettings, this.getAddressGroupSettings, this.createAddressGroupSettings, this.updateAddressGroupSettings, this.addAddressGroupItemsSettings, this.removeAddressGroupItemsSettings, this.cloneAddressGroupItemsSettings, this.deleteAddressGroupSettings, this.listAddressGroupReferencesSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OrganizationAddressGroupServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OrganizationAddressGroupServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OrganizationAddressGroupServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OrganizationAddressGroupServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAddressGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAddressGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAddressGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateAddressGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.addAddressGroupItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.removeAddressGroupItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.cloneAddressGroupItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAddressGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAddressGroupReferencesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAddressGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddressGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateAddressGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddressGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.addAddressGroupItemsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddressGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.removeAddressGroupItemsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddressGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.cloneAddressGroupItemsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddressGroup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteAddressGroupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAddressGroupsRequest, ListAddressGroupsResponse, OrganizationAddressGroupServiceClient.ListAddressGroupsPagedResponse> listAddressGroupsSettings() {
            return this.listAddressGroupsSettings;
        }

        public UnaryCallSettings.Builder<GetAddressGroupRequest, AddressGroup> getAddressGroupSettings() {
            return this.getAddressGroupSettings;
        }

        public UnaryCallSettings.Builder<CreateAddressGroupRequest, Operation> createAddressGroupSettings() {
            return this.createAddressGroupSettings;
        }

        public OperationCallSettings.Builder<CreateAddressGroupRequest, AddressGroup, OperationMetadata> createAddressGroupOperationSettings() {
            return this.createAddressGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAddressGroupRequest, Operation> updateAddressGroupSettings() {
            return this.updateAddressGroupSettings;
        }

        public OperationCallSettings.Builder<UpdateAddressGroupRequest, AddressGroup, OperationMetadata> updateAddressGroupOperationSettings() {
            return this.updateAddressGroupOperationSettings;
        }

        public UnaryCallSettings.Builder<AddAddressGroupItemsRequest, Operation> addAddressGroupItemsSettings() {
            return this.addAddressGroupItemsSettings;
        }

        public OperationCallSettings.Builder<AddAddressGroupItemsRequest, AddressGroup, OperationMetadata> addAddressGroupItemsOperationSettings() {
            return this.addAddressGroupItemsOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveAddressGroupItemsRequest, Operation> removeAddressGroupItemsSettings() {
            return this.removeAddressGroupItemsSettings;
        }

        public OperationCallSettings.Builder<RemoveAddressGroupItemsRequest, AddressGroup, OperationMetadata> removeAddressGroupItemsOperationSettings() {
            return this.removeAddressGroupItemsOperationSettings;
        }

        public UnaryCallSettings.Builder<CloneAddressGroupItemsRequest, Operation> cloneAddressGroupItemsSettings() {
            return this.cloneAddressGroupItemsSettings;
        }

        public OperationCallSettings.Builder<CloneAddressGroupItemsRequest, AddressGroup, OperationMetadata> cloneAddressGroupItemsOperationSettings() {
            return this.cloneAddressGroupItemsOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAddressGroupRequest, Operation> deleteAddressGroupSettings() {
            return this.deleteAddressGroupSettings;
        }

        public OperationCallSettings.Builder<DeleteAddressGroupRequest, Empty, OperationMetadata> deleteAddressGroupOperationSettings() {
            return this.deleteAddressGroupOperationSettings;
        }

        public PagedCallSettings.Builder<ListAddressGroupReferencesRequest, ListAddressGroupReferencesResponse, OrganizationAddressGroupServiceClient.ListAddressGroupReferencesPagedResponse> listAddressGroupReferencesSettings() {
            return this.listAddressGroupReferencesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, OrganizationAddressGroupServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public OrganizationAddressGroupServiceStubSettings build() throws IOException {
            return new OrganizationAddressGroupServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

