/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.netapp.v1beta1.ActiveDirectory;
import com.google.cloud.netapp.v1beta1.ActiveDirectoryName;
import com.google.cloud.netapp.v1beta1.CreateActiveDirectoryRequest;
import com.google.cloud.netapp.v1beta1.CreateKmsConfigRequest;
import com.google.cloud.netapp.v1beta1.CreateReplicationRequest;
import com.google.cloud.netapp.v1beta1.CreateSnapshotRequest;
import com.google.cloud.netapp.v1beta1.CreateStoragePoolRequest;
import com.google.cloud.netapp.v1beta1.CreateVolumeRequest;
import com.google.cloud.netapp.v1beta1.DeleteActiveDirectoryRequest;
import com.google.cloud.netapp.v1beta1.DeleteKmsConfigRequest;
import com.google.cloud.netapp.v1beta1.DeleteReplicationRequest;
import com.google.cloud.netapp.v1beta1.DeleteSnapshotRequest;
import com.google.cloud.netapp.v1beta1.DeleteStoragePoolRequest;
import com.google.cloud.netapp.v1beta1.DeleteVolumeRequest;
import com.google.cloud.netapp.v1beta1.EncryptVolumesRequest;
import com.google.cloud.netapp.v1beta1.GetActiveDirectoryRequest;
import com.google.cloud.netapp.v1beta1.GetKmsConfigRequest;
import com.google.cloud.netapp.v1beta1.GetReplicationRequest;
import com.google.cloud.netapp.v1beta1.GetSnapshotRequest;
import com.google.cloud.netapp.v1beta1.GetStoragePoolRequest;
import com.google.cloud.netapp.v1beta1.GetVolumeRequest;
import com.google.cloud.netapp.v1beta1.KmsConfig;
import com.google.cloud.netapp.v1beta1.KmsConfigName;
import com.google.cloud.netapp.v1beta1.ListActiveDirectoriesRequest;
import com.google.cloud.netapp.v1beta1.ListActiveDirectoriesResponse;
import com.google.cloud.netapp.v1beta1.ListKmsConfigsRequest;
import com.google.cloud.netapp.v1beta1.ListKmsConfigsResponse;
import com.google.cloud.netapp.v1beta1.ListReplicationsRequest;
import com.google.cloud.netapp.v1beta1.ListReplicationsResponse;
import com.google.cloud.netapp.v1beta1.ListSnapshotsRequest;
import com.google.cloud.netapp.v1beta1.ListSnapshotsResponse;
import com.google.cloud.netapp.v1beta1.ListStoragePoolsRequest;
import com.google.cloud.netapp.v1beta1.ListStoragePoolsResponse;
import com.google.cloud.netapp.v1beta1.ListVolumesRequest;
import com.google.cloud.netapp.v1beta1.ListVolumesResponse;
import com.google.cloud.netapp.v1beta1.LocationName;
import com.google.cloud.netapp.v1beta1.NetAppSettings;
import com.google.cloud.netapp.v1beta1.OperationMetadata;
import com.google.cloud.netapp.v1beta1.Replication;
import com.google.cloud.netapp.v1beta1.ReplicationName;
import com.google.cloud.netapp.v1beta1.ResumeReplicationRequest;
import com.google.cloud.netapp.v1beta1.ReverseReplicationDirectionRequest;
import com.google.cloud.netapp.v1beta1.RevertVolumeRequest;
import com.google.cloud.netapp.v1beta1.Snapshot;
import com.google.cloud.netapp.v1beta1.SnapshotName;
import com.google.cloud.netapp.v1beta1.StopReplicationRequest;
import com.google.cloud.netapp.v1beta1.StoragePool;
import com.google.cloud.netapp.v1beta1.StoragePoolName;
import com.google.cloud.netapp.v1beta1.UpdateActiveDirectoryRequest;
import com.google.cloud.netapp.v1beta1.UpdateKmsConfigRequest;
import com.google.cloud.netapp.v1beta1.UpdateReplicationRequest;
import com.google.cloud.netapp.v1beta1.UpdateSnapshotRequest;
import com.google.cloud.netapp.v1beta1.UpdateStoragePoolRequest;
import com.google.cloud.netapp.v1beta1.UpdateVolumeRequest;
import com.google.cloud.netapp.v1beta1.VerifyKmsConfigRequest;
import com.google.cloud.netapp.v1beta1.VerifyKmsConfigResponse;
import com.google.cloud.netapp.v1beta1.Volume;
import com.google.cloud.netapp.v1beta1.VolumeName;
import com.google.cloud.netapp.v1beta1.stub.NetAppStub;
import com.google.cloud.netapp.v1beta1.stub.NetAppStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class NetAppClient
implements BackgroundResource {
    private final NetAppSettings settings;
    private final NetAppStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final NetAppClient create() throws IOException {
        return NetAppClient.create(NetAppSettings.newBuilder().build());
    }

    public static final NetAppClient create(NetAppSettings settings) throws IOException {
        return new NetAppClient(settings);
    }

    public static final NetAppClient create(NetAppStub stub) {
        return new NetAppClient(stub);
    }

    protected NetAppClient(NetAppSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetAppStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected NetAppClient(NetAppStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final NetAppSettings getSettings() {
        return this.settings;
    }

    public NetAppStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListStoragePoolsPagedResponse listStoragePools(LocationName parent) {
        ListStoragePoolsRequest request = ListStoragePoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listStoragePools(request);
    }

    public final ListStoragePoolsPagedResponse listStoragePools(String parent) {
        ListStoragePoolsRequest request = ListStoragePoolsRequest.newBuilder().setParent(parent).build();
        return this.listStoragePools(request);
    }

    public final ListStoragePoolsPagedResponse listStoragePools(ListStoragePoolsRequest request) {
        return (ListStoragePoolsPagedResponse)((Object)this.listStoragePoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStoragePoolsRequest, ListStoragePoolsPagedResponse> listStoragePoolsPagedCallable() {
        return this.stub.listStoragePoolsPagedCallable();
    }

    public final UnaryCallable<ListStoragePoolsRequest, ListStoragePoolsResponse> listStoragePoolsCallable() {
        return this.stub.listStoragePoolsCallable();
    }

    public final OperationFuture<StoragePool, OperationMetadata> createStoragePoolAsync(LocationName parent, StoragePool storagePool, String storagePoolId) {
        CreateStoragePoolRequest request = CreateStoragePoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setStoragePool(storagePool).setStoragePoolId(storagePoolId).build();
        return this.createStoragePoolAsync(request);
    }

    public final OperationFuture<StoragePool, OperationMetadata> createStoragePoolAsync(String parent, StoragePool storagePool, String storagePoolId) {
        CreateStoragePoolRequest request = CreateStoragePoolRequest.newBuilder().setParent(parent).setStoragePool(storagePool).setStoragePoolId(storagePoolId).build();
        return this.createStoragePoolAsync(request);
    }

    public final OperationFuture<StoragePool, OperationMetadata> createStoragePoolAsync(CreateStoragePoolRequest request) {
        return this.createStoragePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateStoragePoolRequest, StoragePool, OperationMetadata> createStoragePoolOperationCallable() {
        return this.stub.createStoragePoolOperationCallable();
    }

    public final UnaryCallable<CreateStoragePoolRequest, Operation> createStoragePoolCallable() {
        return this.stub.createStoragePoolCallable();
    }

    public final StoragePool getStoragePool(StoragePoolName name) {
        GetStoragePoolRequest request = GetStoragePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStoragePool(request);
    }

    public final StoragePool getStoragePool(String name) {
        GetStoragePoolRequest request = GetStoragePoolRequest.newBuilder().setName(name).build();
        return this.getStoragePool(request);
    }

    public final StoragePool getStoragePool(GetStoragePoolRequest request) {
        return (StoragePool)this.getStoragePoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetStoragePoolRequest, StoragePool> getStoragePoolCallable() {
        return this.stub.getStoragePoolCallable();
    }

    public final OperationFuture<StoragePool, OperationMetadata> updateStoragePoolAsync(StoragePool storagePool, FieldMask updateMask) {
        UpdateStoragePoolRequest request = UpdateStoragePoolRequest.newBuilder().setStoragePool(storagePool).setUpdateMask(updateMask).build();
        return this.updateStoragePoolAsync(request);
    }

    public final OperationFuture<StoragePool, OperationMetadata> updateStoragePoolAsync(UpdateStoragePoolRequest request) {
        return this.updateStoragePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateStoragePoolRequest, StoragePool, OperationMetadata> updateStoragePoolOperationCallable() {
        return this.stub.updateStoragePoolOperationCallable();
    }

    public final UnaryCallable<UpdateStoragePoolRequest, Operation> updateStoragePoolCallable() {
        return this.stub.updateStoragePoolCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStoragePoolAsync(StoragePoolName name) {
        DeleteStoragePoolRequest request = DeleteStoragePoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteStoragePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStoragePoolAsync(String name) {
        DeleteStoragePoolRequest request = DeleteStoragePoolRequest.newBuilder().setName(name).build();
        return this.deleteStoragePoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteStoragePoolAsync(DeleteStoragePoolRequest request) {
        return this.deleteStoragePoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteStoragePoolRequest, Empty, OperationMetadata> deleteStoragePoolOperationCallable() {
        return this.stub.deleteStoragePoolOperationCallable();
    }

    public final UnaryCallable<DeleteStoragePoolRequest, Operation> deleteStoragePoolCallable() {
        return this.stub.deleteStoragePoolCallable();
    }

    public final ListVolumesPagedResponse listVolumes(LocationName parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(String parent) {
        ListVolumesRequest request = ListVolumesRequest.newBuilder().setParent(parent).build();
        return this.listVolumes(request);
    }

    public final ListVolumesPagedResponse listVolumes(ListVolumesRequest request) {
        return (ListVolumesPagedResponse)((Object)this.listVolumesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesPagedResponse> listVolumesPagedCallable() {
        return this.stub.listVolumesPagedCallable();
    }

    public final UnaryCallable<ListVolumesRequest, ListVolumesResponse> listVolumesCallable() {
        return this.stub.listVolumesCallable();
    }

    public final Volume getVolume(VolumeName name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(String name) {
        GetVolumeRequest request = GetVolumeRequest.newBuilder().setName(name).build();
        return this.getVolume(request);
    }

    public final Volume getVolume(GetVolumeRequest request) {
        return (Volume)this.getVolumeCallable().call((Object)request);
    }

    public final UnaryCallable<GetVolumeRequest, Volume> getVolumeCallable() {
        return this.stub.getVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> createVolumeAsync(LocationName parent, Volume volume, String volumeId) {
        CreateVolumeRequest request = CreateVolumeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVolume(volume).setVolumeId(volumeId).build();
        return this.createVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> createVolumeAsync(String parent, Volume volume, String volumeId) {
        CreateVolumeRequest request = CreateVolumeRequest.newBuilder().setParent(parent).setVolume(volume).setVolumeId(volumeId).build();
        return this.createVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> createVolumeAsync(CreateVolumeRequest request) {
        return this.createVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVolumeRequest, Volume, OperationMetadata> createVolumeOperationCallable() {
        return this.stub.createVolumeOperationCallable();
    }

    public final UnaryCallable<CreateVolumeRequest, Operation> createVolumeCallable() {
        return this.stub.createVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(Volume volume, FieldMask updateMask) {
        UpdateVolumeRequest request = UpdateVolumeRequest.newBuilder().setVolume(volume).setUpdateMask(updateMask).build();
        return this.updateVolumeAsync(request);
    }

    public final OperationFuture<Volume, OperationMetadata> updateVolumeAsync(UpdateVolumeRequest request) {
        return this.updateVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVolumeRequest, Volume, OperationMetadata> updateVolumeOperationCallable() {
        return this.stub.updateVolumeOperationCallable();
    }

    public final UnaryCallable<UpdateVolumeRequest, Operation> updateVolumeCallable() {
        return this.stub.updateVolumeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVolumeAsync(VolumeName name) {
        DeleteVolumeRequest request = DeleteVolumeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVolumeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVolumeAsync(String name) {
        DeleteVolumeRequest request = DeleteVolumeRequest.newBuilder().setName(name).build();
        return this.deleteVolumeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVolumeAsync(DeleteVolumeRequest request) {
        return this.deleteVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVolumeRequest, Empty, OperationMetadata> deleteVolumeOperationCallable() {
        return this.stub.deleteVolumeOperationCallable();
    }

    public final UnaryCallable<DeleteVolumeRequest, Operation> deleteVolumeCallable() {
        return this.stub.deleteVolumeCallable();
    }

    public final OperationFuture<Volume, OperationMetadata> revertVolumeAsync(RevertVolumeRequest request) {
        return this.revertVolumeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RevertVolumeRequest, Volume, OperationMetadata> revertVolumeOperationCallable() {
        return this.stub.revertVolumeOperationCallable();
    }

    public final UnaryCallable<RevertVolumeRequest, Operation> revertVolumeCallable() {
        return this.stub.revertVolumeCallable();
    }

    public final ListSnapshotsPagedResponse listSnapshots(VolumeName parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(String parent) {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(parent).build();
        return this.listSnapshots(request);
    }

    public final ListSnapshotsPagedResponse listSnapshots(ListSnapshotsRequest request) {
        return (ListSnapshotsPagedResponse)((Object)this.listSnapshotsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.stub.listSnapshotsPagedCallable();
    }

    public final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.stub.listSnapshotsCallable();
    }

    public final Snapshot getSnapshot(SnapshotName name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(String name) {
        GetSnapshotRequest request = GetSnapshotRequest.newBuilder().setName(name).build();
        return this.getSnapshot(request);
    }

    public final Snapshot getSnapshot(GetSnapshotRequest request) {
        return (Snapshot)this.getSnapshotCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.stub.getSnapshotCallable();
    }

    public final OperationFuture<Snapshot, OperationMetadata> createSnapshotAsync(VolumeName parent, Snapshot snapshot, String snapshotId) {
        CreateSnapshotRequest request = CreateSnapshotRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSnapshot(snapshot).setSnapshotId(snapshotId).build();
        return this.createSnapshotAsync(request);
    }

    public final OperationFuture<Snapshot, OperationMetadata> createSnapshotAsync(String parent, Snapshot snapshot, String snapshotId) {
        CreateSnapshotRequest request = CreateSnapshotRequest.newBuilder().setParent(parent).setSnapshot(snapshot).setSnapshotId(snapshotId).build();
        return this.createSnapshotAsync(request);
    }

    public final OperationFuture<Snapshot, OperationMetadata> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationCallable() {
        return this.stub.createSnapshotOperationCallable();
    }

    public final UnaryCallable<CreateSnapshotRequest, Operation> createSnapshotCallable() {
        return this.stub.createSnapshotCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSnapshotAsync(SnapshotName name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSnapshotAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSnapshotAsync(String name) {
        DeleteSnapshotRequest request = DeleteSnapshotRequest.newBuilder().setName(name).build();
        return this.deleteSnapshotAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationCallable() {
        return this.stub.deleteSnapshotOperationCallable();
    }

    public final UnaryCallable<DeleteSnapshotRequest, Operation> deleteSnapshotCallable() {
        return this.stub.deleteSnapshotCallable();
    }

    public final OperationFuture<Snapshot, OperationMetadata> updateSnapshotAsync(Snapshot snapshot, FieldMask updateMask) {
        UpdateSnapshotRequest request = UpdateSnapshotRequest.newBuilder().setSnapshot(snapshot).setUpdateMask(updateMask).build();
        return this.updateSnapshotAsync(request);
    }

    public final OperationFuture<Snapshot, OperationMetadata> updateSnapshotAsync(UpdateSnapshotRequest request) {
        return this.updateSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationCallable() {
        return this.stub.updateSnapshotOperationCallable();
    }

    public final UnaryCallable<UpdateSnapshotRequest, Operation> updateSnapshotCallable() {
        return this.stub.updateSnapshotCallable();
    }

    public final ListActiveDirectoriesPagedResponse listActiveDirectories(LocationName parent) {
        ListActiveDirectoriesRequest request = ListActiveDirectoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listActiveDirectories(request);
    }

    public final ListActiveDirectoriesPagedResponse listActiveDirectories(String parent) {
        ListActiveDirectoriesRequest request = ListActiveDirectoriesRequest.newBuilder().setParent(parent).build();
        return this.listActiveDirectories(request);
    }

    public final ListActiveDirectoriesPagedResponse listActiveDirectories(ListActiveDirectoriesRequest request) {
        return (ListActiveDirectoriesPagedResponse)((Object)this.listActiveDirectoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListActiveDirectoriesRequest, ListActiveDirectoriesPagedResponse> listActiveDirectoriesPagedCallable() {
        return this.stub.listActiveDirectoriesPagedCallable();
    }

    public final UnaryCallable<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse> listActiveDirectoriesCallable() {
        return this.stub.listActiveDirectoriesCallable();
    }

    public final ActiveDirectory getActiveDirectory(ActiveDirectoryName name) {
        GetActiveDirectoryRequest request = GetActiveDirectoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getActiveDirectory(request);
    }

    public final ActiveDirectory getActiveDirectory(String name) {
        GetActiveDirectoryRequest request = GetActiveDirectoryRequest.newBuilder().setName(name).build();
        return this.getActiveDirectory(request);
    }

    public final ActiveDirectory getActiveDirectory(GetActiveDirectoryRequest request) {
        return (ActiveDirectory)this.getActiveDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetActiveDirectoryRequest, ActiveDirectory> getActiveDirectoryCallable() {
        return this.stub.getActiveDirectoryCallable();
    }

    public final OperationFuture<ActiveDirectory, OperationMetadata> createActiveDirectoryAsync(LocationName parent, ActiveDirectory activeDirectory, String activeDirectoryId) {
        CreateActiveDirectoryRequest request = CreateActiveDirectoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setActiveDirectory(activeDirectory).setActiveDirectoryId(activeDirectoryId).build();
        return this.createActiveDirectoryAsync(request);
    }

    public final OperationFuture<ActiveDirectory, OperationMetadata> createActiveDirectoryAsync(String parent, ActiveDirectory activeDirectory, String activeDirectoryId) {
        CreateActiveDirectoryRequest request = CreateActiveDirectoryRequest.newBuilder().setParent(parent).setActiveDirectory(activeDirectory).setActiveDirectoryId(activeDirectoryId).build();
        return this.createActiveDirectoryAsync(request);
    }

    public final OperationFuture<ActiveDirectory, OperationMetadata> createActiveDirectoryAsync(CreateActiveDirectoryRequest request) {
        return this.createActiveDirectoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateActiveDirectoryRequest, ActiveDirectory, OperationMetadata> createActiveDirectoryOperationCallable() {
        return this.stub.createActiveDirectoryOperationCallable();
    }

    public final UnaryCallable<CreateActiveDirectoryRequest, Operation> createActiveDirectoryCallable() {
        return this.stub.createActiveDirectoryCallable();
    }

    public final OperationFuture<ActiveDirectory, OperationMetadata> updateActiveDirectoryAsync(ActiveDirectory activeDirectory, FieldMask updateMask) {
        UpdateActiveDirectoryRequest request = UpdateActiveDirectoryRequest.newBuilder().setActiveDirectory(activeDirectory).setUpdateMask(updateMask).build();
        return this.updateActiveDirectoryAsync(request);
    }

    public final OperationFuture<ActiveDirectory, OperationMetadata> updateActiveDirectoryAsync(UpdateActiveDirectoryRequest request) {
        return this.updateActiveDirectoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateActiveDirectoryRequest, ActiveDirectory, OperationMetadata> updateActiveDirectoryOperationCallable() {
        return this.stub.updateActiveDirectoryOperationCallable();
    }

    public final UnaryCallable<UpdateActiveDirectoryRequest, Operation> updateActiveDirectoryCallable() {
        return this.stub.updateActiveDirectoryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteActiveDirectoryAsync(ActiveDirectoryName name) {
        DeleteActiveDirectoryRequest request = DeleteActiveDirectoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteActiveDirectoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteActiveDirectoryAsync(String name) {
        DeleteActiveDirectoryRequest request = DeleteActiveDirectoryRequest.newBuilder().setName(name).build();
        return this.deleteActiveDirectoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteActiveDirectoryAsync(DeleteActiveDirectoryRequest request) {
        return this.deleteActiveDirectoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteActiveDirectoryRequest, Empty, OperationMetadata> deleteActiveDirectoryOperationCallable() {
        return this.stub.deleteActiveDirectoryOperationCallable();
    }

    public final UnaryCallable<DeleteActiveDirectoryRequest, Operation> deleteActiveDirectoryCallable() {
        return this.stub.deleteActiveDirectoryCallable();
    }

    public final ListKmsConfigsPagedResponse listKmsConfigs(LocationName parent) {
        ListKmsConfigsRequest request = ListKmsConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKmsConfigs(request);
    }

    public final ListKmsConfigsPagedResponse listKmsConfigs(String parent) {
        ListKmsConfigsRequest request = ListKmsConfigsRequest.newBuilder().setParent(parent).build();
        return this.listKmsConfigs(request);
    }

    public final ListKmsConfigsPagedResponse listKmsConfigs(ListKmsConfigsRequest request) {
        return (ListKmsConfigsPagedResponse)((Object)this.listKmsConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKmsConfigsRequest, ListKmsConfigsPagedResponse> listKmsConfigsPagedCallable() {
        return this.stub.listKmsConfigsPagedCallable();
    }

    public final UnaryCallable<ListKmsConfigsRequest, ListKmsConfigsResponse> listKmsConfigsCallable() {
        return this.stub.listKmsConfigsCallable();
    }

    public final OperationFuture<KmsConfig, OperationMetadata> createKmsConfigAsync(LocationName parent, KmsConfig kmsConfig, String kmsConfigId) {
        CreateKmsConfigRequest request = CreateKmsConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKmsConfig(kmsConfig).setKmsConfigId(kmsConfigId).build();
        return this.createKmsConfigAsync(request);
    }

    public final OperationFuture<KmsConfig, OperationMetadata> createKmsConfigAsync(String parent, KmsConfig kmsConfig, String kmsConfigId) {
        CreateKmsConfigRequest request = CreateKmsConfigRequest.newBuilder().setParent(parent).setKmsConfig(kmsConfig).setKmsConfigId(kmsConfigId).build();
        return this.createKmsConfigAsync(request);
    }

    public final OperationFuture<KmsConfig, OperationMetadata> createKmsConfigAsync(CreateKmsConfigRequest request) {
        return this.createKmsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateKmsConfigRequest, KmsConfig, OperationMetadata> createKmsConfigOperationCallable() {
        return this.stub.createKmsConfigOperationCallable();
    }

    public final UnaryCallable<CreateKmsConfigRequest, Operation> createKmsConfigCallable() {
        return this.stub.createKmsConfigCallable();
    }

    public final KmsConfig getKmsConfig(KmsConfigName name) {
        GetKmsConfigRequest request = GetKmsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKmsConfig(request);
    }

    public final KmsConfig getKmsConfig(String name) {
        GetKmsConfigRequest request = GetKmsConfigRequest.newBuilder().setName(name).build();
        return this.getKmsConfig(request);
    }

    public final KmsConfig getKmsConfig(GetKmsConfigRequest request) {
        return (KmsConfig)this.getKmsConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetKmsConfigRequest, KmsConfig> getKmsConfigCallable() {
        return this.stub.getKmsConfigCallable();
    }

    public final OperationFuture<KmsConfig, OperationMetadata> updateKmsConfigAsync(KmsConfig kmsConfig, FieldMask updateMask) {
        UpdateKmsConfigRequest request = UpdateKmsConfigRequest.newBuilder().setKmsConfig(kmsConfig).setUpdateMask(updateMask).build();
        return this.updateKmsConfigAsync(request);
    }

    public final OperationFuture<KmsConfig, OperationMetadata> updateKmsConfigAsync(UpdateKmsConfigRequest request) {
        return this.updateKmsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateKmsConfigRequest, KmsConfig, OperationMetadata> updateKmsConfigOperationCallable() {
        return this.stub.updateKmsConfigOperationCallable();
    }

    public final UnaryCallable<UpdateKmsConfigRequest, Operation> updateKmsConfigCallable() {
        return this.stub.updateKmsConfigCallable();
    }

    public final OperationFuture<KmsConfig, OperationMetadata> encryptVolumesAsync(EncryptVolumesRequest request) {
        return this.encryptVolumesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EncryptVolumesRequest, KmsConfig, OperationMetadata> encryptVolumesOperationCallable() {
        return this.stub.encryptVolumesOperationCallable();
    }

    public final UnaryCallable<EncryptVolumesRequest, Operation> encryptVolumesCallable() {
        return this.stub.encryptVolumesCallable();
    }

    public final VerifyKmsConfigResponse verifyKmsConfig(VerifyKmsConfigRequest request) {
        return (VerifyKmsConfigResponse)this.verifyKmsConfigCallable().call((Object)request);
    }

    public final UnaryCallable<VerifyKmsConfigRequest, VerifyKmsConfigResponse> verifyKmsConfigCallable() {
        return this.stub.verifyKmsConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteKmsConfigAsync(KmsConfigName name) {
        DeleteKmsConfigRequest request = DeleteKmsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteKmsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteKmsConfigAsync(String name) {
        DeleteKmsConfigRequest request = DeleteKmsConfigRequest.newBuilder().setName(name).build();
        return this.deleteKmsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteKmsConfigAsync(DeleteKmsConfigRequest request) {
        return this.deleteKmsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteKmsConfigRequest, Empty, OperationMetadata> deleteKmsConfigOperationCallable() {
        return this.stub.deleteKmsConfigOperationCallable();
    }

    public final UnaryCallable<DeleteKmsConfigRequest, Operation> deleteKmsConfigCallable() {
        return this.stub.deleteKmsConfigCallable();
    }

    public final ListReplicationsPagedResponse listReplications(VolumeName parent) {
        ListReplicationsRequest request = ListReplicationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReplications(request);
    }

    public final ListReplicationsPagedResponse listReplications(String parent) {
        ListReplicationsRequest request = ListReplicationsRequest.newBuilder().setParent(parent).build();
        return this.listReplications(request);
    }

    public final ListReplicationsPagedResponse listReplications(ListReplicationsRequest request) {
        return (ListReplicationsPagedResponse)((Object)this.listReplicationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReplicationsRequest, ListReplicationsPagedResponse> listReplicationsPagedCallable() {
        return this.stub.listReplicationsPagedCallable();
    }

    public final UnaryCallable<ListReplicationsRequest, ListReplicationsResponse> listReplicationsCallable() {
        return this.stub.listReplicationsCallable();
    }

    public final Replication getReplication(ReplicationName name) {
        GetReplicationRequest request = GetReplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReplication(request);
    }

    public final Replication getReplication(String name) {
        GetReplicationRequest request = GetReplicationRequest.newBuilder().setName(name).build();
        return this.getReplication(request);
    }

    public final Replication getReplication(GetReplicationRequest request) {
        return (Replication)this.getReplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetReplicationRequest, Replication> getReplicationCallable() {
        return this.stub.getReplicationCallable();
    }

    public final OperationFuture<Replication, OperationMetadata> createReplicationAsync(VolumeName parent, Replication replication, String replicationId) {
        CreateReplicationRequest request = CreateReplicationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReplication(replication).setReplicationId(replicationId).build();
        return this.createReplicationAsync(request);
    }

    public final OperationFuture<Replication, OperationMetadata> createReplicationAsync(String parent, Replication replication, String replicationId) {
        CreateReplicationRequest request = CreateReplicationRequest.newBuilder().setParent(parent).setReplication(replication).setReplicationId(replicationId).build();
        return this.createReplicationAsync(request);
    }

    public final OperationFuture<Replication, OperationMetadata> createReplicationAsync(CreateReplicationRequest request) {
        return this.createReplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReplicationRequest, Replication, OperationMetadata> createReplicationOperationCallable() {
        return this.stub.createReplicationOperationCallable();
    }

    public final UnaryCallable<CreateReplicationRequest, Operation> createReplicationCallable() {
        return this.stub.createReplicationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReplicationAsync(ReplicationName name) {
        DeleteReplicationRequest request = DeleteReplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteReplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReplicationAsync(String name) {
        DeleteReplicationRequest request = DeleteReplicationRequest.newBuilder().setName(name).build();
        return this.deleteReplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteReplicationAsync(DeleteReplicationRequest request) {
        return this.deleteReplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteReplicationRequest, Empty, OperationMetadata> deleteReplicationOperationCallable() {
        return this.stub.deleteReplicationOperationCallable();
    }

    public final UnaryCallable<DeleteReplicationRequest, Operation> deleteReplicationCallable() {
        return this.stub.deleteReplicationCallable();
    }

    public final OperationFuture<Replication, OperationMetadata> updateReplicationAsync(Replication replication, FieldMask updateMask) {
        UpdateReplicationRequest request = UpdateReplicationRequest.newBuilder().setReplication(replication).setUpdateMask(updateMask).build();
        return this.updateReplicationAsync(request);
    }

    public final OperationFuture<Replication, OperationMetadata> updateReplicationAsync(UpdateReplicationRequest request) {
        return this.updateReplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateReplicationRequest, Replication, OperationMetadata> updateReplicationOperationCallable() {
        return this.stub.updateReplicationOperationCallable();
    }

    public final UnaryCallable<UpdateReplicationRequest, Operation> updateReplicationCallable() {
        return this.stub.updateReplicationCallable();
    }

    public final OperationFuture<Replication, OperationMetadata> stopReplicationAsync(StopReplicationRequest request) {
        return this.stopReplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopReplicationRequest, Replication, OperationMetadata> stopReplicationOperationCallable() {
        return this.stub.stopReplicationOperationCallable();
    }

    public final UnaryCallable<StopReplicationRequest, Operation> stopReplicationCallable() {
        return this.stub.stopReplicationCallable();
    }

    public final OperationFuture<Replication, OperationMetadata> resumeReplicationAsync(ResumeReplicationRequest request) {
        return this.resumeReplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeReplicationRequest, Replication, OperationMetadata> resumeReplicationOperationCallable() {
        return this.stub.resumeReplicationOperationCallable();
    }

    public final UnaryCallable<ResumeReplicationRequest, Operation> resumeReplicationCallable() {
        return this.stub.resumeReplicationCallable();
    }

    public final OperationFuture<Replication, OperationMetadata> reverseReplicationDirectionAsync(ReverseReplicationDirectionRequest request) {
        return this.reverseReplicationDirectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReverseReplicationDirectionRequest, Replication, OperationMetadata> reverseReplicationDirectionOperationCallable() {
        return this.stub.reverseReplicationDirectionOperationCallable();
    }

    public final UnaryCallable<ReverseReplicationDirectionRequest, Operation> reverseReplicationDirectionCallable() {
        return this.stub.reverseReplicationDirectionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReplicationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReplicationsRequest, ListReplicationsResponse, Replication, ListReplicationsPage, ListReplicationsFixedSizeCollection> {
        private ListReplicationsFixedSizeCollection(List<ListReplicationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReplicationsFixedSizeCollection createEmptyCollection() {
            return new ListReplicationsFixedSizeCollection(null, 0);
        }

        protected ListReplicationsFixedSizeCollection createCollection(List<ListReplicationsPage> pages, int collectionSize) {
            return new ListReplicationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReplicationsPage
    extends AbstractPage<ListReplicationsRequest, ListReplicationsResponse, Replication, ListReplicationsPage> {
        private ListReplicationsPage(PageContext<ListReplicationsRequest, ListReplicationsResponse, Replication> context, ListReplicationsResponse response) {
            super(context, (Object)response);
        }

        private static ListReplicationsPage createEmptyPage() {
            return new ListReplicationsPage(null, null);
        }

        protected ListReplicationsPage createPage(PageContext<ListReplicationsRequest, ListReplicationsResponse, Replication> context, ListReplicationsResponse response) {
            return new ListReplicationsPage(context, response);
        }

        public ApiFuture<ListReplicationsPage> createPageAsync(PageContext<ListReplicationsRequest, ListReplicationsResponse, Replication> context, ApiFuture<ListReplicationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReplicationsPagedResponse
    extends AbstractPagedListResponse<ListReplicationsRequest, ListReplicationsResponse, Replication, ListReplicationsPage, ListReplicationsFixedSizeCollection> {
        public static ApiFuture<ListReplicationsPagedResponse> createAsync(PageContext<ListReplicationsRequest, ListReplicationsResponse, Replication> context, ApiFuture<ListReplicationsResponse> futureResponse) {
            ApiFuture<ListReplicationsPage> futurePage = ListReplicationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReplicationsPagedResponse((ListReplicationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReplicationsPagedResponse(ListReplicationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReplicationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListKmsConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig, ListKmsConfigsPage, ListKmsConfigsFixedSizeCollection> {
        private ListKmsConfigsFixedSizeCollection(List<ListKmsConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKmsConfigsFixedSizeCollection createEmptyCollection() {
            return new ListKmsConfigsFixedSizeCollection(null, 0);
        }

        protected ListKmsConfigsFixedSizeCollection createCollection(List<ListKmsConfigsPage> pages, int collectionSize) {
            return new ListKmsConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKmsConfigsPage
    extends AbstractPage<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig, ListKmsConfigsPage> {
        private ListKmsConfigsPage(PageContext<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig> context, ListKmsConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListKmsConfigsPage createEmptyPage() {
            return new ListKmsConfigsPage(null, null);
        }

        protected ListKmsConfigsPage createPage(PageContext<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig> context, ListKmsConfigsResponse response) {
            return new ListKmsConfigsPage(context, response);
        }

        public ApiFuture<ListKmsConfigsPage> createPageAsync(PageContext<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig> context, ApiFuture<ListKmsConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKmsConfigsPagedResponse
    extends AbstractPagedListResponse<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig, ListKmsConfigsPage, ListKmsConfigsFixedSizeCollection> {
        public static ApiFuture<ListKmsConfigsPagedResponse> createAsync(PageContext<ListKmsConfigsRequest, ListKmsConfigsResponse, KmsConfig> context, ApiFuture<ListKmsConfigsResponse> futureResponse) {
            ApiFuture<ListKmsConfigsPage> futurePage = ListKmsConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListKmsConfigsPagedResponse((ListKmsConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListKmsConfigsPagedResponse(ListKmsConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKmsConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListActiveDirectoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory, ListActiveDirectoriesPage, ListActiveDirectoriesFixedSizeCollection> {
        private ListActiveDirectoriesFixedSizeCollection(List<ListActiveDirectoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListActiveDirectoriesFixedSizeCollection createEmptyCollection() {
            return new ListActiveDirectoriesFixedSizeCollection(null, 0);
        }

        protected ListActiveDirectoriesFixedSizeCollection createCollection(List<ListActiveDirectoriesPage> pages, int collectionSize) {
            return new ListActiveDirectoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListActiveDirectoriesPage
    extends AbstractPage<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory, ListActiveDirectoriesPage> {
        private ListActiveDirectoriesPage(PageContext<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory> context, ListActiveDirectoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListActiveDirectoriesPage createEmptyPage() {
            return new ListActiveDirectoriesPage(null, null);
        }

        protected ListActiveDirectoriesPage createPage(PageContext<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory> context, ListActiveDirectoriesResponse response) {
            return new ListActiveDirectoriesPage(context, response);
        }

        public ApiFuture<ListActiveDirectoriesPage> createPageAsync(PageContext<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory> context, ApiFuture<ListActiveDirectoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListActiveDirectoriesPagedResponse
    extends AbstractPagedListResponse<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory, ListActiveDirectoriesPage, ListActiveDirectoriesFixedSizeCollection> {
        public static ApiFuture<ListActiveDirectoriesPagedResponse> createAsync(PageContext<ListActiveDirectoriesRequest, ListActiveDirectoriesResponse, ActiveDirectory> context, ApiFuture<ListActiveDirectoriesResponse> futureResponse) {
            ApiFuture<ListActiveDirectoriesPage> futurePage = ListActiveDirectoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListActiveDirectoriesPagedResponse((ListActiveDirectoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListActiveDirectoriesPagedResponse(ListActiveDirectoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListActiveDirectoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSnapshotsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        private ListSnapshotsFixedSizeCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSnapshotsFixedSizeCollection createEmptyCollection() {
            return new ListSnapshotsFixedSizeCollection(null, 0);
        }

        protected ListSnapshotsFixedSizeCollection createCollection(List<ListSnapshotsPage> pages, int collectionSize) {
            return new ListSnapshotsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSnapshotsPage
    extends AbstractPage<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage> {
        private ListSnapshotsPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            super(context, (Object)response);
        }

        private static ListSnapshotsPage createEmptyPage() {
            return new ListSnapshotsPage(null, null);
        }

        protected ListSnapshotsPage createPage(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ListSnapshotsResponse response) {
            return new ListSnapshotsPage(context, response);
        }

        public ApiFuture<ListSnapshotsPage> createPageAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSnapshotsPagedResponse
    extends AbstractPagedListResponse<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot, ListSnapshotsPage, ListSnapshotsFixedSizeCollection> {
        public static ApiFuture<ListSnapshotsPagedResponse> createAsync(PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            ApiFuture<ListSnapshotsPage> futurePage = ListSnapshotsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSnapshotsPagedResponse((ListSnapshotsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSnapshotsPagedResponse(ListSnapshotsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSnapshotsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVolumesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        private ListVolumesFixedSizeCollection(List<ListVolumesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVolumesFixedSizeCollection createEmptyCollection() {
            return new ListVolumesFixedSizeCollection(null, 0);
        }

        protected ListVolumesFixedSizeCollection createCollection(List<ListVolumesPage> pages, int collectionSize) {
            return new ListVolumesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVolumesPage
    extends AbstractPage<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage> {
        private ListVolumesPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            super(context, (Object)response);
        }

        private static ListVolumesPage createEmptyPage() {
            return new ListVolumesPage(null, null);
        }

        protected ListVolumesPage createPage(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ListVolumesResponse response) {
            return new ListVolumesPage(context, response);
        }

        public ApiFuture<ListVolumesPage> createPageAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVolumesPagedResponse
    extends AbstractPagedListResponse<ListVolumesRequest, ListVolumesResponse, Volume, ListVolumesPage, ListVolumesFixedSizeCollection> {
        public static ApiFuture<ListVolumesPagedResponse> createAsync(PageContext<ListVolumesRequest, ListVolumesResponse, Volume> context, ApiFuture<ListVolumesResponse> futureResponse) {
            ApiFuture<ListVolumesPage> futurePage = ListVolumesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVolumesPagedResponse((ListVolumesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVolumesPagedResponse(ListVolumesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVolumesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListStoragePoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool, ListStoragePoolsPage, ListStoragePoolsFixedSizeCollection> {
        private ListStoragePoolsFixedSizeCollection(List<ListStoragePoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListStoragePoolsFixedSizeCollection createEmptyCollection() {
            return new ListStoragePoolsFixedSizeCollection(null, 0);
        }

        protected ListStoragePoolsFixedSizeCollection createCollection(List<ListStoragePoolsPage> pages, int collectionSize) {
            return new ListStoragePoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListStoragePoolsPage
    extends AbstractPage<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool, ListStoragePoolsPage> {
        private ListStoragePoolsPage(PageContext<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool> context, ListStoragePoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListStoragePoolsPage createEmptyPage() {
            return new ListStoragePoolsPage(null, null);
        }

        protected ListStoragePoolsPage createPage(PageContext<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool> context, ListStoragePoolsResponse response) {
            return new ListStoragePoolsPage(context, response);
        }

        public ApiFuture<ListStoragePoolsPage> createPageAsync(PageContext<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool> context, ApiFuture<ListStoragePoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListStoragePoolsPagedResponse
    extends AbstractPagedListResponse<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool, ListStoragePoolsPage, ListStoragePoolsFixedSizeCollection> {
        public static ApiFuture<ListStoragePoolsPagedResponse> createAsync(PageContext<ListStoragePoolsRequest, ListStoragePoolsResponse, StoragePool> context, ApiFuture<ListStoragePoolsResponse> futureResponse) {
            ApiFuture<ListStoragePoolsPage> futurePage = ListStoragePoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListStoragePoolsPagedResponse((ListStoragePoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListStoragePoolsPagedResponse(ListStoragePoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListStoragePoolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

