/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.modelarmor.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.modelarmor.v1.CreateTemplateRequest;
import com.google.cloud.modelarmor.v1.DeleteTemplateRequest;
import com.google.cloud.modelarmor.v1.FloorSetting;
import com.google.cloud.modelarmor.v1.GetFloorSettingRequest;
import com.google.cloud.modelarmor.v1.GetTemplateRequest;
import com.google.cloud.modelarmor.v1.ListTemplatesRequest;
import com.google.cloud.modelarmor.v1.ListTemplatesResponse;
import com.google.cloud.modelarmor.v1.ModelArmorClient;
import com.google.cloud.modelarmor.v1.SanitizeModelResponseRequest;
import com.google.cloud.modelarmor.v1.SanitizeModelResponseResponse;
import com.google.cloud.modelarmor.v1.SanitizeUserPromptRequest;
import com.google.cloud.modelarmor.v1.SanitizeUserPromptResponse;
import com.google.cloud.modelarmor.v1.Template;
import com.google.cloud.modelarmor.v1.UpdateFloorSettingRequest;
import com.google.cloud.modelarmor.v1.UpdateTemplateRequest;
import com.google.cloud.modelarmor.v1.stub.GrpcModelArmorStub;
import com.google.cloud.modelarmor.v1.stub.HttpJsonModelArmorStub;
import com.google.cloud.modelarmor.v1.stub.ModelArmorStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ModelArmorStubSettings
extends StubSettings<ModelArmorStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesSettings;
    private final UnaryCallSettings<GetTemplateRequest, Template> getTemplateSettings;
    private final UnaryCallSettings<CreateTemplateRequest, Template> createTemplateSettings;
    private final UnaryCallSettings<UpdateTemplateRequest, Template> updateTemplateSettings;
    private final UnaryCallSettings<DeleteTemplateRequest, Empty> deleteTemplateSettings;
    private final UnaryCallSettings<GetFloorSettingRequest, FloorSetting> getFloorSettingSettings;
    private final UnaryCallSettings<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingSettings;
    private final UnaryCallSettings<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptSettings;
    private final UnaryCallSettings<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListTemplatesRequest, ListTemplatesResponse, Template> LIST_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListTemplatesRequest, ListTemplatesResponse, Template>(){

        public String emptyToken() {
            return "";
        }

        public ListTemplatesRequest injectToken(ListTemplatesRequest payload, String token) {
            return ListTemplatesRequest.newBuilder((ListTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListTemplatesRequest injectPageSize(ListTemplatesRequest payload, int pageSize) {
            return ListTemplatesRequest.newBuilder((ListTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Template> extractResources(ListTemplatesResponse payload) {
            return payload.getTemplatesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse> LIST_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse>(){

        public ApiFuture<ModelArmorClient.ListTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> callable, ListTemplatesRequest request, ApiCallContext context, ApiFuture<ListTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelArmorClient.ListTemplatesPagedResponse.createAsync((PageContext<ListTemplatesRequest, ListTemplatesResponse, Template>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse>(){

        public ApiFuture<ModelArmorClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelArmorClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesSettings() {
        return this.listTemplatesSettings;
    }

    public UnaryCallSettings<GetTemplateRequest, Template> getTemplateSettings() {
        return this.getTemplateSettings;
    }

    public UnaryCallSettings<CreateTemplateRequest, Template> createTemplateSettings() {
        return this.createTemplateSettings;
    }

    public UnaryCallSettings<UpdateTemplateRequest, Template> updateTemplateSettings() {
        return this.updateTemplateSettings;
    }

    public UnaryCallSettings<DeleteTemplateRequest, Empty> deleteTemplateSettings() {
        return this.deleteTemplateSettings;
    }

    public UnaryCallSettings<GetFloorSettingRequest, FloorSetting> getFloorSettingSettings() {
        return this.getFloorSettingSettings;
    }

    public UnaryCallSettings<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingSettings() {
        return this.updateFloorSettingSettings;
    }

    public UnaryCallSettings<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptSettings() {
        return this.sanitizeUserPromptSettings;
    }

    public UnaryCallSettings<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseSettings() {
        return this.sanitizeModelResponseSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ModelArmorStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcModelArmorStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonModelArmorStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "modelarmor";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "modelarmor.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "modelarmor.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ModelArmorStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ModelArmorStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ModelArmorStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ModelArmorStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ModelArmorStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listTemplatesSettings = settingsBuilder.listTemplatesSettings().build();
        this.getTemplateSettings = settingsBuilder.getTemplateSettings().build();
        this.createTemplateSettings = settingsBuilder.createTemplateSettings().build();
        this.updateTemplateSettings = settingsBuilder.updateTemplateSettings().build();
        this.deleteTemplateSettings = settingsBuilder.deleteTemplateSettings().build();
        this.getFloorSettingSettings = settingsBuilder.getFloorSettingSettings().build();
        this.updateFloorSettingSettings = settingsBuilder.updateFloorSettingSettings().build();
        this.sanitizeUserPromptSettings = settingsBuilder.sanitizeUserPromptSettings().build();
        this.sanitizeModelResponseSettings = settingsBuilder.sanitizeModelResponseSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ModelArmorStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesSettings;
        private final UnaryCallSettings.Builder<GetTemplateRequest, Template> getTemplateSettings;
        private final UnaryCallSettings.Builder<CreateTemplateRequest, Template> createTemplateSettings;
        private final UnaryCallSettings.Builder<UpdateTemplateRequest, Template> updateTemplateSettings;
        private final UnaryCallSettings.Builder<DeleteTemplateRequest, Empty> deleteTemplateSettings;
        private final UnaryCallSettings.Builder<GetFloorSettingRequest, FloorSetting> getFloorSettingSettings;
        private final UnaryCallSettings.Builder<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingSettings;
        private final UnaryCallSettings.Builder<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptSettings;
        private final UnaryCallSettings.Builder<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TEMPLATES_PAGE_STR_FACT);
            this.getTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFloorSettingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFloorSettingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sanitizeUserPromptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sanitizeModelResponseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTemplatesSettings, this.getTemplateSettings, this.createTemplateSettings, this.updateTemplateSettings, this.deleteTemplateSettings, this.getFloorSettingSettings, this.updateFloorSettingSettings, this.sanitizeUserPromptSettings, this.sanitizeModelResponseSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ModelArmorStubSettings settings) {
            super((StubSettings)settings);
            this.listTemplatesSettings = settings.listTemplatesSettings.toBuilder();
            this.getTemplateSettings = settings.getTemplateSettings.toBuilder();
            this.createTemplateSettings = settings.createTemplateSettings.toBuilder();
            this.updateTemplateSettings = settings.updateTemplateSettings.toBuilder();
            this.deleteTemplateSettings = settings.deleteTemplateSettings.toBuilder();
            this.getFloorSettingSettings = settings.getFloorSettingSettings.toBuilder();
            this.updateFloorSettingSettings = settings.updateFloorSettingSettings.toBuilder();
            this.sanitizeUserPromptSettings = settings.sanitizeUserPromptSettings.toBuilder();
            this.sanitizeModelResponseSettings = settings.sanitizeModelResponseSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTemplatesSettings, this.getTemplateSettings, this.createTemplateSettings, this.updateTemplateSettings, this.deleteTemplateSettings, this.getFloorSettingSettings, this.updateFloorSettingSettings, this.sanitizeUserPromptSettings, this.sanitizeModelResponseSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ModelArmorStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ModelArmorStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ModelArmorStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ModelArmorStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ModelArmorStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ModelArmorStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ModelArmorStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ModelArmorStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getFloorSettingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateFloorSettingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.sanitizeUserPromptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.sanitizeModelResponseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTemplatesRequest, ListTemplatesResponse, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesSettings() {
            return this.listTemplatesSettings;
        }

        public UnaryCallSettings.Builder<GetTemplateRequest, Template> getTemplateSettings() {
            return this.getTemplateSettings;
        }

        public UnaryCallSettings.Builder<CreateTemplateRequest, Template> createTemplateSettings() {
            return this.createTemplateSettings;
        }

        public UnaryCallSettings.Builder<UpdateTemplateRequest, Template> updateTemplateSettings() {
            return this.updateTemplateSettings;
        }

        public UnaryCallSettings.Builder<DeleteTemplateRequest, Empty> deleteTemplateSettings() {
            return this.deleteTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetFloorSettingRequest, FloorSetting> getFloorSettingSettings() {
            return this.getFloorSettingSettings;
        }

        public UnaryCallSettings.Builder<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingSettings() {
            return this.updateFloorSettingSettings;
        }

        public UnaryCallSettings.Builder<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptSettings() {
            return this.sanitizeUserPromptSettings;
        }

        public UnaryCallSettings.Builder<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseSettings() {
            return this.sanitizeModelResponseSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ModelArmorClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ModelArmorStubSettings build() throws IOException {
            return new ModelArmorStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

