/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.modelarmor.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.modelarmor.v1beta.CreateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.DeleteTemplateRequest;
import com.google.cloud.modelarmor.v1beta.FloorSetting;
import com.google.cloud.modelarmor.v1beta.FloorSettingName;
import com.google.cloud.modelarmor.v1beta.GetFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.GetTemplateRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesResponse;
import com.google.cloud.modelarmor.v1beta.LocationName;
import com.google.cloud.modelarmor.v1beta.ModelArmorSettings;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseResponse;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptResponse;
import com.google.cloud.modelarmor.v1beta.Template;
import com.google.cloud.modelarmor.v1beta.TemplateName;
import com.google.cloud.modelarmor.v1beta.UpdateFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.UpdateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStub;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ModelArmorClient
implements BackgroundResource {
    private final ModelArmorSettings settings;
    private final ModelArmorStub stub;

    public static final ModelArmorClient create() throws IOException {
        return ModelArmorClient.create(ModelArmorSettings.newBuilder().build());
    }

    public static final ModelArmorClient create(ModelArmorSettings settings) throws IOException {
        return new ModelArmorClient(settings);
    }

    public static final ModelArmorClient create(ModelArmorStub stub) {
        return new ModelArmorClient(stub);
    }

    protected ModelArmorClient(ModelArmorSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelArmorStubSettings)settings.getStubSettings()).createStub();
    }

    protected ModelArmorClient(ModelArmorStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ModelArmorSettings getSettings() {
        return this.settings;
    }

    public ModelArmorStub getStub() {
        return this.stub;
    }

    public final ListTemplatesPagedResponse listTemplates(LocationName parent) {
        ListTemplatesRequest request = ListTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTemplates(request);
    }

    public final ListTemplatesPagedResponse listTemplates(String parent) {
        ListTemplatesRequest request = ListTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listTemplates(request);
    }

    public final ListTemplatesPagedResponse listTemplates(ListTemplatesRequest request) {
        return (ListTemplatesPagedResponse)((Object)this.listTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTemplatesRequest, ListTemplatesPagedResponse> listTemplatesPagedCallable() {
        return this.stub.listTemplatesPagedCallable();
    }

    public final UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> listTemplatesCallable() {
        return this.stub.listTemplatesCallable();
    }

    public final Template getTemplate(TemplateName name) {
        GetTemplateRequest request = GetTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTemplate(request);
    }

    public final Template getTemplate(String name) {
        GetTemplateRequest request = GetTemplateRequest.newBuilder().setName(name).build();
        return this.getTemplate(request);
    }

    public final Template getTemplate(GetTemplateRequest request) {
        return (Template)this.getTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetTemplateRequest, Template> getTemplateCallable() {
        return this.stub.getTemplateCallable();
    }

    public final Template createTemplate(LocationName parent, Template template, String templateId) {
        CreateTemplateRequest request = CreateTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTemplate(template).setTemplateId(templateId).build();
        return this.createTemplate(request);
    }

    public final Template createTemplate(String parent, Template template, String templateId) {
        CreateTemplateRequest request = CreateTemplateRequest.newBuilder().setParent(parent).setTemplate(template).setTemplateId(templateId).build();
        return this.createTemplate(request);
    }

    public final Template createTemplate(CreateTemplateRequest request) {
        return (Template)this.createTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTemplateRequest, Template> createTemplateCallable() {
        return this.stub.createTemplateCallable();
    }

    public final Template updateTemplate(Template template, FieldMask updateMask) {
        UpdateTemplateRequest request = UpdateTemplateRequest.newBuilder().setTemplate(template).setUpdateMask(updateMask).build();
        return this.updateTemplate(request);
    }

    public final Template updateTemplate(UpdateTemplateRequest request) {
        return (Template)this.updateTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTemplateRequest, Template> updateTemplateCallable() {
        return this.stub.updateTemplateCallable();
    }

    public final void deleteTemplate(TemplateName name) {
        DeleteTemplateRequest request = DeleteTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTemplate(request);
    }

    public final void deleteTemplate(String name) {
        DeleteTemplateRequest request = DeleteTemplateRequest.newBuilder().setName(name).build();
        this.deleteTemplate(request);
    }

    public final void deleteTemplate(DeleteTemplateRequest request) {
        this.deleteTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTemplateRequest, Empty> deleteTemplateCallable() {
        return this.stub.deleteTemplateCallable();
    }

    public final FloorSetting getFloorSetting(FloorSettingName name) {
        GetFloorSettingRequest request = GetFloorSettingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFloorSetting(request);
    }

    public final FloorSetting getFloorSetting(String name) {
        GetFloorSettingRequest request = GetFloorSettingRequest.newBuilder().setName(name).build();
        return this.getFloorSetting(request);
    }

    public final FloorSetting getFloorSetting(GetFloorSettingRequest request) {
        return (FloorSetting)this.getFloorSettingCallable().call((Object)request);
    }

    public final UnaryCallable<GetFloorSettingRequest, FloorSetting> getFloorSettingCallable() {
        return this.stub.getFloorSettingCallable();
    }

    public final FloorSetting updateFloorSetting(FloorSetting floorSetting, FieldMask updateMask) {
        UpdateFloorSettingRequest request = UpdateFloorSettingRequest.newBuilder().setFloorSetting(floorSetting).setUpdateMask(updateMask).build();
        return this.updateFloorSetting(request);
    }

    public final FloorSetting updateFloorSetting(UpdateFloorSettingRequest request) {
        return (FloorSetting)this.updateFloorSettingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingCallable() {
        return this.stub.updateFloorSettingCallable();
    }

    public final SanitizeUserPromptResponse sanitizeUserPrompt(SanitizeUserPromptRequest request) {
        return (SanitizeUserPromptResponse)this.sanitizeUserPromptCallable().call((Object)request);
    }

    public final UnaryCallable<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptCallable() {
        return this.stub.sanitizeUserPromptCallable();
    }

    public final SanitizeModelResponseResponse sanitizeModelResponse(SanitizeModelResponseRequest request) {
        return (SanitizeModelResponseResponse)this.sanitizeModelResponseCallable().call((Object)request);
    }

    public final UnaryCallable<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseCallable() {
        return this.stub.sanitizeModelResponseCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTemplatesRequest, ListTemplatesResponse, Template, ListTemplatesPage, ListTemplatesFixedSizeCollection> {
        private ListTemplatesFixedSizeCollection(List<ListTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListTemplatesFixedSizeCollection(null, 0);
        }

        protected ListTemplatesFixedSizeCollection createCollection(List<ListTemplatesPage> pages, int collectionSize) {
            return new ListTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTemplatesPage
    extends AbstractPage<ListTemplatesRequest, ListTemplatesResponse, Template, ListTemplatesPage> {
        private ListTemplatesPage(PageContext<ListTemplatesRequest, ListTemplatesResponse, Template> context, ListTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListTemplatesPage createEmptyPage() {
            return new ListTemplatesPage(null, null);
        }

        protected ListTemplatesPage createPage(PageContext<ListTemplatesRequest, ListTemplatesResponse, Template> context, ListTemplatesResponse response) {
            return new ListTemplatesPage(context, response);
        }

        public ApiFuture<ListTemplatesPage> createPageAsync(PageContext<ListTemplatesRequest, ListTemplatesResponse, Template> context, ApiFuture<ListTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTemplatesPagedResponse
    extends AbstractPagedListResponse<ListTemplatesRequest, ListTemplatesResponse, Template, ListTemplatesPage, ListTemplatesFixedSizeCollection> {
        public static ApiFuture<ListTemplatesPagedResponse> createAsync(PageContext<ListTemplatesRequest, ListTemplatesResponse, Template> context, ApiFuture<ListTemplatesResponse> futureResponse) {
            ApiFuture<ListTemplatesPage> futurePage = ListTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTemplatesPagedResponse((ListTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTemplatesPagedResponse(ListTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

