/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.modelarmor.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.modelarmor.v1beta.CreateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.DeleteTemplateRequest;
import com.google.cloud.modelarmor.v1beta.FloorSetting;
import com.google.cloud.modelarmor.v1beta.GetFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.GetTemplateRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesRequest;
import com.google.cloud.modelarmor.v1beta.ListTemplatesResponse;
import com.google.cloud.modelarmor.v1beta.ModelArmorClient;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeModelResponseResponse;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptRequest;
import com.google.cloud.modelarmor.v1beta.SanitizeUserPromptResponse;
import com.google.cloud.modelarmor.v1beta.Template;
import com.google.cloud.modelarmor.v1beta.UpdateFloorSettingRequest;
import com.google.cloud.modelarmor.v1beta.UpdateTemplateRequest;
import com.google.cloud.modelarmor.v1beta.stub.HttpJsonModelArmorCallableFactory;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStub;
import com.google.cloud.modelarmor.v1beta.stub.ModelArmorStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonModelArmorStub
extends ModelArmorStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListTemplatesRequest, ListTemplatesResponse> listTemplatesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/ListTemplates").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/templates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTemplatesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTemplateRequest, Template> getTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/GetTemplate").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/templates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Template.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTemplateRequest, Template> createTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/CreateTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*}/templates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "templateId", (Object)request.getTemplateId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("template", (Message)request.getTemplate(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Template.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateTemplateRequest, Template> updateTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/UpdateTemplate").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{template.name=projects/*/locations/*/templates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "template.name", (Object)request.getTemplate().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("template", (Message)request.getTemplate(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Template.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTemplateRequest, Empty> deleteTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/DeleteTemplate").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/templates/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFloorSettingRequest, FloorSetting> getFloorSettingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/GetFloorSetting").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/floorSetting}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=folders/*/locations/*/floorSetting}", "/v1beta/{name=organizations/*/locations/*/floorSetting}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FloorSetting.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/UpdateFloorSetting").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{floorSetting.name=projects/*/locations/*/floorSetting}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "floorSetting.name", (Object)request.getFloorSetting().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{floorSetting.name=folders/*/locations/*/floorSetting}", "/v1beta/{floorSetting.name=organizations/*/locations/*/floorSetting}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("floorSetting", (Message)request.getFloorSetting(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)FloorSetting.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/SanitizeUserPrompt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/templates/*}:sanitizeUserPrompt", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SanitizeUserPromptResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.modelarmor.v1beta.ModelArmor/SanitizeModelResponse").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/templates/*}:sanitizeModelResponse", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SanitizeModelResponseResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> listTemplatesCallable;
    private final UnaryCallable<ListTemplatesRequest, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesPagedCallable;
    private final UnaryCallable<GetTemplateRequest, Template> getTemplateCallable;
    private final UnaryCallable<CreateTemplateRequest, Template> createTemplateCallable;
    private final UnaryCallable<UpdateTemplateRequest, Template> updateTemplateCallable;
    private final UnaryCallable<DeleteTemplateRequest, Empty> deleteTemplateCallable;
    private final UnaryCallable<GetFloorSettingRequest, FloorSetting> getFloorSettingCallable;
    private final UnaryCallable<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingCallable;
    private final UnaryCallable<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptCallable;
    private final UnaryCallable<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ModelArmorClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonModelArmorStub create(ModelArmorStubSettings settings) throws IOException {
        return new HttpJsonModelArmorStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonModelArmorStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonModelArmorStub(ModelArmorStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonModelArmorStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonModelArmorStub(ModelArmorStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonModelArmorStub(ModelArmorStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonModelArmorCallableFactory());
    }

    protected HttpJsonModelArmorStub(ModelArmorStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listTemplatesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTemplatesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("template.name", String.valueOf(request.getTemplate().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTemplateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getFloorSettingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFloorSettingMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateFloorSettingTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFloorSettingMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("floor_setting.name", String.valueOf(request.getFloorSetting().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings sanitizeUserPromptTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(sanitizeUserPromptMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings sanitizeModelResponseTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(sanitizeModelResponseMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listTemplatesCallable = callableFactory.createUnaryCallable(listTemplatesTransportSettings, settings.listTemplatesSettings(), clientContext);
        this.listTemplatesPagedCallable = callableFactory.createPagedCallable(listTemplatesTransportSettings, settings.listTemplatesSettings(), clientContext);
        this.getTemplateCallable = callableFactory.createUnaryCallable(getTemplateTransportSettings, settings.getTemplateSettings(), clientContext);
        this.createTemplateCallable = callableFactory.createUnaryCallable(createTemplateTransportSettings, settings.createTemplateSettings(), clientContext);
        this.updateTemplateCallable = callableFactory.createUnaryCallable(updateTemplateTransportSettings, settings.updateTemplateSettings(), clientContext);
        this.deleteTemplateCallable = callableFactory.createUnaryCallable(deleteTemplateTransportSettings, settings.deleteTemplateSettings(), clientContext);
        this.getFloorSettingCallable = callableFactory.createUnaryCallable(getFloorSettingTransportSettings, settings.getFloorSettingSettings(), clientContext);
        this.updateFloorSettingCallable = callableFactory.createUnaryCallable(updateFloorSettingTransportSettings, settings.updateFloorSettingSettings(), clientContext);
        this.sanitizeUserPromptCallable = callableFactory.createUnaryCallable(sanitizeUserPromptTransportSettings, settings.sanitizeUserPromptSettings(), clientContext);
        this.sanitizeModelResponseCallable = callableFactory.createUnaryCallable(sanitizeModelResponseTransportSettings, settings.sanitizeModelResponseSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listTemplatesMethodDescriptor);
        methodDescriptors.add(getTemplateMethodDescriptor);
        methodDescriptors.add(createTemplateMethodDescriptor);
        methodDescriptors.add(updateTemplateMethodDescriptor);
        methodDescriptors.add(deleteTemplateMethodDescriptor);
        methodDescriptors.add(getFloorSettingMethodDescriptor);
        methodDescriptors.add(updateFloorSettingMethodDescriptor);
        methodDescriptors.add(sanitizeUserPromptMethodDescriptor);
        methodDescriptors.add(sanitizeModelResponseMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListTemplatesRequest, ListTemplatesResponse> listTemplatesCallable() {
        return this.listTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListTemplatesRequest, ModelArmorClient.ListTemplatesPagedResponse> listTemplatesPagedCallable() {
        return this.listTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<GetTemplateRequest, Template> getTemplateCallable() {
        return this.getTemplateCallable;
    }

    @Override
    public UnaryCallable<CreateTemplateRequest, Template> createTemplateCallable() {
        return this.createTemplateCallable;
    }

    @Override
    public UnaryCallable<UpdateTemplateRequest, Template> updateTemplateCallable() {
        return this.updateTemplateCallable;
    }

    @Override
    public UnaryCallable<DeleteTemplateRequest, Empty> deleteTemplateCallable() {
        return this.deleteTemplateCallable;
    }

    @Override
    public UnaryCallable<GetFloorSettingRequest, FloorSetting> getFloorSettingCallable() {
        return this.getFloorSettingCallable;
    }

    @Override
    public UnaryCallable<UpdateFloorSettingRequest, FloorSetting> updateFloorSettingCallable() {
        return this.updateFloorSettingCallable;
    }

    @Override
    public UnaryCallable<SanitizeUserPromptRequest, SanitizeUserPromptResponse> sanitizeUserPromptCallable() {
        return this.sanitizeUserPromptCallable;
    }

    @Override
    public UnaryCallable<SanitizeModelResponseRequest, SanitizeModelResponseResponse> sanitizeModelResponseCallable() {
        return this.sanitizeModelResponseCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ModelArmorClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

