/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.meet.v2beta.CreateSpaceRequest;
import com.google.apps.meet.v2beta.EndActiveConferenceRequest;
import com.google.apps.meet.v2beta.GetSpaceRequest;
import com.google.apps.meet.v2beta.Space;
import com.google.apps.meet.v2beta.SpaceName;
import com.google.apps.meet.v2beta.SpacesServiceSettings;
import com.google.apps.meet.v2beta.UpdateSpaceRequest;
import com.google.apps.meet.v2beta.stub.SpacesServiceStub;
import com.google.apps.meet.v2beta.stub.SpacesServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SpacesServiceClient
implements BackgroundResource {
    private final SpacesServiceSettings settings;
    private final SpacesServiceStub stub;

    public static final SpacesServiceClient create() throws IOException {
        return SpacesServiceClient.create(SpacesServiceSettings.newBuilder().build());
    }

    public static final SpacesServiceClient create(SpacesServiceSettings settings) throws IOException {
        return new SpacesServiceClient(settings);
    }

    public static final SpacesServiceClient create(SpacesServiceStub stub) {
        return new SpacesServiceClient(stub);
    }

    protected SpacesServiceClient(SpacesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpacesServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SpacesServiceClient(SpacesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SpacesServiceSettings getSettings() {
        return this.settings;
    }

    public SpacesServiceStub getStub() {
        return this.stub;
    }

    public final Space createSpace(Space space) {
        CreateSpaceRequest request = CreateSpaceRequest.newBuilder().setSpace(space).build();
        return this.createSpace(request);
    }

    public final Space createSpace(CreateSpaceRequest request) {
        return (Space)this.createSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable() {
        return this.stub.createSpaceCallable();
    }

    public final Space getSpace(SpaceName name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSpace(request);
    }

    public final Space getSpace(String name) {
        GetSpaceRequest request = GetSpaceRequest.newBuilder().setName(name).build();
        return this.getSpace(request);
    }

    public final Space getSpace(GetSpaceRequest request) {
        return (Space)this.getSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSpaceRequest, Space> getSpaceCallable() {
        return this.stub.getSpaceCallable();
    }

    public final Space updateSpace(Space space, FieldMask updateMask) {
        UpdateSpaceRequest request = UpdateSpaceRequest.newBuilder().setSpace(space).setUpdateMask(updateMask).build();
        return this.updateSpace(request);
    }

    public final Space updateSpace(UpdateSpaceRequest request) {
        return (Space)this.updateSpaceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable() {
        return this.stub.updateSpaceCallable();
    }

    public final void endActiveConference(SpaceName name) {
        EndActiveConferenceRequest request = EndActiveConferenceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.endActiveConference(request);
    }

    public final void endActiveConference(String name) {
        EndActiveConferenceRequest request = EndActiveConferenceRequest.newBuilder().setName(name).build();
        this.endActiveConference(request);
    }

    public final void endActiveConference(EndActiveConferenceRequest request) {
        this.endActiveConferenceCallable().call((Object)request);
    }

    public final UnaryCallable<EndActiveConferenceRequest, Empty> endActiveConferenceCallable() {
        return this.stub.endActiveConferenceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

