/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.meet.v2.CreateSpaceRequest;
import com.google.apps.meet.v2.EndActiveConferenceRequest;
import com.google.apps.meet.v2.GetSpaceRequest;
import com.google.apps.meet.v2.Space;
import com.google.apps.meet.v2.UpdateSpaceRequest;
import com.google.apps.meet.v2.stub.GrpcSpacesServiceCallableFactory;
import com.google.apps.meet.v2.stub.SpacesServiceStub;
import com.google.apps.meet.v2.stub.SpacesServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSpacesServiceStub
extends SpacesServiceStub {
    private static final MethodDescriptor<CreateSpaceRequest, Space> createSpaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.apps.meet.v2.SpacesService/CreateSpace").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSpaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Space.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSpaceRequest, Space> getSpaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.apps.meet.v2.SpacesService/GetSpace").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSpaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Space.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSpaceRequest, Space> updateSpaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.apps.meet.v2.SpacesService/UpdateSpace").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSpaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Space.getDefaultInstance())).build();
    private static final MethodDescriptor<EndActiveConferenceRequest, Empty> endActiveConferenceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.apps.meet.v2.SpacesService/EndActiveConference").setRequestMarshaller(ProtoUtils.marshaller((Message)EndActiveConferenceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable;
    private final UnaryCallable<GetSpaceRequest, Space> getSpaceCallable;
    private final UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable;
    private final UnaryCallable<EndActiveConferenceRequest, Empty> endActiveConferenceCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSpacesServiceStub create(SpacesServiceStubSettings settings) throws IOException {
        return new GrpcSpacesServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSpacesServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSpacesServiceStub(SpacesServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSpacesServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSpacesServiceStub(SpacesServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSpacesServiceStub(SpacesServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSpacesServiceCallableFactory());
    }

    protected GrpcSpacesServiceStub(SpacesServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSpaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSpaceMethodDescriptor).build();
        GrpcCallSettings getSpaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSpaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSpaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSpaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("space.name", String.valueOf(request.getSpace().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings endActiveConferenceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(endActiveConferenceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createSpaceCallable = callableFactory.createUnaryCallable(createSpaceTransportSettings, settings.createSpaceSettings(), clientContext);
        this.getSpaceCallable = callableFactory.createUnaryCallable(getSpaceTransportSettings, settings.getSpaceSettings(), clientContext);
        this.updateSpaceCallable = callableFactory.createUnaryCallable(updateSpaceTransportSettings, settings.updateSpaceSettings(), clientContext);
        this.endActiveConferenceCallable = callableFactory.createUnaryCallable(endActiveConferenceTransportSettings, settings.endActiveConferenceSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable() {
        return this.createSpaceCallable;
    }

    @Override
    public UnaryCallable<GetSpaceRequest, Space> getSpaceCallable() {
        return this.getSpaceCallable;
    }

    @Override
    public UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable() {
        return this.updateSpaceCallable;
    }

    @Override
    public UnaryCallable<EndActiveConferenceRequest, Empty> endActiveConferenceCallable() {
        return this.endActiveConferenceCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

