/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.meet.v2beta.CreateMemberRequest;
import com.google.apps.meet.v2beta.CreateSpaceRequest;
import com.google.apps.meet.v2beta.DeleteMemberRequest;
import com.google.apps.meet.v2beta.EndActiveConferenceRequest;
import com.google.apps.meet.v2beta.GetMemberRequest;
import com.google.apps.meet.v2beta.GetSpaceRequest;
import com.google.apps.meet.v2beta.ListMembersRequest;
import com.google.apps.meet.v2beta.ListMembersResponse;
import com.google.apps.meet.v2beta.Member;
import com.google.apps.meet.v2beta.Space;
import com.google.apps.meet.v2beta.SpacesServiceClient;
import com.google.apps.meet.v2beta.UpdateSpaceRequest;
import com.google.apps.meet.v2beta.stub.GrpcSpacesServiceStub;
import com.google.apps.meet.v2beta.stub.HttpJsonSpacesServiceStub;
import com.google.apps.meet.v2beta.stub.SpacesServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class SpacesServiceStubSettings
extends StubSettings<SpacesServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/meetings.space.created").add((Object)"https://www.googleapis.com/auth/meetings.space.readonly").add((Object)"https://www.googleapis.com/auth/meetings.space.settings").build();
    private final UnaryCallSettings<CreateSpaceRequest, Space> createSpaceSettings;
    private final UnaryCallSettings<GetSpaceRequest, Space> getSpaceSettings;
    private final UnaryCallSettings<UpdateSpaceRequest, Space> updateSpaceSettings;
    private final UnaryCallSettings<EndActiveConferenceRequest, Empty> endActiveConferenceSettings;
    private final UnaryCallSettings<CreateMemberRequest, Member> createMemberSettings;
    private final UnaryCallSettings<GetMemberRequest, Member> getMemberSettings;
    private final PagedCallSettings<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse> listMembersSettings;
    private final UnaryCallSettings<DeleteMemberRequest, Empty> deleteMemberSettings;
    private static final PagedListDescriptor<ListMembersRequest, ListMembersResponse, Member> LIST_MEMBERS_PAGE_STR_DESC = new PagedListDescriptor<ListMembersRequest, ListMembersResponse, Member>(){

        public String emptyToken() {
            return "";
        }

        public ListMembersRequest injectToken(ListMembersRequest payload, String token) {
            return ListMembersRequest.newBuilder((ListMembersRequest)payload).setPageToken(token).build();
        }

        public ListMembersRequest injectPageSize(ListMembersRequest payload, int pageSize) {
            return ListMembersRequest.newBuilder((ListMembersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMembersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMembersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Member> extractResources(ListMembersResponse payload) {
            return payload.getMembersList();
        }
    };
    private static final PagedListResponseFactory<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse> LIST_MEMBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse>(){

        public ApiFuture<SpacesServiceClient.ListMembersPagedResponse> getFuturePagedResponse(UnaryCallable<ListMembersRequest, ListMembersResponse> callable, ListMembersRequest request, ApiCallContext context, ApiFuture<ListMembersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MEMBERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpacesServiceClient.ListMembersPagedResponse.createAsync((PageContext<ListMembersRequest, ListMembersResponse, Member>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSpaceRequest, Space> createSpaceSettings() {
        return this.createSpaceSettings;
    }

    public UnaryCallSettings<GetSpaceRequest, Space> getSpaceSettings() {
        return this.getSpaceSettings;
    }

    public UnaryCallSettings<UpdateSpaceRequest, Space> updateSpaceSettings() {
        return this.updateSpaceSettings;
    }

    public UnaryCallSettings<EndActiveConferenceRequest, Empty> endActiveConferenceSettings() {
        return this.endActiveConferenceSettings;
    }

    public UnaryCallSettings<CreateMemberRequest, Member> createMemberSettings() {
        return this.createMemberSettings;
    }

    public UnaryCallSettings<GetMemberRequest, Member> getMemberSettings() {
        return this.getMemberSettings;
    }

    public PagedCallSettings<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse> listMembersSettings() {
        return this.listMembersSettings;
    }

    public UnaryCallSettings<DeleteMemberRequest, Empty> deleteMemberSettings() {
        return this.deleteMemberSettings;
    }

    public SpacesServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSpacesServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSpacesServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "meet";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "meet.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "meet.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SpacesServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpacesServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpacesServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SpacesServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SpacesServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSpaceSettings = settingsBuilder.createSpaceSettings().build();
        this.getSpaceSettings = settingsBuilder.getSpaceSettings().build();
        this.updateSpaceSettings = settingsBuilder.updateSpaceSettings().build();
        this.endActiveConferenceSettings = settingsBuilder.endActiveConferenceSettings().build();
        this.createMemberSettings = settingsBuilder.createMemberSettings().build();
        this.getMemberSettings = settingsBuilder.getMemberSettings().build();
        this.listMembersSettings = settingsBuilder.listMembersSettings().build();
        this.deleteMemberSettings = settingsBuilder.deleteMemberSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SpacesServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSpaceRequest, Space> createSpaceSettings;
        private final UnaryCallSettings.Builder<GetSpaceRequest, Space> getSpaceSettings;
        private final UnaryCallSettings.Builder<UpdateSpaceRequest, Space> updateSpaceSettings;
        private final UnaryCallSettings.Builder<EndActiveConferenceRequest, Empty> endActiveConferenceSettings;
        private final UnaryCallSettings.Builder<CreateMemberRequest, Member> createMemberSettings;
        private final UnaryCallSettings.Builder<GetMemberRequest, Member> getMemberSettings;
        private final PagedCallSettings.Builder<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse> listMembersSettings;
        private final UnaryCallSettings.Builder<DeleteMemberRequest, Empty> deleteMemberSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSpaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.endActiveConferenceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMemberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMemberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMembersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MEMBERS_PAGE_STR_FACT);
            this.deleteMemberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSpaceSettings, this.getSpaceSettings, this.updateSpaceSettings, this.endActiveConferenceSettings, this.createMemberSettings, this.getMemberSettings, this.listMembersSettings, this.deleteMemberSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SpacesServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSpaceSettings = settings.createSpaceSettings.toBuilder();
            this.getSpaceSettings = settings.getSpaceSettings.toBuilder();
            this.updateSpaceSettings = settings.updateSpaceSettings.toBuilder();
            this.endActiveConferenceSettings = settings.endActiveConferenceSettings.toBuilder();
            this.createMemberSettings = settings.createMemberSettings.toBuilder();
            this.getMemberSettings = settings.getMemberSettings.toBuilder();
            this.listMembersSettings = settings.listMembersSettings.toBuilder();
            this.deleteMemberSettings = settings.deleteMemberSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSpaceSettings, this.getSpaceSettings, this.updateSpaceSettings, this.endActiveConferenceSettings, this.createMemberSettings, this.getMemberSettings, this.listMembersSettings, this.deleteMemberSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SpacesServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SpacesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpacesServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SpacesServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SpacesServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SpacesServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpacesServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SpacesServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSpaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.endActiveConferenceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createMemberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMemberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listMembersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteMemberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSpaceRequest, Space> createSpaceSettings() {
            return this.createSpaceSettings;
        }

        public UnaryCallSettings.Builder<GetSpaceRequest, Space> getSpaceSettings() {
            return this.getSpaceSettings;
        }

        public UnaryCallSettings.Builder<UpdateSpaceRequest, Space> updateSpaceSettings() {
            return this.updateSpaceSettings;
        }

        public UnaryCallSettings.Builder<EndActiveConferenceRequest, Empty> endActiveConferenceSettings() {
            return this.endActiveConferenceSettings;
        }

        public UnaryCallSettings.Builder<CreateMemberRequest, Member> createMemberSettings() {
            return this.createMemberSettings;
        }

        public UnaryCallSettings.Builder<GetMemberRequest, Member> getMemberSettings() {
            return this.getMemberSettings;
        }

        public PagedCallSettings.Builder<ListMembersRequest, ListMembersResponse, SpacesServiceClient.ListMembersPagedResponse> listMembersSettings() {
            return this.listMembersSettings;
        }

        public UnaryCallSettings.Builder<DeleteMemberRequest, Empty> deleteMemberSettings() {
            return this.deleteMemberSettings;
        }

        public SpacesServiceStubSettings build() throws IOException {
            return new SpacesServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

