/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.maintenance.api.v1beta.GetResourceMaintenanceRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.MaintenanceClient;
import com.google.cloud.maintenance.api.v1beta.MaintenanceSummary;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenance;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.stub.GrpcMaintenanceStub;
import com.google.cloud.maintenance.api.v1beta.stub.HttpJsonMaintenanceStub;
import com.google.cloud.maintenance.api.v1beta.stub.MaintenanceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class MaintenanceStubSettings
extends StubSettings<MaintenanceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesSettings;
    private final PagedCallSettings<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesSettings;
    private final UnaryCallSettings<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary> SUMMARIZE_MAINTENANCES_PAGE_STR_DESC = new PagedListDescriptor<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary>(){

        public String emptyToken() {
            return "";
        }

        public SummarizeMaintenancesRequest injectToken(SummarizeMaintenancesRequest payload, String token) {
            return SummarizeMaintenancesRequest.newBuilder((SummarizeMaintenancesRequest)payload).setPageToken(token).build();
        }

        public SummarizeMaintenancesRequest injectPageSize(SummarizeMaintenancesRequest payload, int pageSize) {
            return SummarizeMaintenancesRequest.newBuilder((SummarizeMaintenancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SummarizeMaintenancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SummarizeMaintenancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MaintenanceSummary> extractResources(SummarizeMaintenancesResponse payload) {
            return payload.getMaintenancesList();
        }
    };
    private static final PagedListDescriptor<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance> LIST_RESOURCE_MAINTENANCES_PAGE_STR_DESC = new PagedListDescriptor<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance>(){

        public String emptyToken() {
            return "";
        }

        public ListResourceMaintenancesRequest injectToken(ListResourceMaintenancesRequest payload, String token) {
            return ListResourceMaintenancesRequest.newBuilder((ListResourceMaintenancesRequest)payload).setPageToken(token).build();
        }

        public ListResourceMaintenancesRequest injectPageSize(ListResourceMaintenancesRequest payload, int pageSize) {
            return ListResourceMaintenancesRequest.newBuilder((ListResourceMaintenancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListResourceMaintenancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListResourceMaintenancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourceMaintenance> extractResources(ListResourceMaintenancesResponse payload) {
            return payload.getResourceMaintenancesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse> SUMMARIZE_MAINTENANCES_PAGE_STR_FACT = new PagedListResponseFactory<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse>(){

        public ApiFuture<MaintenanceClient.SummarizeMaintenancesPagedResponse> getFuturePagedResponse(UnaryCallable<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse> callable, SummarizeMaintenancesRequest request, ApiCallContext context, ApiFuture<SummarizeMaintenancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SUMMARIZE_MAINTENANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MaintenanceClient.SummarizeMaintenancesPagedResponse.createAsync((PageContext<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceSummary>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse> LIST_RESOURCE_MAINTENANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse>(){

        public ApiFuture<MaintenanceClient.ListResourceMaintenancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse> callable, ListResourceMaintenancesRequest request, ApiCallContext context, ApiFuture<ListResourceMaintenancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESOURCE_MAINTENANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MaintenanceClient.ListResourceMaintenancesPagedResponse.createAsync((PageContext<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, ResourceMaintenance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse>(){

        public ApiFuture<MaintenanceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MaintenanceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesSettings() {
        return this.summarizeMaintenancesSettings;
    }

    public PagedCallSettings<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesSettings() {
        return this.listResourceMaintenancesSettings;
    }

    public UnaryCallSettings<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceSettings() {
        return this.getResourceMaintenanceSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public MaintenanceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMaintenanceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMaintenanceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "maintenance";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "maintenance.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "maintenance.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MaintenanceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MaintenanceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MaintenanceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MaintenanceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MaintenanceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.summarizeMaintenancesSettings = settingsBuilder.summarizeMaintenancesSettings().build();
        this.listResourceMaintenancesSettings = settingsBuilder.listResourceMaintenancesSettings().build();
        this.getResourceMaintenanceSettings = settingsBuilder.getResourceMaintenanceSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MaintenanceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesSettings;
        private final PagedCallSettings.Builder<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesSettings;
        private final UnaryCallSettings.Builder<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.summarizeMaintenancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SUMMARIZE_MAINTENANCES_PAGE_STR_FACT);
            this.listResourceMaintenancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESOURCE_MAINTENANCES_PAGE_STR_FACT);
            this.getResourceMaintenanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.summarizeMaintenancesSettings, this.listResourceMaintenancesSettings, this.getResourceMaintenanceSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MaintenanceStubSettings settings) {
            super((StubSettings)settings);
            this.summarizeMaintenancesSettings = settings.summarizeMaintenancesSettings.toBuilder();
            this.listResourceMaintenancesSettings = settings.listResourceMaintenancesSettings.toBuilder();
            this.getResourceMaintenanceSettings = settings.getResourceMaintenanceSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.summarizeMaintenancesSettings, this.listResourceMaintenancesSettings, this.getResourceMaintenanceSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MaintenanceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MaintenanceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MaintenanceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MaintenanceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MaintenanceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MaintenanceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MaintenanceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MaintenanceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.summarizeMaintenancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listResourceMaintenancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getResourceMaintenanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesSettings() {
            return this.summarizeMaintenancesSettings;
        }

        public PagedCallSettings.Builder<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesSettings() {
            return this.listResourceMaintenancesSettings;
        }

        public UnaryCallSettings.Builder<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceSettings() {
            return this.getResourceMaintenanceSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, MaintenanceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public MaintenanceStubSettings build() throws IOException {
            return new MaintenanceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

