/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.video.livestream.v1.Channel;
import com.google.cloud.video.livestream.v1.ChannelOperationResponse;
import com.google.cloud.video.livestream.v1.CreateChannelRequest;
import com.google.cloud.video.livestream.v1.CreateEventRequest;
import com.google.cloud.video.livestream.v1.CreateInputRequest;
import com.google.cloud.video.livestream.v1.DeleteChannelRequest;
import com.google.cloud.video.livestream.v1.DeleteEventRequest;
import com.google.cloud.video.livestream.v1.DeleteInputRequest;
import com.google.cloud.video.livestream.v1.Event;
import com.google.cloud.video.livestream.v1.GetChannelRequest;
import com.google.cloud.video.livestream.v1.GetEventRequest;
import com.google.cloud.video.livestream.v1.GetInputRequest;
import com.google.cloud.video.livestream.v1.Input;
import com.google.cloud.video.livestream.v1.ListChannelsRequest;
import com.google.cloud.video.livestream.v1.ListChannelsResponse;
import com.google.cloud.video.livestream.v1.ListEventsRequest;
import com.google.cloud.video.livestream.v1.ListEventsResponse;
import com.google.cloud.video.livestream.v1.ListInputsRequest;
import com.google.cloud.video.livestream.v1.ListInputsResponse;
import com.google.cloud.video.livestream.v1.LivestreamServiceClient;
import com.google.cloud.video.livestream.v1.OperationMetadata;
import com.google.cloud.video.livestream.v1.StartChannelRequest;
import com.google.cloud.video.livestream.v1.StopChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateInputRequest;
import com.google.cloud.video.livestream.v1.stub.GrpcLivestreamServiceCallableFactory;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStub;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLivestreamServiceStub
extends LivestreamServiceStub {
    private static final MethodDescriptor<CreateChannelRequest, Operation> createChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListChannelsRequest, ListChannelsResponse> listChannelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListChannels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChannelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChannelsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetChannelRequest, Channel> getChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Channel.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteChannelRequest, Operation> deleteChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateChannelRequest, Operation> updateChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/UpdateChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartChannelRequest, Operation> startChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/StartChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)StartChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopChannelRequest, Operation> stopChannelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/StopChannel").setRequestMarshaller(ProtoUtils.marshaller((Message)StopChannelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInputRequest, Operation> createInputMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateInput").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInputRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListInputsRequest, ListInputsResponse> listInputsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListInputs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInputsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInputsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInputRequest, Input> getInputMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetInput").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInputRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Input.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInputRequest, Operation> deleteInputMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteInput").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInputRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInputRequest, Operation> updateInputMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/UpdateInput").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInputRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateEventRequest, Event> createEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Event.getDefaultInstance())).build();
    private static final MethodDescriptor<ListEventsRequest, ListEventsResponse> listEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEventsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEventRequest, Event> getEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Event.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteEventRequest, Empty> deleteEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable;
    private final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable;
    private final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable;
    private final UnaryCallable<ListChannelsRequest, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsPagedCallable;
    private final UnaryCallable<GetChannelRequest, Channel> getChannelCallable;
    private final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable;
    private final OperationCallable<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationCallable;
    private final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable;
    private final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable;
    private final UnaryCallable<StartChannelRequest, Operation> startChannelCallable;
    private final OperationCallable<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationCallable;
    private final UnaryCallable<StopChannelRequest, Operation> stopChannelCallable;
    private final OperationCallable<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationCallable;
    private final UnaryCallable<CreateInputRequest, Operation> createInputCallable;
    private final OperationCallable<CreateInputRequest, Input, OperationMetadata> createInputOperationCallable;
    private final UnaryCallable<ListInputsRequest, ListInputsResponse> listInputsCallable;
    private final UnaryCallable<ListInputsRequest, LivestreamServiceClient.ListInputsPagedResponse> listInputsPagedCallable;
    private final UnaryCallable<GetInputRequest, Input> getInputCallable;
    private final UnaryCallable<DeleteInputRequest, Operation> deleteInputCallable;
    private final OperationCallable<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationCallable;
    private final UnaryCallable<UpdateInputRequest, Operation> updateInputCallable;
    private final OperationCallable<UpdateInputRequest, Input, OperationMetadata> updateInputOperationCallable;
    private final UnaryCallable<CreateEventRequest, Event> createEventCallable;
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, LivestreamServiceClient.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<GetEventRequest, Event> getEventCallable;
    private final UnaryCallable<DeleteEventRequest, Empty> deleteEventCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLivestreamServiceStub create(LivestreamServiceStubSettings settings) throws IOException {
        return new GrpcLivestreamServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLivestreamServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLivestreamServiceStub(LivestreamServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLivestreamServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLivestreamServiceStub(LivestreamServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLivestreamServiceStub(LivestreamServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLivestreamServiceCallableFactory());
    }

    protected GrpcLivestreamServiceStub(LivestreamServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listChannelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChannelsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"channel.name", (Object)String.valueOf(request.getChannel().getName()));
            return params.build();
        }).build();
        GrpcCallSettings startChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings stopChannelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopChannelMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createInputTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInputMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listInputsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInputsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getInputTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInputMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteInputTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInputMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateInputTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInputMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"input.name", (Object)String.valueOf(request.getInput().getName()));
            return params.build();
        }).build();
        GrpcCallSettings createEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEventMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEventsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEventMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEventMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createChannelCallable = callableFactory.createUnaryCallable(createChannelTransportSettings, settings.createChannelSettings(), clientContext);
        this.createChannelOperationCallable = callableFactory.createOperationCallable(createChannelTransportSettings, settings.createChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listChannelsCallable = callableFactory.createUnaryCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.listChannelsPagedCallable = callableFactory.createPagedCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.getChannelCallable = callableFactory.createUnaryCallable(getChannelTransportSettings, settings.getChannelSettings(), clientContext);
        this.deleteChannelCallable = callableFactory.createUnaryCallable(deleteChannelTransportSettings, settings.deleteChannelSettings(), clientContext);
        this.deleteChannelOperationCallable = callableFactory.createOperationCallable(deleteChannelTransportSettings, settings.deleteChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateChannelCallable = callableFactory.createUnaryCallable(updateChannelTransportSettings, settings.updateChannelSettings(), clientContext);
        this.updateChannelOperationCallable = callableFactory.createOperationCallable(updateChannelTransportSettings, settings.updateChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startChannelCallable = callableFactory.createUnaryCallable(startChannelTransportSettings, settings.startChannelSettings(), clientContext);
        this.startChannelOperationCallable = callableFactory.createOperationCallable(startChannelTransportSettings, settings.startChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopChannelCallable = callableFactory.createUnaryCallable(stopChannelTransportSettings, settings.stopChannelSettings(), clientContext);
        this.stopChannelOperationCallable = callableFactory.createOperationCallable(stopChannelTransportSettings, settings.stopChannelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createInputCallable = callableFactory.createUnaryCallable(createInputTransportSettings, settings.createInputSettings(), clientContext);
        this.createInputOperationCallable = callableFactory.createOperationCallable(createInputTransportSettings, settings.createInputOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listInputsCallable = callableFactory.createUnaryCallable(listInputsTransportSettings, settings.listInputsSettings(), clientContext);
        this.listInputsPagedCallable = callableFactory.createPagedCallable(listInputsTransportSettings, settings.listInputsSettings(), clientContext);
        this.getInputCallable = callableFactory.createUnaryCallable(getInputTransportSettings, settings.getInputSettings(), clientContext);
        this.deleteInputCallable = callableFactory.createUnaryCallable(deleteInputTransportSettings, settings.deleteInputSettings(), clientContext);
        this.deleteInputOperationCallable = callableFactory.createOperationCallable(deleteInputTransportSettings, settings.deleteInputOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInputCallable = callableFactory.createUnaryCallable(updateInputTransportSettings, settings.updateInputSettings(), clientContext);
        this.updateInputOperationCallable = callableFactory.createOperationCallable(updateInputTransportSettings, settings.updateInputOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createEventCallable = callableFactory.createUnaryCallable(createEventTransportSettings, settings.createEventSettings(), clientContext);
        this.listEventsCallable = callableFactory.createUnaryCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.listEventsPagedCallable = callableFactory.createPagedCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.getEventCallable = callableFactory.createUnaryCallable(getEventTransportSettings, settings.getEventSettings(), clientContext);
        this.deleteEventCallable = callableFactory.createUnaryCallable(deleteEventTransportSettings, settings.deleteEventSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.createChannelCallable;
    }

    @Override
    public OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.createChannelOperationCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.listChannelsCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.listChannelsPagedCallable;
    }

    @Override
    public UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.getChannelCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.deleteChannelCallable;
    }

    @Override
    public OperationCallable<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationCallable() {
        return this.deleteChannelOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.updateChannelCallable;
    }

    @Override
    public OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.updateChannelOperationCallable;
    }

    @Override
    public UnaryCallable<StartChannelRequest, Operation> startChannelCallable() {
        return this.startChannelCallable;
    }

    @Override
    public OperationCallable<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationCallable() {
        return this.startChannelOperationCallable;
    }

    @Override
    public UnaryCallable<StopChannelRequest, Operation> stopChannelCallable() {
        return this.stopChannelCallable;
    }

    @Override
    public OperationCallable<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationCallable() {
        return this.stopChannelOperationCallable;
    }

    @Override
    public UnaryCallable<CreateInputRequest, Operation> createInputCallable() {
        return this.createInputCallable;
    }

    @Override
    public OperationCallable<CreateInputRequest, Input, OperationMetadata> createInputOperationCallable() {
        return this.createInputOperationCallable;
    }

    @Override
    public UnaryCallable<ListInputsRequest, ListInputsResponse> listInputsCallable() {
        return this.listInputsCallable;
    }

    @Override
    public UnaryCallable<ListInputsRequest, LivestreamServiceClient.ListInputsPagedResponse> listInputsPagedCallable() {
        return this.listInputsPagedCallable;
    }

    @Override
    public UnaryCallable<GetInputRequest, Input> getInputCallable() {
        return this.getInputCallable;
    }

    @Override
    public UnaryCallable<DeleteInputRequest, Operation> deleteInputCallable() {
        return this.deleteInputCallable;
    }

    @Override
    public OperationCallable<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationCallable() {
        return this.deleteInputOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInputRequest, Operation> updateInputCallable() {
        return this.updateInputCallable;
    }

    @Override
    public OperationCallable<UpdateInputRequest, Input, OperationMetadata> updateInputOperationCallable() {
        return this.updateInputOperationCallable;
    }

    @Override
    public UnaryCallable<CreateEventRequest, Event> createEventCallable() {
        return this.createEventCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, LivestreamServiceClient.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.getEventCallable;
    }

    @Override
    public UnaryCallable<DeleteEventRequest, Empty> deleteEventCallable() {
        return this.deleteEventCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, LivestreamServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

