/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.inventory.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.inventory.v1.KeyDashboardServiceClient;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysRequest;
import com.google.cloud.kms.inventory.v1.ListCryptoKeysResponse;
import com.google.cloud.kms.inventory.v1.stub.GrpcKeyDashboardServiceCallableFactory;
import com.google.cloud.kms.inventory.v1.stub.KeyDashboardServiceStub;
import com.google.cloud.kms.inventory.v1.stub.KeyDashboardServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcKeyDashboardServiceStub
extends KeyDashboardServiceStub {
    private static final MethodDescriptor<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.inventory.v1.KeyDashboardService/ListCryptoKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCryptoKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCryptoKeysResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable;
    private final UnaryCallable<ListCryptoKeysRequest, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcKeyDashboardServiceStub create(KeyDashboardServiceStubSettings settings) throws IOException {
        return new GrpcKeyDashboardServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcKeyDashboardServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcKeyDashboardServiceStub(KeyDashboardServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcKeyDashboardServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcKeyDashboardServiceStub(KeyDashboardServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcKeyDashboardServiceStub(KeyDashboardServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcKeyDashboardServiceCallableFactory());
    }

    protected GrpcKeyDashboardServiceStub(KeyDashboardServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listCryptoKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCryptoKeysMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.listCryptoKeysCallable = callableFactory.createUnaryCallable(listCryptoKeysTransportSettings, settings.listCryptoKeysSettings(), clientContext);
        this.listCryptoKeysPagedCallable = callableFactory.createPagedCallable(listCryptoKeysTransportSettings, settings.listCryptoKeysSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListCryptoKeysRequest, ListCryptoKeysResponse> listCryptoKeysCallable() {
        return this.listCryptoKeysCallable;
    }

    @Override
    public UnaryCallable<ListCryptoKeysRequest, KeyDashboardServiceClient.ListCryptoKeysPagedResponse> listCryptoKeysPagedCallable() {
        return this.listCryptoKeysPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

