/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.config.v1.ConfigSettings;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.DeploymentName;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.LocationName;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.OperationMetadata;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.ResourceName;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.RevisionName;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.config.v1.stub.ConfigStub;
import com.google.cloud.config.v1.stub.ConfigStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConfigClient
implements BackgroundResource {
    private final ConfigSettings settings;
    private final ConfigStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.newBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    public static final ConfigClient create(ConfigStub stub) {
        return new ConfigClient(stub);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConfigStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConfigClient(ConfigStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    public ConfigStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDeploymentsPagedResponse listDeployments(LocationName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(LocationName parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(String parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(CreateDeploymentRequest request) {
        return this.createDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable() {
        return this.stub.createDeploymentOperationCallable();
    }

    public final UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable() {
        return this.stub.createDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> updateDeploymentAsync(Deployment deployment, FieldMask updateMask) {
        UpdateDeploymentRequest request = UpdateDeploymentRequest.newBuilder().setDeployment(deployment).setUpdateMask(updateMask).build();
        return this.updateDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> updateDeploymentAsync(UpdateDeploymentRequest request) {
        return this.updateDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable() {
        return this.stub.updateDeploymentOperationCallable();
    }

    public final UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable() {
        return this.stub.updateDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(DeploymentName name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(String name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name).build();
        return this.deleteDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(DeleteDeploymentRequest request) {
        return this.deleteDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable() {
        return this.stub.deleteDeploymentOperationCallable();
    }

    public final UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable() {
        return this.stub.deleteDeploymentCallable();
    }

    public final ListRevisionsPagedResponse listRevisions(DeploymentName parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(String parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(ListRevisionsRequest request) {
        return (ListRevisionsPagedResponse)((Object)this.listRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.stub.listRevisionsPagedCallable();
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.stub.listRevisionsCallable();
    }

    public final Revision getRevision(RevisionName name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(String name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(GetRevisionRequest request) {
        return (Revision)this.getRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.stub.getRevisionCallable();
    }

    public final Resource getResource(ResourceName name) {
        GetResourceRequest request = GetResourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResource(request);
    }

    public final Resource getResource(String name) {
        GetResourceRequest request = GetResourceRequest.newBuilder().setName(name).build();
        return this.getResource(request);
    }

    public final Resource getResource(GetResourceRequest request) {
        return (Resource)this.getResourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceRequest, Resource> getResourceCallable() {
        return this.stub.getResourceCallable();
    }

    public final ListResourcesPagedResponse listResources(RevisionName parent) {
        ListResourcesRequest request = ListResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResources(request);
    }

    public final ListResourcesPagedResponse listResources(String parent) {
        ListResourcesRequest request = ListResourcesRequest.newBuilder().setParent(parent).build();
        return this.listResources(request);
    }

    public final ListResourcesPagedResponse listResources(ListResourcesRequest request) {
        return (ListResourcesPagedResponse)((Object)this.listResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourcesRequest, ListResourcesPagedResponse> listResourcesPagedCallable() {
        return this.stub.listResourcesPagedCallable();
    }

    public final UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable() {
        return this.stub.listResourcesCallable();
    }

    public final Statefile exportDeploymentStatefile(ExportDeploymentStatefileRequest request) {
        return (Statefile)this.exportDeploymentStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable() {
        return this.stub.exportDeploymentStatefileCallable();
    }

    public final Statefile exportRevisionStatefile(ExportRevisionStatefileRequest request) {
        return (Statefile)this.exportRevisionStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable() {
        return this.stub.exportRevisionStatefileCallable();
    }

    public final Statefile importStatefile(DeploymentName parent, long lockId) {
        ImportStatefileRequest request = ImportStatefileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLockId(lockId).build();
        return this.importStatefile(request);
    }

    public final Statefile importStatefile(String parent, long lockId) {
        ImportStatefileRequest request = ImportStatefileRequest.newBuilder().setParent(parent).setLockId(lockId).build();
        return this.importStatefile(request);
    }

    public final Statefile importStatefile(ImportStatefileRequest request) {
        return (Statefile)this.importStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable() {
        return this.stub.importStatefileCallable();
    }

    public final void deleteStatefile(DeploymentName name) {
        DeleteStatefileRequest request = DeleteStatefileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteStatefile(request);
    }

    public final void deleteStatefile(String name) {
        DeleteStatefileRequest request = DeleteStatefileRequest.newBuilder().setName(name).build();
        this.deleteStatefile(request);
    }

    public final void deleteStatefile(DeleteStatefileRequest request) {
        this.deleteStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable() {
        return this.stub.deleteStatefileCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(DeploymentName name) {
        LockDeploymentRequest request = LockDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.lockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(String name) {
        LockDeploymentRequest request = LockDeploymentRequest.newBuilder().setName(name).build();
        return this.lockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(LockDeploymentRequest request) {
        return this.lockDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable() {
        return this.stub.lockDeploymentOperationCallable();
    }

    public final UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable() {
        return this.stub.lockDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(DeploymentName name, long lockId) {
        UnlockDeploymentRequest request = UnlockDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).setLockId(lockId).build();
        return this.unlockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(String name, long lockId) {
        UnlockDeploymentRequest request = UnlockDeploymentRequest.newBuilder().setName(name).setLockId(lockId).build();
        return this.unlockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(UnlockDeploymentRequest request) {
        return this.unlockDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable() {
        return this.stub.unlockDeploymentOperationCallable();
    }

    public final UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable() {
        return this.stub.unlockDeploymentCallable();
    }

    public final LockInfo exportLockInfo(DeploymentName name) {
        ExportLockInfoRequest request = ExportLockInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportLockInfo(request);
    }

    public final LockInfo exportLockInfo(String name) {
        ExportLockInfoRequest request = ExportLockInfoRequest.newBuilder().setName(name).build();
        return this.exportLockInfo(request);
    }

    public final LockInfo exportLockInfo(ExportLockInfoRequest request) {
        return (LockInfo)this.exportLockInfoCallable().call((Object)request);
    }

    public final UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable() {
        return this.stub.exportLockInfoCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage, ListResourcesFixedSizeCollection> {
        private ListResourcesFixedSizeCollection(List<ListResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourcesFixedSizeCollection createEmptyCollection() {
            return new ListResourcesFixedSizeCollection(null, 0);
        }

        protected ListResourcesFixedSizeCollection createCollection(List<ListResourcesPage> pages, int collectionSize) {
            return new ListResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourcesPage
    extends AbstractPage<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage> {
        private ListResourcesPage(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ListResourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourcesPage createEmptyPage() {
            return new ListResourcesPage(null, null);
        }

        protected ListResourcesPage createPage(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ListResourcesResponse response) {
            return new ListResourcesPage(context, response);
        }

        public ApiFuture<ListResourcesPage> createPageAsync(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ApiFuture<ListResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourcesPagedResponse
    extends AbstractPagedListResponse<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage, ListResourcesFixedSizeCollection> {
        public static ApiFuture<ListResourcesPagedResponse> createAsync(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ApiFuture<ListResourcesResponse> futureResponse) {
            ApiFuture<ListResourcesPage> futurePage = ListResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourcesPagedResponse((ListResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourcesPagedResponse(ListResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        private ListRevisionsFixedSizeCollection(List<ListRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListRevisionsFixedSizeCollection(null, 0);
        }

        protected ListRevisionsFixedSizeCollection createCollection(List<ListRevisionsPage> pages, int collectionSize) {
            return new ListRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRevisionsPage
    extends AbstractPage<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage> {
        private ListRevisionsPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListRevisionsPage createEmptyPage() {
            return new ListRevisionsPage(null, null);
        }

        protected ListRevisionsPage createPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            return new ListRevisionsPage(context, response);
        }

        public ApiFuture<ListRevisionsPage> createPageAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRevisionsPagedResponse
    extends AbstractPagedListResponse<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        public static ApiFuture<ListRevisionsPagedResponse> createAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            ApiFuture<ListRevisionsPage> futurePage = ListRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRevisionsPagedResponse((ListRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRevisionsPagedResponse(ListRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

