/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iap.v1.Brand;
import com.google.cloud.iap.v1.CreateBrandRequest;
import com.google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.DeleteIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.GetBrandRequest;
import com.google.cloud.iap.v1.GetIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.IdentityAwareProxyClient;
import com.google.cloud.iap.v1.IdentityAwareProxyOAuthServiceClient;
import com.google.cloud.iap.v1.ListBrandsRequest;
import com.google.cloud.iap.v1.ListBrandsResponse;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsRequest;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse;
import com.google.cloud.iap.v1.ResetIdentityAwareProxyClientSecretRequest;
import com.google.cloud.iap.v1.stub.HttpJsonIdentityAwareProxyOAuthServiceCallableFactory;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyOAuthServiceStub;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyOAuthServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonIdentityAwareProxyOAuthServiceStub
extends IdentityAwareProxyOAuthServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListBrandsRequest, ListBrandsResponse> listBrandsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListBrands").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/brands", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBrandsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateBrandRequest, Brand> createBrandMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateBrand").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/brands", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("brand", (Message)request.getBrand(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Brand.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBrandRequest, Brand> getBrandMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetBrand").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/brands/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Brand.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateIdentityAwareProxyClient").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/brands/*}/identityAwareProxyClients", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("identityAwareProxyClient", (Message)request.getIdentityAwareProxyClient(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)IdentityAwareProxyClient.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListIdentityAwareProxyClients").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/brands/*}/identityAwareProxyClients", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListIdentityAwareProxyClientsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetIdentityAwareProxyClient").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/brands/*/identityAwareProxyClients/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)IdentityAwareProxyClient.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ResetIdentityAwareProxyClientSecret").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/brands/*/identityAwareProxyClients/*}:resetSecret", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)IdentityAwareProxyClient.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/DeleteIdentityAwareProxyClient").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/brands/*/identityAwareProxyClients/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListBrandsRequest, ListBrandsResponse> listBrandsCallable;
    private final UnaryCallable<CreateBrandRequest, Brand> createBrandCallable;
    private final UnaryCallable<GetBrandRequest, Brand> getBrandCallable;
    private final UnaryCallable<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientCallable;
    private final UnaryCallable<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsCallable;
    private final UnaryCallable<ListIdentityAwareProxyClientsRequest, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsPagedCallable;
    private final UnaryCallable<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientCallable;
    private final UnaryCallable<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretCallable;
    private final UnaryCallable<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonIdentityAwareProxyOAuthServiceStub create(IdentityAwareProxyOAuthServiceStubSettings settings) throws IOException {
        return new HttpJsonIdentityAwareProxyOAuthServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonIdentityAwareProxyOAuthServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonIdentityAwareProxyOAuthServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonIdentityAwareProxyOAuthServiceCallableFactory());
    }

    protected HttpJsonIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listBrandsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBrandsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createBrandTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBrandMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getBrandTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBrandMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createIdentityAwareProxyClientTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createIdentityAwareProxyClientMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listIdentityAwareProxyClientsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listIdentityAwareProxyClientsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIdentityAwareProxyClientTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIdentityAwareProxyClientMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings resetIdentityAwareProxyClientSecretTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resetIdentityAwareProxyClientSecretMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteIdentityAwareProxyClientTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteIdentityAwareProxyClientMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listBrandsCallable = callableFactory.createUnaryCallable(listBrandsTransportSettings, settings.listBrandsSettings(), clientContext);
        this.createBrandCallable = callableFactory.createUnaryCallable(createBrandTransportSettings, settings.createBrandSettings(), clientContext);
        this.getBrandCallable = callableFactory.createUnaryCallable(getBrandTransportSettings, settings.getBrandSettings(), clientContext);
        this.createIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(createIdentityAwareProxyClientTransportSettings, settings.createIdentityAwareProxyClientSettings(), clientContext);
        this.listIdentityAwareProxyClientsCallable = callableFactory.createUnaryCallable(listIdentityAwareProxyClientsTransportSettings, settings.listIdentityAwareProxyClientsSettings(), clientContext);
        this.listIdentityAwareProxyClientsPagedCallable = callableFactory.createPagedCallable(listIdentityAwareProxyClientsTransportSettings, settings.listIdentityAwareProxyClientsSettings(), clientContext);
        this.getIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(getIdentityAwareProxyClientTransportSettings, settings.getIdentityAwareProxyClientSettings(), clientContext);
        this.resetIdentityAwareProxyClientSecretCallable = callableFactory.createUnaryCallable(resetIdentityAwareProxyClientSecretTransportSettings, settings.resetIdentityAwareProxyClientSecretSettings(), clientContext);
        this.deleteIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(deleteIdentityAwareProxyClientTransportSettings, settings.deleteIdentityAwareProxyClientSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listBrandsMethodDescriptor);
        methodDescriptors.add(createBrandMethodDescriptor);
        methodDescriptors.add(getBrandMethodDescriptor);
        methodDescriptors.add(createIdentityAwareProxyClientMethodDescriptor);
        methodDescriptors.add(listIdentityAwareProxyClientsMethodDescriptor);
        methodDescriptors.add(getIdentityAwareProxyClientMethodDescriptor);
        methodDescriptors.add(resetIdentityAwareProxyClientSecretMethodDescriptor);
        methodDescriptors.add(deleteIdentityAwareProxyClientMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListBrandsRequest, ListBrandsResponse> listBrandsCallable() {
        return this.listBrandsCallable;
    }

    @Override
    public UnaryCallable<CreateBrandRequest, Brand> createBrandCallable() {
        return this.createBrandCallable;
    }

    @Override
    public UnaryCallable<GetBrandRequest, Brand> getBrandCallable() {
        return this.getBrandCallable;
    }

    @Override
    public UnaryCallable<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientCallable() {
        return this.createIdentityAwareProxyClientCallable;
    }

    @Override
    public UnaryCallable<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsCallable() {
        return this.listIdentityAwareProxyClientsCallable;
    }

    @Override
    public UnaryCallable<ListIdentityAwareProxyClientsRequest, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsPagedCallable() {
        return this.listIdentityAwareProxyClientsPagedCallable;
    }

    @Override
    public UnaryCallable<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientCallable() {
        return this.getIdentityAwareProxyClientCallable;
    }

    @Override
    public UnaryCallable<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretCallable() {
        return this.resetIdentityAwareProxyClientSecretCallable;
    }

    @Override
    public UnaryCallable<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientCallable() {
        return this.deleteIdentityAwareProxyClientCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

